/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsInterpreterManager {
    private static final String NODEJS_INTERPRETER_PATH = "nodejs_interpreter_path";
    private final Project myProject;
    private NodeJsInterpreter myDefaultInterpreter;

    public NodeJsInterpreterManager(@NotNull Project project) {
        if (project == null) {
            NodeJsInterpreterManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public static NodeJsInterpreterManager getInstance(@NotNull Project project) {
        if (project == null) {
            NodeJsInterpreterManager.$$$reportNull$$$0(1);
        }
        NodeJsInterpreterManager nodeJsInterpreterManager = (NodeJsInterpreterManager)ServiceManager.getService((Project)project, NodeJsInterpreterManager.class);
        if (nodeJsInterpreterManager == null) {
            NodeJsInterpreterManager.$$$reportNull$$$0(2);
        }
        return nodeJsInterpreterManager;
    }

    @Nullable
    public NodeJsInterpreter getDefault() {
        NodeJsInterpreter interpreter = this.myDefaultInterpreter;
        if (interpreter == null) {
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
            String reference = propertiesComponent.getValue(NODEJS_INTERPRETER_PATH);
            if (StringUtil.isNotEmpty((String)reference)) {
                interpreter = NodeJsInterpreterRef.create(reference).resolveWithoutAliases();
            } else {
                interpreter = NodeJsLocalInterpreterManager.getInstance().detectMostRelevant();
                if (interpreter != null) {
                    propertiesComponent.setValue(NODEJS_INTERPRETER_PATH, interpreter.getReferenceName());
                }
            }
            this.myDefaultInterpreter = interpreter;
        }
        return interpreter;
    }

    public void setDefault(@Nullable NodeJsInterpreter interpreter) {
        this.myDefaultInterpreter = interpreter;
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        if (interpreter == null) {
            propertiesComponent.unsetValue(NODEJS_INTERPRETER_PATH);
        } else {
            propertiesComponent.setValue(NODEJS_INTERPRETER_PATH, interpreter.getReferenceName());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

