/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.javascript.nodejs.interpreter.LeftRightJustifyingLayoutManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.NullableConsumer;
import com.intellij.util.containers.Predicate;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;

public class NodeJsInterpreterRenderer
implements ListCellRenderer<NodeJsInterpreter> {
    private static final Logger LOG = Logger.getInstance(NodeJsInterpreterRenderer.class);
    private final SimpleColoredComponent myNameComp;
    private final SimpleColoredComponent myVersionComp;
    private final JPanel myPanel;
    private final Predicate<NodeJsInterpreter> myIsProjectInterpreter;

    public NodeJsInterpreterRenderer(boolean compact, @NotNull Predicate<NodeJsInterpreter> isProjectInterpreter) {
        if (isProjectInterpreter == null) {
            NodeJsInterpreterRenderer.$$$reportNull$$$0(0);
        }
        this.myNameComp = new SimpleColoredComponent();
        this.myVersionComp = new SimpleColoredComponent();
        this.myPanel = new JPanel(new GridBagLayout());
        this.myIsProjectInterpreter = isProjectInterpreter;
        this.myNameComp.setOpaque(false);
        this.myVersionComp.setOpaque(false);
        JBInsets insets = compact ? new JBInsets(0, 1, 0, 1) : new JBInsets(2, UIUtil.getListCellHPadding(), 2, UIUtil.getListCellHPadding());
        this.myPanel.setBorder(IdeBorderFactory.createEmptyBorder((Insets)insets));
        this.myNameComp.setIpad((Insets)JBUI.emptyInsets());
        this.myVersionComp.setIpad((Insets)JBUI.insets((int)0, (int)10, (int)0, (int)0));
        if (compact) {
            NodeJsInterpreterRenderer.adjustBorderHeight(this.myNameComp);
            this.myVersionComp.setMyBorder(null);
        }
        JPanel nameContainer = NodeJsInterpreterRenderer.wrapInLeftRightJustifyingContainer(this.myNameComp);
        this.myPanel.add((Component)nameContainer, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 256, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        this.myPanel.add((Component)this.myVersionComp, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 256, 0, (Insets)JBUI.emptyInsets(), 0, 0));
    }

    public static void adjustBorderHeight(@NotNull SimpleColoredComponent component) {
        if (component == null) {
            NodeJsInterpreterRenderer.$$$reportNull$$$0(1);
        }
        component.setMyBorder((Border)new EmptyBorder(1, 0, 1, 0));
    }

    @NotNull
    private static JPanel wrapInLeftRightJustifyingContainer(final @NotNull SimpleColoredComponent component) {
        if (component == null) {
            NodeJsInterpreterRenderer.$$$reportNull$$$0(2);
        }
        JPanel container = new JPanel((LayoutManager)new LeftRightJustifyingLayoutManager()){

            @Override
            public int getBaseline(int width, int height) {
                return component.getBaseline(width, height);
            }
        };
        container.setBorder((Border)JBUI.Borders.empty());
        container.setOpaque(false);
        container.add((Component)component);
        JPanel jPanel = container;
        if (jPanel == null) {
            NodeJsInterpreterRenderer.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends NodeJsInterpreter> list, NodeJsInterpreter value, int index, boolean isSelected, boolean cellHasFocus) {
        this.myNameComp.clear();
        this.myVersionComp.clear();
        Font baseFont = list.getFont();
        this.myNameComp.setFont(baseFont);
        this.myVersionComp.setFont(UIUtil.getFont((UIUtil.FontSize)UIUtil.FontSize.SMALL, (Font)baseFont));
        if (this.myPanel.isEnabled() != list.isEnabled()) {
            UIUtil.setEnabled((Component)this.myPanel, (boolean)list.isEnabled(), (boolean)true);
        }
        if (value == null) {
            return this.myPanel;
        }
        this.myPanel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
        Color foreground = isSelected ? list.getSelectionForeground() : list.getForeground();
        this.myNameComp.setForeground(foreground);
        this.myVersionComp.setForeground(foreground);
        this.customize(list, value, index, isSelected);
        return this.myPanel;
    }

    private void customize(@NotNull JList<? extends NodeJsInterpreter> list, @NotNull NodeJsInterpreter interpreter, int index, boolean isSelected) {
        if (list == null) {
            NodeJsInterpreterRenderer.$$$reportNull$$$0(4);
        }
        if (interpreter == null) {
            NodeJsInterpreterRenderer.$$$reportNull$$$0(5);
        }
        Ref<SemVer> versionRef = interpreter.getCachedVersion();
        boolean valid = true;
        if (versionRef != null && versionRef.isNull()) {
            NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast(interpreter);
            valid = localInterpreter == null || localInterpreter.isValid();
        }
        this.myNameComp.append(interpreter.getPresentableName(), valid ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.ERROR_ATTRIBUTES);
        if (this.myIsProjectInterpreter.apply((Object)interpreter)) {
            SimpleTextAttributes attrs = isSelected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
            this.myNameComp.append("  (Project)", attrs);
        }
        if (versionRef != null) {
            SemVer version2 = (SemVer)versionRef.get();
            if (version2 != null) {
                this.addVersion(version2, isSelected);
            }
        } else {
            ModalityState modalityState = ModalityState.current();
            interpreter.fetchVersion((NullableConsumer<SemVer>)((NullableConsumer)version -> {
                if (list == null) {
                    NodeJsInterpreterRenderer.$$$reportNull$$$0(9);
                }
                if (interpreter == null) {
                    NodeJsInterpreterRenderer.$$$reportNull$$$0(10);
                }
                if (version != null) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (list == null) {
                            NodeJsInterpreterRenderer.$$$reportNull$$$0(11);
                        }
                        if (interpreter == null) {
                            NodeJsInterpreterRenderer.$$$reportNull$$$0(12);
                        }
                        NodeJsInterpreterRenderer.scheduleRepaint(list, interpreter, index);
                    }, modalityState);
                }
            }));
        }
    }

    private static void scheduleRepaint(@NotNull JList<? extends NodeJsInterpreter> list, @NotNull NodeJsInterpreter interpreter, int index) {
        NodeJsInterpreter value;
        if (list == null) {
            NodeJsInterpreterRenderer.$$$reportNull$$$0(6);
        }
        if (interpreter == null) {
            NodeJsInterpreterRenderer.$$$reportNull$$$0(7);
        }
        if (!list.isVisible()) {
            return;
        }
        ListModel<? extends NodeJsInterpreter> listModel = list.getModel();
        if (index == -1) {
            if (listModel instanceof NodeJsInterpreterField.NodeJsInterpreterComboBoxModel) {
                ((NodeJsInterpreterField.NodeJsInterpreterComboBoxModel)listModel).repaintSelectedElementIfMatches(interpreter);
            } else {
                LOG.warn("Expected ListModel class: " + NodeJsInterpreterField.NodeJsInterpreterComboBoxModel.class + ", actual: " + listModel.getClass());
            }
        } else if (0 <= index && index < listModel.getSize() && (value = listModel.getElementAt(index)) == interpreter) {
            list.repaint(list.getCellBounds(index, index));
        }
    }

    private void addVersion(@NotNull SemVer version, boolean isSelected) {
        if (version == null) {
            NodeJsInterpreterRenderer.$$$reportNull$$$0(8);
        }
        SimpleTextAttributes attrs = isSelected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES;
        this.myVersionComp.append(version.getRawVersion(), attrs);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isProjectInterpreter";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRenderer";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRenderer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInLeftRightJustifyingContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "adjustBorderHeight";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "wrapInLeftRightJustifyingContainer";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "customize";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "scheduleRepaint";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addVersion";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$customize$1";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

