/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePackageDescriptor {
    private final List<String> myPackageNames;

    public NodePackageDescriptor(@NotNull String packageName) {
        if (packageName == null) {
            NodePackageDescriptor.$$$reportNull$$$0(0);
        }
        this.myPackageNames = Collections.singletonList(packageName);
    }

    public NodePackageDescriptor(String ... packageNames) {
        if (packageNames == null) {
            NodePackageDescriptor.$$$reportNull$$$0(1);
        }
        this.myPackageNames = ImmutableList.copyOf((Object[])packageNames);
    }

    public NodePackageDescriptor(@NotNull List<String> packageNames) {
        if (packageNames == null) {
            NodePackageDescriptor.$$$reportNull$$$0(2);
        }
        this.myPackageNames = ImmutableList.copyOf(packageNames);
    }

    @NotNull
    public List<String> getPackageNames() {
        List<String> list = this.myPackageNames;
        if (list == null) {
            NodePackageDescriptor.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public NodePackage findPreferredPackage(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory) {
        if (project == null) {
            NodePackageDescriptor.$$$reportNull$$$0(4);
        }
        NodePackage nodePackage = this.findFirstDirectDependencyPackage(project, interpreter, contextFileOrDirectory);
        if (nodePackage == null) {
            NodePackageDescriptor.$$$reportNull$$$0(5);
        }
        return nodePackage;
    }

    @NotNull
    public NodePackage findFirstDirectDependencyPackage(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory) {
        if (project == null) {
            NodePackageDescriptor.$$$reportNull$$$0(6);
        }
        NodePackage nodePackage = (NodePackage)ReadAction.compute(() -> {
            List<NodePackage> packages;
            NodePackage pkg;
            if (project == null) {
                NodePackageDescriptor.$$$reportNull$$$0(17);
            }
            return (pkg = (NodePackage)ContainerUtil.getFirstItem(packages = this.listAvailable(project, interpreter, contextFileOrDirectory, true))) != null ? pkg : new NodePackage("");
        });
        if (nodePackage == null) {
            NodePackageDescriptor.$$$reportNull$$$0(7);
        }
        return nodePackage;
    }

    @NotNull
    public final List<NodePackage> listAvailable(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory) {
        if (project == null) {
            NodePackageDescriptor.$$$reportNull$$$0(8);
        }
        List<NodePackage> list = this.listAvailable(project, interpreter, contextFileOrDirectory, false);
        if (list == null) {
            NodePackageDescriptor.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public final List<NodePackage> listAvailable(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory, boolean directDependenciesInsideProject) {
        if (project == null) {
            NodePackageDescriptor.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        LinkedHashSet<NodePackage> packages = new LinkedHashSet<NodePackage>();
        for (String packageName : this.myPackageNames) {
            NodePackageDescriptor.listAvailable(packages, packageName, project, interpreter, contextFileOrDirectory, directDependenciesInsideProject);
        }
        ArrayList<NodePackage> arrayList = new ArrayList<NodePackage>(packages);
        if (arrayList == null) {
            NodePackageDescriptor.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private static void listAvailable(@NotNull Set<NodePackage> packages, @NotNull String packageName, @NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory, boolean directDependenciesInsideProject) {
        if (packages == null) {
            NodePackageDescriptor.$$$reportNull$$$0(12);
        }
        if (packageName == null) {
            NodePackageDescriptor.$$$reportNull$$$0(13);
        }
        if (project == null) {
            NodePackageDescriptor.$$$reportNull$$$0(14);
        }
        ArrayList modules = ContainerUtil.newArrayList();
        if (contextFileOrDirectory != null) {
            NodeModuleSearchUtil.findModulesWithName((List<CompletionModuleInfo>)modules, packageName, contextFileOrDirectory, false, null);
        }
        NodeModuleSearchUtil.findModulesByNameInContentRoots(modules, packageName, project, false, interpreter, true);
        Collection<Object> packageJsonFiles = Collections.emptyList();
        if (!DumbService.isDumb((Project)project)) {
            try {
                packageJsonFiles = FilenameIndex.getVirtualFilesByName((Project)project, (String)"package.json", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
        for (Object packageJson : packageJsonFiles) {
            VirtualFile nodeModulesDir;
            PackageJsonData data = PackageJsonData.getOrCreate((VirtualFile)packageJson);
            if (!data.getAllDependencies().contains(packageName) || (nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson((VirtualFile)packageJson)) == null) continue;
            NodeModuleSearchUtil.findModuleWithNameInDirectory(modules, nodeModulesDir, ModuleType.NODE_MODULES_DIR, packageName);
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
        for (CompletionModuleInfo module : modules) {
            VirtualFile packageJson;
            VirtualFile dir = module.getVirtualFile();
            if (dir == null || !dir.isDirectory()) continue;
            boolean ok = true;
            if (directDependenciesInsideProject && JSLibraryUtil.getContentRootForFile(fileIndex, dir) != null && (packageJson = NodeModuleUtil.findPackageJsonByNodeModules(dir.getParent())) != null) {
                PackageJsonData data = PackageJsonData.getOrCreate(packageJson);
                ok = data.isDependencyOfAnyType(packageName);
            }
            if (!ok) continue;
            packages.add(new NodePackage(dir.getPath()));
        }
        if (!directDependenciesInsideProject && "yarn".equals(packageName)) {
            if (SystemInfo.isWindows) {
                NodePackageDescriptor.tryAdd(packages, new File("C:\\Program Files (x86)\\Yarn"));
                NodePackageDescriptor.tryAdd(packages, new File("C:\\Program Files\\Yarn"));
            } else {
                NodePackageDescriptor.tryAdd(packages, new File("/usr/share/yarn"));
                NodePackageDescriptor.tryAdd(packages, new File("/opt/local/libexec/yarn"));
                File cellarYarnDir = NodePackageDescriptor.findCellarYarnDir();
                if (cellarYarnDir != null) {
                    File[] versions;
                    for (File version : versions = (File[])ObjectUtils.notNull((Object)cellarYarnDir.listFiles(), (Object)ArrayUtil.EMPTY_FILE_ARRAY)) {
                        if (NodePackageDescriptor.tryAdd(packages, new File(version, "libexec"))) continue;
                        NodePackageDescriptor.tryAdd(packages, new File(version, "libexec/lib/node_modules/yarn"));
                    }
                }
            }
        }
    }

    private static boolean tryAdd(@NotNull Set<NodePackage> packages, @NotNull File packageDir) {
        File packageJson;
        if (packages == null) {
            NodePackageDescriptor.$$$reportNull$$$0(15);
        }
        if (packageDir == null) {
            NodePackageDescriptor.$$$reportNull$$$0(16);
        }
        if (packageDir.isDirectory() && (packageJson = new File(packageDir, "package.json")).isFile()) {
            packages.add(new NodePackage(packageDir.getAbsolutePath()));
            return true;
        }
        return false;
    }

    private static File findCellarYarnDir() {
        File yarn;
        File root;
        File bin;
        File yarnExe = PathEnvironmentVariableUtil.findInPath((String)"yarn");
        if (yarnExe != null && (bin = yarnExe.getParentFile()) != null && bin.getName().equals("bin") && (root = bin.getParentFile()) != null && (yarn = new File(root, "Cellar/yarn")).isDirectory()) {
            return yarn;
        }
        File yarn2 = new File(SystemProperties.getUserHome(), ".linuxbrew/Cellar/yarn");
        if (yarn2.isDirectory()) {
            return yarn2;
        }
        yarn2 = new File("/usr/local/Cellar/yarn");
        if (yarn2.isDirectory()) {
            return yarn2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNames";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/util/NodePackageDescriptor";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/util/NodePackageDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageNames";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findPreferredPackage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findFirstDirectDependencyPackage";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "listAvailable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findPreferredPackage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findFirstDirectDependencyPackage";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "listAvailable";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "tryAdd";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findFirstDirectDependencyPackage$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

