/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.refactoring;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ES6MoveSymbolDialog
extends RefactoringDialog {
    public static final String MOVE_ES6_MEMBERS_OPEN_IN_EDITOR = "Move.ES6.Members.OpenInEditor";
    private static final String RECENT_KEYS = "es6.move.members.recent.items";
    @NotNull
    protected final TextFieldWithHistoryWithBrowseButton myModuleField;
    @NotNull
    protected final JPanel myExtraPanel;
    @NotNull
    protected final JPanel myPanel;
    @NotNull
    protected final JBTextField myFromField;
    @NotNull
    private final JCheckBox myOpenEditorCb;

    private static void initializeDestinationField(@NotNull Project project, @NotNull String toPath, @NotNull PsiElement context, @NotNull TextFieldWithHistoryWithBrowseButton moduleField) {
        if (project == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(0);
        }
        if (toPath == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(1);
        }
        if (context == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(2);
        }
        if (moduleField == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(3);
        }
        PsiFile file = context.getContainingFile();
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileDescriptor((FileType)file.getFileType());
        descriptor2.setRoots(ProjectRootManager.getInstance((Project)project).getContentRoots());
        descriptor2.withTreeRootVisible(true);
        TextComponentAccessor<TextFieldWithHistory> accessor = new TextComponentAccessor<TextFieldWithHistory>(){

            public String getText(TextFieldWithHistory component) {
                return component.getText();
            }

            public void setText(TextFieldWithHistory component, @NotNull String text) {
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                component.setTextAndAddToHistory(text);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/ecmascript6/refactoring/ES6MoveSymbolDialog$1", "setText"));
            }
        };
        String message = JSBundle.message((String)"es6.move.module.members.refactoring.dialog.move.member.to", (Object[])new Object[0]);
        moduleField.addBrowseFolderListener(message, null, project, descriptor2, (TextComponentAccessor)accessor);
        List entries = RecentsManager.getInstance((Project)project).getRecentEntries(RECENT_KEYS);
        TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)moduleField.getChildComponent();
        if (entries != null) {
            textFieldWithHistory.setHistory(entries);
        }
        textFieldWithHistory.setText(toPath);
        moduleField.setTextFieldPreferredWidth(70);
    }

    public ES6MoveSymbolDialog(@NotNull Project project, @NotNull String fromPath, @NotNull String toPath, @NotNull PsiElement context) {
        if (project == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(4);
        }
        if (fromPath == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(5);
        }
        if (toPath == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(6);
        }
        if (context == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(7);
        }
        super(project, true);
        this.myExtraPanel = new JPanel(new BorderLayout());
        FormBuilder builder = FormBuilder.createFormBuilder();
        this.myFromField = new JBTextField();
        this.myFromField.setText(fromPath);
        this.myFromField.setEnabled(false);
        this.myModuleField = new TextFieldWithHistoryWithBrowseButton();
        ES6MoveSymbolDialog.initializeDestinationField(project, toPath, context, this.myModuleField);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myModuleField);
        boolean openInEditorDefaultValue = PropertiesComponent.getInstance().getBoolean(MOVE_ES6_MEMBERS_OPEN_IN_EDITOR, true);
        this.myOpenEditorCb = new NonFocusableCheckBox(JSBundle.message((String)"es6.move.module.members.refactoring.dialog.open.in.editor", (Object[])new Object[0]));
        this.myOpenEditorCb.setSelected(openInEditorDefaultValue);
        builder.addLabeledComponent(JSBundle.message((String)"es6.move.module.members.refactoring.dialog.field.from", (Object[])new Object[0]), (JComponent)this.myFromField);
        builder.addLabeledComponent(JSBundle.message((String)"es6.move.module.members.refactoring.dialog.field.to", (Object[])new Object[0]), (JComponent)this.myModuleField);
        String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("CodeCompletion"));
        builder.addTooltip(RefactoringBundle.message((String)"path.completion.shortcut", (Object[])new Object[]{shortcutText}));
        builder.addComponent((JComponent)this.myExtraPanel);
        builder.addComponent((JComponent)this.myOpenEditorCb);
        JPanel panel = builder.getPanel();
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)panel, "North");
        this.myPanel = wrapper;
    }

    public void saveOpenInEditorOption() {
        PropertiesComponent.getInstance().setValue(MOVE_ES6_MEMBERS_OPEN_IN_EDITOR, this.myOpenEditorCb.isSelected(), true);
    }

    public boolean isOpenInEditor() {
        return this.myOpenEditorCb.isSelected();
    }

    protected void doAction() {
        String text = ((TextFieldWithHistory)this.myModuleField.getChildComponent()).getText();
        if (!StringUtil.isEmpty((String)text)) {
            RecentsManager.getInstance((Project)this.myProject).registerRecentEntry(RECENT_KEYS, text);
        }
        this.close(0);
    }

    protected void init() {
        super.init();
        this.preselectLastPathComponent((TextFieldWithHistory)this.myModuleField.getChildComponent());
    }

    protected void preselectLastPathComponent(@NotNull TextFieldWithHistory field) {
        String text;
        if (field == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(8);
        }
        if (StringUtil.isEmpty((String)(text = FileUtil.toCanonicalPath((String)field.getText())))) {
            return;
        }
        int separator = text.lastIndexOf(47);
        int length = text.length();
        if (separator > 0 && separator + 1 < length) {
            JTextField editor = field.getTextEditor();
            editor.select(separator + 1, length);
        }
    }

    @Nullable
    protected JComponent createNorthPanel() {
        return this.myPanel;
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myModuleField;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toPath";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleField";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ecmascript6/refactoring/ES6MoveSymbolDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "initializeDestinationField";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "preselectLastPathComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

