/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.resolve;

import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.ecmascript6.resolve.JSModuleElementsProcessor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextUtil;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyInstanceContextElement;
import com.intellij.lang.javascript.psi.resolve.processors.JSCandidateResultProcessor;
import com.intellij.lang.javascript.psi.resolve.processors.JSQualifiedItemProcessorBase;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.typescript.TypeScriptResolveHelper;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6PsiUtil {
    public static final TokenSet DECLARATIONS = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.EXPORT_DECLARATION});
    public static final String DEFAULT_NAME = "default";

    @NotNull
    public static Collection<PsiElement> getBindingAllPossibleExports(@NotNull Collection<PsiElement> elements) {
        if (elements == null) {
            ES6PsiUtil.$$$reportNull$$$0(0);
        }
        for (PsiElement element : elements) {
            TypeScriptExportAssignment assignment = TypeScriptPsiUtil.findExportAssignment(element);
            if (assignment == null) continue;
            ArrayList arrayList = ContainerUtil.newArrayList((Object[])new PsiElement[]{assignment});
            if (arrayList == null) {
                ES6PsiUtil.$$$reportNull$$$0(1);
            }
            return arrayList;
        }
        Collection<PsiElement> collection = elements;
        if (collection == null) {
            ES6PsiUtil.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @Nullable
    public static JSElement findDefaultExport(@NotNull PsiElement scopeElement) {
        Stream<? extends PsiElement> stream;
        Optional<? extends PsiElement> exportDefaultAssignment;
        if (scopeElement == null) {
            ES6PsiUtil.$$$reportNull$$$0(3);
        }
        if ((exportDefaultAssignment = (stream = JSStubBasedPsiTreeUtil.getFilteredFileOrModuleChildrenStream(scopeElement, ES6ElementTypes.EXPORT_DEFAULT_ASSIGNMENT, ES6ExportDefaultAssignment.class)).findAny()).isPresent()) {
            PsiElement element = exportDefaultAssignment.get();
            return element instanceof JSElement ? (JSElement)element : null;
        }
        final Ref resultElement = Ref.create();
        JSResolveProcessorBase processor = new JSResolveProcessorBase(DEFAULT_NAME){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (element instanceof ES6ExportSpecifierAlias || element instanceof ES6ExportSpecifier || element instanceof ES6ExportedDefaultBinding) {
                    resultElement.set((Object)element);
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        JSStubBasedPsiTreeUtil.processDeclarationsInScope(scopeElement, processor, false);
        PsiElement result = (PsiElement)resultElement.get();
        if (!(result instanceof JSElement)) {
            return null;
        }
        if (result instanceof ES6ExportSpecifier) {
            ResolveResult[] resultResultsForSpecifier = ((ES6ExportSpecifier)result).multiResolve(false);
            PsiElement item = (PsiElement)ContainerUtil.getFirstItem(JSResolveResult.toElements(resultResultsForSpecifier));
            return item instanceof JSElement ? (JSElement)item : null;
        }
        return (JSElement)result;
    }

    public static boolean isAsyncContext(@Nullable JSFunction function) {
        if (function == null) {
            return false;
        }
        JSAttributeList attributeList = function.getAttributeList();
        return attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.ASYNC);
    }

    @Contract(value="null -> false")
    public static boolean isAwaitExpression(@Nullable PsiElement expression) {
        JSPrefixExpression prefixExpression;
        JSPrefixExpression jSPrefixExpression = prefixExpression = expression instanceof JSPrefixExpression ? (JSPrefixExpression)expression : null;
        if (prefixExpression != null) {
            return prefixExpression.getOperationSign() == JSTokenTypes.AWAIT_KEYWORD;
        }
        return false;
    }

    public static boolean isGeneratorContext(@Nullable JSFunction parent) {
        if (parent != null) {
            return parent.isGenerator();
        }
        return false;
    }

    public static boolean processExportAllDeclarations(@NotNull JSElement owner, PsiElement place, @NotNull JSModuleElementsProcessor processor, Collection<PsiElement> visited) {
        if (owner == null) {
            ES6PsiUtil.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            ES6PsiUtil.$$$reportNull$$$0(5);
        }
        if (!ES6PsiUtil.isExternalModule((PsiElement)owner)) {
            return true;
        }
        PsiElement[] children = JSStubBasedPsiTreeUtil.getChildrenByType(owner, DECLARATIONS);
        if (children == null) {
            return true;
        }
        for (PsiElement child : children) {
            ES6FromClause clause;
            ES6ExportDeclaration declaration;
            if (!(child instanceof ES6ExportDeclaration) || !(declaration = (ES6ExportDeclaration)child).isExportAll() || (clause = declaration.getFromClause()) == null) continue;
            Collection<PsiElement> elements = ES6PsiUtil.getFromClauseResolvedReferences(clause);
            for (PsiElement element : elements) {
                if (!(element instanceof JSElement) || element.isEquivalentTo((PsiElement)owner)) continue;
                if (visited == null) {
                    visited = ContainerUtil.newHashSet();
                }
                if (ES6PsiUtil.processExportDeclarationInScope((JSElement)element, processor, null, ResolveState.initial(), (PsiElement)element.getContainingFile(), place, visited)) continue;
                return false;
            }
        }
        return true;
    }

    private static Collection<PsiElement> getFromClauseResolvedReferences(@NotNull ES6FromClause clause) {
        if (clause == null) {
            ES6PsiUtil.$$$reportNull$$$0(6);
        }
        Collection elements = clause.resolveReferencedElements();
        ArrayList result = ContainerUtil.newArrayListWithCapacity((int)elements.size());
        for (PsiElement element : elements) {
            TypeScriptExportAssignment assignment = TypeScriptPsiUtil.findExportAssignment(element);
            if (assignment == null) {
                result.add(element);
                continue;
            }
            String name = assignment.getInitializerReference();
            if (name == null) continue;
            JSTypeResolveResult typeResolveResult = TypeScriptImportHandler.getInstance().resolveName(name, (PsiElement)assignment);
            result.addAll(typeResolveResult.getElements());
        }
        return result;
    }

    @NotNull
    public static List<JSType> processSpecifier(@NotNull ES6ImportExportSpecifier specifier, @NotNull ResultSink sink) {
        JSElement scope;
        ES6ImportExportDeclaration declaration;
        if (specifier == null) {
            ES6PsiUtil.$$$reportNull$$$0(7);
        }
        if (sink == null) {
            ES6PsiUtil.$$$reportNull$$$0(8);
        }
        if ((declaration = specifier.getDeclaration()) == null) {
            List<JSType> list = Collections.emptyList();
            if (list == null) {
                ES6PsiUtil.$$$reportNull$$$0(9);
            }
            return list;
        }
        ES6FromClause clause = declaration.getFromClause();
        List innerAliases = null;
        if (clause != null) {
            Collection<PsiElement> scopes = ES6PsiUtil.getFromClauseResolvedReferences(clause);
            for (PsiElement scope2 : scopes) {
                QualifiedItemProcessor<?> processor = ES6PsiUtil.createSpecifierResolveProcessor(specifier, scope2, sink);
                JSDelegatingModuleElementsProcessor delegatingProcessor = new JSDelegatingModuleElementsProcessor(processor);
                ES6PsiUtil.processSpecifierForScope(specifier, delegatingProcessor, scope2);
                innerAliases = delegatingProcessor.myInnerAliases;
            }
        } else if (specifier instanceof ES6ExportSpecifier && (scope = ES6PsiUtil.getExportScope((PsiElement)specifier)) != null) {
            final QualifiedItemProcessor<?> processor = ES6PsiUtil.createSpecifierResolveProcessor(specifier, (PsiElement)scope, sink);
            JSResolveProcessorBase delegatingProcessor = new JSResolveProcessorBase(processor.getName()){

                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                    if (element == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (state == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (element instanceof ES6ExportSpecifier || element instanceof ES6ExportSpecifierAlias) {
                        return true;
                    }
                    return processor.execute(element, state);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "state";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$2";
                    objectArray[2] = "execute";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            JSResolveUtil.processDeclarationsInScope(scope, delegatingProcessor, ResolveState.initial(), (PsiElement)scope.getContainingFile(), (PsiElement)specifier);
        }
        List list = innerAliases != null ? innerAliases : Collections.emptyList();
        if (list == null) {
            ES6PsiUtil.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static boolean processSpecifierForScope(@NotNull ES6ImportExportSpecifier specifier, @NotNull JSModuleElementsProcessor processor, PsiElement scope) {
        if (specifier == null) {
            ES6PsiUtil.$$$reportNull$$$0(11);
        }
        if (processor == null) {
            ES6PsiUtil.$$$reportNull$$$0(12);
        }
        if (!(scope instanceof JSElement)) {
            return true;
        }
        if (scope instanceof JSVariable) {
            JSType possibleType = ((JSVariable)scope).getType();
            if (possibleType != null) {
                processor.process(possibleType, new JSEvaluateContext(scope.getContainingFile()), scope);
            }
            return true;
        }
        return ES6PsiUtil.processExportDeclarationInScope((JSElement)scope, processor, ResolveState.initial(), (PsiElement)specifier);
    }

    public static QualifiedItemProcessor<?> createSpecifierResolveProcessor(@NotNull ES6ImportExportSpecifier specifier, @NotNull PsiElement scope, @NotNull ResultSink sink) {
        if (specifier == null) {
            ES6PsiUtil.$$$reportNull$$$0(13);
        }
        if (scope == null) {
            ES6PsiUtil.$$$reportNull$$$0(14);
        }
        if (sink == null) {
            ES6PsiUtil.$$$reportNull$$$0(15);
        }
        QualifiedItemProcessor<? extends ResultSink> processor = JSDialectSpecificHandlersFactory.forElement(scope).createCompletionItemProcessor(sink, specifier.getContainingFile());
        processor.setLocalResolve(true);
        processor.setTypeContext(true);
        processor.setSkipImplicitDeclarations(true);
        return processor;
    }

    public static void addInnerAliases(@NotNull List<JSType> innerAliases, @NotNull BaseJSSymbolProcessor processor) {
        if (innerAliases == null) {
            ES6PsiUtil.$$$reportNull$$$0(16);
        }
        if (processor == null) {
            ES6PsiUtil.$$$reportNull$$$0(17);
        }
        for (JSType type : innerAliases) {
            JSNamespaceEvaluationResult ns = JSNamespaceEvaluationResult.fromType(type);
            PsiFile scope = type.getSource().getScope();
            if (ns == null) continue;
            processor.addTypeHierarchy(ns, scope);
        }
    }

    @Nullable
    public static JSElement getExportScope(@NotNull PsiElement element) {
        if (element == null) {
            ES6PsiUtil.$$$reportNull$$$0(18);
        }
        return element instanceof PsiFile ? null : (JSElement)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{TypeScriptModule.class, JSFile.class});
    }

    @Nullable
    public static PsiElement getNonStrictExportScope(@NotNull PsiElement element) {
        if (element == null) {
            ES6PsiUtil.$$$reportNull$$$0(19);
        }
        return PsiTreeUtil.getContextOfType((PsiElement)element, (boolean)false, (Class[])new Class[]{TypeScriptModule.class, JSFile.class});
    }

    public static boolean processExportDeclarationInScope(@NotNull JSElement scope, @NotNull JSModuleElementsProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (scope == null) {
            ES6PsiUtil.$$$reportNull$$$0(20);
        }
        if (processor == null) {
            ES6PsiUtil.$$$reportNull$$$0(21);
        }
        if (state == null) {
            ES6PsiUtil.$$$reportNull$$$0(22);
        }
        if (place == null) {
            ES6PsiUtil.$$$reportNull$$$0(23);
        }
        return ES6PsiUtil.processExportDeclarationInScope(scope, processor, null, state, null, place, null);
    }

    public static boolean processExportDeclarationInScope(@NotNull JSElement scope, @NotNull JSModuleElementsProcessor processor, @Nullable JSEvaluationResultContext evaluateContext, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place, @Nullable Collection<PsiElement> visited) {
        boolean isES6Module;
        if (scope == null) {
            ES6PsiUtil.$$$reportNull$$$0(24);
        }
        if (processor == null) {
            ES6PsiUtil.$$$reportNull$$$0(25);
        }
        if (state == null) {
            ES6PsiUtil.$$$reportNull$$$0(26);
        }
        if (place == null) {
            ES6PsiUtil.$$$reportNull$$$0(27);
        }
        if (visited != null && !visited.add((PsiElement)scope)) {
            return false;
        }
        boolean hasIncompleteMatch = false;
        boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)scope);
        if (scope instanceof JSFile && !isTypeScript && ES6PsiUtil.isEmptyContext(evaluateContext)) {
            GlobalSearchScope fileScope = GlobalSearchScope.fileScope((PsiFile)((JSFile)scope));
            QualifiedItemProcessor resolveProcessor = processor instanceof ResolveProcessor ? (QualifiedItemProcessor)processor : (processor instanceof JSDelegatingModuleElementsProcessor ? ((JSDelegatingModuleElementsProcessor)processor).myDelegate : null);
            boolean processingFromIndices = false;
            if (resolveProcessor != null) {
                processingFromIndices = resolveProcessor.isProcessingFromIndices();
                resolveProcessor.setSkipImplicitDeclarations(true);
            }
            Processor namespaceMembersProcessor = element -> {
                if (processor == null) {
                    ES6PsiUtil.$$$reportNull$$$0(39);
                }
                if (resolveProcessor != null && resolveProcessor.getName() == null && (element.getAccessType() == JSAttributeList.AccessType.PRIVATE || JSVisibilityUtil.seemsToBePrivateSymbol(element.getName()))) {
                    return true;
                }
                return processor.execute((PsiElement)element, ResolveState.initial());
            };
            JSClassResolver.getInstance().processNamespaceMembers("exports", fileScope, (Processor<JSPsiElementBase>)namespaceMembersProcessor);
            JSClassResolver.getInstance().processNamespaceMembers("module.exports", fileScope, (Processor<JSPsiElementBase>)namespaceMembersProcessor);
            if (resolveProcessor != null) {
                resolveProcessor.setSkipImplicitDeclarations(processingFromIndices);
            }
        }
        if (scope instanceof JSFile && !isTypeScript) {
            JSType exportsInnerAlias = ((JSFile)scope).getExportsInnerAlias();
            if (exportsInnerAlias != null) {
                if (visited == null) {
                    visited = ContainerUtil.newHashSet();
                }
                HashSet _visited = visited;
                JSApplyContextUtil.applyTypeToContext(exportsInnerAlias, evaluateContext, (newType, newContext) -> {
                    if (scope == null) {
                        ES6PsiUtil.$$$reportNull$$$0(33);
                    }
                    if (processor == null) {
                        ES6PsiUtil.$$$reportNull$$$0(34);
                    }
                    if (place == null) {
                        ES6PsiUtil.$$$reportNull$$$0(35);
                    }
                    JSTypeUtils.processExpandedType((Processor<JSType>)((Processor)typeComponent -> {
                        if (scope == null) {
                            ES6PsiUtil.$$$reportNull$$$0(36);
                        }
                        if (processor == null) {
                            ES6PsiUtil.$$$reportNull$$$0(37);
                        }
                        if (place == null) {
                            ES6PsiUtil.$$$reportNull$$$0(38);
                        }
                        if (typeComponent instanceof JSRequireCallExpressionType) {
                            String referencedModule = ((JSRequireCallExpressionType)((Object)((Object)typeComponent))).getReferencedModule();
                            Collection<PsiElement> reexportedModules = JSFileReferencesUtil.resolveModuleReference((PsiFile)((JSFile)scope), referencedModule);
                            for (PsiElement reexportedModule : reexportedModules) {
                                if (!(reexportedModule instanceof JSElement)) continue;
                                ES6PsiUtil.processExportDeclarationInScope((JSElement)reexportedModule, processor, newContext, ResolveState.initial(), (PsiElement)reexportedModule.getContainingFile(), place, _visited);
                            }
                        }
                        return true;
                    }), newType);
                });
                JSEvaluateContext context = evaluateContext != null ? JSEvaluateContext.fromEvaluationResultContext(evaluateContext) : new JSEvaluateContext((PsiFile)scope);
                processor.process(exportsInnerAlias, context, (PsiElement)scope);
            }
            hasIncompleteMatch = exportsInnerAlias != null || !((JSFile)scope).hasES6Syntax();
        }
        ES6ExportedElementsProcessor exportedElementsProcessor = processor instanceof ES6ExportedElementsProcessor ? (ES6ExportedElementsProcessor)((Object)processor) : new ES6ExportedElementsProcessor(processor);
        boolean result = true;
        boolean bl = isES6Module = isTypeScript || scope instanceof JSFile && ((JSFile)scope).hasES6Syntax();
        if (isES6Module && ES6PsiUtil.isEmptyContext(evaluateContext)) {
            boolean bl2 = result = isTypeScript ? JSResolveUtil.processDeclarationsInScope(scope, exportedElementsProcessor, state, lastParent, place) : JSStubBasedPsiTreeUtil.processDeclarationsInScope((PsiElement)scope, exportedElementsProcessor, false);
            if (result) {
                ES6PsiUtil.processExportAllDeclarations(scope, place, processor, visited);
            }
            if (result && DialectDetector.isTypeScript((PsiElement)scope) && processor.getName() != null) {
                QualifiedItemProcessor sinkProcessor;
                QualifiedItemProcessor qualifiedItemProcessor = processor instanceof SinkResolveProcessor ? (QualifiedItemProcessor)processor : (sinkProcessor = processor instanceof JSDelegatingModuleElementsProcessor ? ((JSDelegatingModuleElementsProcessor)processor).myDelegate : null);
                if (sinkProcessor != null && ((ResultSink)sinkProcessor.getResultSink()).getResultCount() == 0) {
                    TypeScriptResolveHelper.processGlobalThings(sinkProcessor, ResolveState.initial(), (PsiElement)scope);
                }
            }
        }
        return hasIncompleteMatch || result;
    }

    private static boolean isEmptyContext(@Nullable JSEvaluationResultContext evaluateContext) {
        return evaluateContext == null || evaluateContext.isJSElementsToApplyEmpty() || evaluateContext.getJSElementsToApply().size() == 1 && evaluateContext.peekJSElementToApply() instanceof JSApplyInstanceContextElement;
    }

    public static boolean isImportElement(PsiElement item) {
        return item instanceof ES6ImportedBinding || item instanceof ES6ImportExportSpecifierAlias || item instanceof TypeScriptImportStatement;
    }

    @Deprecated
    public static PsiReference[] createImportExportFromClauseReferences(@NotNull PsiElement host, int offset, @NotNull String text, @Nullable PsiReferenceProvider provider) {
        if (host == null) {
            ES6PsiUtil.$$$reportNull$$$0(28);
        }
        if (text == null) {
            ES6PsiUtil.$$$reportNull$$$0(29);
        }
        return JSFileReferencesUtil.createImportExportFromClauseReferences(host, offset, text, provider);
    }

    public static boolean isElementCanBeExported(@NotNull PsiElement element) {
        if (element == null) {
            ES6PsiUtil.$$$reportNull$$$0(30);
        }
        return element instanceof JSAttributeListOwner && !(element instanceof TypeScriptTypeMember) && !(element instanceof JSParameter) && !(element instanceof JSProperty) && !(element instanceof JSField) && !(element instanceof TypeScriptType);
    }

    public static boolean isExternalModule(@NotNull PsiElement element) {
        if (element == null) {
            ES6PsiUtil.$$$reportNull$$$0(31);
        }
        if (element instanceof JSFile) {
            return ((JSFile)element).getModuleStatus() == JSFile.ModuleStatus.ES6;
        }
        return element instanceof TypeScriptModule && !((TypeScriptModule)element).isInternal();
    }

    @Nullable
    public static PsiElement findExternalModule(@NotNull PsiElement context) {
        if (context == null) {
            ES6PsiUtil.$$$reportNull$$$0(32);
        }
        JSElement container = ES6PsiUtil.getExportScope(context);
        while (container != null) {
            if (ES6PsiUtil.isExternalModule((PsiElement)container)) {
                return container;
            }
            if (container instanceof PsiFile) {
                return null;
            }
            container = ES6PsiUtil.getExportScope((PsiElement)container);
        }
        return null;
    }

    @Contract(value="null -> null")
    public static JSClass getES6ConstructorClass(@Nullable PsiElement element) {
        if (!(element instanceof JSFunction)) {
            return null;
        }
        if (JSResolveUtil.isConstructorFunction(element) && "constructor".equals(((JSFunction)element).getName())) {
            return JSUtils.getMemberContainingClass(element);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 5: 
            case 12: 
            case 17: 
            case 21: 
            case 25: 
            case 34: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clause";
                break;
            }
            case 7: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifier";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 14: 
            case 20: 
            case 24: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerAliases";
                break;
            }
            case 18: 
            case 19: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 23: 
            case 27: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBindingAllPossibleExports";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "processSpecifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBindingAllPossibleExports";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findDefaultExport";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processExportAllDeclarations";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFromClauseResolvedReferences";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processSpecifier";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processSpecifierForScope";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createSpecifierResolveProcessor";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addInnerAliases";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getExportScope";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getNonStrictExportScope";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processExportDeclarationInScope";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createImportExportFromClauseReferences";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isElementCanBeExported";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isExternalModule";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findExternalModule";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processExportDeclarationInScope$2";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processExportDeclarationInScope$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JSDelegatingModuleElementsProcessor
    extends JSQualifiedItemProcessorBase
    implements JSModuleElementsProcessor {
        @NotNull
        private final List<JSType> myInnerAliases;
        @NotNull
        private final QualifiedItemProcessor<?> myDelegate;

        public JSDelegatingModuleElementsProcessor(@NotNull QualifiedItemProcessor<?> delegate) {
            if (delegate == null) {
                JSDelegatingModuleElementsProcessor.$$$reportNull$$$0(0);
            }
            this.myInnerAliases = new SmartList();
            this.myDelegate = delegate;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                JSDelegatingModuleElementsProcessor.$$$reportNull$$$0(1);
            }
            if (state == null) {
                JSDelegatingModuleElementsProcessor.$$$reportNull$$$0(2);
            }
            return this.myDelegate.execute(element, state);
        }

        @Override
        @Nullable
        public String getName() {
            return this.myDelegate.getName();
        }

        @Override
        public void process(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext, PsiElement source) {
            if (type == null) {
                JSDelegatingModuleElementsProcessor.$$$reportNull$$$0(3);
            }
            if (evaluateContext == null) {
                JSDelegatingModuleElementsProcessor.$$$reportNull$$$0(4);
            }
            this.myDelegate.process(type, evaluateContext, source);
            this.myInnerAliases.add(type);
        }

        @Override
        public void executeCandidateResult(PsiElement element, String s) {
            this.myDelegate.executeCandidateResult(element, s);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluateContext";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$JSDelegatingModuleElementsProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ES6ExportedElementsProcessor
    extends JSResolveProcessorBase {
        @NotNull
        private final PsiScopeProcessor myDelegate;

        public ES6ExportedElementsProcessor(@NotNull PsiScopeProcessor delegateProcessor) {
            if (delegateProcessor == null) {
                ES6ExportedElementsProcessor.$$$reportNull$$$0(0);
            }
            super(delegateProcessor instanceof JSResolveProcessor ? ((JSResolveProcessor)delegateProcessor).getName() : null);
            this.myDelegate = delegateProcessor;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                ES6ExportedElementsProcessor.$$$reportNull$$$0(1);
            }
            if (state == null) {
                ES6ExportedElementsProcessor.$$$reportNull$$$0(2);
            }
            if (element instanceof ES6ExportSpecifier) {
                ResolveResult[] results;
                ES6ExportDeclaration declaration = ((ES6ExportSpecifier)element).getDeclaration();
                if (declaration != null && declaration.getFromClause() == null) {
                    return true;
                }
                for (ResolveResult result : results = ((ES6ExportSpecifier)element).multiResolve(false)) {
                    PsiElement resultElement;
                    if (!result.isValidResult() || (resultElement = result.getElement()) == null || this.myDelegate.execute(resultElement, state)) continue;
                    return false;
                }
            } else {
                if (ES6ImportHandler.isExported(element)) {
                    return this.myDelegate.execute(element, state);
                }
                if (this.myDelegate instanceof JSCandidateResultProcessor) {
                    ((JSCandidateResultProcessor)this.myDelegate).executeCandidateResult(element, "javascript.element.need.to.be.exported");
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegateProcessor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$ES6ExportedElementsProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

