/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.javascript.JavaScriptReferenceContributor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.injected.MultiHostRegistrarImpl;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInjectionController {
    private static final int MAX_LITERAL_PROCESSING_SIZE = 4096;
    public static final List<Class<? extends PsiElement>> ELEMENTS_TO_INJECT_IN = ContainerUtil.list((Object[])new Class[]{JSLiteralExpression.class});

    private JSInjectionController() {
    }

    public static boolean willInjectJs(@NotNull PsiElement host) {
        JSExpression[] args;
        PsiElement hostParent;
        JSReferenceExpression expression;
        JSQualifiedName name;
        if (host == null) {
            JSInjectionController.$$$reportNull$$$0(0);
        }
        JSQualifiedName jSQualifiedName = name = (expression = JSUtils.getMethodNameIfInsideCall(hostParent = host.getParent())) != null ? JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)expression) : null;
        return name != null && ("setInterval".equals(name.getName()) || "setTimeout".equals(name.getName())) && (name.getParent() == null || name.getParent().getParent() == null && "window".equals(name.getParent().getName())) && hostParent instanceof JSArgumentList && (args = ((JSArgumentList)hostParent).getArguments()).length > 0 && args[0] == host;
    }

    public static boolean willInjectCss(@NotNull PsiElement topElement) {
        ASTNode node;
        if (topElement == null) {
            JSInjectionController.$$$reportNull$$$0(1);
        }
        if ((node = topElement.getNode()) == null) {
            return false;
        }
        if (node.getTextLength() >= 4096) {
            return false;
        }
        if (JavaScriptReferenceContributor.isLiteralInCssContext(topElement, false)) {
            return JSInjectionController.checkValidAndNontrivialCss(JSInjectionController.getInjectionText(topElement));
        }
        return false;
    }

    private static boolean checkValidAndNontrivialCss(String text) {
        if (StringUtil.containsChar((String)text, (char)'?')) {
            return false;
        }
        if (StringUtil.containsChar((String)text, (char)'%')) {
            return false;
        }
        if (text.contains("##")) {
            return false;
        }
        if (StringUtil.containsChar((String)text, (char)'#')) {
            int diesIndex = text.indexOf(35);
            while (diesIndex == 0 || diesIndex > 0 && (text.charAt(diesIndex - 1) == '\'' || text.charAt(diesIndex - 1) != '=')) {
                diesIndex = text.indexOf(35, diesIndex + 1);
            }
            if (diesIndex >= 0) {
                return false;
            }
        }
        if (text.contains("[]")) {
            return false;
        }
        int eqPos = text.indexOf(61);
        if (eqPos != -1) {
            int valuePos;
            for (valuePos = eqPos + 1; valuePos < text.length() && Character.isWhitespace(text.charAt(valuePos)); ++valuePos) {
            }
            if (valuePos < text.length() && Character.isDigit(text.charAt(valuePos))) {
                return false;
            }
        }
        return !JavaScriptReferenceContributor.isSimpleCss(text);
    }

    public static boolean willInjectHtml(@NotNull PsiElement hostExpression) {
        if (hostExpression == null) {
            JSInjectionController.$$$reportNull$$$0(2);
        }
        if (!DialectDetector.isActionScript(hostExpression) && hostExpression.getTextLength() < 4096) {
            if (!hostExpression.textContains('<')) {
                return false;
            }
            String text = JSInjectionController.getInjectionText(hostExpression);
            int length = text.length();
            int tagStart = text.indexOf(60);
            return tagStart >= 0 && (tagStart < length - 1 && Character.isLetter(text.charAt(tagStart + 1)) || tagStart < length - 2 && text.charAt(tagStart + 1) == '/' && Character.isLetter(text.charAt(tagStart + 2)) || tagStart < length - 3 && text.charAt(tagStart + 1) == '!' && text.charAt(tagStart + 2) == '-' && text.charAt(tagStart + 3) == '-' || tagStart < length - 2 && text.charAt(tagStart + 1) == '!' && (text.charAt(tagStart + 2) == 'd' || text.charAt(tagStart + 2) == 'D')) && text.indexOf(62, tagStart) > 0 && !JSInjectionController.hasOuterLanguage(hostExpression);
        }
        return false;
    }

    protected static boolean hasOuterLanguage(PsiElement host) {
        final Ref result = Ref.create((Object)false);
        host.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof OuterLanguageElement) {
                    result.set((Object)true);
                    this.stopWalking();
                    return;
                }
                super.visitElement(element);
            }
        });
        return (Boolean)result.get();
    }

    @NotNull
    public static PsiElement getTopElement(@NotNull PsiLanguageInjectionHost host) {
        if (host == null) {
            JSInjectionController.$$$reportNull$$$0(3);
        }
        PsiLanguageInjectionHost parent = host;
        while (parent.getParent() instanceof JSBinaryExpression && ((JSBinaryExpression)parent.getParent()).getOperationSign() == JSTokenTypes.PLUS || parent.getParent() instanceof JSParenthesizedExpression) {
            parent = parent.getParent();
        }
        PsiLanguageInjectionHost psiLanguageInjectionHost = parent;
        if (psiLanguageInjectionHost == null) {
            JSInjectionController.$$$reportNull$$$0(4);
        }
        return psiLanguageInjectionHost;
    }

    public static List<JSLiteralExpression> getConcatenationParts(@NotNull PsiElement topElement) {
        if (topElement == null) {
            JSInjectionController.$$$reportNull$$$0(5);
        }
        final ArrayList results = ContainerUtil.newArrayList();
        topElement.accept((PsiElementVisitor)new JSRecursiveWalkingElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof JSBinaryExpression && ((JSBinaryExpression)element).getOperationSign() == JSTokenTypes.PLUS || element instanceof JSParenthesizedExpression) {
                    super.visitElement(element);
                }
            }

            public void visitJSLiteralExpression(JSLiteralExpression node) {
                if (node.isQuotedLiteral()) {
                    results.add(node);
                }
            }
        });
        return results;
    }

    @NotNull
    public static String getInjectionText(@NotNull PsiElement topElement) {
        if (topElement == null) {
            JSInjectionController.$$$reportNull$$$0(6);
        }
        String string = StringUtil.join(JSInjectionController.getConcatenationParts(topElement), jsLiteralExpression -> new JSQuotedLiteralInjector((JSLiteralExpression)jsLiteralExpression).getInjectedText(), (String)"");
        if (string == null) {
            JSInjectionController.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static List<PlaceInfo> getPlaceInfos(@NotNull PsiElement topElement) {
        if (topElement == null) {
            JSInjectionController.$$$reportNull$$$0(8);
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (JSLiteralExpression literalExpression : JSInjectionController.getConcatenationParts(topElement)) {
            result.addAll(new JSQuotedLiteralInjector(literalExpression).getPlaces());
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            JSInjectionController.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public static void injectInQuotedLiteral(@NotNull MultiHostRegistrar registrar, @NotNull Language language, @NotNull JSLiteralExpression literalExpression, @Nullable String prefix, @Nullable String suffix) {
        if (registrar == null) {
            JSInjectionController.$$$reportNull$$$0(10);
        }
        if (language == null) {
            JSInjectionController.$$$reportNull$$$0(11);
        }
        if (literalExpression == null) {
            JSInjectionController.$$$reportNull$$$0(12);
        }
        registrar.startInjecting(language);
        JSInjectionController.injectForPlaces(registrar, new JSQuotedLiteralInjector(literalExpression).getPlaces(), prefix, suffix);
        registrar.doneInjecting();
    }

    public static void concatenationAwareInject(@NotNull MultiHostRegistrar registrar, @NotNull Language language, @NotNull PsiElement topElement, @Nullable String prefix, @Nullable String suffix) {
        List<PlaceInfo> places;
        if (registrar == null) {
            JSInjectionController.$$$reportNull$$$0(13);
        }
        if (language == null) {
            JSInjectionController.$$$reportNull$$$0(14);
        }
        if (topElement == null) {
            JSInjectionController.$$$reportNull$$$0(15);
        }
        if ((places = JSInjectionController.getPlaceInfos(topElement)).isEmpty()) {
            return;
        }
        MultiHostRegistrarImpl registrarImpl = (MultiHostRegistrarImpl)registrar;
        MultiHostRegistrarImpl originalRegistrar = null;
        if (!(topElement instanceof PsiLanguageInjectionHost)) {
            registrarImpl = new MultiHostRegistrarImpl(topElement.getProject(), topElement.getContainingFile(), topElement);
            originalRegistrar = (MultiHostRegistrarImpl)registrar;
        }
        registrarImpl.startInjecting(language);
        JSInjectionController.injectForPlaces((MultiHostRegistrar)registrarImpl, places, prefix, suffix);
        registrarImpl.doneInjecting();
        if (originalRegistrar != null) {
            for (Pair pair : registrarImpl.getResult()) {
                originalRegistrar.addToResults((Place)pair.first, (PsiFile)pair.second, registrarImpl);
            }
        }
    }

    private static void injectForPlaces(@NotNull MultiHostRegistrar registrar, @NotNull List<PlaceInfo> places, @Nullable String prefix, @Nullable String suffix) {
        if (registrar == null) {
            JSInjectionController.$$$reportNull$$$0(16);
        }
        if (places == null) {
            JSInjectionController.$$$reportNull$$$0(17);
        }
        boolean first = true;
        Iterator<PlaceInfo> iterator = places.iterator();
        while (iterator.hasNext()) {
            PlaceInfo place = iterator.next();
            String placePrefix = place.getPrefix();
            String placeSuffix = place.getSuffix();
            if (first && prefix != null) {
                placePrefix = placePrefix == null ? prefix : prefix + placePrefix;
            }
            first = false;
            if (!iterator.hasNext() && suffix != null) {
                placeSuffix = placeSuffix == null ? suffix : placeSuffix + suffix;
            }
            registrar.addPlace(placePrefix, placeSuffix, place.getHost(), place.getRange());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostExpression";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/JSInjectionController";
                break;
            }
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "places";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/JSInjectionController";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectionText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "willInjectJs";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "willInjectCss";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "willInjectHtml";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTopElement";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConcatenationParts";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInjectionText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceInfos";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "injectInQuotedLiteral";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "concatenationAwareInject";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "injectForPlaces";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PlaceInfo {
        private final String myPrefix;
        private final TextRange myRange;
        private final String mySuffix;
        private final PsiLanguageInjectionHost myHost;

        public PlaceInfo(String prefix, TextRange range, String suffix, PsiLanguageInjectionHost host) {
            this.myPrefix = prefix;
            this.myRange = range;
            this.mySuffix = suffix;
            this.myHost = host;
        }

        public String getPrefix() {
            return this.myPrefix;
        }

        public String getSuffix() {
            return this.mySuffix;
        }

        public TextRange getRange() {
            return this.myRange;
        }

        public PsiLanguageInjectionHost getHost() {
            return this.myHost;
        }

        public static PlaceInfo create(String prefix, TextRange range, String suffix, PsiLanguageInjectionHost host) {
            return new PlaceInfo(prefix, range, suffix, host);
        }
    }

    static class JSQuotedLiteralInjector {
        private static final String EXTERNAL_FRAGMENT = "EXTERNAL_FRAGMENT";
        @NotNull
        private final JSLiteralExpression myQuotedLiteral;

        public JSQuotedLiteralInjector(@NotNull JSLiteralExpression quotedLiteral) {
            if (quotedLiteral == null) {
                JSQuotedLiteralInjector.$$$reportNull$$$0(0);
            }
            this.myQuotedLiteral = quotedLiteral;
        }

        public String getInjectedText() {
            String text = this.myQuotedLiteral.getText();
            StringBuilder result = new StringBuilder();
            for (PlaceInfo place : this.getPlaces()) {
                if (place.getPrefix() != null) {
                    result.append(place.getPrefix());
                }
                result.append(text.substring(place.getRange().getStartOffset(), place.getRange().getEndOffset()));
                if (place.getSuffix() == null) continue;
                result.append(place.getSuffix());
            }
            return result.toString();
        }

        public List<PlaceInfo> getPlaces() {
            if (this.myQuotedLiteral instanceof JSStringTemplateExpression) {
                JSStringTemplateExpression templateExpression = (JSStringTemplateExpression)this.myQuotedLiteral;
                TextRange[] ranges = templateExpression.getStringRanges();
                if (ranges.length > 0) {
                    ArrayList<PlaceInfo> result = new ArrayList<PlaceInfo>(ranges.length);
                    ASTNode quotedLiteralNode = this.myQuotedLiteral.getNode();
                    ASTNode backquote = quotedLiteralNode.findChildByType(JSTokenTypes.BACKQUOTE);
                    int backquoteOffset = backquote != null ? backquote.getStartOffset() - quotedLiteralNode.getStartOffset() : -1;
                    for (int i = 0; i < ranges.length; ++i) {
                        TextRange range = ranges[i];
                        String prefix = i == 0 && range.getStartOffset() > backquoteOffset + 1 ? EXTERNAL_FRAGMENT : null;
                        String suffix = i < ranges.length - 1 || range.getEndOffset() < this.myQuotedLiteral.getTextLength() - 1 ? EXTERNAL_FRAGMENT : null;
                        result.add(PlaceInfo.create(prefix, range, suffix, (PsiLanguageInjectionHost)this.myQuotedLiteral));
                    }
                    return result;
                }
                if (!ArrayUtil.isEmpty((Object[])templateExpression.getArguments())) {
                    return ContainerUtil.emptyList();
                }
            }
            int endOffset = Math.max(this.myQuotedLiteral.getTextLength() - 1, 1);
            return Collections.singletonList(PlaceInfo.create(null, TextRange.create((int)1, (int)endOffset), null, (PsiLanguageInjectionHost)this.myQuotedLiteral));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quotedLiteral", "com/intellij/lang/javascript/JSInjectionController$JSQuotedLiteralInjector", "<init>"));
        }
    }
}

