/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class JSStringUtil {
    public static final char SIMPLE_QUOTE = '\'';
    public static final char DOUBLE_QUOTE = '\"';

    private JSStringUtil() {
    }

    public static boolean isSingleQuoteStringLiteral(PsiElement expression) {
        String value = expression.getText();
        return value != null && value.charAt(0) == '\'' && value.charAt(value.length() - 1) == '\'';
    }

    public static boolean isDoubleQuoteStringLiteral(PsiElement expression) {
        String value = expression.getText();
        return JSStringUtil.isDoubleQuotedString(value);
    }

    public static boolean isDoubleQuotedString(String value) {
        return value != null && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"';
    }

    @NotNull
    public static String changeQuotes(String jsStringLiteral) {
        char newQuote;
        char oldQuote;
        if (jsStringLiteral.startsWith("'")) {
            oldQuote = '\'';
            newQuote = '\"';
        } else if (jsStringLiteral.startsWith("\"")) {
            oldQuote = '\"';
            newQuote = '\'';
        } else {
            String string = jsStringLiteral;
            if (string == null) {
                JSStringUtil.$$$reportNull$$$0(0);
            }
            return string;
        }
        StringBuilder stringBuilder = JSStringUtil.changeQuotesInternal(jsStringLiteral, oldQuote, newQuote);
        stringBuilder.setCharAt(0, newQuote);
        stringBuilder.setCharAt(stringBuilder.length() - 1, newQuote);
        String string = stringBuilder.toString();
        if (string == null) {
            JSStringUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String changeQuotesInLiteralValue(String value, char oldQuote, char newQuote) {
        String string = JSStringUtil.changeQuotesInternal(value, oldQuote, newQuote).toString();
        if (string == null) {
            JSStringUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static StringBuilder changeQuotesInternal(String source, char oldQuote, char newQuote) {
        StringBuilder buffer = new StringBuilder(source);
        boolean screened = false;
        int bufferIndex = 1;
        for (int i = 1; i < source.length() - 1; ++i) {
            char c = source.charAt(i);
            if (screened) {
                if (c == oldQuote) {
                    buffer.deleteCharAt(bufferIndex - 1);
                } else {
                    ++bufferIndex;
                }
                screened = false;
                continue;
            }
            if (c == '\\') {
                screened = true;
            } else if (c == newQuote) {
                buffer.insert(bufferIndex++, '\\');
            }
            ++bufferIndex;
        }
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            JSStringUtil.$$$reportNull$$$0(3);
        }
        return stringBuilder;
    }

    @NotNull
    public static String unescapeSimpleStringChars(@NotNull String chars) {
        if (chars == null) {
            JSStringUtil.$$$reportNull$$$0(4);
        }
        int index = 0;
        StringBuilder outChars = new StringBuilder();
        block12: while (index < chars.length()) {
            char c = chars.charAt(index);
            ++index;
            if (c != '\\') {
                outChars.append(c);
                continue;
            }
            if (index >= chars.length()) break;
            c = chars.charAt(index);
            ++index;
            if (c == 'u' || c == 'x') {
                outChars.append('\\').append(c);
                continue;
            }
            switch (c) {
                case 'b': {
                    outChars.append('\b');
                    continue block12;
                }
                case 't': {
                    outChars.append('\t');
                    continue block12;
                }
                case 'n': {
                    outChars.append('\n');
                    continue block12;
                }
                case 'f': {
                    outChars.append('\f');
                    continue block12;
                }
                case 'r': {
                    outChars.append('\r');
                    continue block12;
                }
                case '\"': {
                    outChars.append('\"');
                    continue block12;
                }
                case '/': {
                    outChars.append('/');
                    continue block12;
                }
                case '\n': {
                    outChars.append('\n');
                    continue block12;
                }
                case '\'': {
                    outChars.append('\'');
                    continue block12;
                }
                case '\\': {
                    outChars.append('\\');
                    continue block12;
                }
            }
            outChars.append(c);
        }
        String string = outChars.toString();
        if (string == null) {
            JSStringUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static void escapeSimpleStringChars(@NotNull String str, char quote, boolean escapeNewlines, boolean escapeWhitespace, boolean escapeTemplateStringArg, @NotNull StringBuilder buffer) {
        if (str == null) {
            JSStringUtil.$$$reportNull$$$0(6);
        }
        if (buffer == null) {
            JSStringUtil.$$$reportNull$$$0(7);
        }
        for (int idx = 0; idx < str.length(); ++idx) {
            char ch = str.charAt(idx);
            if (ch == '\\') {
                char next;
                char c = next = idx < str.length() - 1 ? str.charAt(idx + 1) : (char)'\u0000';
                if (next == 'u' || next == 'x') {
                    buffer.append(ch);
                    continue;
                }
                buffer.append("\\\\");
                continue;
            }
            if (ch == quote) {
                buffer.append("\\").append(ch);
                continue;
            }
            if (escapeTemplateStringArg && ch == '{') {
                char prev;
                char c = prev = idx > 0 ? str.charAt(idx - 1) : (char)'\u0000';
                if (prev == '$') {
                    buffer.append("\\").append(ch);
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            if (escapeWhitespace) {
                if (ch == '\b') {
                    buffer.append("\\b");
                    continue;
                }
                if (ch == '\t') {
                    buffer.append("\\t");
                    continue;
                }
                if (ch == '\f') {
                    buffer.append("\\f");
                    continue;
                }
                if (ch == '\r') {
                    buffer.append("\\r");
                    continue;
                }
            }
            if (escapeNewlines && ch == '\n') {
                buffer.append("\\n");
                continue;
            }
            buffer.append(ch);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String unquoteAndUnescapeString(@NotNull String s) {
        if (s == null) {
            JSStringUtil.$$$reportNull$$$0(8);
        }
        if (StringUtil.isQuotedString((String)s)) {
            String string = JSStringUtil.unescapeSimpleStringChars(StringUtil.replaceUnicodeEscapeSequences((String)s.substring(1, s.length() - 1)));
            if (string == null) {
                JSStringUtil.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = StringUtil.replaceUnicodeEscapeSequences((String)s);
        if (string == null) {
            JSStringUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    public static double parseNumericValue(@NotNull String value) throws NumberFormatException {
        if (value == null) {
            JSStringUtil.$$$reportNull$$$0(11);
        }
        return JSStringUtil.parseNumericValue(value, 0, false).getValue();
    }

    @NotNull
    public static NumberParseResult parseNumericValue(@NotNull String value, int startOffset, boolean allowPlus) throws NumberFormatException {
        char ch0;
        boolean signed;
        if (value == null) {
            JSStringUtil.$$$reportNull$$$0(12);
        }
        int offset = startOffset;
        int totalLength = value.length();
        if (totalLength == 0) {
            throw new NumberFormatException("Value cannot be empty");
        }
        if (offset >= totalLength) {
            throw new NumberFormatException("Offset " + offset + " cannot be greater than string length " + totalLength);
        }
        char sign = value.charAt(offset);
        boolean bl = signed = sign == '-' || allowPlus && sign == '+';
        if (signed) {
            ++offset;
        }
        if (Character.isDigit(ch0 = value.charAt(offset))) {
            char ch = ch0;
            StringBuilder builder = new StringBuilder();
            if (signed) {
                builder.append(sign);
            }
            if (ch == '0') {
                int radix;
                Function allowedCharFilter;
                if (++offset >= totalLength) {
                    NumberParseResult numberParseResult = new NumberParseResult(0.0, offset, "0");
                    if (numberParseResult == null) {
                        JSStringUtil.$$$reportNull$$$0(13);
                    }
                    return numberParseResult;
                }
                char litCh = ch = value.charAt(offset);
                switch (ch) {
                    case 'B': 
                    case 'b': {
                        allowedCharFilter = c -> c.charValue() == '0' || c.charValue() == '1';
                        radix = 2;
                        break;
                    }
                    case 'O': 
                    case 'o': {
                        allowedCharFilter = StringUtil::isOctalDigit;
                        radix = 8;
                        break;
                    }
                    case 'X': 
                    case 'x': {
                        allowedCharFilter = StringUtil::isHexDigit;
                        radix = 16;
                        break;
                    }
                    default: {
                        NumberParseResult numberParseResult = new NumberParseResult(0.0, offset, "0");
                        if (numberParseResult == null) {
                            JSStringUtil.$$$reportNull$$$0(14);
                        }
                        return numberParseResult;
                    }
                }
                if (++offset < totalLength) {
                    ch = value.charAt(offset);
                    while (((Boolean)allowedCharFilter.fun((Object)Character.valueOf(ch))).booleanValue()) {
                        builder.append(ch);
                        if (++offset >= totalLength) break;
                        ch = value.charAt(offset);
                    }
                }
                String s = builder.toString();
                NumberParseResult numberParseResult = new NumberParseResult(Long.parseLong(s, radix), offset, "0" + litCh + s);
                if (numberParseResult == null) {
                    JSStringUtil.$$$reportNull$$$0(15);
                }
                return numberParseResult;
            }
            if (ch == '.') {
                if (++offset >= totalLength) {
                    throw new NumberFormatException("Invalid numeric value " + value);
                }
                builder.append(ch);
                ch = value.charAt(offset);
            }
            boolean hadDot = false;
            boolean hadExp = false;
            while (Character.isDigit(ch)) {
                builder.append(ch);
                if (++offset >= totalLength) break;
                ch = value.charAt(offset);
                if (!hadDot && ch == '.') {
                    builder.append(ch);
                    if (++offset >= totalLength) break;
                    ch = value.charAt(offset);
                    hadDot = true;
                    continue;
                }
                if (hadExp || ch != 'e' && ch != 'E') continue;
                builder.append(ch);
                if (++offset >= totalLength) break;
                ch = value.charAt(offset);
                hadDot = true;
                hadExp = true;
                if (ch != '+' && ch != '-') continue;
                builder.append(ch);
                if (++offset >= totalLength) break;
                ch = value.charAt(offset);
            }
            String s = builder.toString();
            NumberParseResult numberParseResult = new NumberParseResult(Double.parseDouble(s), offset, s);
            if (numberParseResult == null) {
                JSStringUtil.$$$reportNull$$$0(16);
            }
            return numberParseResult;
        }
        throw new NumberFormatException("Invalid numeric value " + value);
    }

    public static boolean isNumericValueStart(@NotNull String value, boolean allowPlus) {
        if (value == null) {
            JSStringUtil.$$$reportNull$$$0(17);
        }
        if (value.length() == 0) {
            return false;
        }
        int shift = 0;
        char ch0 = value.charAt(0);
        if (ch0 == '-' || allowPlus && ch0 == '+') {
            ch0 = value.charAt(1);
            ++shift;
        }
        if (Character.isDigit(ch0)) {
            return true;
        }
        int length = value.length();
        if (length <= shift + 1) {
            return false;
        }
        char ch1 = value.charAt(shift + 1);
        return ch0 == '.' && Character.isDigit(ch1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/JSStringUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 11: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "changeQuotes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "changeQuotesInLiteralValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "changeQuotesInternal";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/JSStringUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeSimpleStringChars";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "unquoteAndUnescapeString";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "parseNumericValue";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unescapeSimpleStringChars";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "escapeSimpleStringChars";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "unquoteAndUnescapeString";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseNumericValue";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isNumericValueStart";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class NumberParseResult {
        private double value;
        private int newOffset;
        private String stringValue;

        public NumberParseResult(double value, int newOffset, String stringValue) {
            this.value = value;
            this.newOffset = newOffset;
            this.stringValue = stringValue;
        }

        public double getValue() {
            return this.value;
        }

        public int getNewOffset() {
            return this.newOffset;
        }

        public String getStringValue() {
            return this.stringValue;
        }
    }
}

