/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.lang.javascript.bower.BowerSettings;
import com.intellij.lang.javascript.bower.BowerView;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="JsBowerSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class BowerSettingsManager
implements PersistentStateComponent<Element> {
    private static final String NODE_INTERPRETER_PATH = "node-interpreter";
    private static final String EXE_PATH = "exe-path";
    private static final String CONFIG_PATH = "config-path";
    private BowerSettings mySettings;

    public BowerSettingsManager(@NotNull Project project) {
        if (project == null) {
            BowerSettingsManager.$$$reportNull$$$0(0);
        }
        this.mySettings = new BowerSettings.Builder(project).setBowerExecutablePath(BowerSettingsManager.guessBowerExecutable(project)).setBowerJsonPath(BowerSettingsManager.guessBowerConfig(project)).build();
    }

    @NotNull
    private static String guessBowerExecutable(@NotNull Project project) {
        if (project == null) {
            BowerSettingsManager.$$$reportNull$$$0(1);
        }
        List<String> exePaths = BowerView.calcPossibleBowerExecutableFiles(project);
        String string = StringUtil.notNullize((String)((String)ContainerUtil.getFirstItem(exePaths)));
        if (string == null) {
            BowerSettingsManager.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static String guessBowerConfig(@NotNull Project project) {
        VirtualFile bowerJson;
        VirtualFile baseDir;
        if (project == null) {
            BowerSettingsManager.$$$reportNull$$$0(3);
        }
        if ((baseDir = project.getBaseDir()) != null && baseDir.isValid() && (bowerJson = baseDir.findChild("bower.json")) != null && bowerJson.isValid() && !bowerJson.isDirectory()) {
            String string = FileUtil.toSystemDependentName((String)bowerJson.getPath());
            if (string == null) {
                BowerSettingsManager.$$$reportNull$$$0(4);
            }
            return string;
        }
        if ("" == null) {
            BowerSettingsManager.$$$reportNull$$$0(5);
        }
        return "";
    }

    @Nullable
    public Element getState() {
        BowerSettings settings = this.mySettings;
        Element root = new Element("js-bower-settings");
        JDOMExternalizerUtil.addElementWithValueAttribute((Element)root, (String)NODE_INTERPRETER_PATH, (String)settings.getInterpreterRef().getReferenceName());
        Element exePathElement = new Element(EXE_PATH);
        exePathElement.addContent((Content)new Text(settings.getBowerExecutablePath()));
        root.addContent(exePathElement);
        Element configPathElement = new Element(CONFIG_PATH);
        configPathElement.addContent((Content)new Text(settings.getBowerJsonPath()));
        root.addContent(configPathElement);
        return root;
    }

    public void loadState(Element state) {
        if (state != null) {
            Element configPathElement;
            BowerSettings.Builder builder = this.mySettings.createBuilder();
            String interpreterRefName = JDOMExternalizerUtil.getFirstChildValueAttribute((Element)state, (String)NODE_INTERPRETER_PATH);
            NodeJsInterpreterRef interpreterRef = interpreterRefName != null ? NodeJsInterpreterRef.create(interpreterRefName) : NodeJsInterpreterRef.createProjectRef();
            builder.setInterpreterRef(interpreterRef);
            Element exePathElement = state.getChild(EXE_PATH);
            if (exePathElement != null) {
                builder.setBowerExecutablePath(exePathElement.getText());
            }
            if ((configPathElement = state.getChild(CONFIG_PATH)) != null) {
                builder.setBowerJsonPath(configPathElement.getText());
            }
            this.mySettings = builder.build();
        }
    }

    @NotNull
    public BowerSettings getSettings() {
        BowerSettings bowerSettings = this.mySettings;
        if (bowerSettings == null) {
            BowerSettingsManager.$$$reportNull$$$0(6);
        }
        return bowerSettings;
    }

    public void setSettings(@NotNull BowerSettings settings) {
        if (settings == null) {
            BowerSettingsManager.$$$reportNull$$$0(7);
        }
        this.mySettings = settings;
    }

    @NotNull
    public static BowerSettingsManager getInstance(@NotNull Project project) {
        if (project == null) {
            BowerSettingsManager.$$$reportNull$$$0(8);
        }
        BowerSettingsManager bowerSettingsManager = (BowerSettingsManager)ServiceManager.getService((Project)project, BowerSettingsManager.class);
        if (bowerSettingsManager == null) {
            BowerSettingsManager.$$$reportNull$$$0(9);
        }
        return bowerSettingsManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/bower/BowerSettingsManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/bower/BowerSettingsManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "guessBowerExecutable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "guessBowerConfig";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "guessBowerExecutable";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "guessBowerConfig";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setSettings";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

