/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.javascript.JSFileReference;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCompletionUtil {
    private static final String COMPLETE_REQUIRED_FILENAME_WITH_EXTENSION = "commonjs.complete.required.filename.with.extension";
    private static final Integer DEFAULT_PROXIMITY_VALUE = 0;
    private static final Integer DEFAULT_PRIORITY_VALUE = 0;
    public static final Key<Integer> PRIORITY = Key.create((String)"js.several.definitions.element.priority");
    public static final Key<Integer> PROXIMITY = Key.create((String)"js.several.definitions.element.proximity");

    @Nullable
    public static LookupElement createLookupElementForJSModule(@Nullable PsiElement psiElement) {
        PsiFile psiFile = (PsiFile)ObjectUtils.tryCast((Object)psiElement, PsiFile.class);
        if (psiFile == null || !psiFile.isPhysical()) {
            return null;
        }
        String fileName = psiFile.getName();
        String extension = JSFileReference.findImplicitExtension(fileName);
        RegistryValue withExtValue = Registry.get((String)COMPLETE_REQUIRED_FILENAME_WITH_EXTENSION);
        if (extension != null && !withExtValue.asBoolean()) {
            String nameWithoutExt = fileName.substring(0, fileName.length() - extension.length());
            return LookupElementBuilder.create((Object)psiFile, (String)nameWithoutExt).withIcon(psiFile.getIcon(0)).withPresentableText(fileName);
        }
        return null;
    }

    public static void setJSLookupPriority(@NotNull LookupItem<?> element, @NotNull JSLookupPriority priority) {
        if (element == null) {
            JSCompletionUtil.$$$reportNull$$$0(0);
        }
        if (priority == null) {
            JSCompletionUtil.$$$reportNull$$$0(1);
        }
        element.setPriority((double)priority.getPriorityValue());
        element.putUserData(JSLookupPriority.EXPLICIT_PROXIMITY_KEY, (Object)priority.getProximityValue());
    }

    @NotNull
    public static LookupElement withJSLookupPriority(@NotNull LookupElement element, @NotNull JSLookupPriority priority) {
        if (element == null) {
            JSCompletionUtil.$$$reportNull$$$0(2);
        }
        if (priority == null) {
            JSCompletionUtil.$$$reportNull$$$0(3);
        }
        if (element instanceof LookupItem) {
            JSCompletionUtil.setJSLookupPriority((LookupItem)element, priority);
        } else {
            element = PrioritizedLookupElement.withPriority((LookupElement)element, (double)priority.getPriorityValue());
            if (priority.getProximityValue() != 0) {
                element = PrioritizedLookupElement.withExplicitProximity((LookupElement)element, (int)priority.getProximityValue());
            }
        }
        LookupElement lookupElement = element;
        if (lookupElement == null) {
            JSCompletionUtil.$$$reportNull$$$0(4);
        }
        return lookupElement;
    }

    public static double getLookupElementPriority(@NotNull LookupElement element) {
        if (element == null) {
            JSCompletionUtil.$$$reportNull$$$0(5);
        }
        if (element instanceof LookupItem) {
            return ((LookupItem)element).getPriority();
        }
        if (element instanceof PrioritizedLookupElement) {
            return ((PrioritizedLookupElement)element).getPriority();
        }
        Integer data = (Integer)element.getUserData(PRIORITY);
        return ((Integer)ObjectUtils.notNull((Object)data, (Object)DEFAULT_PRIORITY_VALUE)).intValue();
    }

    public static int getLookupElementProximity(LookupElement element) {
        if (element instanceof PrioritizedLookupElement) {
            return ((PrioritizedLookupElement)element).getExplicitProximity();
        }
        if (element instanceof LookupItem) {
            Integer proximity = (Integer)element.getUserData(JSLookupPriority.EXPLICIT_PROXIMITY_KEY);
            return (Integer)ObjectUtils.notNull((Object)proximity, (Object)DEFAULT_PROXIMITY_VALUE);
        }
        Integer proximity = (Integer)element.getUserData(PROXIMITY);
        return (Integer)ObjectUtils.notNull((Object)proximity, (Object)DEFAULT_PROXIMITY_VALUE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSCompletionUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSCompletionUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withJSLookupPriority";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setJSLookupPriority";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withJSLookupPriority";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLookupElementPriority";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

