/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flow.FlowJSServerManager;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.flow.FlowJSToolWindowProvider;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.flow.protocol.FlowJSStandardOutputProtocol;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSAutocompleteCommand;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSCheckContentsCommand;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSCommandWithArgument;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSCoverageCommand;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSFindModuleCommand;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSGetDefinitionCommand;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSStatusCommand;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSTypeInfoCommand;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSFileHighlightingInfo;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceDefaultCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceQueueImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSServerService
extends JSLanguageServiceBase
implements JSLanguageService,
Disposable {
    public static final Logger LOGGER = Logger.getInstance((String)"#com.intellij.lang.javascript.flow.FlowJSServerService");
    public static final long SMALL_TIMEOUT = TimeUnit.SECONDS.toMillis(1L);
    public static final long MIDDLE_TIMEOUT = TimeUnit.SECONDS.toMillis(3L);
    public static final long LARGE_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    private static final long COMPLETION_TIMEOUT_MILLIS = 1000L;
    static final Condition<VirtualFile> FILES_TO_PROCESS = virtualFile -> {
        if (virtualFile == null) {
            return false;
        }
        FileType type = virtualFile.getFileType();
        return DialectDetector.JAVASCRIPT_FILE_TYPES.contains(type) && virtualFile.isInLocalFileSystem() && virtualFile.getUserData(JSLanguageServiceQueue.GENERATED_FILE_MARKER) == null;
    };
    @NotNull
    private final FlowJSConfig myConfig;
    @NotNull
    private final JSLanguageServiceDefaultCacheData myCacheData;
    private static final ImmutableList<JSAnnotationError> HAS_UNSAVED_FILES_RESULT = ContainerUtil.immutableList((Object[])new JSAnnotationError[]{new JSLanguageServiceAnnotationResult(JSBundle.message((String)"js.flow.has.unsaved.files", (Object[])new Object[0]), null, null, 0, 0, 0, 0)});

    FlowJSServerService(@NotNull FlowJSConfig config2, @NotNull Project project, @NotNull String consoleId) {
        if (config2 == null) {
            FlowJSServerService.$$$reportNull$$$0(0);
        }
        if (project == null) {
            FlowJSServerService.$$$reportNull$$$0(1);
        }
        if (consoleId == null) {
            FlowJSServerService.$$$reportNull$$$0(2);
        }
        super(project, consoleId);
        this.myConfig = config2;
        this.myCacheData = new JSLanguageServiceDefaultCacheData(){

            @Override
            @NotNull
            public JSLanguageServiceObject updateCacheAndGetServiceObject(@NotNull JSLanguageServiceCommand input) {
                if (input == null) {
                    1.$$$reportNull$$$0(0);
                }
                JSLanguageServiceObject jSLanguageServiceObject = new JSLanguageServiceObject(){};
                if (jSLanguageServiceObject == null) {
                    1.$$$reportNull$$$0(1);
                }
                return jSLanguageServiceObject;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "input";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSServerService$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSServerService$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "updateCacheAndGetServiceObject";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "updateCacheAndGetServiceObject";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    protected long getAliveCheckTimeout() {
        return TimeUnit.MINUTES.toMillis(3L);
    }

    @Override
    protected boolean needInitToolWindow() {
        FlowJSServerManager serverManager = FlowJSServerManager.getInstance(this.myProject);
        return serverManager != null && serverManager.isFlowAvailable();
    }

    @Override
    @NotNull
    protected String getProcessName() {
        if ("Flow" == null) {
            FlowJSServerService.$$$reportNull$$$0(3);
        }
        return "Flow";
    }

    @Override
    @Nullable
    protected JSLanguageServiceToolWindowManager createToolWindow(Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        return FlowJSToolWindowProvider.getToolWindow(this.myProject);
    }

    @Override
    @Nullable
    protected JSLanguageServiceQueue createLanguageServiceQueue() {
        FlowJSStandardOutputProtocol protocol = new FlowJSStandardOutputProtocol(this.myProject, this.myConfig);
        return new JSLanguageServiceQueueImpl(this.myProject, protocol, this.myProcessConnector, this.myDefaultReporter, this.myCacheData);
    }

    @Nullable
    private <T> Future<T> sendCommand(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceCommandProcessor<T> processor) {
        JSLanguageServiceQueue process;
        if (command == null) {
            FlowJSServerService.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            FlowJSServerService.$$$reportNull$$$0(5);
        }
        if ((process = this.getProcess()) == null) {
            return null;
        }
        if (!process.isValid()) {
            return null;
        }
        return process.execute(command, processor);
    }

    public PsiElement getDefinitionOfElement(@NotNull Document document, @NotNull VirtualFile virtualFile, @NotNull PsiElement element) {
        if (document == null) {
            FlowJSServerService.$$$reportNull$$$0(6);
        }
        if (virtualFile == null) {
            FlowJSServerService.$$$reportNull$$$0(7);
        }
        if (element == null) {
            FlowJSServerService.$$$reportNull$$$0(8);
        }
        ArrayList<String> request = new ArrayList<String>();
        int offset = element.getTextOffset();
        int line = document.getLineNumber(offset) + 1;
        int column = offset - document.getLineStartOffset(line - 1) + element.getTextLength();
        FlowJSServerService.setCommandLineParams(request, this.myConfig);
        request.add(virtualFile.getName());
        request.add(String.valueOf(line));
        request.add(String.valueOf(column));
        VirtualFile parent = virtualFile.getParent();
        String path = parent.getCanonicalPath();
        if (path == null) {
            return null;
        }
        FlowJSGetDefinitionCommand commandWithArgument = new FlowJSGetDefinitionCommand(request, document.getText(), path);
        ArrayList<JsonObject> requestAnswer = new ArrayList<JsonObject>();
        Future<Boolean> future = this.sendCommand(commandWithArgument, (JSLanguageServiceObject serviceObject, JSLanguageServiceAnswer answer) -> requestAnswer.add(answer.getElement()));
        FlowJSServerService.awaitFuture(future, MIDDLE_TIMEOUT);
        return this.getPsiElementFromDefinitionCommandAnswer(requestAnswer, virtualFile);
    }

    @Nullable
    private PsiElement getPsiElementFromDefinitionCommandAnswer(@NotNull List<JsonObject> answer, @NotNull VirtualFile currentFile) {
        VirtualFile virtualFile;
        if (answer == null) {
            FlowJSServerService.$$$reportNull$$$0(9);
        }
        if (currentFile == null) {
            FlowJSServerService.$$$reportNull$$$0(10);
        }
        if (answer.isEmpty()) {
            return null;
        }
        JsonObject answerJson = answer.get(0);
        if (answerJson == null) {
            return null;
        }
        JsonElement path = answerJson.get("path");
        if (path.getAsString().isEmpty()) {
            return null;
        }
        int startLine = answerJson.get("line").getAsInt() - 1;
        int startColumn = answerJson.get("start").getAsInt() - 1;
        if (startLine >= 0 && startColumn >= 0 && (virtualFile = !path.getAsString().equals("-") ? LocalFileSystem.getInstance().findFileByPath(path.getAsString()) : currentFile) != null) {
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(virtualFile);
            try {
                FileViewProvider provider = PsiManager.getInstance((Project)this.myProject).findViewProvider(virtualFile);
                if (provider == null) {
                    return null;
                }
                Document document = provider.getDocument();
                if (document != null) {
                    int offset = document.getLineStartOffset(startLine) + startColumn;
                    if (psiFile != null) {
                        return psiFile.findElementAt(offset);
                    }
                }
            }
            catch (NullPointerException e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public PsiElement findModuleOfElement(@NotNull VirtualFile file, @NotNull PsiElement element) {
        if (file == null) {
            FlowJSServerService.$$$reportNull$$$0(11);
        }
        if (element == null) {
            FlowJSServerService.$$$reportNull$$$0(12);
        }
        ArrayList<String> request = new ArrayList<String>();
        FlowJSServerService.setCommandLineParams(request, this.myConfig);
        request.add(StringUtil.unquoteString((String)element.getText()));
        request.add(file.getPath());
        VirtualFile parent = file.getParent();
        String path = parent.getCanonicalPath();
        if (path == null) {
            return null;
        }
        FlowJSFindModuleCommand commandWithArgument = new FlowJSFindModuleCommand(request, null, path);
        ArrayList<JsonObject> requestAnswer = new ArrayList<JsonObject>();
        Future<Boolean> future = this.sendCommand(commandWithArgument, (JSLanguageServiceObject serviceObject, JSLanguageServiceAnswer answer) -> requestAnswer.add(answer.getElement()));
        FlowJSServerService.awaitFuture(future, MIDDLE_TIMEOUT);
        return this.getPsiElementFromFindModuleCommandAnswer(requestAnswer);
    }

    @Nullable
    private PsiElement getPsiElementFromFindModuleCommandAnswer(List<JsonObject> answerList) {
        JsonObject answer;
        if (!answerList.isEmpty() && (answer = answerList.get(0)).has("file")) {
            String path = answer.get("file").getAsString();
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
            if (virtualFile != null) {
                return PsiManager.getInstance((Project)this.myProject).findFile(virtualFile);
            }
        }
        return null;
    }

    public String getTypeOfElement(@NotNull PsiElement element, @NotNull VirtualFile virtualFile, @NotNull Document document) {
        if (element == null) {
            FlowJSServerService.$$$reportNull$$$0(13);
        }
        if (virtualFile == null) {
            FlowJSServerService.$$$reportNull$$$0(14);
        }
        if (document == null) {
            FlowJSServerService.$$$reportNull$$$0(15);
        }
        ArrayList<String> request = new ArrayList<String>();
        int offset = element.getTextOffset();
        int line = document.getLineNumber(offset) + 1;
        int column = offset - document.getLineStartOffset(line - 1) + element.getTextLength();
        FlowJSServerService.setCommandLineParams(request, this.myConfig);
        request.add(virtualFile.getName());
        request.add(String.valueOf(line));
        request.add(String.valueOf(column));
        VirtualFile parent = virtualFile.getParent();
        String path = parent.getCanonicalPath();
        if (path == null) {
            return null;
        }
        FlowJSTypeInfoCommand commandWithArgument = new FlowJSTypeInfoCommand(request, document.getText(), path);
        ArrayList<JsonObject> requestAnswer = new ArrayList<JsonObject>();
        Future<Boolean> future = this.sendCommand(commandWithArgument, (JSLanguageServiceObject serviceObject, JSLanguageServiceAnswer answer) -> requestAnswer.add(answer.getElement()));
        FlowJSServerService.awaitFuture(future, SMALL_TIMEOUT);
        return FlowJSServerService.getTypeFromAnswer(requestAnswer);
    }

    @NotNull
    private static String getTypeFromAnswer(List<JsonObject> answer) {
        JsonObject answerJson;
        String type = "";
        if (!answer.isEmpty() && (answerJson = answer.get(0)).has("type")) {
            type = answerJson.get("type").getAsString();
        }
        String string = type;
        if (string == null) {
            FlowJSServerService.$$$reportNull$$$0(16);
        }
        return string;
    }

    public static void setCommandLineParams(List<String> request, FlowJSConfig config2) {
        request.add("--root");
        request.add(config2.getConfigDirectory().getPath());
        request.add("--json");
        request.add("--no-auto-start");
    }

    @NotNull
    public List<JsonObject> getCompletionOfElement(@NotNull PsiFile originalFile, @NotNull Document document, @NotNull CompletionParameters parameters, @NotNull String text) {
        String filePath;
        if (originalFile == null) {
            FlowJSServerService.$$$reportNull$$$0(17);
        }
        if (document == null) {
            FlowJSServerService.$$$reportNull$$$0(18);
        }
        if (parameters == null) {
            FlowJSServerService.$$$reportNull$$$0(19);
        }
        if (text == null) {
            FlowJSServerService.$$$reportNull$$$0(20);
        }
        ArrayList<String> request = new ArrayList<String>();
        FlowJSServerService.setCommandLineParams(request, this.myConfig);
        request.add(originalFile.getVirtualFile().getCanonicalPath());
        PsiDirectory directory = originalFile.getContainingDirectory();
        String string = filePath = directory != null ? directory.getVirtualFile().getPath() : originalFile.getProject().getBasePath();
        if (filePath == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                FlowJSServerService.$$$reportNull$$$0(21);
            }
            return list;
        }
        int line = document.getLineNumber(parameters.getOffset());
        request.add(String.valueOf(line + 1));
        request.add(String.valueOf(parameters.getOffset() - document.getLineStartOffset(line) + "IntellijIdeaRulezzz ".length()));
        FlowJSAutocompleteCommand commandWithArgument = new FlowJSAutocompleteCommand(request, text, filePath);
        ArrayList<JsonObject> requestAnswer = new ArrayList<JsonObject>();
        Future<Boolean> future = this.sendCommand(commandWithArgument, (JSLanguageServiceObject serviceObject, JSLanguageServiceAnswer answer) -> requestAnswer.add(answer.getElement()));
        JSLanguageServiceUtil.awaitFuture(future, 1000L, 10L, null);
        ArrayList<JsonObject> arrayList = requestAnswer;
        if (arrayList == null) {
            FlowJSServerService.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    public List<JSAnnotationError> getAllErrors() {
        FlowJSStatusCommand commandWithArgument = new FlowJSStatusCommand(this.myConfig.getConfigDirectory().getPath());
        ArrayList requestAnswer = new ArrayList();
        Future<Boolean> future = this.sendCommand(commandWithArgument, (JSLanguageServiceObject serviceObject, JSLanguageServiceAnswer answer) -> requestAnswer.add(answer.getElement()));
        FlowJSServerService.awaitFuture(future, LARGE_TIMEOUT);
        return requestAnswer.isEmpty() ? Collections.emptyList() : FlowJSServerService.parseFlowErrors((JsonObject)requestAnswer.get(0), null);
    }

    @NotNull
    public static List<JSAnnotationError> parseFlowErrors(@NotNull JsonObject json, @Nullable String filePath) {
        JsonElement hasErrors;
        if (json == null) {
            FlowJSServerService.$$$reportNull$$$0(23);
        }
        ArrayList<JSAnnotationError> listOfErrors = new ArrayList<JSAnnotationError>();
        VirtualFile targetFile = null;
        if (filePath != null) {
            targetFile = LocalFileSystem.getInstance().findFileByPath(filePath);
        }
        if ((hasErrors = json.get("passed")) != null && !hasErrors.getAsBoolean()) {
            try {
                JsonArray errorArray = json.getAsJsonArray("errors");
                for (JsonElement error : errorArray) {
                    JsonObject errorObject;
                    JSLanguageServiceAnnotationResult annotationResult;
                    if (!error.isJsonObject() || (annotationResult = FlowJSServerService.parseFlowError(targetFile, errorObject = error.getAsJsonObject())) == null) continue;
                    listOfErrors.add(annotationResult);
                }
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
        ArrayList<JSAnnotationError> arrayList = listOfErrors;
        if (arrayList == null) {
            FlowJSServerService.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    @Nullable
    private static JSLanguageServiceAnnotationResult parseFlowError(@Nullable VirtualFile targetFile, JsonObject errorObject) {
        VirtualFile virtualFile;
        int line = 0;
        int column = 0;
        int lineEnd = 0;
        int columnEnd = 0;
        StringBuilder errorText = new StringBuilder();
        String errorCategory = errorObject.get("level").getAsString();
        String filePath = null;
        JsonArray messageArray = errorObject.getAsJsonArray("message");
        boolean isFirstMessage = true;
        for (JsonElement message : messageArray) {
            JsonObject messageObject = message.getAsJsonObject();
            if (messageObject.get("type").getAsString().equals("Blame") && filePath == null && (filePath = messageObject.get("path").getAsString()) != null) {
                JsonObject loc = messageObject.get("loc").getAsJsonObject();
                JsonObject start = loc.get("start").getAsJsonObject();
                JsonObject end = loc.get("end").getAsJsonObject();
                line = start.get("line").getAsInt();
                column = start.get("column").getAsInt();
                lineEnd = end.get("line").getAsInt();
                columnEnd = end.get("column").getAsInt() + 1;
            }
            if (isFirstMessage) {
                errorText.append("Flow: ");
            }
            errorText.append(messageObject.get("descr").getAsString());
            if (!isFirstMessage) {
                errorText.append(" ");
            }
            if (isFirstMessage && messageArray.size() > 1) {
                errorText.append(". ");
            }
            isFirstMessage = false;
        }
        if (targetFile != null && filePath != null && (virtualFile = LocalFileSystem.getInstance().findFileByPath(filePath)) != null && !targetFile.equals(virtualFile)) {
            return null;
        }
        return new JSLanguageServiceAnnotationResult(errorText.toString(), filePath, errorCategory, line, column, lineEnd, columnEnd);
    }

    public List<JSAnnotationError> getCoverageOfFile(@NotNull PsiFile originalFile) {
        if (originalFile == null) {
            FlowJSServerService.$$$reportNull$$$0(25);
        }
        ArrayList<String> parameterList = new ArrayList<String>();
        FlowJSServerService.setCommandLineParams(parameterList, this.myConfig);
        parameterList.add(originalFile.getVirtualFile().getPath());
        FlowJSCoverageCommand commandWithArgument = new FlowJSCoverageCommand(parameterList, originalFile.getText(), this.myConfig.getConfigDirectory().getPath());
        ArrayList requestAnswer = new ArrayList();
        Future<Boolean> future = this.sendCommand(commandWithArgument, (JSLanguageServiceObject serviceObject, JSLanguageServiceAnswer answer) -> requestAnswer.add(answer.getElement()));
        FlowJSServerService.awaitFuture(future, LARGE_TIMEOUT);
        ArrayList errors = ContainerUtil.newArrayList();
        if (!requestAnswer.isEmpty()) {
            errors.addAll(FlowJSServerService.parseCoverageError((JsonObject)requestAnswer.get(0)));
        }
        return errors;
    }

    private static List<JSLanguageServiceAnnotationResult> parseCoverageError(@NotNull JsonObject json) {
        if (json == null) {
            FlowJSServerService.$$$reportNull$$$0(26);
        }
        ArrayList listOfErrors = ContainerUtil.newArrayList();
        JsonElement expression = json.get("expressions");
        if (expression != null) {
            try {
                JsonArray errorArray = expression.getAsJsonObject().getAsJsonArray("uncovered_locs");
                for (JsonElement error : errorArray) {
                    if (!error.isJsonObject()) continue;
                    JsonObject errorObject = error.getAsJsonObject();
                    String source = errorObject.get("source").getAsString();
                    JsonObject start = errorObject.get("start").getAsJsonObject();
                    JsonObject end = errorObject.get("end").getAsJsonObject();
                    int line = start.get("line").getAsInt();
                    int column = start.get("column").getAsInt();
                    int lineEnd = end.get("line").getAsInt();
                    int columnEnd = end.get("column").getAsInt();
                    JSLanguageServiceAnnotationResult annotationResult = new JSLanguageServiceAnnotationResult(JSBundle.message((String)"js.flowjs.coverage.inspection.error.text", (Object[])new Object[0]), source != null ? source : "", "Warning", line, column, lineEnd, columnEnd);
                    listOfErrors.add(annotationResult);
                }
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
        return listOfErrors;
    }

    public static boolean awaitFuture(@Nullable Future<Boolean> future, long period) {
        if (future == null) {
            return false;
        }
        try {
            future.get(period, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            return false;
        }
        return future.isDone();
    }

    public static void saveSyncAllUnsavedFiles(@NotNull PsiFile exceptThis) {
        List<Document> toSave;
        if (exceptThis == null) {
            FlowJSServerService.$$$reportNull$$$0(27);
        }
        if (!(toSave = FlowJSServerService.getUnsavedFlowDocuments(exceptThis)).isEmpty()) {
            ApplicationManager.getApplication().invokeAndWait(() -> FlowJSServerService.saveFiles(toSave));
        }
    }

    @NotNull
    public static List<Document> getUnsavedFlowDocuments(@NotNull PsiFile exceptThis) {
        if (exceptThis == null) {
            FlowJSServerService.$$$reportNull$$$0(28);
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        VirtualFile exceptThisVFile = exceptThis.getVirtualFile();
        Project project = exceptThis.getProject();
        List<Document> list = Arrays.stream(FileDocumentManager.getInstance().getUnsavedDocuments()).filter(document -> {
            VirtualFile file = documentManager.getFile(document);
            return file != null && !file.equals(exceptThisVFile) && DialectDetector.JAVASCRIPT_FILE_TYPES.contains(file.getFileType()) && !FlowJSServerService.isOpenedInOtherProjectAndNotThis(file, project);
        }).collect(Collectors.toList());
        if (list == null) {
            FlowJSServerService.$$$reportNull$$$0(29);
        }
        return list;
    }

    private static boolean isOpenedInOtherProjectAndNotThis(@NotNull VirtualFile file, @NotNull Project currentProject) {
        Project[] openedProjects;
        if (file == null) {
            FlowJSServerService.$$$reportNull$$$0(30);
        }
        if (currentProject == null) {
            FlowJSServerService.$$$reportNull$$$0(31);
        }
        if ((openedProjects = ProjectManager.getInstance().getOpenProjects()).length <= 1) {
            return false;
        }
        if (ProjectFileIndex.getInstance((Project)currentProject).getModuleForFile(file, false) != null) {
            return false;
        }
        for (Project otherProject : openedProjects) {
            if (otherProject == currentProject || ProjectFileIndex.getInstance((Project)otherProject).getModuleForFile(file, false) == null) continue;
            return true;
        }
        return false;
    }

    public static void saveFiles(Collection<Document> unsavedDocuments) {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        for (Document document : unsavedDocuments) {
            fileDocumentManager.saveDocument(document);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.stopFlowServer();
    }

    @Override
    protected Runnable getDisposeQueueRunnableUnderLock(@NotNull JSLanguageServiceQueue serviceToDispose) {
        if (serviceToDispose == null) {
            FlowJSServerService.$$$reportNull$$$0(32);
        }
        Runnable runnable = super.getDisposeQueueRunnableUnderLock(serviceToDispose);
        return () -> {
            runnable.run();
            this.stopFlowServer();
        };
    }

    private void stopFlowServer() {
    }

    @Nullable
    public static String isFlowServerAvailable(@NotNull String path, @NotNull Project project) {
        if (path == null) {
            FlowJSServerService.$$$reportNull$$$0(33);
        }
        if (project == null) {
            FlowJSServerService.$$$reportNull$$$0(34);
        }
        if (path.isEmpty()) {
            return JSBundle.message((String)"js.flow.enable.flow.service.error.empty", (Object[])new Object[0]);
        }
        GeneralCommandLine line = new GeneralCommandLine();
        line.setExePath(path);
        line.addParameter("version");
        line.addParameter("--json");
        line.setWorkDirectory(project.getBasePath());
        final Ref answer = new Ref();
        final Ref answerReceived = Ref.create((Object)Boolean.FALSE);
        if (!FileUtil.exists((String)path)) {
            return JSBundle.message((String)"js.flow.enable.flow.service.error", (Object[])new Object[0]);
        }
        try {
            OSProcessHandler handler = new OSProcessHandler(line);
            final StringBuilder resultJson = new StringBuilder();
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (outputType == ProcessOutputTypes.STDOUT) {
                        answerReceived.set((Object)Boolean.TRUE);
                        String text = event.getText();
                        resultJson.append(text);
                        JsonElement element = FlowJSStandardOutputProtocol.parseJsonSafe(resultJson.toString());
                        if (element != null) {
                            answer.set(null);
                        } else {
                            answer.set((Object)JSBundle.message((String)"js.flow.enable.flow.service.error.invalid.json", (Object[])new Object[]{resultJson}));
                        }
                    } else if (outputType == ProcessOutputTypes.STDERR) {
                        answerReceived.set((Object)Boolean.TRUE);
                        answer.set((Object)event.getText());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/lang/javascript/flow/FlowJSServerService$2";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            handler.startNotify();
            if (handler.waitFor()) {
                if (((Boolean)answerReceived.get()).booleanValue() && answer.get() == null) {
                    return null;
                }
                return JSBundle.message((String)"js.flow.enable.flow.service.error.on.checking", (Object[])new Object[]{(Boolean)answerReceived.get() != false ? answer.get() : "Empty process output"});
            }
            return JSBundle.message((String)"js.flow.enable.flow.service.error.on.checking", (Object[])new Object[]{"Process doesn't respond"});
        }
        catch (ExecutionException e) {
            return JSBundle.message((String)"js.flow.enable.flow.service.error.on.checking", (Object[])new Object[]{e.getMessage()});
        }
    }

    @NotNull
    public static List<String> calcPossibleFlowExecutableFiles(Project project) {
        ArrayList paths = ContainerUtil.newArrayList();
        String execFileName = FlowJSServerService.getFlowExecutableFilename();
        List files = PathEnvironmentVariableUtil.findAllExeFilesInPath((String)execFileName);
        for (File file : files) {
            paths.add(file.getAbsolutePath());
        }
        ArrayList infos = ContainerUtil.newArrayList();
        NodeModuleSearchUtil.findModulesWithName((List<CompletionModuleInfo>)infos, "flow-bin", project.getBaseDir(), null, false);
        for (CompletionModuleInfo info : infos) {
            VirtualFile moduleDir = info.getVirtualFile();
            if (info.getType() != ModuleType.NODE_MODULES_DIR || moduleDir == null) continue;
            VirtualFile execFile = VfsUtil.findRelativeFile((VirtualFile)moduleDir, (String[])new String[]{"..", ".bin", execFileName});
            if (execFile != null && !execFile.isDirectory()) {
                paths.add(execFile.getPath());
                continue;
            }
            VirtualFile execFileInVendor = VfsUtil.findRelativeFile((VirtualFile)moduleDir, (String[])new String[]{"vendor", execFileName});
            if (execFileInVendor == null || execFileInVendor.isDirectory()) continue;
            paths.add(execFileInVendor.getPath());
        }
        ContainerUtil.removeDuplicates((Collection)paths);
        ArrayList arrayList = paths;
        if (arrayList == null) {
            FlowJSServerService.$$$reportNull$$$0(35);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    private static String getFlowExecutableFilename() {
        String string = SystemInfo.isWindows ? "flow.exe" : "flow";
        if (string == null) {
            FlowJSServerService.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    public FlowJSConfig getConfig() {
        FlowJSConfig flowJSConfig = this.myConfig;
        if (flowJSConfig == null) {
            FlowJSServerService.$$$reportNull$$$0(37);
        }
        return flowJSConfig;
    }

    @Override
    @Nullable
    public Future<List<JSAnnotationError>> highlight(@NotNull PsiFile file, @Nullable JSFileHighlightingInfo info) {
        FlowJSCommandWithArgument commandWithArgument;
        List<Document> toSave;
        if (file == null) {
            FlowJSServerService.$$$reportNull$$$0(38);
        }
        if (!(toSave = FlowJSServerService.getUnsavedFlowDocuments(file)).isEmpty()) {
            if (FlowJSSettingsManager.isAutoSaveEnabled(this.myProject)) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (file == null) {
                        FlowJSServerService.$$$reportNull$$$0(43);
                    }
                    LOGGER.debug("Save and restart flow highlighting");
                    DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(file);
                    FlowJSServerService.saveFiles(toSave);
                });
            } else {
                ApplicationManager.getApplication().invokeLater(() -> {
                    JSLanguageServiceToolWindowManager jsLanguageServiceToolWindowManager;
                    if (file == null) {
                        FlowJSServerService.$$$reportNull$$$0(42);
                    }
                    if ((jsLanguageServiceToolWindowManager = FlowJSToolWindowProvider.getToolWindow(file.getProject())) != null) {
                        jsLanguageServiceToolWindowManager.logCurrentErrors((List<JSAnnotationError>)HAS_UNSAVED_FILES_RESULT, false);
                    }
                });
            }
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        String fileName = virtualFile.getPath();
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null || FileDocumentManager.getInstance().isDocumentUnsaved(document)) {
            String text = file.getText();
            String fileDir = virtualFile.getParent().getPath();
            commandWithArgument = new FlowJSCheckContentsCommand(fileName, fileDir, this.myConfig, text);
        } else {
            String configPath = this.getConfig().getConfigDirectory().getPath();
            commandWithArgument = new FlowJSStatusCommand(configPath);
        }
        return this.sendCommand(commandWithArgument, (JSLanguageServiceObject serviceObject, JSLanguageServiceAnswer answer) -> {
            if (file == null) {
                FlowJSServerService.$$$reportNull$$$0(41);
            }
            JSLanguageServiceToolWindowManager jsLanguageServiceToolWindowManager = FlowJSToolWindowProvider.getToolWindow(file.getProject());
            List<JSAnnotationError> annotationResult = FlowJSServerService.parseFlowErrors(answer.getElement(), fileName);
            if (jsLanguageServiceToolWindowManager != null) {
                ApplicationManager.getApplication().invokeLater(() -> jsLanguageServiceToolWindowManager.logCurrentErrors((List<JSAnnotationError>)ContainerUtil.immutableList((List)annotationResult), false));
            }
            return annotationResult;
        });
    }

    @Override
    public boolean canHighlight(@NotNull PsiFile file) {
        if (file == null) {
            FlowJSServerService.$$$reportNull$$$0(39);
        }
        return true;
    }

    @Override
    @NotNull
    public Condition<VirtualFile> getAcceptableFilesFilter() {
        Condition<VirtualFile> condition = FILES_TO_PROCESS;
        if (condition == null) {
            FlowJSServerService.$$$reportNull$$$0(40);
        }
        return condition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 16: 
            case 21: 
            case 22: 
            case 24: 
            case 29: 
            case 35: 
            case 36: 
            case 37: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 16: 
            case 21: 
            case 22: 
            case 24: 
            case 29: 
            case 35: 
            case 36: 
            case 37: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleId";
                break;
            }
            case 3: 
            case 16: 
            case 21: 
            case 22: 
            case 24: 
            case 29: 
            case 35: 
            case 36: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSServerService";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 11: 
            case 30: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "json";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptThis";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentProject";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceToDispose";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSServerService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFromAnswer";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionOfElement";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "parseFlowErrors";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsavedFlowDocuments";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "calcPossibleFlowExecutableFiles";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlowExecutableFilename";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptableFilesFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 16: 
            case 21: 
            case 22: 
            case 24: 
            case 29: 
            case 35: 
            case 36: 
            case 37: 
            case 40: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sendCommand";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDefinitionOfElement";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElementFromDefinitionCommandAnswer";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findModuleOfElement";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTypeOfElement";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionOfElement";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "parseFlowErrors";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getCoverageOfFile";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "parseCoverageError";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "saveSyncAllUnsavedFiles";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getUnsavedFlowDocuments";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isOpenedInOtherProjectAndNotThis";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getDisposeQueueRunnableUnderLock";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isFlowServerAvailable";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "highlight";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "canHighlight";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$highlight$13";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$highlight$11";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lambda$highlight$10";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 16: 
            case 21: 
            case 22: 
            case 24: 
            case 29: 
            case 35: 
            case 36: 
            case 37: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

