/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flow.FlowJSServerManager;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.ResendingOSProcessHandler;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import icons.JavaScriptLanguageIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSToolWindowProvider {
    @NotNull
    private final JSLanguageServiceToolWindowManager myToolWindow;

    @Nullable
    public static JSLanguageServiceToolWindowManager getToolWindow(Project project) {
        if (project == null || project.isDefault() || project.isDisposed()) {
            return null;
        }
        FlowJSToolWindowProvider provider = (FlowJSToolWindowProvider)ServiceManager.getService((Project)project, FlowJSToolWindowProvider.class);
        return provider == null ? null : provider.getToolWindow();
    }

    public FlowJSToolWindowProvider(final @NotNull Project project) {
        if (project == null) {
            FlowJSToolWindowProvider.$$$reportNull$$$0(0);
        }
        AnAction restartAllServersAction = new AnAction(JSBundle.message((String)"js.flow.all.servers.action.restart", (Object[])new Object[0]), JSBundle.message((String)"js.flow.all.servers.action.restart", (Object[])new Object[0]), AllIcons.Javaee.UpdateRunningApplication){

            public void actionPerformed(AnActionEvent e) {
                FlowJSToolWindowProvider.this.getToolWindow().resetToolWindow();
                Collection<FlowJSServerService> servers = FlowJSServerManager.getInstance(project).getAllServers();
                for (FlowJSServerService server : servers) {
                    server.terminateStartedProcess(true);
                }
            }
        };
        AnAction checkAllFiles = new AnAction(JSBundle.message((String)"javascript.flow.error.panel.all.errors", (Object[])new Object[0]), JSBundle.message((String)"javascript.flow.error.panel.all.errors", (Object[])new Object[0]), JavaScriptLanguageIcons.Typescript.CompileCurrentFile1){

            public void actionPerformed(AnActionEvent e) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    FlowJSServerManager serverManager;
                    if (project == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if ((serverManager = FlowJSServerManager.getInstance(project)) != null) {
                        List results;
                        Collection<FlowJSServerService> servers = serverManager.getAllServers();
                        if (servers.size() == 1) {
                            results = ((FlowJSServerService)ContainerUtil.getFirstItem(servers)).getAllErrors();
                        } else {
                            List errorFutures = ContainerUtil.map(servers, server -> ApplicationManager.getApplication().executeOnPooledThread(() -> server.getAllErrors()));
                            results = ContainerUtil.newSmartList();
                            for (Future errorFuture : errorFutures) {
                                List errorsFromFuture = Collections.emptyList();
                                try {
                                    errorsFromFuture = (List)errorFuture.get();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                results.addAll(errorsFromFuture);
                            }
                        }
                        ApplicationManager.getApplication().invokeLater(() -> FlowJSToolWindowProvider.this.myToolWindow.logProjectErrors((ImmutableList<JSAnnotationError>)ContainerUtil.immutableList((List)results), true));
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSToolWindowProvider$2", "lambda$actionPerformed$3"));
            }
        };
        this.myToolWindow = new JSLanguageServiceToolWindowManager(project, "Flow", "reference.tool.windows.flow", JavaScriptLanguageIcons.Flowjs.Flow13, new AnAction[]{checkAllFiles, restartAllServersAction}){

            @Override
            public synchronized void connectToProcessHandler(@NotNull String serviceId, @NotNull ProcessHandler handler) {
                if (serviceId == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (handler == null) {
                    3.$$$reportNull$$$0(1);
                }
                ((ResendingOSProcessHandler)handler).stopAfterNextListenerAdded();
                super.connectToProcessHandler(serviceId, handler);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "serviceId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "handler";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/flow/FlowJSToolWindowProvider$3";
                objectArray[2] = "connectToProcessHandler";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        Disposer.register((Disposable)project, (Disposable)this.myToolWindow);
    }

    @NotNull
    public JSLanguageServiceToolWindowManager getToolWindow() {
        JSLanguageServiceToolWindowManager jSLanguageServiceToolWindowManager = this.myToolWindow;
        if (jSLanguageServiceToolWindowManager == null) {
            FlowJSToolWindowProvider.$$$reportNull$$$0(1);
        }
        return jSLanguageServiceToolWindowManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSToolWindowProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSToolWindowProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

