/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.webpack;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.frameworks.webpack.WebpackConfigHighlightingInspection;
import com.intellij.lang.javascript.frameworks.webpack.WebpackUtil;
import com.intellij.lang.javascript.json.JSJsonLikePsiWalker;
import com.intellij.lang.javascript.json.JsonSchemaInJavaScriptProvider;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebpackInJavaScriptJsonSchemaProvider
implements JsonSchemaInJavaScriptProvider {
    public static VirtualFile getWebpackSchemaFile() {
        return JsonSchemaProviderFactory.getResourceFile(WebpackInJavaScriptJsonSchemaProvider.class, (String)"/jsonSchemas/webpack-schema.json");
    }

    @Override
    public VirtualFile getSchemaFile() {
        return WebpackInJavaScriptJsonSchemaProvider.getWebpackSchemaFile();
    }

    @Override
    public boolean isAvailable(@NotNull PsiElement element) {
        if (element == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(0);
        }
        return WebpackInJavaScriptJsonSchemaProvider.isWebpackInspectionAllowed(element) && WebpackInJavaScriptJsonSchemaProvider.isApplicable(element);
    }

    static boolean isAvailableForFile(@NotNull PsiFile file) {
        if (file == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(1);
        }
        return Registry.is((String)"JavaScript.WebPack.With.JsonSchema", (boolean)true) && StringUtil.containsIgnoreCase((String)file.getName(), (String)"webpack") && DialectDetector.JAVASCRIPT_FILE_TYPES.contains(file.getFileType());
    }

    public static boolean isApplicable(@NotNull PsiElement element) {
        if (element == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(2);
        }
        return element.getContainingFile() != null && WebpackInJavaScriptJsonSchemaProvider.isAvailableForFile(element.getContainingFile()) && WebpackUtil.isWebpack2(element.getProject()) && WebpackInJavaScriptJsonSchemaProvider.isInSupportedArea(element) && WebpackInJavaScriptJsonSchemaProvider.isInTopLevelObject(element);
    }

    private static boolean isInTopLevelObject(@NotNull PsiElement element) {
        PsiElement current;
        if (element == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(3);
        }
        for (current = element; !(current == null || JSJsonLikePsiWalker.isTerminalInStatement(current) || current instanceof PsiFile || current instanceof JSEmbeddedContent); current = current.getParent()) {
            if (current instanceof JSProperty || current instanceof JSLiteralExpression || current instanceof JSObjectLiteralExpression || current instanceof JSArrayLiteralExpression || current instanceof JSReferenceExpression || current instanceof LeafPsiElement) {
                continue;
            }
            return false;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)current, JSObjectLiteralExpression.class) == null;
    }

    private static boolean isWebpackInspectionAllowed(@NotNull PsiElement element) {
        if (element == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(4);
        }
        if (element.getContainingFile() == null) {
            return false;
        }
        InspectionProfileImpl profile = InspectionProfileManager.getInstance((Project)element.getProject()).getCurrentProfile();
        String name = InspectionProfileEntry.getShortName((String)WebpackConfigHighlightingInspection.class.getSimpleName());
        InspectionToolWrapper tool = profile.getInspectionTool(name, element.getProject());
        return profile.isToolEnabled(HighlightDisplayKey.find((String)name), element) && tool != null && !tool.getTool().isSuppressedFor(element);
    }

    private static boolean isInSupportedArea(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(5);
        }
        if ((file = (PsiFile)ReadAction.compute(() -> {
            if (element == null) {
                WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(14);
            }
            if (element.getContainingFile() == null || !element.isValid() || !element.getContainingFile().isValid()) {
                return null;
            }
            if (JSTokenTypes.STRING_LITERAL.equals(element.getNode().getElementType())) {
                return null;
            }
            return element.getContainingFile();
        })) == null) {
            return false;
        }
        List ranges = (List)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.create(WebpackInJavaScriptJsonSchemaProvider.getModuleExportsParts(file), (Object[])new Object[]{file}));
        return ContainerUtil.or((Iterable)ranges, range -> {
            if (element == null) {
                WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(13);
            }
            return range.contains(element.getTextRange());
        });
    }

    private static List<TextRange> getModuleExportsParts(@NotNull PsiFile file) {
        if (file == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(6);
        }
        List<JSAssignmentExpression> assignmentCandidates = PsiTreeUtil.findChildrenOfType((PsiElement)file, JSAssignmentExpression.class).stream().filter(assignment -> (assignment.getParent() instanceof JSStatement || assignment.getParent() instanceof JSCommaExpression) && assignment.getDefinitionExpression() != null && JSRefactoringUtil.isModuleExportsOrExports(assignment.getDefinitionExpression().getExpression())).collect(Collectors.toList());
        SmartList directParts = new SmartList();
        directParts.addAll(WebpackInJavaScriptJsonSchemaProvider.getObjectLiteralsAssignments(assignmentCandidates));
        directParts.addAll(WebpackInJavaScriptJsonSchemaProvider.getReferencesAssignments(assignmentCandidates));
        directParts.addAll(WebpackInJavaScriptJsonSchemaProvider.getReturnFromFunctionModuleExports(assignmentCandidates));
        directParts.addAll(WebpackInJavaScriptJsonSchemaProvider.getWebpackConfigVariables(file));
        return directParts.stream().sorted(Comparator.comparingInt(TextRange::getStartOffset)).collect(Collectors.toList());
    }

    @NotNull
    private static List<TextRange> getReturnFromFunctionModuleExports(@NotNull List<JSAssignmentExpression> candidates) {
        if (candidates == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(7);
        }
        List<TextRange> list = candidates.stream().filter(a -> a.getDefinitionExpression() != null && a.getDefinitionExpression().getInitializer() instanceof JSFunction).map(a -> {
            JSFunction function = (JSFunction)a.getDefinitionExpression().getInitializer();
            assert (function != null);
            JSElement body = JSChangeUtil.getFunctionBody(function);
            if (body instanceof JSStatement) {
                JSReturnStatement[] returns = (JSReturnStatement[])PsiTreeUtil.getChildrenOfType((PsiElement)body, JSReturnStatement.class);
                if (returns != null) {
                    return Arrays.stream(returns).map(r -> r.getExpression()).filter(e -> e instanceof JSObjectLiteralExpression).collect(Collectors.toList());
                }
            } else if (body instanceof JSObjectLiteralExpression) {
                return Collections.singletonList(body);
            }
            return Collections.emptyList();
        }).flatMap(Collection::stream).map(PsiElement::getTextRange).collect(Collectors.toList());
        if (list == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private static List<TextRange> getWebpackConfigVariables(@NotNull PsiFile file) {
        if (file == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(9);
        }
        List lists = PsiTreeUtil.findChildrenOfType((PsiElement)file, JSVariable.class).stream().filter(variable -> "webpackConfig".equalsIgnoreCase(variable.getName())).map(variable -> PsiTreeUtil.findChildrenOfAnyType((PsiElement)variable, (Class[])new Class[]{JSObjectLiteralExpression.class, JSArrayLiteralExpression.class})).filter(e -> e != null).collect(Collectors.toList());
        List<TextRange> list = ContainerUtil.concat(lists).stream().filter(Objects::nonNull).map(PsiElement::getTextRange).sorted(Comparator.comparingInt(TextRange::getStartOffset)).collect(Collectors.toList());
        if (list == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    private static List<TextRange> getReferencesAssignments(List<JSAssignmentExpression> assignmentCandidates) {
        List<TextRange> list = assignmentCandidates.stream().filter(a -> a.getDefinitionExpression() != null).map(a -> WebpackInJavaScriptJsonSchemaProvider.getObjectLiteralFromReference(a.getDefinitionExpression().getInitializer())).filter(Objects::nonNull).map(PsiElement::getTextRange).collect(Collectors.toList());
        if (list == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    private static List<TextRange> getObjectLiteralsAssignments(List<JSAssignmentExpression> assignmentCandidates) {
        List<TextRange> list = assignmentCandidates.stream().filter(assignment -> {
            JSDefinitionExpression definition = assignment.getDefinitionExpression();
            return definition != null && (definition.getInitializer() instanceof JSObjectLiteralExpression || definition.getInitializer() instanceof JSArrayLiteralExpression);
        }).map(PsiElement::getTextRange).collect(Collectors.toList());
        if (list == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(12);
        }
        return list;
    }

    private static JSExpression getObjectLiteralFromReference(@Nullable JSExpression initializer) {
        JSExpression varInitializer;
        PsiElement resolve;
        if (initializer instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)initializer).resolve()) != null && resolve.isValid() && resolve instanceof JSVariable && (varInitializer = ((JSVariable)resolve).getInitializer()) instanceof JSObjectLiteralExpression) {
            return varInitializer;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnFromFunctionModuleExports";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebpackConfigVariables";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesAssignments";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectLiteralsAssignments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableForFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInTopLevelObject";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isWebpackInspectionAllowed";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isInSupportedArea";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getModuleExportsParts";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getReturnFromFunctionModuleExports";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getWebpackConfigVariables";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isInSupportedArea$2";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isInSupportedArea$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

