/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.javascript.TypeScriptFileType;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class TypeScriptFileIncludeProvider
extends FileIncludeProvider {
    private static final String START_PREFIX = "./";

    @NotNull
    public String getId() {
        String string = TypeScriptFileType.INSTANCE.getName();
        if (string == null) {
            TypeScriptFileIncludeProvider.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean acceptFile(VirtualFile file) {
        return TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(file.getFileType()) && JavaScriptIndex.ourIndexedFilesFilter.acceptInput(file);
    }

    public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
        if (fileTypeSink == null) {
            TypeScriptFileIncludeProvider.$$$reportNull$$$0(1);
        }
        for (FileType type : TypeScriptUtil.TYPESCRIPT_FILE_TYPES) {
            fileTypeSink.consume((Object)type);
        }
    }

    @NotNull
    public FileIncludeInfo[] getIncludeInfos(FileContent content) {
        JSFile file = (JSFile)ObjectUtils.tryCast((Object)content.getPsiFile(), JSFile.class);
        if (file == null) {
            if (FileIncludeInfo.EMPTY == null) {
                TypeScriptFileIncludeProvider.$$$reportNull$$$0(2);
            }
            return FileIncludeInfo.EMPTY;
        }
        FileIncludeInfo[] fileIncludeInfoArray = TypeScriptFileIncludeProvider.buildFileIncludeInfo(file.getReferencedPaths());
        if (fileIncludeInfoArray == null) {
            TypeScriptFileIncludeProvider.$$$reportNull$$$0(3);
        }
        return fileIncludeInfoArray;
    }

    @NotNull
    private static FileIncludeInfo[] buildFileIncludeInfo(Collection<String> refSet) {
        if (refSet.isEmpty()) {
            if (FileIncludeInfo.EMPTY == null) {
                TypeScriptFileIncludeProvider.$$$reportNull$$$0(4);
            }
            return FileIncludeInfo.EMPTY;
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (String ref : refSet) {
            boolean addSuffix;
            String path = FileUtil.toSystemIndependentName((String)StringUtil.unquoteString((String)ref));
            boolean addPrefix = TypeScriptFileIncludeProvider.needPrefix(path);
            boolean bl = addSuffix = JSFileReference.findExtension(path, TypeScriptUtil.TYPESCRIPT_EXTENSIONS) == null && !path.endsWith("/");
            if (!addSuffix) {
                result.add(TypeScriptFileIncludeProvider.createInfo(addPrefix ? START_PREFIX + path : path));
                continue;
            }
            for (String extension : TypeScriptUtil.TYPESCRIPT_EXTENSIONS) {
                result.add(TypeScriptFileIncludeProvider.createInfo((addPrefix ? START_PREFIX : "") + path + extension));
            }
        }
        FileIncludeInfo[] fileIncludeInfoArray = result.toArray(FileIncludeInfo.EMPTY);
        if (fileIncludeInfoArray == null) {
            TypeScriptFileIncludeProvider.$$$reportNull$$$0(5);
        }
        return fileIncludeInfoArray;
    }

    private static FileIncludeInfo createInfo(@NotNull String path) {
        if (path == null) {
            TypeScriptFileIncludeProvider.$$$reportNull$$$0(6);
        }
        return new FileIncludeInfo(path);
    }

    private static boolean needPrefix(String path) {
        return !path.startsWith(START_PREFIX) && !path.startsWith("../") && !FileUtil.isAbsolutePlatformIndependent((String)path);
    }

    public int getVersion() {
        return 2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/TypeScriptFileIncludeProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeSink";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/TypeScriptFileIncludeProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludeInfos";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFileIncludeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerFileTypesUsedForIndexing";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

