/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.ES6CreateConstructorFix;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementMethodsFix;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6CreateClassOrInterfaceFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String targetName;
    private final boolean myIsInterface;
    @Nullable
    private final JSType myExpectedType;
    @Nullable
    private final SmartPsiElementPointer<JSArgumentList> myConstructorArguments;

    public ES6CreateClassOrInterfaceFix(@NotNull JSReferenceExpression expression, boolean isInterface, @Nullable JSArgumentList constructorArguments, @Nullable JSType expectedType) {
        if (expression == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(0);
        }
        super((PsiElement)expression);
        this.targetName = expression.getText();
        this.myIsInterface = isInterface;
        this.myExpectedType = expectedType;
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)expression.getProject());
        this.myConstructorArguments = constructorArguments != null ? smartPointerManager.createSmartPsiElementPointer((PsiElement)constructorArguments) : null;
    }

    @NotNull
    public String getText() {
        String key = this.myIsInterface ? "javascript.create.interface.intention.name" : "javascript.create.class.intention.name";
        String string = JSBundle.message((String)key, (Object[])new Object[]{this.targetName});
        if (string == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        JSArgumentList argumentList;
        if (project == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(3);
        }
        if (file == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(4);
        }
        if (startElement == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(5);
        }
        if (endElement == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(6);
        }
        PsiFile targetFile = startElement.getContainingFile();
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(startElement);
        if (!FileModificationService.getInstance().prepareFileForWrite(targetFile)) {
            return;
        }
        String declarationText = ES6CreateClassOrInterfaceFix.getDeclarationText(this.myIsInterface, this.targetName, ES6CreateClassOrInterfaceFix.getBaseClass(this.myExpectedType), ES6CreateClassOrInterfaceFix.getImplementsList(this.myExpectedType));
        JSClass result = JSChangeUtil.createStatementPsiFromTextWithContext(declarationText, (PsiElement)targetFile, JSClass.class);
        if (result == null) {
            return;
        }
        if (dialect != null && dialect.isTypeScript) {
            TypeScriptImplementMethodsFix.invokeOnClass(result);
        }
        PsiElement topLevelDeclaration = PsiTreeUtil.findFirstParent((PsiElement)startElement, element -> {
            PsiElement parent = element.getParent();
            return parent instanceof JSFile || parent instanceof JSEmbeddedContent;
        });
        result = (JSClass)targetFile.addBefore((PsiElement)result, topLevelDeclaration);
        BaseCreateFix.navigate(project, editor, result.getTextOffset(), targetFile.getVirtualFile());
        CodeStyleManager.getInstance((Project)project).reformatNewlyAddedElement(result.getParent().getNode(), result.getNode());
        JSArgumentList jSArgumentList = argumentList = this.myConstructorArguments != null ? (JSArgumentList)this.myConstructorArguments.getElement() : null;
        if (argumentList != null && argumentList.getArguments().length > 0) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            Document document = documentManager.getDocument(file);
            if (document == null) {
                return;
            }
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            ES6CreateConstructorFix.generateConstructor(result, argumentList, editor);
        }
    }

    private static String getDeclarationText(boolean isInterface, String name, String baseClass, List<String> implementsList) {
        StringBuilder builder = new StringBuilder();
        builder.append(isInterface ? "interface " : "class ").append(name);
        if (!StringUtil.isEmpty((String)baseClass)) {
            builder.append(" extends ").append(baseClass);
        }
        if (!implementsList.isEmpty()) {
            builder.append(" implements ").append(StringUtil.join(implementsList, s -> s, (String)","));
        }
        builder.append("{\n}");
        return builder.toString();
    }

    @Nullable
    private static String getBaseClass(@Nullable JSType expectedType) {
        if (expectedType instanceof JSNamedType) {
            return ES6CreateClassOrInterfaceFix.getNameIfApplicable(expectedType, false);
        }
        if (expectedType instanceof JSIntersectionTypeImpl) {
            List classNames = ContainerUtil.mapNotNull(((JSIntersectionTypeImpl)expectedType).getTypes(), type -> ES6CreateClassOrInterfaceFix.getNameIfApplicable(type, false));
            return classNames.size() == 1 ? (String)classNames.get(0) : null;
        }
        return null;
    }

    private static List<String> getImplementsList(@Nullable JSType expectedType) {
        if (expectedType instanceof JSNamedType) {
            return ContainerUtil.createMaybeSingletonList((Object)ES6CreateClassOrInterfaceFix.getNameIfApplicable(expectedType, true));
        }
        if (expectedType instanceof JSIntersectionTypeImpl) {
            return ContainerUtil.mapNotNull(((JSIntersectionTypeImpl)expectedType).getTypes(), type -> ES6CreateClassOrInterfaceFix.getNameIfApplicable(type, true));
        }
        return ContainerUtil.emptyList();
    }

    @Nullable
    private static String getNameIfApplicable(@NotNull JSType expectedType, boolean isInterface) {
        if (expectedType == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(7);
        }
        if (expectedType instanceof JSTypeImpl && ((JSTypeImpl)expectedType).isInterface() == isInterface) {
            return expectedType.getTypeText(JSType.TypeTextFormat.CODE);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6CreateClassOrInterfaceFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6CreateClassOrInterfaceFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNameIfApplicable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

