/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.MultiMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSFileReferencesInspection
extends JSInspection {
    public static final String SHORT_NAME = JSFileReferencesInspection.calcShortNameFromClass(JSFileReferencesInspection.class);
    public boolean myIgnoreComplexCases = true;

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.file.references.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            JSFileReferencesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            JSFileReferencesInspection.$$$reportNull$$$0(1);
        }
        return highlightDisplayLevel;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JSBundle.message((String)"js.file.references.inspection.ignore.complex.cases", (Object[])new Object[0]), (InspectionProfileEntry)this, "myIgnoreComplexCases");
    }

    public static boolean acceptsReference(@NotNull FileReference reference) {
        PsiElement element;
        DialectOptionHolder holder;
        if (reference == null) {
            JSFileReferencesInspection.$$$reportNull$$$0(2);
        }
        if ((holder = DialectDetector.dialectOfElement((element = reference.getElement()) instanceof PsiComment ? element.getParent() : element)) == null) {
            return false;
        }
        if (holder.isTypeScript) {
            if (element instanceof ES6FromClause || element instanceof PsiComment || element instanceof ES6ImportExportSpecifier || element instanceof TypeScriptExternalModuleReference) {
                return false;
            }
            if (TypeScriptPsiUtil.isLiteralModuleAugmentationName(element)) {
                return false;
            }
        }
        return !holder.isECMA4;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSLiteralExpression(JSLiteralExpression node) {
                this.checkReferences((PsiElement)node);
            }

            public void visitES6FromClause(ES6FromClause fromClause) {
                this.checkReferences((PsiElement)fromClause);
            }

            private void checkReferences(PsiElement node) {
                HashMap hardRefs = new HashMap();
                MultiMap softRefs = MultiMap.create();
                for (PsiReference ref : node.getReferences()) {
                    if (!(ref instanceof FileReference) || !JSFileReferencesInspection.acceptsReference((FileReference)ref)) continue;
                    FileReference fileRef = (FileReference)ref;
                    TextRange range = ref.getRangeInElement();
                    if (ref.isSoft() && JSFileReferencesInspection.this.myIgnoreComplexCases) {
                        softRefs.putValue((Object)range, (Object)fileRef);
                        continue;
                    }
                    if (hardRefs.containsKey(range) && hardRefs.get(range) == null) continue;
                    ResolveResult[] results = fileRef.multiResolve(false);
                    if (results.length != 0) {
                        hardRefs.put(range, null);
                        continue;
                    }
                    hardRefs.put(range, fileRef);
                }
                block1: for (Map.Entry entry : hardRefs.entrySet()) {
                    FileReference ref = (FileReference)entry.getValue();
                    if (ref == null) continue;
                    for (FileReference softRef : softRefs.get(entry.getKey())) {
                        if (softRef.multiResolve(false).length <= 0) continue;
                        continue block1;
                    }
                    String message = XmlHighlightVisitor.getErrorDescription((PsiReference)ref);
                    holder.registerProblem(node, ref.getRangeInElement(), message, ref.getQuickFixes());
                }
            }
        };
        if (jSElementVisitor == null) {
            JSFileReferencesInspection.$$$reportNull$$$0(3);
        }
        return jSElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSFileReferencesInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSFileReferencesInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "acceptsReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

