/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.JSChangeVisibilityUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureProcessor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodDescriptor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypeScriptModifierIntention
extends JavaScriptIntention
implements LowPriorityAction {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        TypeScriptFunction method;
        if (project == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(1);
        }
        if ((method = this.getFunction(element)) != null) {
            this.invokeForFunction(project, element, (JSFunction)method);
            return;
        }
        JSVariable field = this.getField(element);
        if (field != null) {
            this.invokeForField(project, element, field);
        }
    }

    private void invokeForField(@NotNull Project project, @NotNull PsiElement element, JSVariable field) {
        if (project == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(3);
        }
        JSAttributeList.AccessType type = this.getInspectionAccessType();
        ApplicationManager.getApplication().runWriteAction(() -> JSChangeVisibilityUtil.setVisibility((JSAttributeListOwner)field, type, null));
    }

    private void invokeForFunction(@NotNull Project project, @NotNull PsiElement element, JSFunction method) {
        if (project == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(5);
        }
        if (method == null) {
            return;
        }
        if ((method = this.getParentFunction(method, project, element)) == null) {
            return;
        }
        JSParameterInfo[] infos = (JSParameterInfo[])ContainerUtil.toArray(JSMethodDescriptor.getParameters(method), JSParameterInfo.ARRAY_FACTORY);
        JSType type = method.getReturnType();
        String stringType = type == null ? null : type.getTypeText(JSType.TypeTextFormat.CODE);
        PsiElement returnTypeElement = method.getReturnTypeElement();
        JSChangeSignatureProcessor processor = new JSChangeSignatureProcessor(method, this.getInspectionAccessType(), method.getName(), returnTypeElement == null ? null : stringType, infos, Collections.emptySet(), Collections.emptySet());
        processor.setPrepareSuccessfulSwingThreadCallback(() -> {});
        processor.run();
    }

    @Nullable
    protected JSFunction getParentFunction(@Nullable JSFunction method, @NotNull Project project, @Nullable PsiElement context) {
        if (project == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(6);
        }
        if (method == null) {
            return null;
        }
        Map<JSClass, JSFunction> map = JSInheritanceUtil.findDeclaringClassesMap(method);
        if (map.size() != 1) {
            return method;
        }
        Map.Entry item = (Map.Entry)ContainerUtil.getFirstItem(map.entrySet());
        if (item == null) {
            return method;
        }
        JSFunction value = (JSFunction)item.getValue();
        if (value.equals(method)) {
            return method;
        }
        return this.getParentFunction(value, project, context);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(7);
        }
        if (element == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(8);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        if (!(file instanceof JSFile)) {
            return false;
        }
        if (!DialectDetector.isTypeScript(element)) {
            return false;
        }
        return this.checkForFunction(project, element) || this.checkForField(project, element);
    }

    protected boolean checkForFunction(@NotNull Project project, @NotNull PsiElement element) {
        JSClass parentClass;
        TypeScriptFunction function;
        if (project == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(9);
        }
        if (element == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(10);
        }
        if ((function = this.getFunction(element)) == null || function.getAttributeList() == null || function.isConstructor()) {
            return false;
        }
        JSClass jsClass = JSResolveUtil.getClassOfContext((PsiElement)function);
        if (jsClass == null || jsClass.isInterface()) {
            return false;
        }
        JSFunction parentFunction = this.getParentFunction((JSFunction)function, project, element);
        if (parentFunction != function && ((parentClass = JSResolveUtil.getClassOfContext((PsiElement)parentFunction)) == null || parentClass.isInterface())) {
            return false;
        }
        JSAttributeList.AccessType modifier = this.getCurrentModifier((JSAttributeListOwner)function);
        return modifier != this.getInspectionAccessType();
    }

    protected boolean checkForField(@NotNull Project project, @NotNull PsiElement element) {
        JSVariable field;
        if (project == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(11);
        }
        if (element == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(12);
        }
        if ((field = this.getField(element)) == null || field.getAttributeList() == null) {
            return false;
        }
        JSAttributeList.AccessType modifier = this.getCurrentModifier((JSAttributeListOwner)field);
        if (modifier == this.getInspectionAccessType()) {
            return false;
        }
        Collection<JSPsiElementBase> members = JSInheritanceUtil.findTopMembers((JSQualifiedNamedElement)field);
        return members.stream().filter(el -> el == field).findAny().isPresent();
    }

    @Nullable
    protected JSAttributeList.AccessType getCurrentModifier(@NotNull JSAttributeListOwner owner) {
        JSAttributeList list;
        if (owner == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(13);
        }
        if ((list = owner.getAttributeList()) == null) {
            return null;
        }
        return list.getAccessType();
    }

    @Nullable
    protected JSVariable getField(@NotNull PsiElement current) {
        JSStatement statement;
        if (current == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(14);
        }
        if ((statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)current, JSStatement.class)) == null || !(statement instanceof JSVarStatement)) {
            return null;
        }
        JSVarStatement varStatement = (JSVarStatement)statement;
        PsiElement parent = varStatement.getParent();
        if (parent instanceof JSClass && !(parent instanceof TypeScriptEnum)) {
            int length;
            if (current.getParent() instanceof JSAttributeList && (length = varStatement.getVariables().length) == 1) {
                return varStatement.getVariables()[0];
            }
            return (JSVariable)PsiTreeUtil.getParentOfType((PsiElement)current, JSVariable.class);
        }
        return null;
    }

    @Nullable
    protected TypeScriptFunction getFunction(@NotNull PsiElement current) {
        PsiElement parent;
        if (current == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(15);
        }
        if ((parent = current.getParent()) instanceof JSAttributeList) {
            parent = parent.getParent();
        }
        return parent instanceof TypeScriptFunction ? (TypeScriptFunction)parent : null;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = "Make '" + JSVisibilityUtil.accessTypeToKeyword(this.getInspectionAccessType(), DialectOptionHolder.TS) + "'";
        if (string == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(17);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public abstract JSAttributeList.AccessType getInspectionAccessType();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/TypeScriptModifierIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/TypeScriptModifierIntention";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invokeForField";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invokeForFunction";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getParentFunction";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkForFunction";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkForField";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentModifier";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getField";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFunction";
                break;
            }
            case 16: 
            case 17: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

