/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public abstract class JSLinterConfigChangeTracker {
    private final AtomicBoolean myTracking;
    private final Project myProject;
    private final Condition<VirtualFile> myFileFilter;

    public JSLinterConfigChangeTracker(@NotNull Project project, @NotNull FileType fileType) {
        if (project == null) {
            JSLinterConfigChangeTracker.$$$reportNull$$$0(0);
        }
        if (fileType == null) {
            JSLinterConfigChangeTracker.$$$reportNull$$$0(1);
        }
        this(project, (Condition<VirtualFile>)((Condition)file -> {
            if (fileType == null) {
                JSLinterConfigChangeTracker.$$$reportNull$$$0(5);
            }
            return file.getFileType() == fileType;
        }));
    }

    public JSLinterConfigChangeTracker(@NotNull Project project, @NotNull Condition<VirtualFile> fileFilter) {
        if (project == null) {
            JSLinterConfigChangeTracker.$$$reportNull$$$0(2);
        }
        if (fileFilter == null) {
            JSLinterConfigChangeTracker.$$$reportNull$$$0(3);
        }
        this.myTracking = new AtomicBoolean(false);
        this.myProject = project;
        this.myFileFilter = fileFilter;
    }

    public void startIfNeeded() {
        if (this.myTracking.compareAndSet(false, true)) {
            ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                if (!this.myProject.isDisposed()) {
                    VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new JSLinterConfigFileVfsListener(), (Disposable)this.myProject);
                    EditorEventMulticaster multicaster = EditorFactory.getInstance().getEventMulticaster();
                    multicaster.addDocumentListener((DocumentListener)new JSLinterConfigFileDocumentListener(), (Disposable)this.myProject);
                }
            }));
        }
    }

    private void onChange(@NotNull VirtualFile file) {
        if (file == null) {
            JSLinterConfigChangeTracker.$$$reportNull$$$0(4);
        }
        if (this.myFileFilter.value((Object)file) && !this.myProject.isDisposed() && this.isAnalyzerRestartNeeded(this.myProject, file)) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
        }
    }

    protected abstract boolean isAnalyzerRestartNeeded(@NotNull Project var1, @NotNull VirtualFile var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileFilter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterConfigChangeTracker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "onChange";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$new$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class JSLinterConfigFileDocumentListener
    implements DocumentListener {
        private JSLinterConfigFileDocumentListener() {
        }

        public void documentChanged(DocumentEvent event) {
            VirtualFile file = FileDocumentManager.getInstance().getFile(event.getDocument());
            if (file != null) {
                JSLinterConfigChangeTracker.this.onChange(file);
            }
        }
    }

    private class JSLinterConfigFileVfsListener
    implements VirtualFileListener {
        private JSLinterConfigFileVfsListener() {
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                JSLinterConfigFileVfsListener.$$$reportNull$$$0(0);
            }
            JSLinterConfigChangeTracker.this.onChange(event.getFile());
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                JSLinterConfigFileVfsListener.$$$reportNull$$$0(1);
            }
            JSLinterConfigChangeTracker.this.onChange(event.getFile());
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                JSLinterConfigFileVfsListener.$$$reportNull$$$0(2);
            }
            JSLinterConfigChangeTracker.this.onChange(event.getFile());
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                JSLinterConfigFileVfsListener.$$$reportNull$$$0(3);
            }
            JSLinterConfigChangeTracker.this.onChange(event.getFile());
            JSLinterConfigChangeTracker.this.onChange(event.getOriginalFile());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterConfigChangeTracker$JSLinterConfigFileVfsListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileDeleted";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileMoved";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCopied";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

