/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterGuesser;
import com.intellij.lang.javascript.linter.JSLinterStandardFixes;
import com.intellij.lang.javascript.linter.JSNpmLinterState;
import com.intellij.lang.javascript.linter.JsqtViewProcessOutputAction;
import com.intellij.lang.javascript.linter.rhino.RhinoUtil;
import com.intellij.lang.javascript.modules.InstallNodeLocalDependenciesAction;
import com.intellij.lang.javascript.service.ResultWithError;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.TopLevel;

public class JSLinterUtil {
    public static final Language VUE = Language.findLanguageByID((String)"Vue");
    public static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Linter Language Service", NotificationDisplayType.BALLOON, true);

    private JSLinterUtil() {
    }

    @NotNull
    public static NativeObject convertPredefToRhinoMap(@NotNull Object predef) {
        if (predef == null) {
            JSLinterUtil.$$$reportNull$$$0(0);
        }
        HashMap map = new HashMap();
        if (predef instanceof String) {
            Map<String, Boolean> boolMap = JSLinterUtil.convertPredefStrToMap((String)predef);
            map.putAll(boolMap);
        } else if (predef instanceof List) {
            for (Object o : (List)predef) {
                if (!(o instanceof String)) continue;
                map.put((String)o, false);
            }
        } else if (predef instanceof Map) {
            for (Map.Entry entry : ((Map)predef).entrySet()) {
                if (!(entry.getKey() instanceof String)) continue;
                map.put((String)entry.getKey(), entry.getValue());
            }
        }
        NativeObject nativeObject = RhinoUtil.toRhinoMap(map);
        if (nativeObject == null) {
            JSLinterUtil.$$$reportNull$$$0(1);
        }
        return nativeObject;
    }

    @NotNull
    public static NativeArray convertPredefStrToNativeArray(@NotNull String predef, @NotNull Scriptable scope) {
        if (predef == null) {
            JSLinterUtil.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            JSLinterUtil.$$$reportNull$$$0(3);
        }
        Map<String, Boolean> structure = JSLinterUtil.convertPredefStrToMap(predef);
        NativeArray array = RhinoUtil.toRhinoArray(ContainerUtil.newArrayList(structure.keySet()));
        ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)array, (Scriptable)scope, (TopLevel.Builtins)TopLevel.Builtins.Array);
        NativeArray nativeArray = array;
        if (nativeArray == null) {
            JSLinterUtil.$$$reportNull$$$0(4);
        }
        return nativeArray;
    }

    @NotNull
    private static Map<String, Boolean> convertPredefStrToMap(@NotNull String predef) {
        if (predef == null) {
            JSLinterUtil.$$$reportNull$$$0(5);
        }
        LinkedHashMap map = ContainerUtil.newLinkedHashMap();
        StringTokenizer st = new StringTokenizer(predef, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            int ind = token.indexOf(58);
            String name = token;
            boolean readonly = false;
            if (ind >= 0) {
                String value = token.substring(ind + 1).trim();
                if (Boolean.toString(true).equals(value) || Boolean.toString(false).equals(value)) {
                    name = token.substring(0, ind).trim();
                    readonly = Boolean.parseBoolean(value);
                }
            }
            map.put(name, readonly);
        }
        LinkedHashMap linkedHashMap = map;
        if (linkedHashMap == null) {
            JSLinterUtil.$$$reportNull$$$0(6);
        }
        return linkedHashMap;
    }

    @NotNull
    public static Annotation createAnnotation(@NotNull AnnotationHolder holder, @NotNull HighlightSeverity severity, @Nullable TextAttributes forcedTextAttributes, @NotNull TextRange range, @NotNull String message) {
        if (holder == null) {
            JSLinterUtil.$$$reportNull$$$0(7);
        }
        if (severity == null) {
            JSLinterUtil.$$$reportNull$$$0(8);
        }
        if (range == null) {
            JSLinterUtil.$$$reportNull$$$0(9);
        }
        if (message == null) {
            JSLinterUtil.$$$reportNull$$$0(10);
        }
        if (forcedTextAttributes != null) {
            Annotation annotation = holder.createAnnotation(severity, range, message);
            annotation.setEnforcedTextAttributes(forcedTextAttributes);
            annotation.setNeedsUpdateOnTyping(false);
            Annotation annotation2 = annotation;
            if (annotation2 == null) {
                JSLinterUtil.$$$reportNull$$$0(11);
            }
            return annotation2;
        }
        Annotation annotation = severity == HighlightSeverity.ERROR ? holder.createErrorAnnotation(range, message) : holder.createWarningAnnotation(range, message);
        annotation.setNeedsUpdateOnTyping(false);
        JSLinterUtil.setTooltipToAnnotation(annotation);
        Annotation annotation3 = annotation;
        if (annotation3 == null) {
            JSLinterUtil.$$$reportNull$$$0(12);
        }
        return annotation3;
    }

    private static void setTooltipToAnnotation(@NotNull Annotation annotation) {
        if (annotation == null) {
            JSLinterUtil.$$$reportNull$$$0(13);
        }
        String message = annotation.getMessage();
        String escaped = XmlStringUtil.escapeString((String)message);
        escaped = StringUtil.convertLineSeparators((String)escaped, (String)"\n").replace("\n", "<br/>");
        String tooltip = message == null ? null : XmlStringUtil.wrapInHtml((CharSequence)escaped);
        annotation.setTooltip(tooltip);
    }

    @NotNull
    public static HighlightSeverity getSeverity(@NotNull InspectionProjectProfileManager inspectionProjectProfileManager, @NotNull HighlightDisplayKey inspectionKey, @NotNull PsiFile file) {
        InspectionProfileImpl inspectionProfile;
        HighlightDisplayLevel errorLevel;
        if (inspectionProjectProfileManager == null) {
            JSLinterUtil.$$$reportNull$$$0(14);
        }
        if (inspectionKey == null) {
            JSLinterUtil.$$$reportNull$$$0(15);
        }
        if (file == null) {
            JSLinterUtil.$$$reportNull$$$0(16);
        }
        if ((errorLevel = (inspectionProfile = inspectionProjectProfileManager.getCurrentProfile()).getErrorLevel(inspectionKey, (PsiElement)file)) == null) {
            errorLevel = HighlightDisplayLevel.WARNING;
        }
        HighlightSeverity highlightSeverity = errorLevel.getSeverity();
        if (highlightSeverity == null) {
            JSLinterUtil.$$$reportNull$$$0(17);
        }
        return highlightSeverity;
    }

    @NotNull
    public static TextAttributes getTextAttributes(@Nullable EditorColorsScheme editorColorsScheme, @NotNull SeverityRegistrar severityRegistrar, @NotNull HighlightSeverity severity) {
        TextAttributes textAttributes;
        if (severityRegistrar == null) {
            JSLinterUtil.$$$reportNull$$$0(18);
        }
        if (severity == null) {
            JSLinterUtil.$$$reportNull$$$0(19);
        }
        if ((textAttributes = severityRegistrar.getTextAttributesBySeverity(severity)) != null) {
            TextAttributes textAttributes2 = textAttributes;
            if (textAttributes2 == null) {
                JSLinterUtil.$$$reportNull$$$0(20);
            }
            return textAttributes2;
        }
        EditorColorsScheme colorsScheme = JSLinterUtil.getColorsScheme(editorColorsScheme);
        HighlightInfoType.HighlightInfoTypeImpl infoType = severityRegistrar.getHighlightInfoTypeBySeverity(severity);
        TextAttributesKey key = infoType.getAttributesKey();
        TextAttributes textAttributes3 = colorsScheme.getAttributes(key);
        if (textAttributes3 == null) {
            JSLinterUtil.$$$reportNull$$$0(21);
        }
        return textAttributes3;
    }

    @NotNull
    private static EditorColorsScheme getColorsScheme(@Nullable EditorColorsScheme customScheme) {
        if (customScheme != null) {
            EditorColorsScheme editorColorsScheme = customScheme;
            if (editorColorsScheme == null) {
                JSLinterUtil.$$$reportNull$$$0(22);
            }
            return editorColorsScheme;
        }
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        if (editorColorsScheme == null) {
            JSLinterUtil.$$$reportNull$$$0(23);
        }
        return editorColorsScheme;
    }

    @NotNull
    public static List<JSLinterError> limitErrorsAtTheSamePosition(@NotNull List<JSLinterError> errors, int limit) {
        if (errors == null) {
            JSLinterUtil.$$$reportNull$$$0(24);
        }
        Collections.sort(errors, (o1, o2) -> o1.compareFully((JSLinterError)o2));
        JSLinterError prev = null;
        ArrayList limited = ContainerUtil.newArrayList();
        int count = 0;
        for (JSLinterError error : errors) {
            if (prev != null && prev.compareLogicalPositionTo(error) == 0) {
                if (prev.getDescription().equals(error.getDescription())) continue;
                ++count;
            } else {
                count = 1;
            }
            if (count <= limit) {
                limited.add(error);
            }
            prev = error;
        }
        ArrayList arrayList = limited;
        if (arrayList == null) {
            JSLinterUtil.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @NotNull
    public static TextFieldWithBrowseButton createTextFieldWithBrowseButton(@NotNull Project project, @NotNull String description) {
        if (project == null) {
            JSLinterUtil.$$$reportNull$$$0(26);
        }
        if (description == null) {
            JSLinterUtil.$$$reportNull$$$0(27);
        }
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton(new JTextField(0));
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        JTextField textField = (JTextField)textFieldWithBrowseButton.getChildComponent();
        textField.setDisabledTextColor(UIUtil.getLabelDisabledForeground());
        textFieldWithBrowseButton.addBrowseFolderListener(description, null, project, fileChooserDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        FileChooserFactory.getInstance().installFileCompletion(textField, fileChooserDescriptor, true, (Disposable)project);
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = textFieldWithBrowseButton;
        if (textFieldWithBrowseButton2 == null) {
            JSLinterUtil.$$$reportNull$$$0(28);
        }
        return textFieldWithBrowseButton2;
    }

    @NotNull
    public static JEditorPane createDefaultContent(@NotNull String message) {
        if (message == null) {
            JSLinterUtil.$$$reportNull$$$0(29);
        }
        JEditorPane jEditorPane = JSLinterUtil.createHtmlViewer(message, null);
        if (jEditorPane == null) {
            JSLinterUtil.$$$reportNull$$$0(30);
        }
        return jEditorPane;
    }

    @NotNull
    public static JEditorPane createHtmlViewer(@NotNull String innerBodyHtml, @Nullable Font font) {
        if (innerBodyHtml == null) {
            JSLinterUtil.$$$reportNull$$$0(31);
        }
        if (font == null) {
            font = UIUtil.getLabelFont();
        }
        JEditorPane pane = SwingHelper.createHtmlViewer((boolean)true, (Font)font, null, null);
        String html = String.format("<html><head>%s</head><body>%s</body></html>", UIUtil.getCssFontDeclaration((Font)font, (Color)UIUtil.getLabelForeground(), null, null), innerBodyHtml);
        pane.setText(html);
        JEditorPane jEditorPane = pane;
        if (jEditorPane == null) {
            JSLinterUtil.$$$reportNull$$$0(32);
        }
        return jEditorPane;
    }

    public static int getRadioIconWidth() {
        Icon icon = UIManager.getIcon("RadioButton.icon");
        if (icon != null) {
            return icon.getIconWidth();
        }
        return 12;
    }

    public static boolean isVueFile(@NotNull PsiFile file) {
        if (file == null) {
            JSLinterUtil.$$$reportNull$$$0(33);
        }
        return VUE != null && VUE.equals(file.getLanguage());
    }

    public static boolean isPureHtmlFile(@NotNull PsiFile file) {
        if (file == null) {
            JSLinterUtil.$$$reportNull$$$0(34);
        }
        if (file.getLanguage() == HTMLLanguage.INSTANCE) {
            FileType fileTypeByName = FileTypeRegistry.getInstance().getFileTypeByFileName(file.getName());
            return fileTypeByName == HtmlFileType.INSTANCE;
        }
        return false;
    }

    @NotNull
    public static String getAbsoluteOrRelativePathToProjectRoot(@NotNull Project project, @NotNull VirtualFile file) {
        VirtualFile root;
        if (project == null) {
            JSLinterUtil.$$$reportNull$$$0(35);
        }
        if (file == null) {
            JSLinterUtil.$$$reportNull$$$0(36);
        }
        if ((root = project.getBaseDir()) != null && VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)true)) {
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)File.separatorChar);
            if (StringUtil.isEmpty((String)relativePath)) {
                String string = root.getName();
                if (string == null) {
                    JSLinterUtil.$$$reportNull$$$0(37);
                }
                return string;
            }
            String string = root.getName() + File.separatorChar + relativePath;
            if (string == null) {
                JSLinterUtil.$$$reportNull$$$0(38);
            }
            return string;
        }
        String string = FileUtil.getLocationRelativeToUserHome((String)file.getPresentableUrl());
        if (string == null) {
            JSLinterUtil.$$$reportNull$$$0(39);
        }
        return string;
    }

    @Nullable
    public static IntentionAction createDetailsAction(@NotNull Project project, @NotNull VirtualFile fileToLint, @Nullable GeneralCommandLine commandLine, @NotNull ProcessOutput output, @Nullable Icon icon) {
        if (project == null) {
            JSLinterUtil.$$$reportNull$$$0(40);
        }
        if (fileToLint == null) {
            JSLinterUtil.$$$reportNull$$$0(41);
        }
        if (output == null) {
            JSLinterUtil.$$$reportNull$$$0(42);
        }
        if (!StringUtil.containsLineBreak((CharSequence)output.getStderr())) {
            return null;
        }
        String presentableFilePath = (String)ReadAction.compute(() -> {
            if (project == null) {
                JSLinterUtil.$$$reportNull$$$0(68);
            }
            if (fileToLint == null) {
                JSLinterUtil.$$$reportNull$$$0(69);
            }
            return project.isDisposed() ? fileToLint.getPresentableUrl() : JSLinterUtil.getAbsoluteOrRelativePathToProjectRoot(project, fileToLint);
        });
        return new JsqtViewProcessOutputAction("Failed to lint " + presentableFilePath, icon, commandLine, null, output);
    }

    @NotNull
    public static ResultWithError<VirtualFile> checkPath(@NotNull String path, boolean isDir, @NotNull String fieldName) {
        VirtualFile virtualFile;
        if (path == null) {
            JSLinterUtil.$$$reportNull$$$0(43);
        }
        if (fieldName == null) {
            JSLinterUtil.$$$reportNull$$$0(44);
        }
        if ((virtualFile = JSLinterConfigFileUtil.findLocalFileByPath(path)) == null || !virtualFile.isValid() || isDir != virtualFile.isDirectory()) {
            ResultWithError<VirtualFile> resultWithError = ResultWithError.error("Please specify correct path to " + fieldName);
            if (resultWithError == null) {
                JSLinterUtil.$$$reportNull$$$0(45);
            }
            return resultWithError;
        }
        ResultWithError<VirtualFile> resultWithError = ResultWithError.result(virtualFile);
        if (resultWithError == null) {
            JSLinterUtil.$$$reportNull$$$0(46);
        }
        return resultWithError;
    }

    @Nullable
    public static JSLinterFileLevelAnnotation validateInterpreterAndPackage(@NotNull Project project, @NotNull String packageName, @NotNull JSNpmLinterState<?> linterState) {
        if (project == null) {
            JSLinterUtil.$$$reportNull$$$0(47);
        }
        if (packageName == null) {
            JSLinterUtil.$$$reportNull$$$0(48);
        }
        if (linterState == null) {
            JSLinterUtil.$$$reportNull$$$0(49);
        }
        try {
            NodeJsInterpreter interpreter = linterState.getInterpreterRef().resolve(project);
            NodeJsLocalInterpreter.castAndValidate(interpreter);
        }
        catch (ExecutionException e) {
            return new JSLinterFileLevelAnnotation(StringUtil.decapitalize((String)e.getMessage()));
        }
        String packagePath = StringUtil.notNullize((String)linterState.getLinterPackagePath());
        ResultWithError<VirtualFile> packageValidation = JSLinterUtil.checkPath(packagePath, true, packageName);
        return packageValidation.getError() == null ? null : JSLinterUtil.createLinterPackageError(project, packagePath, packageName);
    }

    public static JSLinterFileLevelAnnotation createLinterPackageError(@NotNull Project project, @NotNull String packagePath, @NonNls @NotNull String packageName) {
        if (project == null) {
            JSLinterUtil.$$$reportNull$$$0(50);
        }
        if (packagePath == null) {
            JSLinterUtil.$$$reportNull$$$0(51);
        }
        if (packageName == null) {
            JSLinterUtil.$$$reportNull$$$0(52);
        }
        if (StringUtil.isEmptyOrSpaces((String)packagePath)) {
            return new JSLinterFileLevelAnnotation(String.format("Please specify path to '%s' package", packageName));
        }
        File path = new File(packagePath);
        if (path.getParentFile() != null && "node_modules".equals(path.getParentFile().getName()) && Objects.equals(path.getParentFile().getParentFile(), new File(project.getBasePath()))) {
            String message = String.format("Please install '%s' package", packageName);
            JSLinterFileLevelAnnotation annotation = new JSLinterFileLevelAnnotation(null, message, HighlightSeverity.ERROR, new JSLinterStandardFixes());
            VirtualFile packageJson = project.getBaseDir().findChild("package.json");
            if (packageJson != null) {
                annotation.getFixes().setOtherFixes(Collections.singletonList(new MyInstallNpmIntention()));
            }
            return annotation;
        }
        return new JSLinterFileLevelAnnotation(String.format("Please specify path to '%s' package correctly", packageName));
    }

    @Nullable
    public static Document getDocumentForElement(@NotNull PsiElement element) {
        if (element == null) {
            JSLinterUtil.$$$reportNull$$$0(53);
        }
        if (!element.isValid()) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile != null && psiFile.isValid()) {
            psiFile = InjectedLanguageManager.getInstance((Project)psiFile.getProject()).getTopLevelFile((PsiElement)psiFile.getOriginalFile());
            return PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
        }
        return null;
    }

    @NotNull
    public static String convertLineSeparatorsToFileOriginal(@NotNull Project project, @NotNull String fileContent, @NotNull VirtualFile file) {
        String lineSeparator;
        if (project == null) {
            JSLinterUtil.$$$reportNull$$$0(54);
        }
        if (fileContent == null) {
            JSLinterUtil.$$$reportNull$$$0(55);
        }
        if (file == null) {
            JSLinterUtil.$$$reportNull$$$0(56);
        }
        if ((lineSeparator = FileDocumentManager.getInstance().getLineSeparator(file, project)).equals("\n")) {
            String string = fileContent;
            if (string == null) {
                JSLinterUtil.$$$reportNull$$$0(57);
            }
            return string;
        }
        String string = StringUtil.convertLineSeparators((String)fileContent, (String)lineSeparator);
        if (string == null) {
            JSLinterUtil.$$$reportNull$$$0(58);
        }
        return string;
    }

    public static void reportCodeStyleSettingsImported(@NotNull Project project, @NotNull String linterName, @NotNull VirtualFile file, @NotNull Collection<String> importedRuleNames) {
        if (project == null) {
            JSLinterUtil.$$$reportNull$$$0(59);
        }
        if (linterName == null) {
            JSLinterUtil.$$$reportNull$$$0(60);
        }
        if (file == null) {
            JSLinterUtil.$$$reportNull$$$0(61);
        }
        if (importedRuleNames == null) {
            JSLinterUtil.$$$reportNull$$$0(62);
        }
        JSLinterUtil.reportCodeStyleSettingsImported(project, linterName, file, importedRuleNames, null);
    }

    public static void reportCodeStyleSettingsImported(final @NotNull Project project, @NotNull String linterName, final @NotNull VirtualFile file, @NotNull Collection<String> importedRuleNames, final @Nullable Runnable resetAction) {
        if (project == null) {
            JSLinterUtil.$$$reportNull$$$0(63);
        }
        if (linterName == null) {
            JSLinterUtil.$$$reportNull$$$0(64);
        }
        if (file == null) {
            JSLinterUtil.$$$reportNull$$$0(65);
        }
        if (importedRuleNames == null) {
            JSLinterUtil.$$$reportNull$$$0(66);
        }
        String rulesText = importedRuleNames.stream().sorted().collect(Collectors.joining(", "));
        String message = JSBundle.message((String)"javascript.linter.import.notification", (Object[])new Object[]{linterName, file.getName(), rulesText, importedRuleNames.size()});
        Notification notification = JSLinterGuesser.NOTIFICATION_GROUP.createNotification(message, NotificationType.INFORMATION);
        notification.addAction((AnAction)new NotificationAction(String.format("Edit '%s'", file.getName())){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    1.$$$reportNull$$$0(1);
                }
                new OpenFileDescriptor(project, file, 0).navigate(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/linter/JSLinterUtil$1";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (resetAction != null) {
            notification.addAction((AnAction)new NotificationAction(JSBundle.message((String)"javascript.linter.import.notification.reset", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (notification == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (project.isDisposed()) {
                        return;
                    }
                    resetAction.run();
                    JSLinterGuesser.NOTIFICATION_GROUP.createNotification(JSBundle.message((String)"javascript.linter.import.notification.restored", (Object[])new Object[0]), NotificationType.INFORMATION).notify(project);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/lang/javascript/linter/JSLinterUtil$2";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        notification.notify(project);
    }

    public static String addHtmlURLMarkupIfNeeded(@NotNull String message) {
        if (message == null) {
            JSLinterUtil.$$$reportNull$$$0(67);
        }
        if (!URLUtil.canContainUrl((String)message)) {
            return message;
        }
        StringBuilder sb = new StringBuilder("<html>");
        Matcher matcher = URLUtil.URL_PATTERN.matcher(message);
        int prev = 0;
        while (matcher.find()) {
            String url = MessageFormat.format("<a href=\"{0}\">{0}</a>", matcher.group());
            sb.append(message.substring(prev, matcher.start())).append(url);
            prev = matcher.end();
        }
        if (prev < message.length()) {
            sb.append(message.substring(prev, message.length()));
        }
        sb.append("</html>");
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 30: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 45: 
            case 46: 
            case 57: 
            case 58: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 30: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 45: 
            case 46: 
            case 57: 
            case 58: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predef";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 30: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 45: 
            case 46: 
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 8: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 10: 
            case 29: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionProjectProfileManager";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionKey";
                break;
            }
            case 16: 
            case 33: 
            case 34: 
            case 36: 
            case 56: 
            case 61: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severityRegistrar";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 26: 
            case 35: 
            case 40: 
            case 47: 
            case 50: 
            case 54: 
            case 59: 
            case 63: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerBodyHtml";
                break;
            }
            case 41: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToLint";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linterState";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packagePath";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
            case 60: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linterName";
                break;
            }
            case 62: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedRuleNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "convertPredefToRhinoMap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "convertPredefStrToNativeArray";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "convertPredefStrToMap";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotation";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverity";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextAttributes";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorsScheme";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "limitErrorsAtTheSamePosition";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextFieldWithBrowseButton";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultContent";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createHtmlViewer";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsoluteOrRelativePathToProjectRoot";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "checkPath";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLineSeparatorsToFileOriginal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertPredefToRhinoMap";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 30: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 45: 
            case 46: 
            case 57: 
            case 58: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertPredefStrToNativeArray";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convertPredefStrToMap";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotation";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setTooltipToAnnotation";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSeverity";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTextAttributes";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "limitErrorsAtTheSamePosition";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createTextFieldWithBrowseButton";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultContent";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createHtmlViewer";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isVueFile";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isPureHtmlFile";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getAbsoluteOrRelativePathToProjectRoot";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createDetailsAction";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "checkPath";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "validateInterpreterAndPackage";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createLinterPackageError";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentForElement";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "convertLineSeparatorsToFileOriginal";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "reportCodeStyleSettingsImported";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "addHtmlURLMarkupIfNeeded";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createDetailsAction$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 30: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 45: 
            case 46: 
            case 57: 
            case 58: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyInstallNpmIntention
    implements IntentionAction {
        private MyInstallNpmIntention() {
        }

        @Nls
        @NotNull
        public String getText() {
            String string = JSBundle.message((String)"node.js.quickfix.run.npm.update.text", (Object[])new Object[]{"install"});
            if (string == null) {
                MyInstallNpmIntention.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"node.js.quickfix.install.node.module.update.modules.family.name", (Object[])new Object[0]);
            if (string == null) {
                MyInstallNpmIntention.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                MyInstallNpmIntention.$$$reportNull$$$0(2);
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            VirtualFile packageJson;
            if (project == null) {
                MyInstallNpmIntention.$$$reportNull$$$0(3);
            }
            if ((packageJson = project.getBaseDir().findChild("package.json")) != null) {
                InstallNodeLocalDependenciesAction.runAndShowConsole(project, packageJson);
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterUtil$MyInstallNpmIntention";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterUtil$MyInstallNpmIntention";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

