/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeJSSettingsManager;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateManager;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.modules.ConsoleProgress;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallNodeLocalDependenciesAction
extends AnAction
implements DumbAware {
    public InstallNodeLocalDependenciesAction() {
        super("Run 'npm install'", null, AllIcons.Actions.Install);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        VirtualFile packageJson = InstallNodeLocalDependenciesAction.getPackageJsonFile(e);
        boolean show = project != null && packageJson != null;
        e.getPresentation().setEnabledAndVisible(show);
        if (show) {
            NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance(project).getDefault();
            NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast(interpreter);
            boolean yarn = localInterpreter != null && localInterpreter.isYarnAlikePackage();
            NpmCommand npmCommand = InstallNodeLocalDependenciesAction.guessNpmCommand(packageJson);
            String exe = yarn ? "yarn" : "npm";
            e.getPresentation().setText("Run '" + exe + " " + npmCommand.getCliOption(yarn) + "'");
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        VirtualFile packageJson = InstallNodeLocalDependenciesAction.getPackageJsonFile(e);
        if (project != null && packageJson != null) {
            InstallNodeLocalDependenciesAction.runAndShowConsole(project, packageJson);
        }
    }

    @NotNull
    public static NpmCommand guessNpmCommand(@NotNull VirtualFile packageJson) {
        VirtualFile nodeModulesDir;
        if (packageJson == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(2);
        }
        NpmCommand npmCommand = (nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(packageJson)) != null ? NpmCommand.UPDATE : NpmCommand.INSTALL;
        if (npmCommand == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(3);
        }
        return npmCommand;
    }

    @Nullable
    private static VirtualFile getPackageJsonFile(@NotNull AnActionEvent e) {
        VirtualFile file;
        if (e == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(4);
        }
        if ((file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) != null && PackageJsonUtil.isPackageJsonFile(file) && file.isValid()) {
            return file;
        }
        return null;
    }

    public static void runAndShowConsole(@NotNull Project project, @NotNull VirtualFile packageJson) {
        if (project == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(5);
        }
        if (packageJson == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(6);
        }
        InstallNodeLocalDependenciesAction.runAndShowConsole(project, Collections.singletonList(packageJson));
    }

    public static void runAndShowConsole(final @NotNull Project project, final @NotNull List<VirtualFile> packageJsonFiles) {
        VirtualFile packageJson;
        if (project == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(7);
        }
        if (packageJsonFiles == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(8);
        }
        if ((packageJson = (VirtualFile)ContainerUtil.getFirstItem(packageJsonFiles)) == null) {
            return;
        }
        InstallNodeLocalDependenciesAction.saveFile(packageJson);
        final NpmCommand npmCommand = InstallNodeLocalDependenciesAction.guessNpmCommand(packageJson);
        ExecutionEnvironmentBuilder builder = new ExecutionEnvironmentBuilder(project, DefaultRunExecutor.getRunExecutorInstance()).runProfile(new RunProfile(){

            public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
                if (executor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (environment == null) {
                    1.$$$reportNull$$$0(1);
                }
                return new MyRunProfileState(environment.getProject(), packageJson, npmCommand, packageJsonFiles.subList(1, packageJsonFiles.size()));
            }

            public String getName() {
                String text = NpmCommand.INSTALL == npmCommand ? "Node.js dependencies installation" : "Node.js dependencies " + npmCommand.getCliOption();
                text = text + " for " + JsbtUtil.getRelativePath(project, packageJson);
                return text;
            }

            @Nullable
            public Icon getIcon() {
                return AllIcons.Actions.Install;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "executor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "environment";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$1";
                objectArray[2] = "getState";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ExecutionManager.getInstance((Project)project).restartRunProfile(builder.build());
    }

    static void saveFile(@NotNull VirtualFile file) {
        Document doc;
        FileDocumentManager fileDocumentManager;
        if (file == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(9);
        }
        if ((fileDocumentManager = FileDocumentManager.getInstance()).isFileModified(file) && (doc = fileDocumentManager.getDocument(file)) != null) {
            fileDocumentManager.saveDocument(doc);
        }
    }

    @NotNull
    private static NodeJsLocalInterpreter getProjectLocalInterpreter(@NotNull Project project, @NotNull List<VirtualFile> packageJsonFiles) throws ExecutionException {
        NodeJsInterpreter interpreter;
        NodeJsLocalInterpreter localInterpreter;
        if (project == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(10);
        }
        if (packageJsonFiles == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(11);
        }
        if ((localInterpreter = NodeJsLocalInterpreter.tryCast(interpreter = NodeJsInterpreterManager.getInstance(project).getDefault())) == null) {
            throw new NodeInterpreterException(project, packageJsonFiles, "No local Node.js interpreter");
        }
        if (!localInterpreter.isValid()) {
            throw new NodeInterpreterException(project, packageJsonFiles, "Invalid \"" + localInterpreter.getInterpreterSystemDependentPath() + "\"");
        }
        NodeJsLocalInterpreter nodeJsLocalInterpreter = localInterpreter;
        if (nodeJsLocalInterpreter == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(12);
        }
        return nodeJsLocalInterpreter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonFiles";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "guessNpmCommand";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectLocalInterpreter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "guessNpmCommand";
                break;
            }
            case 3: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPackageJsonFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "runAndShowConsole";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "saveFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getProjectLocalInterpreter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NodeInterpreterException
    extends ExecutionException
    implements HyperlinkListener {
        private final Project myProject;
        private final List<VirtualFile> myPackageJsonFiles;

        private NodeInterpreterException(@NotNull Project project, @NotNull List<VirtualFile> packageJsonFiles, @NotNull String details) {
            if (project == null) {
                NodeInterpreterException.$$$reportNull$$$0(0);
            }
            if (packageJsonFiles == null) {
                NodeInterpreterException.$$$reportNull$$$0(1);
            }
            if (details == null) {
                NodeInterpreterException.$$$reportNull$$$0(2);
            }
            super(details + "<p/>Please specify local Node.js interpreter in <a href=''>Node.js and NPM</a>");
            this.myProject = project;
            this.myPackageJsonFiles = packageJsonFiles;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e != null && e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                NodeJSSettingsManager.editSettingsAppropriately(this.myProject);
                NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance(this.myProject).getDefault();
                try {
                    NodeJsLocalInterpreter.castAndValidate(interpreter);
                    InstallNodeLocalDependenciesAction.runAndShowConsole(this.myProject, this.myPackageJsonFiles);
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "packageJsonFiles";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "details";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$NodeInterpreterException";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyRunProfileState
    implements RunProfileState {
        private final Project myProject;
        private final VirtualFile myPackageJson;
        private final NpmCommand myNpmCommand;
        private final List<VirtualFile> myEnqueuedPackageJsonFiles;

        public MyRunProfileState(@NotNull Project project, @NotNull VirtualFile packageJson, @NotNull NpmCommand npmCommand, @NotNull List<VirtualFile> enqueuedPackageJsonFiles) {
            if (project == null) {
                MyRunProfileState.$$$reportNull$$$0(0);
            }
            if (packageJson == null) {
                MyRunProfileState.$$$reportNull$$$0(1);
            }
            if (npmCommand == null) {
                MyRunProfileState.$$$reportNull$$$0(2);
            }
            if (enqueuedPackageJsonFiles == null) {
                MyRunProfileState.$$$reportNull$$$0(3);
            }
            this.myProject = project;
            this.myPackageJson = packageJson;
            this.myNpmCommand = npmCommand;
            this.myEnqueuedPackageJsonFiles = enqueuedPackageJsonFiles;
        }

        @Nullable
        public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
            VirtualFile dir;
            if (runner == null) {
                MyRunProfileState.$$$reportNull$$$0(4);
            }
            if ((dir = this.myPackageJson.getParent()) == null) {
                throw new ExecutionException("Cannot determine package.json directory");
            }
            TextConsoleBuilder consoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(this.myProject);
            consoleBuilder.addFilter((Filter)new NodeStackTraceFilter(this.myProject, dir));
            NodeJsLocalInterpreter localInterpreter = InstallNodeLocalDependenciesAction.getProjectLocalInterpreter(this.myProject, ContainerUtil.concat(Collections.singletonList(this.myPackageJson), this.myEnqueuedPackageJsonFiles));
            final Runnable done = PackageJsonDependenciesExternalUpdateManager.getInstance(this.myProject).externalUpdateStarted(this.myPackageJson, null);
            GeneralCommandLine commandLine = MyRunProfileState.createCommandLine(this.myProject, dir, localInterpreter, this.myNpmCommand);
            KillableColoredProcessHandler processHandler = new KillableColoredProcessHandler(commandLine, true);
            ProcessTerminatedListener.attach((ProcessHandler)processHandler);
            ConsoleView console = consoleBuilder.getConsole();
            console.attachToProcess((ProcessHandler)processHandler);
            ConsoleProgress.install(console, (ProcessHandler)processHandler);
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    done.run();
                    if (event.getExitCode() == 0) {
                        new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)myProject).addRequest(() -> InstallNodeLocalDependenciesAction.runAndShowConsole(myProject, myEnqueuedPackageJsonFiles), 2000);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$MyRunProfileState$1", "processTerminated"));
                }
            });
            return new DefaultExecutionResult((ExecutionConsole)console, (ProcessHandler)processHandler);
        }

        @NotNull
        private static GeneralCommandLine createCommandLine(@NotNull Project project, @NotNull VirtualFile workingDir, @NotNull NodeJsLocalInterpreter localInterpreter, @NotNull NpmCommand npmCommand) throws ExecutionException {
            if (project == null) {
                MyRunProfileState.$$$reportNull$$$0(5);
            }
            if (workingDir == null) {
                MyRunProfileState.$$$reportNull$$$0(6);
            }
            if (localInterpreter == null) {
                MyRunProfileState.$$$reportNull$$$0(7);
            }
            if (npmCommand == null) {
                MyRunProfileState.$$$reportNull$$$0(8);
            }
            GeneralCommandLine commandLine = new GeneralCommandLine();
            commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
            NodeCommandLineUtil.configureUsefulEnvironment(commandLine);
            commandLine.setWorkDirectory(workingDir.getPath());
            commandLine.setCharset(CharsetToolkit.UTF8_CHARSET);
            commandLine.setExePath(localInterpreter.getInterpreterSystemDependentPath());
            String cliJsFilePath = localInterpreter.getValidNpmCliJsFilePath(project);
            commandLine.addParameter(cliJsFilePath);
            commandLine.addParameter(npmCommand.getCliOption(localInterpreter.isYarnAlikePackage()));
            if (!localInterpreter.isYarnAlikePackage()) {
                commandLine.addParameter("--scripts-prepend-node-path=auto");
            }
            GeneralCommandLine generalCommandLine = commandLine;
            if (generalCommandLine == null) {
                MyRunProfileState.$$$reportNull$$$0(9);
            }
            return generalCommandLine;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageJson";
                    break;
                }
                case 2: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "npmCommand";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enqueuedPackageJsonFiles";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runner";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "workingDir";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localInterpreter";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$MyRunProfileState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$MyRunProfileState";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCommandLine";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createCommandLine";
                    break;
                }
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

