/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryManager;
import com.intellij.lang.ecmascript6.completion.ES6ImportExportSpecifierCompletionProvider;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathBuilder;
import com.intellij.lang.ecmascript6.psi.impl.JSModuleImportPathBuilder;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.modules.JSModuleFixDescriptor;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.modules.ModuleFixCreator;
import com.intellij.lang.javascript.modules.ModuleReferenceInfo;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJSModulesSearcher {
    @NotNull
    private final VirtualFile myModuleRoot;
    @NotNull
    private final ModuleFixCreator myModuleFixCreator;
    @NotNull
    private final ModuleReferenceInfo myModuleReferenceInfo;
    @NotNull
    private final PsiElement myNode;
    @NotNull
    private final ResolveResult[] myResolveResults;
    private final boolean myOnlyCommonJs;

    public NodeJSModulesSearcher(@NotNull VirtualFile moduleRoot, @NotNull ModuleReferenceInfo info, @NotNull PsiElement node, @NotNull ResolveResult[] results, @NotNull Set<VirtualFile> predefinedFiles, boolean onlyCommonJs) {
        if (moduleRoot == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(0);
        }
        if (info == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(1);
        }
        if (node == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(2);
        }
        if (results == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(3);
        }
        if (predefinedFiles == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(4);
        }
        this.myModuleReferenceInfo = info;
        this.myNode = node;
        this.myResolveResults = results;
        this.myModuleRoot = moduleRoot;
        this.myOnlyCommonJs = onlyCommonJs;
        this.myModuleFixCreator = new ModuleFixCreator(predefinedFiles, this.myModuleReferenceInfo);
    }

    public List<JSModuleFixDescriptor> find() {
        if (this.hasGlobalResolvedElement()) {
            return Collections.emptyList();
        }
        this.fillHardcodedVariants();
        if (this.myModuleReferenceInfo.getParentName() != null) {
            if (!this.findVariantsForMethods(this.myModuleReferenceInfo)) {
                return this.myModuleFixCreator.getFixDescriptors();
            }
        } else {
            String referenceName = this.myModuleReferenceInfo.getContextName();
            if (referenceName != null) {
                VirtualFile byName;
                VirtualFile coreModule = NodeJsCoreLibraryManager.getInstance(this.myNode.getProject()).findCoreModuleFileByName(referenceName);
                if (coreModule != null) {
                    this.myModuleFixCreator.addFix(new JSModuleFixDescriptor(ModuleFixCreator.ModuleType.nodejs, coreModule.getNameWithoutExtension(), coreModule, referenceName, null));
                    return this.myModuleFixCreator.getFixDescriptors();
                }
                this.findMatchingExports(referenceName);
                if (!this.myOnlyCommonJs && this.myModuleFixCreator.isEmpty()) {
                    this.findCandidatesFromImportedFiles(referenceName);
                }
                if (this.myModuleFixCreator.isEmpty() && (byName = NodeModuleUtil.getProjectChildModuleByName(this.myNode.getProject(), this.myModuleRoot, referenceName)) != null && byName.getNameWithoutExtension().equals(referenceName)) {
                    this.myModuleFixCreator.addFix(new JSModuleFixDescriptor(ModuleFixCreator.ModuleType.nodejs, referenceName, byName, referenceName, null));
                    return this.myModuleFixCreator.getFixDescriptors();
                }
            }
        }
        this.myModuleFixCreator.addShortModules();
        return this.myModuleFixCreator.getFixDescriptors();
    }

    public boolean hasGlobalResolvedElement() {
        for (ResolveResult result : this.myResolveResults) {
            PsiElement element = result.getElement();
            if (element == null || !this.myModuleFixCreator.isGlobalPredefinedElement(element)) continue;
            return true;
        }
        return false;
    }

    private void fillHardcodedVariants() {
        ResolvedModuleInfo info;
        String referenceName = this.myModuleReferenceInfo.getContextName();
        if (!"React".equals(referenceName)) {
            return;
        }
        VirtualFile byName = NodeModuleUtil.getProjectChildModuleByName(this.myNode.getProject(), this.myModuleRoot, "react");
        if (byName != null && byName.isDirectory() && (info = NodeModuleDirectorySearchProcessor.PROCESSOR.loadDirectory(this.myModuleRoot, byName, ModuleType.NODE_MODULES_DIR, true)) != null) {
            VirtualFile moduleFile = info.getModuleMainFile();
            this.myModuleFixCreator.addFix(new JSModuleFixDescriptor(ModuleFixCreator.ModuleType.nodejs, "react", moduleFile, "React", null));
        }
    }

    private void findCandidatesFromImportedFiles(String referenceName) {
        PsiFile file = this.myNode.getContainingFile();
        if (!(file instanceof JSFile)) {
            return;
        }
        Collection<ES6ImportDeclaration> imports = NodeJSModulesSearcher.findImportsInFile(file);
        HashSet<JSFile> filesFromImport = new HashSet<JSFile>();
        for (ES6ImportDeclaration anImport : imports) {
            PsiFile psiFile;
            ES6FromClause fromClause = anImport.getFromClause();
            if (fromClause == null) continue;
            Collection elements = fromClause.resolveReferencedElements();
            if ((elements = ContainerUtil.filter((Collection)elements, element -> element != null && element.isValid())).size() != 1 || !((psiFile = ((PsiElement)elements.iterator().next()).getContainingFile()) instanceof JSFile)) continue;
            filesFromImport.add((JSFile)psiFile);
        }
        for (JSFile jsFile : filesFromImport) {
            QualifiedItemProcessor<?> es6processor = ES6ImportExportSpecifierCompletionProvider.createCompletionProcessor((PsiFile)jsFile);
            ES6PsiUtil.processExportDeclarationInScope((JSElement)jsFile, es6processor, ResolveState.initial(), (PsiElement)jsFile);
            List<PsiElement> es6processorResults = es6processor.getResults();
            if (es6processorResults == null) continue;
            for (PsiElement result : es6processorResults) {
                if (!result.isValid() || !(result instanceof JSElementBase) || ((JSElementBase)result).getNamespace() != null || !referenceName.equals(((JSNamedElementBase)result).getName())) continue;
                this.processPossibleMatch(result, true);
            }
        }
    }

    private static Collection<ES6ImportDeclaration> findImportsInFile(PsiFile file) {
        return ES6ImportPsiUtil.getImportDeclarations((PsiElement)file);
    }

    private void findMatchingExports(String referenceName) {
        PsiFile file;
        for (ResolveResult result : this.myResolveResults) {
            PsiElement element;
            if (!result.isValidResult() && !"javascript.element.need.to.be.imported".equals(((JSResolveResult)result).getResolveProblemKey()) || (element = result.getElement()) == null) continue;
            this.processPossibleMatch(element, true);
        }
        if (this.myModuleReferenceInfo.processFromIndex()) {
            this.searchWithStubIndex(this.myModuleReferenceInfo.getContextName(), this.myNode.getProject(), true);
        }
        if ((file = this.myNode.getContainingFile()) instanceof JSFile && DialectDetector.isES6((PsiElement)file)) {
            ArrayList<PsiFile> filesList = new ArrayList<PsiFile>();
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myNode.getProject());
            filesList.addAll(Arrays.asList(FilenameIndex.getFilesByName((Project)this.myNode.getProject(), (String)(referenceName + ".js"), (GlobalSearchScope)scope)));
            filesList.addAll(Arrays.asList(FilenameIndex.getFilesByName((Project)this.myNode.getProject(), (String)(referenceName + ".jsx"), (GlobalSearchScope)scope)));
            filesList.addAll(Arrays.asList(FilenameIndex.getFilesByName((Project)this.myNode.getProject(), (String)(referenceName + ".ts"), (GlobalSearchScope)scope)));
            for (PsiFile psiFile : filesList) {
                JSModuleFixDescriptor descriptor2;
                JSElement export;
                if (!(psiFile instanceof JSFile) || (export = ES6PsiUtil.findDefaultExport((PsiElement)psiFile)) == null || (descriptor2 = this.addFixFromFile(null, psiFile, null, ModuleFixCreator.ModuleType.es6)) == null) continue;
                descriptor2.setDefaultExport(true);
            }
        }
    }

    private void searchWithStubIndex(String referenceName, Project project, boolean withoutModuleWord) {
        ArrayList elementsToProcess = new ArrayList();
        StubIndex.getInstance().processElements(JSSymbolIndex2.KEY, (Object)referenceName, project, GlobalSearchScope.allScope((Project)project), JSElement.class, Processors.cancelableCollectProcessor(elementsToProcess));
        for (JSElement element : elementsToProcess) {
            this.processPossibleMatch((PsiElement)element, withoutModuleWord);
        }
    }

    private void processPossibleMatch(@NotNull PsiElement element, boolean withoutModuleWord) {
        String aliasText;
        if (element == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(5);
        }
        PsiFile file = element.getContainingFile();
        if (!(element.isValid() && file.isValid() && file instanceof JSFile)) {
            return;
        }
        if (!(element instanceof JSQualifiedNamedElement)) {
            return;
        }
        JSQualifiedName elementNamespace = ((JSQualifiedNamedElement)element).getNamespace();
        if (!this.myModuleReferenceInfo.isAcceptable(element)) {
            return;
        }
        JSFile jsFile = (JSFile)file;
        String string = aliasText = jsFile.getExportsInnerAlias() == null ? null : jsFile.getExportsInnerAlias().getTypeText();
        if (elementNamespace != null) {
            String exportName;
            JSModuleFixDescriptor descriptor2;
            boolean isAlias = elementNamespace.getName().equals(aliasText);
            if ((NodeJSModulesSearcher.isExports(elementNamespace.getName()) || isAlias) && (descriptor2 = this.addFixFromFile(element, (PsiFile)jsFile, exportName = withoutModuleWord ? ((JSQualifiedNamedElement)element).getName() : null, ModuleFixCreator.ModuleType.nodejs)) != null) {
                if (withoutModuleWord) {
                    descriptor2.moduleElementIsMissing();
                }
                if (ES6ImportPsiUtil.isFlowTypeDefinition(element)) {
                    descriptor2.setIsFlowType(true);
                }
                return;
            }
        }
        if (!DialectDetector.isES6((PsiElement)file)) {
            return;
        }
        this.resolveFromContextExports((JSQualifiedNamedElement)element, withoutModuleWord, jsFile);
    }

    private void resolveFromContextExports(@NotNull JSQualifiedNamedElement element, boolean withoutModuleWord, JSFile jsFile) {
        if (element == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(6);
        }
        String nameInExports = withoutModuleWord ? element.getName() : null;
        ContextInfo contextStatement = null;
        if (element.isExported() || (contextStatement = new ContextInfo(element)).isExported()) {
            JSQualifiedNamedElement importedElement;
            JSModuleFixDescriptor descriptor2;
            if (!element.isExported() && contextStatement != null && contextStatement.getExportedName() != null) {
                nameInExports = contextStatement.getExportedName();
            }
            if ((descriptor2 = this.addFixFromFile((PsiElement)(importedElement = contextStatement != null ? contextStatement.myContextElement : element), (PsiFile)jsFile, nameInExports, ModuleFixCreator.ModuleType.es6)) != null) {
                descriptor2.setDefaultExport(contextStatement != null && contextStatement.myIsDefaultExported);
                descriptor2.setIsFlowType(ES6ImportPsiUtil.isFlowTypeDefinition((PsiElement)importedElement));
            }
        }
    }

    private static boolean isExports(String text) {
        return "exports".equals(text) || "module.exports".equals(text);
    }

    private boolean findVariantsForMethods(@NotNull ModuleReferenceInfo moduleReferenceInfo) {
        if (moduleReferenceInfo == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(7);
        }
        Collection<PsiElement> results = this.myModuleReferenceInfo.getResolvedParent();
        for (PsiElement resolveResult : results) {
            this.processPossibleMatch(resolveResult, false);
        }
        if (moduleReferenceInfo.getParentName() != null) {
            this.searchWithStubIndex(this.myModuleReferenceInfo.getParentName(), this.myNode.getProject(), false);
        }
        return true;
    }

    private JSModuleFixDescriptor addFixFromFile(@Nullable PsiElement importedElement, @NotNull PsiFile targetPsiFile, @Nullable String nameInExports, @NotNull ModuleFixCreator.ModuleType moduleType) {
        VirtualFile targetFile;
        VirtualFile file;
        if (targetPsiFile == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(8);
        }
        if (moduleType == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(9);
        }
        if ((file = this.myNode.getContainingFile().getVirtualFile()).equals(targetFile = targetPsiFile.getVirtualFile())) {
            return null;
        }
        if (!NodeModuleUtil.checkNodeModulesAssociation(targetPsiFile, this.myOnlyCommonJs) && !NodeJSModulesSearcher.isCoreModuleFile(this.myNode, targetFile)) {
            return null;
        }
        JSModuleNameInfo info = NodeJSModulesSearcher.getModuleInfo(this.myNode, this.myModuleRoot, importedElement, targetPsiFile);
        JSModuleFixDescriptor descriptor2 = NodeJSModulesSearcher.createFixDescriptionFromFile(info, moduleType, this.myModuleReferenceInfo.getContextName(), nameInExports);
        if (descriptor2 != null) {
            this.myModuleFixCreator.addFix(descriptor2);
        }
        return this.myModuleFixCreator.isNoFixesShouldBeSuggested() ? null : descriptor2;
    }

    public static JSModuleFixDescriptor createFixDescriptionFromFile(@Nullable JSModuleNameInfo info, @NotNull ModuleFixCreator.ModuleType moduleType, @Nullable String refName, @Nullable String nameInExports) {
        if (moduleType == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(10);
        }
        if (info == null) {
            return null;
        }
        VirtualFile module = info.getModule();
        if (module == null || refName == null) {
            return null;
        }
        return new JSModuleFixDescriptor(moduleType, info.getModuleName(), module, refName, nameInExports);
    }

    @Nullable
    public static JSModuleNameInfo getModuleInfo(@NotNull PsiElement place, @NotNull VirtualFile moduleRoot, @Nullable PsiElement importedElement, @NotNull PsiFile targetPsiFile) {
        if (place == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(11);
        }
        if (moduleRoot == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(12);
        }
        if (targetPsiFile == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(13);
        }
        VirtualFile targetFile = targetPsiFile.getVirtualFile();
        JSImportPathBuilder builder = DialectDetector.isTypeScript((PsiElement)targetPsiFile) ? JSImportPathBuilder.createBuilder(place, importedElement, targetFile) : new JSModuleImportPathBuilder(place, importedElement, targetFile, moduleRoot);
        return ES6CreateImportUtil.getExternalFileModuleName(builder);
    }

    public static boolean isCoreModuleFile(@NotNull PsiElement place, @NotNull VirtualFile targetFile) {
        if (place == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(14);
        }
        if (targetFile == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(15);
        }
        return NodeJsCoreLibraryManager.getInstance(place.getProject()).isCoreModuleLibraryFile(targetFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRoot";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedFiles";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleReferenceInfo";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPsiFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/modules/NodeJSModulesSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processPossibleMatch";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveFromContextExports";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findVariantsForMethods";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addFixFromFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "createFixDescriptionFromFile";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getModuleInfo";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "isCoreModuleFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ContextInfo {
        private boolean myIsExported;
        private boolean myIsDefaultExported;
        private PsiElement myContextElement;
        private String myExportedName;

        public ContextInfo(@NotNull JSQualifiedNamedElement element) {
            JSQualifiedNamedElement current;
            if (element == null) {
                ContextInfo.$$$reportNull$$$0(0);
            }
            for (current = element; !(current instanceof JSStatement) && !(current instanceof JSFile) && current != null; current = current.getContext()) {
                if (this.myIsExported || !(current instanceof JSElementBase) || !(current instanceof JSNamedElement)) continue;
                JSElementBase elementBase = (JSElementBase)current;
                boolean directlyExported = elementBase.isExported();
                this.myIsDefaultExported = elementBase.isExportedWithDefault();
                if (!directlyExported && !this.myIsDefaultExported) continue;
                this.myExportedName = ((JSNamedElement)current).getName();
                this.myIsExported = true;
            }
            this.myContextElement = current;
            if (this.myContextElement instanceof ES6ExportDefaultAssignment) {
                this.myExportedName = ((ES6ExportDefaultAssignment)this.myContextElement).getInitializerReference();
                this.myIsExported = true;
                this.myIsDefaultExported = true;
            }
        }

        public boolean isExported() {
            return this.myIsExported;
        }

        public PsiElement getContextElement() {
            return this.myContextElement;
        }

        public String getExportedName() {
            return this.myExportedName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher$ContextInfo", "<init>"));
        }
    }
}

