/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.buildTools.webpack.WebPackConfigManager;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.InstallNodeModuleAddToDependenciesQuickFix;
import com.intellij.lang.javascript.modules.InstallNodeModuleAddToDevDependenciesQuickFix;
import com.intellij.lang.javascript.modules.InstallNodeModuleQuickFix;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.RecordModuleIntoDepPackageJsonQuickFix;
import com.intellij.lang.javascript.modules.RecordModuleIntoDevPackageJsonQuickFix;
import com.intellij.lang.javascript.modules.RunNpmUpdateQuickFix;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmUsedModulesInstalledInspection
extends JSInspection {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.modules.NpmUsedModulesInstalledInspection");
    public static final String[] NODE_MODULES = new String[]{"node_modules"};

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, final LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitES6FromClause(ES6FromClause fromClause) {
                if (!DialectDetector.isJavaScript((PsiElement)fromClause)) {
                    return;
                }
                Convertor resolver = moduleRoot -> {
                    PsiReference[] references;
                    for (PsiReference reference : references = fromClause.getReferences()) {
                        PsiElement resolve = reference.resolve();
                        if (resolve == null || !resolve.isValid() || resolve.getContainingFile() == null) continue;
                        return resolve.getContainingFile().getVirtualFile();
                    }
                    return null;
                };
                NpmUsedModulesInstalledInspection.this.check((PsiElement)fromClause, fromClause.getReferenceText(), holder, (Convertor<VirtualFile, VirtualFile>)resolver, (Getter<InstallNodeModuleQuickFix.ModuleElement<? extends JSElement>>)() -> new InstallNodeModuleQuickFix.ES6FromClauseModuleElement(fromClause));
            }

            public void visitJSCallExpression(JSCallExpression call) {
                if (!DialectDetector.isJavaScript((PsiElement)call.getContainingFile())) {
                    return;
                }
                Project project = session.getFile().getProject();
                if (!call.isRequireCall()) {
                    return;
                }
                if (!NodeJsCoreLibraryManager.isAssociatedWithNodeCoreLibrary(session.getFile())) {
                    return;
                }
                JSExpression argument = call.getArguments()[0];
                if (argument instanceof JSLiteralExpression) {
                    LOG.debug("Module " + argument.getText() + " does not have a reference");
                    String referenceText = StringUtil.unquoteString((String)argument.getText());
                    Convertor resolver = moduleRoot -> {
                        String[] split;
                        ResolveResult[] resolve;
                        JSModuleBaseReference reference = this.getNodeModuleReference(argument);
                        if (reference == null) {
                            return null;
                        }
                        Object list = reference instanceof PsiPolyVariantReference ? ((PsiPolyVariantReference)reference).multiResolve(false) : ((resolve = ((PsiReference)reference).resolve()) != null ? new ResolveResult[]{new PsiElementResolveResult((PsiElement)resolve)} : null);
                        if (list != null) {
                            for (ResolveResult result : list) {
                                PsiFileSystemItem psiFile;
                                if (result == null || !result.isValidResult() || result.getElement() == null || !result.getElement().isValid()) continue;
                                PsiElement resolve2 = result.getElement();
                                Object object = psiFile = resolve2 instanceof PsiFileSystemItem ? (PsiFileSystemItem)resolve2 : resolve2.getContainingFile();
                                if (psiFile.isDirectory() || !DialectDetector.JAVASCRIPT_FILE_TYPES.contains(psiFile.getVirtualFile().getFileType()) && !TypeScriptUtil.isDefinitionFile(psiFile.getVirtualFile()) || !(psiFile instanceof PsiFile) || !NodeModuleUtil.checkNodeModulesAssociation((PsiFile)psiFile, true) || NodeModuleUtil.getRequireModuleInfo(project, moduleRoot, psiFile.getVirtualFile()) == null) continue;
                                return psiFile.getVirtualFile();
                            }
                        }
                        String name = (split = referenceText.replace("\\", "/").split("/")).length == 0 ? referenceText : split[0];
                        VirtualFile nm = moduleRoot.findChild("node_modules");
                        if (nm != null) {
                            return nm.findChild(name);
                        }
                        return null;
                    };
                    NpmUsedModulesInstalledInspection.this.check((PsiElement)argument, referenceText, holder, (Convertor<VirtualFile, VirtualFile>)resolver, (Getter<InstallNodeModuleQuickFix.ModuleElement<? extends JSElement>>)() -> new InstallNodeModuleQuickFix.RequireModuleElement((JSLiteralExpression)argument));
                }
            }

            private JSModuleBaseReference getNodeModuleReference(JSExpression argument) {
                PsiReference[] references;
                for (PsiReference reference : references = argument.getReferences()) {
                    if (!(reference instanceof JSModuleBaseReference)) continue;
                    return (JSModuleBaseReference)reference;
                }
                return null;
            }
        };
        if (jSElementVisitor == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(0);
        }
        return jSElementVisitor;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Check require() reference" == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(1);
        }
        return "Check require() reference";
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(2);
        }
        return highlightDisplayLevel;
    }

    private void check(@Nullable PsiElement element, @Nullable String referenceText, ProblemsHolder holder, @NotNull Convertor<VirtualFile, VirtualFile> resolver, @NotNull Getter<InstallNodeModuleQuickFix.ModuleElement<? extends JSElement>> pointerCreator) {
        ASTNode[] children;
        PsiElement elementToHoldFix;
        if (resolver == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(3);
        }
        if (pointerCreator == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(4);
        }
        if (referenceText == null || element == null) {
            return;
        }
        String moduleName = NpmUsedModulesInstalledInspection.getModuleName(referenceText = referenceText.trim());
        if (NpmUsedModulesInstalledInspection.notInstallableModuleName(moduleName)) {
            return;
        }
        Project project = element.getProject();
        if (NpmUsedModulesInstalledInspection.isAliasedModule(moduleName, project)) {
            return;
        }
        if (NodeJsCoreLibraryManager.isCoreModuleName(moduleName)) {
            return;
        }
        VirtualFile coreModule = NodeJsCoreLibraryManager.getInstance(project).findCoreModuleFileByName(moduleName);
        if (coreModule != null) {
            return;
        }
        if (PackageJsonDependenciesExternalUpdateManager.getInstance(project).isExternalUpdateRunning(moduleName)) {
            return;
        }
        Collection packageJsonFiles = FilenameIndex.getVirtualFilesByName((Project)project, (String)"package.json", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
        packageJsonFiles = ContainerUtil.filter((Collection)packageJsonFiles, file -> !JSLibraryUtil.isProbableLibraryFile(file));
        boolean inPackageJson = false;
        InstallationDetector installationDetector = new InstallationDetector(project, resolver);
        if (!packageJsonFiles.isEmpty()) {
            for (VirtualFile packageJsonFile : packageJsonFiles) {
                VirtualFile moduleRoot = packageJsonFile.getParent();
                if (moduleRoot == null || !packageJsonFile.isValid()) continue;
                boolean notInPackageJson = NpmUsedModulesInstalledInspection.moduleNotInPackageJson(moduleName, packageJsonFile);
                if (!notInPackageJson) {
                    inPackageJson = true;
                }
                installationDetector.accept(moduleRoot);
                if (!inPackageJson || !installationDetector.isInstalledMaybeMultiple()) continue;
                return;
            }
        }
        if (!installationDetector.isInstalledMaybeMultiple() && packageJsonFiles.isEmpty()) {
            installationDetector.accept(project.getBaseDir());
        }
        if ((elementToHoldFix = element) instanceof ES6FromClause && (children = elementToHoldFix.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.STRING_LITERAL}))).length == 1) {
            elementToHoldFix = children[0].getPsi();
        }
        InstallNodeModuleQuickFix.ModuleElement moduleElement = (InstallNodeModuleQuickFix.ModuleElement)pointerCreator.get();
        if (installationDetector.isInstalledMaybeMultiple()) {
            if (!inPackageJson && installationDetector.isLibraryResolveOnly()) {
                holder.registerProblem(elementToHoldFix, JSBundle.message((String)"npm.modules.inspection.content.of.require.not.in.dependencies.warning", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RecordModuleIntoDepPackageJsonQuickFix(moduleElement, packageJsonFiles, installationDetector.getNodeModules()), new RecordModuleIntoDevPackageJsonQuickFix(moduleElement, packageJsonFiles, installationDetector.getNodeModules())});
            }
        } else {
            ArrayList<InstallNodeModuleQuickFix> fixes = new ArrayList<InstallNodeModuleQuickFix>();
            if (!inPackageJson) {
                fixes.add(new InstallNodeModuleAddToDependenciesQuickFix(moduleElement, packageJsonFiles));
                fixes.add(new InstallNodeModuleAddToDevDependenciesQuickFix(moduleElement, packageJsonFiles));
            }
            fixes.add(new InstallNodeModuleQuickFix(moduleElement, packageJsonFiles));
            if (!packageJsonFiles.isEmpty()) {
                fixes.add(new RunNpmUpdateQuickFix(moduleElement, packageJsonFiles));
            }
            holder.registerProblem(elementToHoldFix, JSBundle.message((String)"npm.modules.inspection.content.of.require.module.not.installed.warning", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes.toArray(new LocalQuickFix[fixes.size()]));
        }
    }

    private static boolean isAliasedModule(String moduleName, Project project) {
        Map<String, String> alias = WebPackConfigManager.Companion.instance(project).config().getResolve().getAlias();
        return alias.containsKey(moduleName) || alias.containsKey(moduleName + "$");
    }

    @NotNull
    public static String getModuleName(@NotNull String text) {
        String path;
        if (text == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(5);
        }
        if (NpmUsedModulesInstalledInspection.startWithLocalPrefix(path = StringUtil.unquoteString((String)text))) {
            String string = path;
            if (string == null) {
                NpmUsedModulesInstalledInspection.$$$reportNull$$$0(6);
            }
            return string;
        }
        String[] strings = path.split("/");
        if (strings.length > 1) {
            if (strings[0].startsWith("@")) {
                String string = strings[0] + "/" + strings[1];
                if (string == null) {
                    NpmUsedModulesInstalledInspection.$$$reportNull$$$0(7);
                }
                return string;
            }
            String string = strings[0];
            if (string == null) {
                NpmUsedModulesInstalledInspection.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = strings.length == 0 ? "" : strings[0];
        if (string == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static boolean startWithLocalPrefix(@NotNull String text) {
        if (text == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(10);
        }
        return text.startsWith("./") || text.startsWith("../");
    }

    public static boolean notInstallableModuleName(@NotNull String moduleName) {
        if (moduleName == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(11);
        }
        if (NpmUsedModulesInstalledInspection.startWithLocalPrefix(moduleName)) {
            return true;
        }
        if (StringUtil.isEmptyOrSpaces((String)moduleName)) {
            return true;
        }
        boolean haveNamePartInWord = false;
        for (int i = 0; i < moduleName.length(); ++i) {
            char ch = moduleName.charAt(i);
            if (ch == '@' && i > 0) {
                return true;
            }
            boolean namePart = Character.isLetterOrDigit(ch) || ch == '_' || ch == '-' || ch == '@';
            haveNamePartInWord |= namePart;
            if (namePart || ch == '.' || ch == '/') continue;
            return true;
        }
        return !haveNamePartInWord;
    }

    public static boolean moduleNotInPackageJson(@NotNull String name, @NotNull VirtualFile packageJsonFile) {
        PackageJsonData data;
        if (name == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(12);
        }
        if (packageJsonFile == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(13);
        }
        return !(data = PackageJsonData.getOrCreate(packageJsonFile)).isDependencyOfAnyType(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointerCreator";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "check";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getModuleName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "startWithLocalPrefix";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "notInstallableModuleName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "moduleNotInPackageJson";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InstallationDetector {
        private boolean myIsLibraryResolveOnly;
        private boolean myMultipleInstallations;
        private VirtualFile myNodeModules;
        @NotNull
        private final Project myProject;
        @NotNull
        private final Convertor<VirtualFile, VirtualFile> myResolver;

        public InstallationDetector(@NotNull Project project, @NotNull Convertor<VirtualFile, VirtualFile> resolver) {
            if (project == null) {
                InstallationDetector.$$$reportNull$$$0(0);
            }
            if (resolver == null) {
                InstallationDetector.$$$reportNull$$$0(1);
            }
            this.myIsLibraryResolveOnly = true;
            this.myProject = project;
            this.myResolver = resolver;
        }

        public void accept(@NotNull VirtualFile packageJsonParent) {
            VirtualFile resolveFile;
            if (packageJsonParent == null) {
                InstallationDetector.$$$reportNull$$$0(2);
            }
            if ((resolveFile = (VirtualFile)this.myResolver.convert((Object)packageJsonParent)) != null) {
                this.myIsLibraryResolveOnly &= JSLibraryUtil.hasDirectoryInPath(resolveFile, NODE_MODULES, NodeModuleUtil.findParentContentRoot(this.myProject, resolveFile));
                VirtualFile folder = JSLibraryUtil.getTopLibraryFolder(resolveFile, NODE_MODULES[0], null);
                if (folder != null) {
                    if (!this.myMultipleInstallations && this.myNodeModules == null) {
                        this.myNodeModules = folder.getParent();
                    } else {
                        this.myMultipleInstallations = true;
                        this.myNodeModules = null;
                    }
                }
            }
        }

        public boolean isLibraryResolveOnly() {
            return this.myIsLibraryResolveOnly;
        }

        public boolean isInstalledMaybeMultiple() {
            return this.myNodeModules != null || this.myMultipleInstallations;
        }

        public boolean isInstalled() {
            return this.myNodeModules != null;
        }

        public boolean isMultipleInstallations() {
            return this.myMultipleInstallations;
        }

        public VirtualFile getNodeModules() {
            return this.myNodeModules;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolver";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageJsonParent";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection$InstallationDetector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

