/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSExpressionImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JSConditionalExpressionImpl
extends JSExpressionImpl
implements JSConditionalExpression {
    public JSConditionalExpressionImpl(IElementType elementType) {
        super(elementType);
    }

    public JSExpression getCondition() {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType type = child.getElementType();
            if (type == JSTokenTypes.QUEST) {
                return null;
            }
            if (!JSExtendedLanguagesTokenSetProvider.EXPRESSIONS.contains(type)) continue;
            return (JSExpression)child.getPsi();
        }
        return null;
    }

    public JSExpression getThen() {
        boolean questPassed = false;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType type = child.getElementType();
            if (type == JSTokenTypes.QUEST) {
                questPassed = true;
            }
            if (type == JSTokenTypes.COLON) {
                return null;
            }
            if (!questPassed || !JSExtendedLanguagesTokenSetProvider.EXPRESSIONS.contains(type)) continue;
            return (JSExpression)child.getPsi();
        }
        return null;
    }

    public JSExpression getElse() {
        boolean questPassed = false;
        boolean colonPassed = false;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType type = child.getElementType();
            if (type == JSTokenTypes.QUEST) {
                questPassed = true;
            }
            if (type == JSTokenTypes.COLON) {
                colonPassed = true;
            }
            if (!questPassed || !colonPassed || !JSExtendedLanguagesTokenSetProvider.EXPRESSIONS.contains(type)) continue;
            return (JSExpression)child.getPsi();
        }
        return null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSConditionalExpressionImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSConditionalExpression((JSConditionalExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSConditionalExpressionImpl", "accept"));
    }
}

