/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.JSStatementImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JSForInStatementImpl
extends JSStatementImpl
implements JSForInStatement {
    public JSForInStatementImpl(IElementType elementType) {
        super(elementType);
    }

    public JSVarStatement getDeclarationStatement() {
        ASTNode childNode = this.getNode().findChildByType((IElementType)JSElementTypes.VAR_STATEMENT);
        return childNode == null ? null : (JSVarStatement)childNode.getPsi();
    }

    public JSExpression getVariableExpression() {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == JSTokenTypes.IN_KEYWORD) {
                return null;
            }
            if (!JSExtendedLanguagesTokenSetProvider.EXPRESSIONS.contains(child.getElementType())) continue;
            return (JSExpression)child.getPsi();
        }
        return null;
    }

    public JSExpression getCollectionExpression() {
        boolean inPassed = false;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == JSTokenTypes.IN_KEYWORD || child.getElementType() == JSTokenTypes.OF_KEYWORD) {
                inPassed = true;
            }
            if (!inPassed || !JSExtendedLanguagesTokenSetProvider.EXPRESSIONS.contains(child.getElementType())) continue;
            return (JSExpression)child.getPsi();
        }
        return null;
    }

    public boolean isForEach() {
        return this.getNode().findChildByType(JSTokenTypes.EACH_KEYWORD) != null || this.getNode().findChildByType(JSTokenTypes.OF_KEYWORD) != null;
    }

    public JSStatement getBody() {
        boolean passedRParen = false;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == JSTokenTypes.RPAR) {
                passedRParen = true;
                continue;
            }
            if (!passedRParen || !JSExtendedLanguagesTokenSetProvider.STATEMENTS.contains(child.getElementType())) continue;
            return (JSStatement)child.getPsi();
        }
        return null;
    }

    public JSExpression getCondition() {
        return null;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            JSForInStatementImpl.$$$reportNull$$$0(0);
        }
        if (state == null) {
            JSForInStatementImpl.$$$reportNull$$$0(1);
        }
        if (place == null) {
            JSForInStatementImpl.$$$reportNull$$$0(2);
        }
        if (lastParent != null) {
            JSVarStatement statement = this.getDeclarationStatement();
            if (statement != null) {
                return statement.processDeclarations(processor, state, lastParent, place);
            }
            JSExpression expression = this.getVariableExpression();
            if (expression != null && !processor.execute((PsiElement)expression, state)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSForInStatementImpl.$$$reportNull$$$0(3);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSForInStatement((JSForInStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSForInStatementImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processDeclarations";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

