/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageWrapper;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.impl.JSReferenceSetElement;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSReferenceExpressionResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTagContextBuilder;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlToken;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSTextReference
extends JSReferenceSetElement
implements EmptyResolveMessageProvider {
    protected JSTextReference(@NotNull JSReferenceSet set, @NotNull String s, int offset) {
        if (set == null) {
            JSTextReference.$$$reportNull$$$0(0);
        }
        if (s == null) {
            JSTextReference.$$$reportNull$$$0(1);
        }
        this(set, s, new TextRange(offset, offset + s.length()));
    }

    protected JSTextReference(@NotNull JSReferenceSet set, @NotNull String s, @NotNull TextRange rangeInElement) {
        if (set == null) {
            JSTextReference.$$$reportNull$$$0(2);
        }
        if (s == null) {
            JSTextReference.$$$reportNull$$$0(3);
        }
        if (rangeInElement == null) {
            JSTextReference.$$$reportNull$$$0(4);
        }
        super(set, s, rangeInElement);
    }

    public void processToSink(PsiFile containingFile, ResultSink resultSink) {
        MyResolveProcessor processor = this.createResolveProcessor(resultSink.getName(), resultSink.place, resultSink);
        this.doProcess(containingFile, processor);
    }

    protected MyResolveProcessor createResolveProcessor(String name, PsiElement place, ResultSink resultSink) {
        return new MyResolveProcessor(name, place, resultSink);
    }

    @Override
    @NotNull
    public JSQualifiedName getQualifiedName() {
        ArrayList<String> contextNames = null;
        PsiReference prevContextReference = null;
        for (PsiReference ref : this.mySet.myReferences) {
            if (ref == this) break;
            if (contextNames == null) {
                contextNames = new ArrayList<String>(3);
            }
            contextNames.add(ref.getCanonicalText());
            prevContextReference = ref;
        }
        if (contextNames != null) {
            String qName;
            PsiElement psiElement = prevContextReference.resolve();
            if (psiElement instanceof XmlToken) {
                JSTagContextBuilder builder = new JSTagContextBuilder(psiElement, "HTMLElement");
                psiElement = builder.element;
            }
            if (psiElement instanceof JSClass && (qName = ((JSClass)psiElement).getQualifiedName()) != null) {
                contextNames = new ArrayList<String>(3);
                BaseJSSymbolProcessor.addIndexListFromQName(qName, contextNames);
            }
        }
        JSQualifiedName jSQualifiedName = this.qNameFromNames(contextNames);
        if (jSQualifiedName == null) {
            JSTextReference.$$$reportNull$$$0(5);
        }
        return jSQualifiedName;
    }

    @NotNull
    protected JSQualifiedName qNameFromNames(List<String> contextNames) {
        JSQualifiedNameImpl qualifier = contextNames != null ? JSQualifiedNameImpl.fromComponents(contextNames) : null;
        JSQualifiedNameImpl jSQualifiedNameImpl = JSQualifiedNameImpl.create(this.getCanonicalText(), qualifier);
        if (jSQualifiedNameImpl == null) {
            JSTextReference.$$$reportNull$$$0(6);
        }
        return jSQualifiedNameImpl;
    }

    @Override
    @NotNull
    protected ResolveResult[] doResolve() {
        ResolveResult[] resolveResultArray = this.doResolve(this.myCanonicalText);
        if (resolveResultArray == null) {
            JSTextReference.$$$reportNull$$$0(7);
        }
        return resolveResultArray;
    }

    protected final ResolveResult[] doResolve(String text) {
        if ("*".equals(this.myCanonicalText) || "?".equals(this.myCanonicalText)) {
            return new ResolveResult[]{new JSResolveResult(this.mySet.getElement())};
        }
        PsiFile psiFile = this.mySet.element.getContainingFile();
        if (this.useActionScriptIndex(psiFile)) {
            MyResolveProcessor processor = this.createResolveProcessor(text, (PsiElement)psiFile, new ResolveResultSink((PsiElement)psiFile, text));
            this.doProcess(psiFile, processor);
            return processor.getResultsAsResolveResults();
        }
        return JSTextReference.defaultResolve(this, text);
    }

    public boolean useActionScriptIndex(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            JSTextReference.$$$reportNull$$$0(8);
        }
        return DialectDetector.isActionScript((PsiElement)psiFile) || this.mySet.onlyFqns;
    }

    private void doProcess(PsiFile psiFile, SinkResolveProcessor processor) {
        PsiElement nearestClass = this.findNearestClass();
        int index = this.calcMyIndex();
        if (index == 0) {
            if ("this".equals(this.myCanonicalText) && nearestClass instanceof JSClass) {
                processor.addResult(nearestClass);
                return;
            }
            if (this.myRangeInElement.getStartOffset() > 0) {
                if (nearestClass instanceof JSClass && !(this.mySet.element instanceof JSLiteralExpression)) {
                    processor.setToProcessHierarchy(true);
                    processor.setTypeContext(true);
                    processor.configureClassScope((JSClass)nearestClass);
                    if (!nearestClass.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), nearestClass, nearestClass)) {
                        return;
                    }
                }
            } else if (nearestClass instanceof JSClass) {
                processor.setTypeContext(true);
                processor.setToProcessMembers(false);
                if (!nearestClass.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), nearestClass, nearestClass)) {
                    return;
                }
                if (!this.mySet.onlyFqns && this.mySet.element instanceof JSDocTagValue) {
                    String packageName = JSResolveUtil.getPackageName(nearestClass);
                    processor.setForcedPackageName(packageName);
                    String classQName = !packageName.isEmpty() ? packageName + "." + this.myCanonicalText : this.myCanonicalText;
                    PsiElement clazz = JSDialectSpecificHandlersFactory.forElement(nearestClass).getClassResolver().findClassByQName(classQName, nearestClass);
                    if (clazz != null && !clazz.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), clazz, clazz)) {
                        return;
                    }
                }
            }
            PsiElement startFrom = this.mySet.element;
            PsiElement lastParent = this.mySet.element.getParent();
            if (this.mySet.element instanceof JSLiteralExpression) {
                JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)this.mySet.element, JSFunction.class);
                while (fun != null) {
                    startFrom = fun;
                    lastParent = fun.getParent();
                    fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)fun, JSFunction.class);
                }
            }
            JSResolveUtil.treeWalkUp(processor, startFrom, lastParent, this.mySet.element);
            if (!(psiFile instanceof JSFile) && !(psiFile instanceof XmlFile) && psiFile.getContext() == null) {
                JSResolveUtil.processGlobalThings(processor, ResolveState.initial(), (PsiElement)psiFile, (PsiElement)psiFile);
            }
        } else {
            PsiElement psiElement = this.mySet.myReferences[index - 1].resolve();
            if (psiElement instanceof JSOffsetBasedImplicitElement && ((JSOffsetBasedImplicitElement)psiElement).getType() == JSImplicitElement.Type.Tag) {
                psiElement = ((JSOffsetBasedImplicitElement)psiElement).getElementAtOffset();
            }
            if (psiElement instanceof XmlToken) {
                JSTagContextBuilder builder = new JSTagContextBuilder(psiElement, "HTMLElement");
                psiElement = builder.element;
            }
            if (psiElement != null) {
                JSType type = null;
                if (psiElement instanceof JSVariable) {
                    type = ((JSVariable)psiElement).getType();
                } else if (psiElement instanceof JSFunction && ((JSFunction)psiElement).isGetProperty()) {
                    type = ((JSFunction)psiElement).getReturnType();
                }
                if (type != null) {
                    String typeText = type.getTypeText();
                    typeText = JSTypeUtils.getTypeMatchingNamespace(typeText);
                    String qname = JSImportHandlingUtil.resolveTypeName(typeText, psiElement);
                    assert (qname != null);
                    PsiElement typeClass = JSClassResolver.findClassFromNamespace(qname, psiElement);
                    if (typeClass instanceof JSClass) {
                        psiElement = typeClass;
                    }
                }
                if (psiElement instanceof JSClass) {
                    processor.setToProcessHierarchy(true);
                }
                String packageName = null;
                if (psiElement instanceof JSPackageWrapper) {
                    packageName = ((JSPackageWrapper)psiElement).getQualifiedName();
                } else if (psiElement instanceof JSClass) {
                    packageName = JSResolveUtil.getPackageName(psiElement);
                }
                if (packageName != null) {
                    processor.setForcedPackageName(packageName);
                }
                if (psiElement instanceof JSClass) {
                    processor.configureClassScope((JSClass)psiElement);
                    processor.setAllowUnqualifiedStaticsFromInstance(true);
                }
                psiElement.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), psiElement, psiElement);
            }
        }
        if (psiFile instanceof XmlFile && !JavaScriptSupportLoader.isMxmlOrFxgFile(psiFile)) {
            JSResolveUtil.processTopLevelClasses(processor, ResolveState.initial(), psiFile.getProject(), JSResolveUtil.getResolveScope((PsiElement)psiFile), this.mySet.onlyFqns ? JSResolveUtil.GlobalSymbolsAcceptanceState.ACCEPT_ONLY_CLASSES : JSResolveUtil.GlobalSymbolsAcceptanceState.WHATEVER, false);
        }
    }

    private int calcMyIndex() {
        int i;
        for (i = 0; i < this.mySet.myReferences.length && this.mySet.myReferences[i] != this; ++i) {
        }
        return i;
    }

    protected PsiElement findNearestClass() {
        PsiElement originalElement;
        PsiElement parent;
        PsiElement elt = this.mySet.element;
        PsiElement candidateBlock = null;
        while (!((parent = elt.getParent()) instanceof JSFile || parent instanceof JSPackageStatement || parent instanceof XmlTagChild)) {
            if (parent instanceof JSBlockStatement) {
                candidateBlock = elt;
            }
            if ((elt = parent) != null && !(elt instanceof JSClass)) continue;
        }
        if (parent instanceof XmlTag) {
            if (XmlBackedJSClassImpl.isComponentTag((XmlTag)parent)) {
                XmlTag[] subtags = ((XmlTag)parent).getSubTags();
                if (subtags.length > 0) {
                    elt = XmlBackedJSClassFactory.getInstance().getXmlBackedClass(subtags[0]);
                }
            } else {
                XmlFile xmlFile = (XmlFile)parent.getContainingFile();
                if (JavaScriptSupportLoader.isMxmlOrFxgFile((PsiFile)xmlFile)) {
                    elt = XmlBackedJSClassFactory.getXmlBackedClass(xmlFile);
                }
            }
        }
        if (elt != null && !(elt instanceof JSClass) && candidateBlock != null) {
            elt = candidateBlock;
        }
        if (elt != null && (originalElement = CompletionUtilCoreImpl.getOriginalElement((PsiElement)elt)) != null) {
            elt = originalElement;
        }
        return elt;
    }

    public static ResolveResult[] defaultResolve(JSReferenceSetElement element, String text) {
        ResolveResult[] localResults;
        PsiFile psiFile = element.getElement().getContainingFile();
        PsiElement referenceElement = element.mySet.element;
        WalkUpResolveProcessor processor = new WalkUpResolveProcessor(text, psiFile, referenceElement);
        JSQualifiedName qualifiedName = element.getQualifiedName();
        JSQualifiedName qualifier = qualifiedName.getParent();
        if (qualifier != null) {
            processor.addTypeHierarchy(new JSNamespaceImpl(qualifier, JSContext.UNKNOWN, true), null);
        }
        processor.allowPartialResults();
        processor.setAddOnlyCompleteMatches(qualifier != null || !(referenceElement instanceof JSLiteralExpression));
        String str = qualifiedName.getQualifiedName();
        PsiElement context = psiFile.getContext();
        if (qualifier == null) {
            SinkResolveProcessor<ResolveResultSink> localProcessor = new SinkResolveProcessor<ResolveResultSink>(str, new ResolveResultSink(referenceElement, str));
            element.processLocalVariants(psiFile, localProcessor, context);
            processor.addLocalResults(localProcessor);
        }
        if ((localResults = processor.getResults()).length > 0) {
            return localResults;
        }
        if (context != null) {
            JSResolveUtil.tryProcessXmlFileImplicitElements(context, processor);
        }
        JSReferenceExpressionResolver.processAllSymbols(processor);
        return processor.getResults();
    }

    @Override
    public void processLocalVariants(PsiFile psiFile, SinkResolveProcessor<?> processor, PsiElement context) {
        this.doProcessLocalVariants(psiFile, processor, context, (Condition<PsiElement>)((Condition)element -> {
            JSNamedElement namedElement = element instanceof JSNamedElement ? (JSNamedElement)element : null;
            return namedElement != null && !JSUtils.isLocallyDefined(namedElement, (PsiElement)JSPsiImplUtils.getScopeNode(namedElement));
        }));
    }

    protected final void doProcessLocalVariants(PsiFile psiFile, final SinkResolveProcessor<?> processor, PsiElement context, final Condition<PsiElement> filter) {
        if (context == null && this.mySet.myReferences[0] != this) {
            return;
        }
        String name = processor.getName();
        JSResolveUtil.treeWalkUp(new ResolveProcessor(name){
            {
                super(name);
                this.setProcessingOptions(new JSResolveUtil.StructureResolveProcessor.StructureProcessingOptions());
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (filter.value((Object)element)) {
                    return processor.execute(element, state);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/impl/JSTextReference$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this.mySet.element, this.mySet.element, this.mySet.element);
        if (context != null) {
            JSResolveUtil.treeWalkUp(processor, (PsiElement)psiFile, (PsiElement)psiFile, this.mySet.element);
        }
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String text = this.getCanonicalText();
        text = "'" + text.replace("'", "''") + "'";
        String string = JSBundle.message((String)(this.mySet.element.getParent() instanceof TypeScriptImportStatement ? "javascript.unresolved.file" : "javascript.unresolved.variable.or.type.name.message2"), (Object[])new Object[]{text});
        if (string == null) {
            JSTextReference.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSTextReference";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSTextReference";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "qNameFromNames";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolve";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "useActionScriptIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class MyResolveProcessor
    extends SinkResolveProcessor {
        private String normalizedQN;

        public MyResolveProcessor(String name, @NotNull PsiElement _place, ResultSink sink) {
            if (sink == null) {
                MyResolveProcessor.$$$reportNull$$$0(0);
            }
            super(name, _place, sink);
        }

        @Override
        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            String qName;
            if (element == null) {
                MyResolveProcessor.$$$reportNull$$$0(1);
            }
            if (state == null) {
                MyResolveProcessor.$$$reportNull$$$0(2);
            }
            if (JSTextReference.this.mySet.onlyFqns) {
                if (!(element instanceof JSPackageWrapper) && !(element instanceof JSClass)) {
                    return true;
                }
                if (this.myName != null && element instanceof JSClass && this.myName.equals(((JSClass)element).getName())) {
                    if (this.normalizedQN == null) {
                        this.normalizedQN = StringUtil.stripQuotesAroundValue((String)JSTextReference.this.mySet.myReferenceText).replace(':', '.');
                    }
                    if (!this.normalizedQN.equals(((JSClass)element).getQualifiedName())) {
                        return true;
                    }
                }
            }
            if (JSTextReference.this.mySet.myOnlyDefaultPackage && element instanceof JSQualifiedNamedElement && (qName = ((JSQualifiedNamedElement)element).getQualifiedName()) != null && !StringUtil.isEmpty((String)StringUtil.getPackageName((String)qName))) {
                return true;
            }
            return super.execute(element, state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSTextReference$MyResolveProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

