/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSImplicitElementProviderImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocCommentCachedData;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocCommentCachedDataBuilder;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReferenceSet;
import com.intellij.lang.javascript.psi.stubs.JSDocCommentStub;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubIndexingUtils;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeVisitor;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDocCommentImpl
extends JSImplicitElementProviderImpl<JSDocCommentStub>
implements JSDocComment,
StubBasedPsiElement<JSDocCommentStub> {
    @Nullable
    private JSDocCommentCachedData myCachedData;
    private static final Key<ParameterizedCachedValue<PsiReference[], JSDocCommentImpl>> REFERENCES_KEY = Key.create((String)"js.doc.references");
    private static final ParameterizedCachedValueProvider<PsiReference[], JSDocCommentImpl> REFERENCES_PROVIDER = param -> {
        JSParameterTypeDecorator type;
        String text;
        ArrayList result = new ArrayList();
        PsiElement data = param.findChildByType(JSDocTokenTypes.DOC_COMMENT_DATA);
        PsiElement parent = param.getParent();
        if (data != null && (parent instanceof JSFunction && JSPsiImplUtils.getPrevSiblingIgnoreWhitespace((PsiElement)param) instanceof JSParameterList || JSDocCommentImpl.mayRelateToArrowFunctionParam(param) || parent instanceof JSParameterList || parent instanceof JSDestructuringContainer || parent instanceof JSDestructuringElement || parent instanceof JSDestructuringArrayRestElement || parent instanceof JSDestructuringProperty) && (text = data.getText()).indexOf(10) == -1 && (type = new JSTypeParser(text, new JSTypeVisitor((JSDocCommentImpl)param, data, result){
            final /* synthetic */ JSDocCommentImpl val$param;
            final /* synthetic */ PsiElement val$data;
            final /* synthetic */ List val$result;
            {
                this.val$param = jSDocCommentImpl;
                this.val$data = psiElement;
                this.val$result = list;
            }

            @Override
            public void visitSingleType(int startOffset, String name) {
                if (!"void".equals(name)) {
                    JSDocReferenceSet set = new JSDocReferenceSet((PsiElement)this.val$param, name, this.val$data.getStartOffsetInParent() + startOffset, false);
                    Collections.addAll(this.val$result, set.getReferences());
                }
            }

            @Override
            public void visitRecordProperty(int startOffset, String name, @Nullable String recordPropertyType) {
            }
        }).parseParameterType()) == null) {
            result.clear();
        }
        Collections.addAll(result, ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)param));
        return CachedValueProvider.Result.create((Object)result.toArray(PsiReference.EMPTY_ARRAY), (Object[])new Object[]{param});
    };

    public JSDocCommentImpl(ASTNode node) {
        super(node);
    }

    public JSDocCommentImpl(JSDocCommentStub stub, IStubElementType signature) {
        super(stub, signature);
    }

    public IElementType getTokenType() {
        return this.getNode().getElementType();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSDocCommentImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSDocComment((JSDocComment)this);
        } else {
            visitor.visitComment((PsiComment)this);
        }
    }

    @NotNull
    public JSDocTag[] getTags() {
        PsiElement firstChild = this.getFirstChild();
        if (firstChild instanceof JSDocComment) {
            JSDocTag[] jSDocTagArray = ((JSDocComment)firstChild).getTags();
            if (jSDocTagArray == null) {
                JSDocCommentImpl.$$$reportNull$$$0(1);
            }
            return jSDocTagArray;
        }
        JSDocTag[] jSDocTagArray = (JSDocTag[])this.findChildrenByType(JSDocTokenTypes.DOC_TAG, JSDocTag.class);
        if (jSDocTagArray == null) {
            JSDocCommentImpl.$$$reportNull$$$0(2);
        }
        return jSDocTagArray;
    }

    public PsiElement getOwner() {
        return this.getParent();
    }

    public PsiReference getReference() {
        return (PsiReference)ArrayUtil.getFirstElement((Object[])this.getReferences());
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = (PsiReference[])CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, REFERENCES_KEY, REFERENCES_PROVIDER, false, (Object)this);
        if (psiReferenceArray == null) {
            JSDocCommentImpl.$$$reportNull$$$0(3);
        }
        return psiReferenceArray;
    }

    private static boolean mayRelateToArrowFunctionParam(@NotNull JSDocComment docComment) {
        PsiElement nextSibling;
        PsiElement parent;
        if (docComment == null) {
            JSDocCommentImpl.$$$reportNull$$$0(4);
        }
        if (!((parent = docComment.getParent()) instanceof JSFunction) || !JSPsiImplUtils.isArrowFunction((JSFunction)parent)) {
            return false;
        }
        for (nextSibling = docComment.getNextSibling(); nextSibling != null && (nextSibling instanceof PsiWhiteSpace || nextSibling.getTextRange().isEmpty()); nextSibling = nextSibling.getNextSibling()) {
        }
        return nextSibling instanceof JSParameterList && nextSibling.getFirstChild() instanceof JSParameter;
    }

    @Nullable
    public static PsiComment findPossiblyRelatedCommentForArrowFunctionParam(@NotNull JSParameter parameter) {
        PsiElement parent;
        if (parameter == null) {
            JSDocCommentImpl.$$$reportNull$$$0(5);
        }
        if ((parent = parameter.getParent()) instanceof JSParameterList && parent.getFirstChild() == parameter) {
            PsiElement prevSibling;
            for (prevSibling = parent.getPrevSibling(); prevSibling != null && (prevSibling instanceof PsiWhiteSpace || prevSibling.getTextRange().isEmpty()); prevSibling = prevSibling.getPrevSibling()) {
            }
            if (prevSibling instanceof PsiComment) {
                return (PsiComment)prevSibling;
            }
        }
        return null;
    }

    @NotNull
    public List<String> getGenericParameters() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            List list = stub.getGenericParameters();
            if (list == null) {
                JSDocCommentImpl.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<String> list = this.getCachedData().getGenericParameters();
        if (list == null) {
            JSDocCommentImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    public JSAttributeList.AccessType getAccessType() {
        return this.getCachedData().getAccessType();
    }

    @Nullable
    public String getExplicitName() {
        JSDocCommentCachedData cachedData = this.getCachedData();
        JSQualifiedName className = cachedData.getClassName();
        return className != null ? className.getName() : cachedData.getExplicitName();
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        return this.getCachedData().getNamespace();
    }

    public boolean isNamespaceExplicitlyDeclared() {
        return this.getCachedData().isNamespaceExplicitlyDeclared();
    }

    @Nullable
    public String getType() {
        return this.getCachedData().getType();
    }

    @Nullable
    public Map<JSQualifiedName, String> getProperties() {
        return this.getCachedData().getProperties();
    }

    @NotNull
    public JSContext getJSContext() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            JSContext jSContext = stub.getJSContext();
            if (jSContext == null) {
                JSDocCommentImpl.$$$reportNull$$$0(8);
            }
            return jSContext;
        }
        JSContext jSContext = this.getCachedData().getContext();
        if (jSContext == null) {
            JSDocCommentImpl.$$$reportNull$$$0(9);
        }
        return jSContext;
    }

    public boolean isClassExplicitly() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            return stub.isClassExplicitly();
        }
        return this.getCachedData().isClassExplicitly();
    }

    public boolean hasInterfaceTag() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasInterfaceTag();
        }
        return this.getCachedData().isInterface();
    }

    public boolean hasDeprecatedTag() {
        return this.getCachedData().hasDeprecatedTag();
    }

    public boolean hasConstructsTag() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasConstructsTag();
        }
        return this.getCachedData().hasConstructsTag();
    }

    @NotNull
    public JSDocComment.BrowserFamily getBrowserFamily() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            JSDocComment.BrowserFamily browserFamily = stub.getBrowserFamily();
            if (browserFamily == null) {
                JSDocCommentImpl.$$$reportNull$$$0(10);
            }
            return browserFamily;
        }
        JSDocComment.BrowserFamily browserFamily = this.getCachedData().getBrowserFamily();
        if (browserFamily == null) {
            JSDocCommentImpl.$$$reportNull$$$0(11);
        }
        return browserFamily;
    }

    public boolean hasNamespaceTag() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasNamespaceTag();
        }
        return this.getCachedData().hasNamespaceTag();
    }

    public boolean hasAbstractTag() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasAbstractTag();
        }
        return this.getCachedData().hasAbstractTag();
    }

    @Nullable
    public String getLendsTagValue() {
        return this.getCachedData().getLendsTagValue();
    }

    @Nullable
    public String getDefaultValue(@NotNull JSQualifiedName parameterName) {
        if (parameterName == null) {
            JSDocCommentImpl.$$$reportNull$$$0(12);
        }
        return this.getCachedData().getDefaultValue(parameterName);
    }

    @Override
    @Nullable
    public JSElementIndexingData calculateIndexingData() {
        Map<JSQualifiedName, String> properties;
        JSType parse;
        String enumType;
        Collection<String> baseTypes;
        JSDocCommentCachedData cachedData = this.getCachedData();
        JSElementIndexingDataImpl indexingData = null;
        PsiElement element = JSDocumentationUtils.findAttachedElementFromComment((PsiComment)this);
        JSQualifiedNameImpl qualifiedName = element instanceof JSQualifiedNamedElement ? JSQualifiedNameImpl.fromQualifiedNamedElement((JSElementBase)((JSQualifiedNamedElement)element)) : null;
        for (Pair<String, String> typedef : cachedData.getTypedefs()) {
            if (typedef.first == null || typedef.second == null) continue;
            if (indexingData == null) {
                indexingData = new JSElementIndexingDataImpl();
            }
            indexingData.addTypedef((String)typedef.first, (String)typedef.second);
        }
        JSQualifiedName className = cachedData.getClassName();
        if (className != null) {
            boolean addClassFromComment;
            String classNameTag = className.getQualifiedName();
            boolean classNameIsMorePrecise = qualifiedName == null || !qualifiedName.getQualifiedName().endsWith(classNameTag);
            boolean bl = addClassFromComment = element == null || classNameIsMorePrecise;
            if (classNameIsMorePrecise) {
                qualifiedName = className;
            }
            if (addClassFromComment || qualifiedName.getParent() != null) {
                SmartList elements;
                if (indexingData == null) {
                    indexingData = new JSElementIndexingDataImpl();
                }
                if ((elements = indexingData.getImplicitElements()) == null) {
                    elements = new SmartList();
                    indexingData.setImplicitElements((Collection<JSImplicitElement>)elements);
                }
                if (addClassFromComment) {
                    JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(qualifiedName.getName(), (PsiElement)this).setNamespace(qualifiedName.getParent()).setType(JSImplicitElement.Type.Class).setProperties(JSImplicitElement.Property.MinorImportance);
                    indexingData.addImplicitElement(new JSImplicitElementImpl(builder));
                }
                JSStubIndexingUtils.addImplicitNamespaces(qualifiedName, (Collection<JSImplicitElement>)elements, (PsiElement)this);
            }
        }
        String name = cachedData.getExplicitName();
        JSQualifiedName namespace = cachedData.getNamespace();
        if (name != null || element instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpression((JSReferenceExpression)element)) {
            if (name == null) {
                qualifiedName = JSQualifiedNameImpl.fromQualifiedName(element.getText());
                name = qualifiedName.getName();
                namespace = qualifiedName.getParent();
            } else {
                qualifiedName = JSQualifiedNameImpl.create(name, namespace);
            }
            if (indexingData == null) {
                indexingData = new JSElementIndexingDataImpl();
            }
            JSImplicitElement.Type elementType = cachedData.isInterface() ? JSImplicitElement.Type.Interface : (cachedData.isClassExplicitly() ? JSImplicitElement.Type.Class : (cachedData.hasNamespaceTag() ? JSImplicitElement.Type.Namespace : (cachedData.seemsToBeFunction() ? JSImplicitElement.Type.Function : JSImplicitElement.Type.Variable)));
            PsiElement attachedElement = JSDocumentationUtils.findAttachedElementFromComment((PsiComment)this);
            if (attachedElement instanceof JSReferenceExpression) {
                attachedElement = attachedElement.getParent();
            }
            if (!(attachedElement instanceof JSNamedElement) || !name.equals(((JSNamedElement)attachedElement).getName())) {
                this.addImplicitElement(indexingData, name, namespace, elementType);
            }
            if (!cachedData.seemsToBeFunction() && elementType == JSImplicitElement.Type.Namespace) {
                SmartList elements = indexingData.getImplicitElements();
                if (elements == null) {
                    elements = new SmartList();
                    indexingData.setImplicitElements((Collection<JSImplicitElement>)elements);
                }
                JSStubIndexingUtils.addImplicitNamespaces(qualifiedName, (Collection<JSImplicitElement>)elements, (PsiElement)this);
            }
        }
        if ((baseTypes = cachedData.getBaseTypes()) != null && !baseTypes.isEmpty()) {
            String currentName = null;
            if (cachedData.hasConstructsTag()) {
                String explicitName;
                PsiComment parentComment;
                JSObjectLiteralExpression parent = (JSObjectLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)this, JSObjectLiteralExpression.class);
                if (parent != null && (parentComment = JSDocumentationUtils.findDocComment((PsiElement)parent)) instanceof JSDocComment && (explicitName = ((JSDocComment)parentComment).getExplicitName()) != null) {
                    currentName = JSQualifiedNameImpl.create(explicitName, ((JSDocComment)parentComment).getNamespace()).getQualifiedName();
                }
            } else if (qualifiedName != null) {
                currentName = qualifiedName.getQualifiedName();
            }
            if (currentName != null) {
                if (indexingData == null) {
                    indexingData = new JSElementIndexingDataImpl();
                }
                for (String baseType : baseTypes) {
                    indexingData.addBaseType(currentName, baseType);
                }
            }
        }
        if ((enumType = cachedData.getEnumType()) != null && qualifiedName != null && ((parse = new JSTypeParser(enumType, JSTypeSource.EMPTY).parse()) instanceof JSTypeImpl || parse instanceof JSSpecialNamedTypeImpl)) {
            if (indexingData == null) {
                indexingData = new JSElementIndexingDataImpl();
            }
            indexingData.addBaseType(qualifiedName.getQualifiedName(), parse.getTypeText(JSType.TypeTextFormat.SIMPLE));
        }
        if (!((properties = cachedData.getProperties()) == null || properties.size() == 1 && qualifiedName != null && qualifiedName.getName().equals(((JSQualifiedName)ContainerUtil.getFirstItem(properties.keySet())).getName()))) {
            JSRecordType propertiesType;
            if (indexingData == null) {
                indexingData = new JSElementIndexingDataImpl();
            }
            if ((propertiesType = JSTypeUtils.buildRecordTypeFromProperties(properties, cachedData.getOptionals(), JSTypeSource.EMPTY)) != null) {
                Collection<JSImplicitElement> elements = JSTypeUtils.getImplicitMembersFromRecordType(propertiesType, qualifiedName, (PsiElement)this);
                indexingData.addImplicitElements(elements);
            }
        }
        if (qualifiedName != null) {
            indexingData = this.processRecordType(indexingData, cachedData.getType(), qualifiedName);
        }
        for (Pair<String, String> typedef : cachedData.getTypedefs()) {
            String typedefName = (String)typedef.first;
            if (typedefName == null || typedefName.equals(name)) continue;
            if (indexingData == null) {
                indexingData = new JSElementIndexingDataImpl();
            }
            JSQualifiedNameImpl typedefQName = JSQualifiedNameImpl.fromNamepath(typedefName);
            JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(typedefQName, (PsiElement)this).setType(JSImplicitElement.Type.Interface);
            indexingData.addImplicitElement(builder.toImplicitElement());
            indexingData = this.processRecordType(indexingData, (String)typedef.second, typedefQName);
        }
        List<Pair<JSQualifiedName, String>> parameters = cachedData.getParameters();
        if (parameters != null) {
            JSQualifiedNameImpl baseName = JSQualifiedNameImpl.create("options", qualifiedName);
            JSRecordType mergedParametersType = JSTypeUtils.buildRecordTypeFromQualifiedNames(parameters, Collections.emptySet(), JSTypeSource.EMPTY);
            if (mergedParametersType != null) {
                for (JSRecordType.TypeMember member : mergedParametersType.getTypeMembers()) {
                    JSQualifiedNameImpl baseParameterNs;
                    Collection<JSImplicitElement> members;
                    JSType type;
                    if (!(member instanceof JSRecordType.PropertySignature) || !((type = ((JSRecordType.PropertySignature)member).getType()) instanceof JSRecordType) || (members = JSTypeUtils.getImplicitMembersFromRecordType((JSRecordType)type, baseParameterNs = JSQualifiedNameImpl.create(((JSRecordType.PropertySignature)member).getMemberName(), baseName), (PsiElement)this)).isEmpty()) continue;
                    if (indexingData == null) {
                        indexingData = new JSElementIndexingDataImpl();
                    }
                    indexingData.addImplicitElements(members);
                }
            }
        }
        for (FrameworkIndexingHandler handler : (FrameworkIndexingHandler[])FrameworkIndexingHandler.EP_NAME.getExtensions()) {
            indexingData = (JSElementIndexingDataImpl)handler.processJSDocComment(this, indexingData);
        }
        return indexingData;
    }

    private void addImplicitElement(@NotNull JSElementIndexingDataImpl indexingData, String name, JSQualifiedName namespace, JSImplicitElement.Type elementType) {
        if (indexingData == null) {
            JSDocCommentImpl.$$$reportNull$$$0(13);
        }
        JSDocCommentCachedData cachedData = this.getCachedData();
        JSContext context = cachedData.getContext();
        if (cachedData.seemsToBeFunction()) {
            ArrayList<Pair<String, JSParameterTypeDecorator>> parameters = new ArrayList<Pair<String, JSParameterTypeDecorator>>();
            for (Pair<String, String> pair : JSDocumentationUtils.findParameters((PsiElement)this)) {
                JSParameterTypeDecorator decorator = JSTypeUtils.createParameterType((String)pair.second, JSTypeSource.EXPLICITLY_DECLARED);
                if (decorator == null) {
                    decorator = JSParameterTypeDecoratorImpl.EMPTY;
                }
                parameters.add((Pair<String, JSParameterTypeDecorator>)Pair.create((Object)pair.first, (Object)decorator));
            }
            JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(name, (PsiElement)this).setType(JSImplicitElement.Type.Function).setParametersFromDecorators(parameters).setTypeString(cachedData.getReturnType()).setNamespace(namespace).setContext(context);
            indexingData.addImplicitElement(builder.toImplicitElement());
        } else {
            JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(name, (PsiElement)this).setNamespace(namespace).setType(elementType).setContext(context).setTypeString(cachedData.getType());
            if (cachedData.hasLendsTag()) {
                builder.setProperties(JSImplicitElement.Property.MinorImportance);
            }
            indexingData.addImplicitElement(builder.toImplicitElement());
        }
    }

    @Nullable
    private JSElementIndexingDataImpl processRecordType(@Nullable JSElementIndexingDataImpl data, @Nullable String typeName, @NotNull JSQualifiedName namespace) {
        JSType type;
        if (namespace == null) {
            JSDocCommentImpl.$$$reportNull$$$0(14);
        }
        if ((type = JSTypeUtils.createType(typeName, JSTypeSource.EMPTY)) instanceof JSRecordType) {
            Collection<JSImplicitElement> members = JSTypeUtils.getImplicitMembersFromRecordType((JSRecordType)type, namespace, (PsiElement)this);
            if (data == null && !members.isEmpty()) {
                data = new JSElementIndexingDataImpl();
            }
            if (!members.isEmpty()) {
                assert (data != null);
                data.addImplicitElements(members);
            }
        }
        return data;
    }

    public static boolean shouldCreateStub(ASTNode node) {
        return true;
    }

    private static JSDocCommentCachedData calculateCachedData(ASTNode node) {
        JSDocCommentCachedData cachedData = new JSDocCommentCachedData();
        JSDocumentationUtils.processDocumentationTextFromComment(node, new JSDocCommentCachedDataBuilder(cachedData, node));
        return cachedData;
    }

    @NotNull
    JSDocCommentCachedData getCachedData() {
        PsiElement element;
        String qualifiedName;
        JSDocCommentCachedData cachedData = this.myCachedData;
        if (cachedData != null) {
            JSDocCommentCachedData jSDocCommentCachedData = cachedData;
            if (jSDocCommentCachedData == null) {
                JSDocCommentImpl.$$$reportNull$$$0(15);
            }
            return jSDocCommentCachedData;
        }
        cachedData = JSDocCommentImpl.calculateCachedData(this.getNode());
        List<Pair<String, String>> typedefs = cachedData.getTypedefs();
        for (int i = 0; i < typedefs.size(); ++i) {
            Pair<String, String> typedef = typedefs.get(i);
            String typedefName = (String)typedef.first;
            if (typedefName == null) {
                typedefName = this.findNameOfClassAppliedTo(cachedData);
            }
            String typedefType = (String)typedef.second;
            Map<JSQualifiedName, String> properties = cachedData.getProperties();
            THashSet genericParameters = new THashSet(cachedData.getGenericParameters());
            if (properties != null && !properties.isEmpty()) {
                Object newType = JSTypeUtils.buildRecordTypeFromProperties(properties, cachedData.getOptionals(), JSTypeSource.EMPTY);
                assert (newType != null);
                JSType typedefJSType = JSTypeUtils.createTypeFromJSDoc(typedefType, JSTypeSource.EMPTY);
                if (!(typedefJSType instanceof JSObjectType)) {
                    newType = new JSCompositeTypeImpl(JSTypeSource.EMPTY, new JSType[]{newType, typedefJSType});
                }
                newType = JSTypeUtils.addGenericParameters((JSType)newType, (Set<String>)genericParameters);
                typedefType = newType.getTypeText(JSType.TypeTextFormat.SERIALIZED);
                cachedData.clearProperties();
            } else if (cachedData.seemsToBeFunction() && typedefs.size() == 1) {
                SmartList decorators = new SmartList();
                for (Pair pair : JSDocumentationUtils.findParameters((PsiElement)this)) {
                    JSParameterTypeDecorator decorator = JSTypeUtils.createParameterType((String)pair.second, JSTypeSource.EXPLICITLY_DECLARED);
                    if (decorator != null && !genericParameters.isEmpty()) {
                        decorator = new JSParameterTypeDecoratorImpl(JSTypeUtils.addGenericParameters(decorator.getType(), (Set<String>)genericParameters), decorator.isOptional(), decorator.isRest(), decorator.isExplicitlyDeclared());
                    }
                    if (decorator == null) {
                        decorator = JSParameterTypeDecoratorImpl.EMPTY;
                    }
                    decorators.add(decorator);
                }
                JSType returnType = JSTypeUtils.createType(cachedData.getReturnType(), JSTypeSource.EMPTY);
                returnType = JSTypeUtils.addGenericParameters(returnType, (Set<String>)genericParameters);
                if (!decorators.isEmpty() || returnType != null) {
                    JSFunctionTypeImpl jSFunctionTypeImpl = new JSFunctionTypeImpl(JSTypeSource.EMPTY, (List<JSParameterTypeDecorator>)decorators, returnType);
                    typedefType = jSFunctionTypeImpl.getTypeText(JSType.TypeTextFormat.SERIALIZED);
                }
            }
            typedefs.set(i, (Pair<String, String>)Pair.create((Object)typedefName, (Object)(typedefType != null ? typedefType : "*")));
        }
        if (cachedData.getAlias() != null && (qualifiedName = JSDocumentationUtils.getQualifiedNameFromPsi(element = JSDocumentationUtils.findAttachedElementFromComment((PsiComment)this))) != null) {
            cachedData.addTypedef(cachedData.getAlias(), qualifiedName);
        }
        this.myCachedData = cachedData;
        JSDocCommentCachedData jSDocCommentCachedData = cachedData;
        if (jSDocCommentCachedData == null) {
            JSDocCommentImpl.$$$reportNull$$$0(16);
        }
        return jSDocCommentCachedData;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myCachedData = null;
    }

    public boolean isValidHost() {
        return true;
    }

    public PsiLanguageInjectionHost updateText(@NotNull String newText) {
        ASTNode newTree;
        if (newText == null) {
            JSDocCommentImpl.$$$reportNull$$$0(17);
        }
        return (newTree = JSChangeUtil.createJSTreeFromText(this.getProject(), newText)).getElementType() == JSStubElementTypes.DOC_COMMENT ? (JSDocComment)newTree.getPsi() : this;
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        LiteralTextEscaper literalTextEscaper = LiteralTextEscaper.createSimple((PsiLanguageInjectionHost)this);
        if (literalTextEscaper == null) {
            JSDocCommentImpl.$$$reportNull$$$0(18);
        }
        return literalTextEscaper;
    }

    @Nullable
    public String getThisType() {
        return this.getCachedData().getThisType();
    }

    public boolean hasConstTag() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasConstTag();
        }
        return this.getCachedData().hasConstTag();
    }

    @NotNull
    public List<Pair<String, String>> getTypedefs() {
        List<Pair<String, String>> list = this.getCachedData().getTypedefs();
        if (list == null) {
            JSDocCommentImpl.$$$reportNull$$$0(19);
        }
        return list;
    }

    @Nullable
    public String getEnumType() {
        return this.getCachedData().getEnumType();
    }

    @Nullable
    public String findNameOfClassAppliedTo() {
        return this.findNameOfClassAppliedTo(this.getCachedData());
    }

    @Nullable
    private String findNameOfClassAppliedTo(@NotNull JSDocCommentCachedData cachedData) {
        JSQualifiedName qName;
        if (cachedData == null) {
            JSDocCommentImpl.$$$reportNull$$$0(20);
        }
        if ((qName = cachedData.getClassName()) == null) {
            String explicitName = cachedData.getExplicitName();
            qName = explicitName != null ? JSQualifiedNameImpl.create(explicitName, cachedData.getNamespace()) : null;
        }
        PsiElement namedElement = JSDocumentationUtils.findAttachedElementFromComment((PsiComment)this);
        String codeName = JSDocumentationUtils.getQualifiedNameFromPsi(namedElement);
        return qName == null || codeName != null && codeName.endsWith(qName.getQualifiedName()) ? codeName : JSQualifiedNameImpl.toString(qName);
    }

    @Nullable
    public String getReturnType() {
        return this.getCachedData().getReturnType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docComment";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexingData";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTags";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericParameters";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSContext";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrowserFamily";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedData";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createLiteralTextEscaper";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypedefs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "mayRelateToArrowFunctionParam";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findPossiblyRelatedCommentForArrowFunctionParam";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultValue";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addImplicitElement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processRecordType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findNameOfClassAppliedTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

