/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.flex.JSResolveHelper;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSNamespaceIncludingLocalMembersIndex;
import com.intellij.lang.javascript.psi.stubs.JSNamespaceMembersIndex;
import com.intellij.lang.javascript.psi.stubs.JSQualifiedElementIndex;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.lang.javascript.psi.stubs.JSSymbolQualifiedNamesIndex;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ComparatorUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSClassResolver {
    private static JSClassResolver INSTANCE = null;

    protected JSClassResolver() {
    }

    public static JSClassResolver getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JSClassResolver();
        }
        return INSTANCE;
    }

    public static PsiElement findClassFromNamespace(@NotNull String qname, @NotNull PsiElement context) {
        if (qname == null) {
            JSClassResolver.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JSClassResolver.$$$reportNull$$$0(1);
        }
        return JSClassResolver.findClassFromNamespace(qname, context, JSResolveUtil.getResolveScope(context));
    }

    public static PsiElement findClassFromNamespace(@NotNull String qname, @NotNull PsiElement context, @NotNull GlobalSearchScope scope) {
        JSNamedElement localElement;
        DialectOptionHolder dialect;
        if (qname == null) {
            JSClassResolver.$$$reportNull$$$0(2);
        }
        if (context == null) {
            JSClassResolver.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(4);
        }
        if ((dialect = DialectDetector.dialectOfFile(context.getContainingFile())) != null && (dialect.isJavaScript() || dialect.isTypeScript)) {
            return null;
        }
        VirtualFile vFile = context.getContainingFile().getVirtualFile();
        if (!"Object".equals(qname) && (vFile == null || scope.contains(vFile)) && (localElement = JSResolveUtil.findFileLocalElement(qname, context)) != null) {
            return localElement;
        }
        return JSDialectSpecificHandlersFactory.forElement(context).getClassResolver().findClassByQName(qname, scope);
    }

    public static long getResolveResultTimestamp(PsiElement candidate) {
        for (JSResolveHelper helper : (JSResolveHelper[])Extensions.getExtensions(JSResolveHelper.EP_NAME)) {
            long result = helper.getResolveResultTimestamp(candidate);
            if (result == -1L) continue;
            return result;
        }
        return -1L;
    }

    public PsiElement findClassByQName(@NotNull String link, @NotNull PsiElement context) {
        if (link == null) {
            JSClassResolver.$$$reportNull$$$0(5);
        }
        if (context == null) {
            JSClassResolver.$$$reportNull$$$0(6);
        }
        return this.findClassByQName(link, JavaScriptIndex.getInstance(context.getProject()), JSResolveUtil.getResolveScope(context), DialectOptionHolder.JS_1_5);
    }

    @Nullable
    public PsiElement findClassByQName(@NotNull String link, @NotNull GlobalSearchScope scope) {
        if (link == null) {
            JSClassResolver.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(8);
        }
        return TypeScriptClassResolver.getInstance().findAnyClassByQName(link, scope);
    }

    @Nullable
    protected final PsiElement findClassByQName(@NotNull String link, JavaScriptIndex index, GlobalSearchScope searchScope, @NotNull DialectOptionHolder dialect) {
        if (link == null) {
            JSClassResolver.$$$reportNull$$$0(9);
        }
        if (dialect == null) {
            JSClassResolver.$$$reportNull$$$0(10);
        }
        if (searchScope instanceof JSResolveUtil.AllowFileLocalSymbols) {
            return this.doFindClassByQName(link, index, searchScope, true, dialect);
        }
        PsiElement element = index.recallClass(link, searchScope);
        if (element != null) {
            return element;
        }
        element = this.doFindClassByQName(link, index, searchScope, false, dialect);
        if (element != null) {
            index.rememberTopLevelClassElement(link, searchScope, element);
        }
        return element;
    }

    protected PsiElement doFindClassByQName(@NotNull String link, JavaScriptIndex index, GlobalSearchScope searchScope, boolean allowFileLocalSymbols, @NotNull DialectOptionHolder dialect) {
        if (link == null) {
            JSClassResolver.$$$reportNull$$$0(11);
        }
        if (dialect == null) {
            JSClassResolver.$$$reportNull$$$0(12);
        }
        Project project = index.getProject();
        Collection candidates = StubIndex.getElements(JSQualifiedElementIndex.KEY, (Object)link.hashCode(), (Project)project, (GlobalSearchScope)searchScope, JSQualifiedNamedElement.class);
        for (Object _clazz : candidates) {
            PsiFile file;
            JSQualifiedNamedElement clazz;
            if (!(_clazz instanceof JSQualifiedNamedElement) || !link.equals((clazz = (JSQualifiedNamedElement)_clazz).getQualifiedName()) || (file = clazz.getContainingFile()).getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)) continue;
            return clazz;
        }
        return null;
    }

    @NotNull
    public List<JSClass> findClassesByQName(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        PsiElement clazz;
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(13);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(14);
        }
        List<JSClass> list = (clazz = this.findClassByQName(qName, scope)) instanceof JSClass ? Collections.singletonList((JSClass)clazz) : Collections.emptyList();
        if (list == null) {
            JSClassResolver.$$$reportNull$$$0(15);
        }
        return list;
    }

    public boolean processElementByQName(@NotNull String qName, @NotNull GlobalSearchScope scope, @NotNull Processor<? super JSQualifiedNamedElement> processor) {
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(16);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(17);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(18);
        }
        return StubIndex.getInstance().processElements(JSQualifiedElementIndex.KEY, (Object)qName.hashCode(), scope.getProject(), scope, JSQualifiedNamedElement.class, processor);
    }

    @NotNull
    public Collection<JSQualifiedNamedElement> findElementsByQName(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(19);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(20);
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.processElementByQName(qName, scope, (Processor<? super JSQualifiedNamedElement>)processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            JSClassResolver.$$$reportNull$$$0(21);
        }
        return collection;
    }

    @NotNull
    public Collection<JSPsiElementBase> findNamespaceMembers(@NotNull String namespace, @NotNull GlobalSearchScope scope) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(22);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(23);
        }
        Collection<JSPsiElementBase> collection = this.findNamespaceMembers(namespace, scope, false);
        if (collection == null) {
            JSClassResolver.$$$reportNull$$$0(24);
        }
        return collection;
    }

    public boolean processNamespaceMembers(@NotNull String namespace, @NotNull GlobalSearchScope scope, @NotNull Processor<JSPsiElementBase> processor) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(25);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(26);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(27);
        }
        return this.processNamespaceMembers(namespace, scope, processor, JSNamespaceMembersIndex.KEY);
    }

    @NotNull
    public Collection<JSPsiElementBase> findNamespaceMembers(@NotNull String namespace, @NotNull GlobalSearchScope scope, boolean includeLocal) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(28);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(29);
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        StubIndexKey<String, JSElement> key = includeLocal ? JSNamespaceIncludingLocalMembersIndex.KEY : JSNamespaceMembersIndex.KEY;
        this.processNamespaceMembers(namespace, scope, (Processor<JSPsiElementBase>)processor, key);
        Collection collection = processor.getResults();
        if (collection == null) {
            JSClassResolver.$$$reportNull$$$0(30);
        }
        return collection;
    }

    public boolean processNamespaceMembers(@NotNull String namespace, @NotNull GlobalSearchScope scope, @NotNull Processor<JSPsiElementBase> processor, StubIndexKey<String, JSElement> indexKey) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(31);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(32);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(33);
        }
        JSQualifiedNameImpl namespaceQName = "".equals(namespace) ? null : JSQualifiedNameImpl.fromQualifiedName(namespace);
        Project project = scope.getProject();
        if (project == null) {
            return true;
        }
        return StubIndex.getInstance().processElements(indexKey, (Object)namespace, project, scope, JSElement.class, element -> {
            Collection implicitElements;
            JSElementIndexingData data;
            if (processor == null) {
                JSClassResolver.$$$reportNull$$$0(63);
            }
            boolean emptyImplicitElements = true;
            if (element instanceof JSImplicitElementProvider && (data = ((JSImplicitElementProvider)element).getIndexingData()) != null && (implicitElements = data.getImplicitElements()) != null) {
                emptyImplicitElements = false;
                for (JSImplicitElement implicitElement : implicitElements) {
                    if (!ComparatorUtil.equalsNullable((Object)namespaceQName, (Object)implicitElement.getNamespace()) || processor.process((Object)implicitElement)) continue;
                    return false;
                }
            }
            return !(element instanceof JSPsiElementBase) || !emptyImplicitElements && !ComparatorUtil.equalsNullable((Object)namespaceQName, (Object)((JSPsiElementBase)element).getNamespace()) || processor.process((Object)((JSPsiElementBase)element));
        });
    }

    @NotNull
    public Collection<JSPsiElementBase> findElementsByQNameIncludingImplicit(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(34);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(35);
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.processElementsByQNameIncludingImplicit(qName, scope, (Processor<JSPsiElementBase>)processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            JSClassResolver.$$$reportNull$$$0(36);
        }
        return collection;
    }

    public void processElementsByQNameIncludingImplicit(@NotNull String qName, @NotNull GlobalSearchScope scope, @NotNull Processor<JSPsiElementBase> processor) {
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(37);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(38);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(39);
        }
        this.processElementsByQNameIncludingImplicit(qName, scope, null, processor);
    }

    public void processElementsByQNameIncludingImplicit(@NotNull String qName, @NotNull GlobalSearchScope scope, @Nullable PsiFile fileToIncludeLocal, @NotNull Processor<JSPsiElementBase> processor) {
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(40);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(41);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(42);
        }
        Project project = scope.getProject();
        assert (project != null);
        StubIndex.getInstance().processElements(JSSymbolQualifiedNamesIndex.KEY, (Object)qName.hashCode(), project, scope, JSElement.class, element -> {
            JSQualifiedName ns;
            String processedElementQName;
            if (qName == null) {
                JSClassResolver.$$$reportNull$$$0(61);
            }
            if (processor == null) {
                JSClassResolver.$$$reportNull$$$0(62);
            }
            if (element instanceof JSPsiElementBase && qName.equals(processedElementQName = fileToIncludeLocal != null && fileToIncludeLocal.equals(element.getContainingFile()) ? ((ns = ((JSPsiElementBase)element).getJSNamespace().getQualifiedName()) != null ? ns.getQualifiedName() + "." + element.getName() : element.getName()) : ((JSPsiElementBase)element).getQualifiedName()) && !processor.process((Object)((JSPsiElementBase)element))) {
                return false;
            }
            if (element instanceof JSImplicitElementProvider) {
                List elements = ((JSImplicitElementProvider)element).findElementsByQualifiedName(qName);
                for (JSImplicitElement implicitElement : elements) {
                    if (processor.process((Object)implicitElement)) continue;
                    return false;
                }
            }
            return true;
        });
    }

    @NotNull
    public Collection<JSPsiElementBase> findElementsByNameIncludingImplicit(@NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            JSClassResolver.$$$reportNull$$$0(43);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(44);
        }
        Collection<JSPsiElementBase> collection = JSClassResolver.findElementsByNameIncludingImplicit(name, scope, false);
        if (collection == null) {
            JSClassResolver.$$$reportNull$$$0(45);
        }
        return collection;
    }

    @NotNull
    public static Collection<JSPsiElementBase> findElementsByNameIncludingImplicit(@NotNull String name, @NotNull GlobalSearchScope scope, boolean justClasses) {
        if (name == null) {
            JSClassResolver.$$$reportNull$$$0(46);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(47);
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        JSClassResolver.processElementsByNameIncludingImplicit(name, scope, justClasses, (Processor<JSPsiElementBase>)processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            JSClassResolver.$$$reportNull$$$0(48);
        }
        return collection;
    }

    public static boolean processElementsByNameIncludingImplicit(@NotNull String name, @NotNull GlobalSearchScope scope, boolean justClasses, @NotNull Processor<JSPsiElementBase> processor) {
        if (name == null) {
            JSClassResolver.$$$reportNull$$$0(49);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(50);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(51);
        }
        return JSClassResolver.processElementsByNameIncludingImplicit(name, scope, justClasses, JSSymbolIndex2.KEY, processor);
    }

    public static boolean processElementsByNameIncludingImplicit(@NotNull String name, @NotNull GlobalSearchScope scope, boolean justClasses, @NotNull StubIndexKey<String, JSElement> indexKey, @NotNull Processor<JSPsiElementBase> processor) {
        if (name == null) {
            JSClassResolver.$$$reportNull$$$0(52);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(53);
        }
        if (indexKey == null) {
            JSClassResolver.$$$reportNull$$$0(54);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(55);
        }
        Project project = scope.getProject();
        assert (project != null);
        return StubIndex.getInstance().processElements(indexKey, (Object)name, project, scope, JSElement.class, element -> {
            if (name == null) {
                JSClassResolver.$$$reportNull$$$0(59);
            }
            if (processor == null) {
                JSClassResolver.$$$reportNull$$$0(60);
            }
            ProgressManager.checkCanceled();
            if (justClasses && !(element instanceof JSClass)) {
                return true;
            }
            return !(element instanceof JSPsiElementBase && name.equals(element.getName()) ? !processor.process((Object)((JSPsiElementBase)element)) : element instanceof JSImplicitElementProvider && !JSClassResolver.processImplicitElements(name, (Processor<? super JSImplicitElement>)processor, (JSImplicitElementProvider)element));
        });
    }

    public static boolean processImplicitElements(@NotNull String name, @NotNull Processor<? super JSImplicitElement> processor, @NotNull JSImplicitElementProvider element) {
        JSElementIndexingData data;
        Collection implicitElements;
        if (name == null) {
            JSClassResolver.$$$reportNull$$$0(56);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(57);
        }
        if (element == null) {
            JSClassResolver.$$$reportNull$$$0(58);
        }
        Collection collection = implicitElements = (data = element.getIndexingData()) != null ? data.getImplicitElements() : null;
        if (implicitElements != null) {
            for (JSImplicitElement implicitElement : implicitElements) {
                if (!name.equals(implicitElement.getName()) || processor.process((Object)implicitElement)) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 21: 
            case 24: 
            case 30: 
            case 36: 
            case 45: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 21: 
            case 24: 
            case 30: 
            case 36: 
            case 45: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qname";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 8: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 35: 
            case 38: 
            case 41: 
            case 44: 
            case 47: 
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 13: 
            case 16: 
            case 19: 
            case 34: 
            case 37: 
            case 40: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 15: 
            case 21: 
            case 24: 
            case 30: 
            case 36: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSClassResolver";
                break;
            }
            case 18: 
            case 27: 
            case 33: 
            case 39: 
            case 42: 
            case 51: 
            case 55: 
            case 57: 
            case 60: 
            case 62: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 22: 
            case 25: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 43: 
            case 46: 
            case 49: 
            case 52: 
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexKey";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSClassResolver";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesByQName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsByQName";
                break;
            }
            case 24: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "findNamespaceMembers";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsByQNameIncludingImplicit";
                break;
            }
            case 45: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsByNameIncludingImplicit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findClassFromNamespace";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findClassByQName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doFindClassByQName";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findClassesByQName";
                break;
            }
            case 15: 
            case 21: 
            case 24: 
            case 30: 
            case 36: 
            case 45: 
            case 48: {
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processElementByQName";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findElementsByQName";
                break;
            }
            case 22: 
            case 23: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findNamespaceMembers";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processNamespaceMembers";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findElementsByQNameIncludingImplicit";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "processElementsByQNameIncludingImplicit";
                break;
            }
            case 43: 
            case 44: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findElementsByNameIncludingImplicit";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "processElementsByNameIncludingImplicit";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "processImplicitElements";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processElementsByNameIncludingImplicit$2";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processElementsByQNameIncludingImplicit$1";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processNamespaceMembers$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 21: 
            case 24: 
            case 30: 
            case 36: 
            case 45: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

