/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSGenericParameterApplierImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSGenericsIndex;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCacheService;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.TreeItem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGenericTypesEvaluator {
    private static JSGenericTypesEvaluator INSTANCE = null;
    public static final Key<MultiMap<String, JSType>> ourGenericArgumentsMapKey = Key.create((String)"generic.arguments");

    protected JSGenericTypesEvaluator() {
    }

    public static JSGenericTypesEvaluator getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JSGenericTypesEvaluator();
        }
        return INSTANCE;
    }

    public final JSType evaluateGenerics(@Nullable JSType type, @Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction) {
        return this.evaluateGenerics(type, methodExpression, resolvedFunction, -1);
    }

    public final JSType evaluateGenerics(@Nullable JSType type, @Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction, int paramToSkip) {
        return this.evaluateGenerics(type, methodExpression, resolvedFunction, null, paramToSkip);
    }

    @Nullable
    @Contract(value="!null, _, _, _ -> !null")
    public JSType evaluateGenerics(@Nullable JSType type, @Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction, @Nullable GenericErrorReporter reporter) {
        return this.evaluateGenerics(type, methodExpression, resolvedFunction, reporter, -1);
    }

    @Nullable
    @Contract(value="!null, _, _, _, _ -> !null")
    public JSType evaluateGenerics(@Nullable JSType type, @Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction, @Nullable GenericErrorReporter reporter, int paramToSkip) {
        JSExpression qualifier;
        JSFunctionItem functionItem;
        if (!this.canHaveGenericParameters(type)) {
            return type;
        }
        if (resolvedFunction != null && (functionItem = JSPsiImplUtils.calculatePossibleFunction(resolvedFunction, (PsiElement)methodExpression)) != null) {
            resolvedFunction = functionItem;
        }
        if (methodExpression instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)methodExpression).getQualifier()) != null) {
            type = this.evaluateGenericsFromQualifier(type, qualifier, (JSReferenceExpression)methodExpression);
        }
        if (methodExpression != null && methodExpression.getParent() instanceof JSCallExpression && resolvedFunction != null) {
            JSTypeSubstitutor substitutor = JSGenericTypesEvaluator.inferGenericTypesForCall(resolvedFunction, (JSCallExpression)methodExpression.getParent(), reporter, paramToSkip);
            type = JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)substitutor, reporter);
        }
        return type;
    }

    @NotNull
    private static JSTypeSubstitutor getDefaultTypeSubstitutor(@NotNull PsiElement typeParametersOwner, @NotNull JSCallExpression expression) {
        if (typeParametersOwner == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(0);
        }
        if (expression == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(1);
        }
        if (JSTypeUtils.hasTypeArguments(expression)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluator.$$$reportNull$$$0(2);
            }
            return jSTypeSubstitutor;
        }
        if (!(typeParametersOwner instanceof TypeScriptTypeParameterListOwner)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluator.$$$reportNull$$$0(3);
            }
            return jSTypeSubstitutor;
        }
        TypeScriptTypeParameter[] parameters = TypeScriptPsiUtil.getTypeParametersForOwner(typeParametersOwner);
        if (parameters.length == 0) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluator.$$$reportNull$$$0(4);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor substitutor = new JSTypeSubstitutor();
        for (TypeScriptTypeParameter parameter : parameters) {
            String name = parameter.getName();
            if (name == null) continue;
            JSType type = JSGenericTypesEvaluator.getTypeParameterDefaultType(parameter);
            substitutor.put((Object)name, (Object)type);
        }
        JSTypeSubstitutor jSTypeSubstitutor = substitutor;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(5);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static JSType getTypeParameterDefaultType(@NotNull TypeScriptTypeParameter parameter) {
        TypeScriptType defaultType;
        if (parameter == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(6);
        }
        if ((defaultType = parameter.getDefault()) == null) {
            defaultType = parameter.getTypeConstraint();
        }
        JSType jSType = defaultType == null ? JSAnyType.get((PsiElement)parameter, true) : TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)defaultType);
        if (jSType == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(7);
        }
        return jSType;
    }

    @Contract(value="null->false")
    protected boolean canHaveGenericParameters(@Nullable JSType type) {
        if (type == null) {
            return false;
        }
        return !(type instanceof JSAnyType) && !(type instanceof JSSpecialNamedTypeImpl) && !(type instanceof JSNullType) && !(type instanceof JSUndefinedType) && !(type instanceof JSVoidType);
    }

    @NotNull
    public static JSTypeSubstitutor inferGenericTypesForCall(@NotNull PsiElement resolvedFunction, @NotNull JSCallExpression callExpression, @Nullable GenericErrorReporter reporter) {
        if (resolvedFunction == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(8);
        }
        if (callExpression == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(9);
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSGenericTypesEvaluator.inferGenericTypesForCall(resolvedFunction, callExpression, reporter, -1);
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(10);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static JSTypeSubstitutor inferGenericTypesForCall(@NotNull PsiElement resolvedFunction, @NotNull JSCallExpression callExpression, @Nullable GenericErrorReporter reporter, int paramToSkip) {
        if (resolvedFunction == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(11);
        }
        if (callExpression == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(12);
        }
        JSTypeSubstitutor result = new JSTypeSubstitutor();
        result.putAll((Map)JSGenericTypesEvaluator.getDefaultTypeSubstitutor(resolvedFunction, callExpression));
        if (resolvedFunction instanceof JSFunctionItem) {
            JSParameterItem[] parameters;
            JSFunctionItem functionItem = (JSFunctionItem)resolvedFunction;
            List parameterTypes = ContainerUtil.newSmartList();
            for (JSParameterItem parameter : parameters = functionItem.getParameters()) {
                parameterTypes.add(parameter.getType());
            }
            JSExpression[] arguments = callExpression.getArguments();
            MultiMap<String, JSType> genericArguments = JSGenericTypesEvaluator.inferGenericArgumentsFromCall(parameterTypes, arguments, paramToSkip);
            result.putAll((Map)JSGenericTypesEvaluator.intersectGenerics(genericArguments, resolvedFunction, reporter));
        }
        JSTypeSubstitutor jSTypeSubstitutor = result;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(13);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static JSTypeSubstitutor intersectGenerics(MultiMap<String, JSType> map, @Nullable PsiElement context, @Nullable GenericErrorReporter reporter) {
        JSTypeSubstitutor result = new JSTypeSubstitutor();
        ProcessingContext processingContext = context == null ? null : JSTypeComparingCacheService.getProcessingContextWithCache(context);
        for (Map.Entry entry : map.entrySet()) {
            JSType type;
            Collection value = (Collection)entry.getValue();
            assert (value.size() > 0);
            if (value.size() == 1) {
                result.put(entry.getKey(), ContainerUtil.getFirstItem((Collection)value));
                continue;
            }
            Collection types = (Collection)entry.getValue();
            boolean hasImplicitly = false;
            for (JSType type2 : types) {
                if (type2 != null && type2.getSource().isExplicitlyDeclared()) continue;
                hasImplicitly = true;
                break;
            }
            if ((type = JSGenericTypesEvaluator.intersectTypes(types, processingContext)) != null) {
                result.put(entry.getKey(), (Object)type);
                continue;
            }
            if (reporter != null && hasImplicitly) continue;
        }
        JSTypeSubstitutor jSTypeSubstitutor = result;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(14);
        }
        return jSTypeSubstitutor;
    }

    @Nullable
    public static JSType intersectTypes(@NotNull Collection<JSType> types, @Nullable ProcessingContext context) {
        if (types == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(15);
        }
        List typesForSearch = ContainerUtil.skipNulls((Collection)ContainerUtil.newArrayList(types));
        JSType firstNamed = null;
        for (JSType type : types) {
            JSType currentType;
            JSTypeSource source;
            if (firstNamed == null && type instanceof JSNamedType) {
                firstNamed = type;
            }
            if (type == null || (source = type.getSource()).isTypeScript() && !(currentType = JSTypeUtils.getValuableType(type)).getSource().isExplicitlyDeclared()) continue;
            boolean result = true;
            for (JSType jsType : typesForSearch) {
                if (jsType == type || type.isDirectlyAssignableType(jsType, context)) continue;
                result = false;
                break;
            }
            if (!result) continue;
            return type;
        }
        return null;
    }

    @NotNull
    public static MultiMap<String, JSType> inferGenericArgumentsFromCall(List<JSType> parameterTypes, JSExpression[] arguments, int paramToSkip) {
        MultiMap genericArguments = MultiMap.createSmart();
        ProcessingContext processingContext = new ProcessingContext();
        processingContext.put(ourGenericArgumentsMapKey, (Object)genericArguments);
        for (int i = 0; i < arguments.length; ++i) {
            JSType paramType;
            if (i == paramToSkip) continue;
            if (i >= parameterTypes.size()) break;
            JSExpression argument = arguments[i];
            JSType exprType = JSResolveUtil.getExpressionJSType(argument);
            if (exprType != null && exprType.getSource().isTypeScript()) {
                exprType = TypeScriptGenericTypesEvaluator.getExplicitTypeOrAny(argument, exprType);
            }
            if ((paramType = parameterTypes.get(i)) instanceof JSTypeofTypeImpl) {
                paramType = paramType.substitute();
            }
            if (!JSTypeUtils.hasGenericParameter(paramType)) continue;
            JSGenericTypesEvaluator.matchGenericTypes(processingContext, exprType, paramType);
        }
        MultiMap multiMap = genericArguments;
        if (multiMap == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(16);
        }
        return multiMap;
    }

    public static MultiMap<String, JSType> findGenericsTypeValues(@Nullable JSType exprType, @Nullable JSType paramType) {
        if (exprType == null || paramType == null) {
            return MultiMap.EMPTY;
        }
        MultiMap genericArguments = MultiMap.createSmart();
        ProcessingContext processingContext = new ProcessingContext();
        processingContext.put(ourGenericArgumentsMapKey, (Object)genericArguments);
        JSGenericTypesEvaluator.matchGenericTypes(processingContext, exprType, paramType);
        return genericArguments;
    }

    private static void matchGenericTypes(@NotNull ProcessingContext processingContext, @Nullable JSType exprType, @NotNull JSType paramType) {
        if (processingContext == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(17);
        }
        if (paramType == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(18);
        }
        paramType = JSTypeUtils.applyCompositeMapping(paramType, (Function<JSType, JSType>)((Function)type -> {
            if (!(type instanceof JSGenericParameterImpl)) {
                return type;
            }
            return new JSGenericParameterApplierImpl((JSType)type);
        }));
        paramType.isDirectlyAssignableType(exprType, processingContext);
    }

    @NotNull
    public JSType evaluateGenericsFromQualifier(@NotNull JSType type, @NotNull JSExpression qualifier, JSReferenceExpression methodExpression) {
        JSType qualifierType;
        if (type == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(19);
        }
        if (qualifier == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(20);
        }
        PsiElement sourceElement = type.getSource().getSourceElement();
        List<String> javaScriptGenericParameters = null;
        JSQualifiedName qualifiedName = null;
        PsiElement namespaceElement = sourceElement;
        if (namespaceElement instanceof JSParameter) {
            namespaceElement = ((JSParameter)namespaceElement).getDeclaringFunction();
        }
        if (namespaceElement instanceof JSPsiElementBase && namespaceElement.isValid()) {
            PsiFile file = namespaceElement.getContainingFile();
            for (qualifiedName = ((JSPsiElementBase)namespaceElement).getNamespace(); qualifiedName != null && (javaScriptGenericParameters = JSGenericsIndex.findGenericParameters(qualifiedName.getQualifiedName(), file)) == null; qualifiedName = qualifiedName.getParent()) {
            }
            if (javaScriptGenericParameters != null) {
                List<String> genericParameters = javaScriptGenericParameters;
                type = JSTypeUtils.applyCompositeMapping(type, (Function<JSType, JSType>)((Function)type1 -> {
                    if (type1 instanceof JSTypeImpl && genericParameters.contains(type1.getTypeText())) {
                        return new JSGenericParameterImpl(type1.getTypeText(), type1.getSource());
                    }
                    return type1;
                }));
            }
        }
        if (javaScriptGenericParameters != null && JSTypeUtils.hasGenericParameter(type) && (qualifierType = JSResolveUtil.getExpressionJSType(qualifier)) != null) {
            qualifierType = JSTypeUtils.unwrapDecorations(qualifierType);
            JSTypeSubstitutor typeArguments = JSGenericTypesEvaluator.findTypeArgumentsForClassInHierarchy(qualifierType, qualifiedName, sourceElement);
            type = JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)typeArguments);
        }
        JSType jSType = type;
        if (jSType == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(21);
        }
        return jSType;
    }

    @NotNull
    public static JSTypeSubstitutor findTypeArgumentsForClassInHierarchy(@NotNull JSType genericType, @NotNull JSQualifiedName parentClassNamespace, @NotNull PsiElement scopeElement) {
        String qName;
        if (genericType == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(22);
        }
        if (parentClassNamespace == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(23);
        }
        if (scopeElement == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(24);
        }
        if ((qName = JSTypeUtils.getQualifiedNameMatchingType(genericType, true)) == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluator.$$$reportNull$$$0(25);
            }
            return jSTypeSubstitutor;
        }
        String parentClassName = parentClassNamespace.getQualifiedName();
        if (parentClassName.equals(qName)) {
            List<String> genericParameters = JSGenericsIndex.findGenericParameters(parentClassName, scopeElement.getContainingFile());
            if (genericParameters == null) {
                JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
                if (jSTypeSubstitutor == null) {
                    JSGenericTypesEvaluator.$$$reportNull$$$0(26);
                }
                return jSTypeSubstitutor;
            }
            List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(genericType);
            if (arguments == null) {
                JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
                if (jSTypeSubstitutor == null) {
                    JSGenericTypesEvaluator.$$$reportNull$$$0(27);
                }
                return jSTypeSubstitutor;
            }
            JSTypeSubstitutor typeArguments = new JSTypeSubstitutor();
            for (int i = 0; i < genericParameters.size() && i < arguments.size(); ++i) {
                typeArguments.put((Object)genericParameters.get(i), (Object)arguments.get(i));
            }
            JSTypeSubstitutor jSTypeSubstitutor = typeArguments;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluator.$$$reportNull$$$0(28);
            }
            return jSTypeSubstitutor;
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(scopeElement);
        JSTypeSubstitutor typeArguments = JSGenericTypesEvaluator.getTypeArgumentsMap(genericType, scope);
        JSTypeSubstitutor jSTypeSubstitutor = JSGenericTypesEvaluator.applyTypeSubstitutorUpToParentClass(qName, parentClassName, scopeElement, typeArguments);
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(29);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static JSTypeSubstitutor applyTypeSubstitutorUpToParentClass(@NotNull String qName, @NotNull String parentClassName, @NotNull PsiElement scopeElement, @NotNull JSTypeSubstitutor typeArguments) {
        if (qName == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(30);
        }
        if (parentClassName == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(31);
        }
        if (scopeElement == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(32);
        }
        if (typeArguments == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(33);
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(scopeElement);
        TreeItem<String> root = JSTypeEvaluateManager.buildSuperClassesHierarchy(qName, scope);
        ArrayList<Object> pathToSuperClass = new ArrayList<Object>();
        for (TreeItem parentClass = JSTypeEvaluateManager.findSuperClass(root, parentClassName); parentClass != null && parentClass != root; parentClass = parentClass.getParent()) {
            pathToSuperClass.add(0, parentClass.getData());
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(scopeElement, true);
        for (String string : pathToSuperClass) {
            JSType type = JSTypeUtils.createType(string, typeSource);
            if (type == null) {
                JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
                if (jSTypeSubstitutor == null) {
                    JSGenericTypesEvaluator.$$$reportNull$$$0(34);
                }
                return jSTypeSubstitutor;
            }
            type = JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)typeArguments);
            typeArguments = JSGenericTypesEvaluator.getTypeArgumentsMap(type, scope);
        }
        JSTypeSubstitutor jSTypeSubstitutor = typeArguments;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(35);
        }
        return jSTypeSubstitutor;
    }

    private static JSTypeSubstitutor getTypeArgumentsMap(JSType genericType, @NotNull GlobalSearchScope scope) {
        if (scope == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(36);
        }
        String qName = JSTypeUtils.getQualifiedNameMatchingType(genericType, true);
        List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(genericType);
        if (qName == null || arguments == null) {
            return JSTypeSubstitutor.EMPTY;
        }
        JSTypeSubstitutor typeArguments = new JSTypeSubstitutor();
        List<String> genericParameters = JSGenericsIndex.findGenericParameters(qName, scope);
        if (genericParameters != null) {
            for (int i = 0; i < genericParameters.size() && i < arguments.size(); ++i) {
                typeArguments.put((Object)genericParameters.get(i), (Object)arguments.get(i));
            }
        }
        return typeArguments;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParametersOwner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedFunction";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericType";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClassNamespace";
                break;
            }
            case 24: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElement";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClassName";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTypeSubstitutor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameterDefaultType";
                break;
            }
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "inferGenericTypesForCall";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectGenerics";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "inferGenericArgumentsFromCall";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateGenericsFromQualifier";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "findTypeArgumentsForClassInHierarchy";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "applyTypeSubstitutorUpToParentClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeSubstitutor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 35: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterDefaultType";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "inferGenericTypesForCall";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "intersectTypes";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "matchGenericTypes";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "evaluateGenericsFromQualifier";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findTypeArgumentsForClassInHierarchy";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "applyTypeSubstitutorUpToParentClass";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getTypeArgumentsMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface GenericErrorReporter {
        public void error(String var1);
    }
}

