/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSModuleElementsProcessor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptModuleDeclarationsProcessor;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.ES6QualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.processors.JSModuleElementsResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSQualifiedNameResolver {
    @NotNull
    protected abstract JSQualifiedNameResolver createNestedResolver(@NotNull PsiElement var1);

    @NotNull
    public abstract Collection<PsiElement> resolveQualifiedName(@NotNull String var1);

    protected boolean isStrictTypeContext() {
        return false;
    }

    @NotNull
    protected final Collection<PsiElement> expandElement(@NotNull PsiElement element) {
        if (element == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(0);
        }
        if (element instanceof TypeScriptImportStatement) {
            Collection<PsiElement> rawElements;
            Collection<PsiElement> elements;
            TypeScriptExternalModuleReference externalModuleReference = ((TypeScriptImportStatement)element).getExternalModuleReference();
            TypeScriptEntityName internalModuleReference = ((TypeScriptImportStatement)element).getInternalModuleReference();
            if (externalModuleReference != null) {
                Collection resolveResults = externalModuleReference.multiResolve();
                Collection<PsiElement> collection = this.processExternalModules(resolveResults);
                if (collection == null) {
                    JSQualifiedNameResolver.$$$reportNull$$$0(1);
                }
                return collection;
            }
            if (internalModuleReference != null && !(elements = this.processWithResolveImportReferences(rawElements = JSResolveResult.toElements(internalModuleReference.multiResolve(false)), ContainerUtil.newHashSet())).isEmpty()) {
                Collection<PsiElement> collection = elements;
                if (collection == null) {
                    JSQualifiedNameResolver.$$$reportNull$$$0(2);
                }
                return collection;
            }
        } else if (JSQualifiedNameResolver.isImport(element)) {
            Collection<PsiElement> resolvedImports = this.resolveImport(element, ContainerUtil.newHashSet());
            if (!resolvedImports.isEmpty()) {
                Collection<PsiElement> collection = resolvedImports;
                if (collection == null) {
                    JSQualifiedNameResolver.$$$reportNull$$$0(3);
                }
                return collection;
            }
        } else if (element instanceof TypeScriptGlobalModuleExportDeclaration) {
            Collection<PsiElement> collection = this.processExternalModules(((TypeScriptGlobalModuleExportDeclaration)element).getModules());
            if (collection == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(4);
            }
            return collection;
        }
        List<PsiElement> list = Collections.singletonList(element);
        if (list == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private Collection<PsiElement> processWithResolveImportReferences(@NotNull Collection<? extends PsiElement> elements, @Nullable Set<PsiElement> visited) {
        if (elements == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(6);
        }
        if (elements.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(7);
            }
            return list;
        }
        List result = ContainerUtil.newSmartList();
        for (PsiElement psiElement : elements) {
            if (JSQualifiedNameResolver.isImport(psiElement)) {
                Collection<PsiElement> resolved = this.resolveImport(psiElement, visited);
                result.addAll(resolved);
                continue;
            }
            result.add(psiElement);
        }
        List list = result;
        if (list == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static boolean isImport(@Nullable PsiElement element) {
        return element instanceof ES6ImportExportSpecifier || element instanceof ES6ImportedBinding || element instanceof TypeScriptImportStatement || element instanceof ES6ImportExportSpecifierAlias || element instanceof JSExportAssignment;
    }

    @NotNull
    private Collection<PsiElement> processExternalModules(@NotNull Collection<PsiElement> modules) {
        if (modules == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(9);
        }
        if (modules.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(10);
            }
            return list;
        }
        List result = ContainerUtil.newSmartList();
        for (PsiElement element : modules) {
            TypeScriptExportAssignment exportAssignment;
            if (TypeScriptPsiUtil.isTopLevelContainer(element) && (exportAssignment = TypeScriptPsiUtil.findExportAssignment(element)) != null) {
                result.addAll(this.processAssignExpression((JSExportAssignment)exportAssignment));
                continue;
            }
            result.add(element);
        }
        List list = result;
        if (list == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    private Collection<PsiElement> processAssignExpression(@NotNull JSExportAssignment assignment) {
        JSElement candidate;
        String referenceName;
        if (assignment == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(12);
        }
        if ((referenceName = assignment.getInitializerReference()) != null) {
            JSQualifiedNameResolver resolver = this.createNestedResolver((PsiElement)assignment);
            Collection<PsiElement> collection = this.processWithResolveImportReferences(resolver.resolveQualifiedName(referenceName), ContainerUtil.newHashSet());
            if (collection == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(13);
            }
            return collection;
        }
        JSElement stubElement = assignment.getStubSafeElement();
        Object object = candidate = stubElement == null ? assignment.getExpression() : stubElement;
        if (candidate instanceof JSClass) {
            List<JSElement> list = Collections.singletonList(candidate);
            if (list == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(14);
            }
            return list;
        }
        if (candidate instanceof JSReferenceExpression) {
            Collection<PsiElement> collection = this.processWithResolveImportReferences(JSResolveResult.toElements(((JSReferenceExpression)candidate).multiResolve(false)), null);
            if (collection == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(15);
            }
            return collection;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    protected final Collection<PsiElement> resolveImport(@NotNull PsiElement element, @Nullable Set<PsiElement> visited) {
        if (element == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(17);
        }
        if (visited != null && !visited.add(element)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(18);
            }
            return list;
        }
        if (element instanceof TypeScriptImportStatement) {
            Collection<PsiElement> collection = this.processWithResolveImportReferences(((TypeScriptImportStatement)element).findReferencedElements(), visited);
            if (collection == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(19);
            }
            return collection;
        }
        if (element instanceof ES6ImportExportSpecifier) {
            Collection<PsiElement> collection = this.processWithResolveImportReferences(JSResolveResult.toElements(((ES6ImportExportSpecifier)element).resolveOverAliases()), visited);
            if (collection == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(20);
            }
            return collection;
        }
        if (element instanceof ES6ImportedBinding) {
            Collection<PsiElement> collection = this.processWithResolveImportReferences(((ES6ImportedBinding)element).findReferencedElements(), visited);
            if (collection == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(21);
            }
            return collection;
        }
        if (element instanceof ES6ImportExportSpecifierAlias) {
            ES6ImportExportSpecifier specifier = ((ES6ImportExportSpecifierAlias)element).findSpecifierElement();
            if (specifier != null) {
                Collection<PsiElement> collection = this.processWithResolveImportReferences(JSResolveResult.toElements(specifier.resolveOverAliases()), visited);
                if (collection == null) {
                    JSQualifiedNameResolver.$$$reportNull$$$0(22);
                }
                return collection;
            }
        } else if (element instanceof JSExportAssignment) {
            Collection<PsiElement> collection = this.processAssignExpression((JSExportAssignment)element);
            if (collection == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(23);
            }
            return collection;
        }
        List<PsiElement> list = Collections.singletonList(element);
        if (list == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(24);
        }
        return list;
    }

    @NotNull
    protected final Collection<? extends PsiElement> getLocalElements(@NotNull String name, @NotNull PsiElement scopeElement, @Nullable PsiElement parentScopeElement, boolean isQualifier) {
        if (name == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(25);
        }
        if (scopeElement == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(26);
        }
        PsiElement module = ES6PsiUtil.getNonStrictExportScope(scopeElement);
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        if (!(module instanceof JSElement)) {
            LinkedHashSet linkedHashSet = result;
            if (linkedHashSet == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(27);
            }
            return linkedHashSet;
        }
        PsiElement realPlace = parentScopeElement == null ? scopeElement : parentScopeElement;
        TypeScriptModuleDeclarationsProcessor processor = ES6QualifiedNameResolver.createProcessor(name, this.isStrictTypeContext(), true);
        JSQualifiedNameResolver.processES6DeclarationsInScope((JSElement)module, processor, ResolveState.initial(), module, realPlace, !isQualifier);
        List list = ContainerUtil.notNullize(processor.getResults());
        if (list == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(28);
        }
        return list;
    }

    public static boolean processES6DeclarationsInScope(@NotNull JSElement scope, final @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place, final boolean includeExportSpecifiers) {
        JSResolveProcessorBase delegatingProcessor;
        if (scope == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(29);
        }
        if (processor == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(30);
        }
        if (state == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(31);
        }
        if (place == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(32);
        }
        if (!JSResolveUtil.processDeclarationsInScope(scope, delegatingProcessor = new JSResolveProcessorBase(processor){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!includeExportSpecifiers && element instanceof ES6ExportSpecifier) {
                    return true;
                }
                return processor.execute(element, state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, state, lastParent, place)) {
            return false;
        }
        JSModuleElementsProcessor moduleElementsProcessor = processor instanceof JSModuleElementsResolveProcessor ? (JSModuleElementsProcessor)processor : new JSModuleElementsResolveProcessor(processor){

            @Override
            @Nullable
            public String getName() {
                return processor instanceof JSResolveProcessor ? ((JSResolveProcessor)processor).getName() : null;
            }

            @Override
            public void process(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext, PsiElement source) {
                if (type == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (evaluateContext == null) {
                    2.$$$reportNull$$$0(1);
                }
            }

            @Override
            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (state == null) {
                    2.$$$reportNull$$$0(3);
                }
                return processor.execute(element, state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "evaluateContext";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "state";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "process";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "execute";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        return ES6PsiUtil.processExportAllDeclarations(scope, place, moduleElementsProcessor, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElement";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "expandElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "processWithResolveImportReferences";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "processExternalModules";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "processAssignExpression";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveImport";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "expandElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processWithResolveImportReferences";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processExternalModules";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processAssignExpression";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveImport";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getLocalElements";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "processES6DeclarationsInScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

