/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.lang.ecmascript6.ES6FileType;
import com.intellij.lang.ecmascript6.JSXHarmonyFileType;
import com.intellij.lang.javascript.FlowJSFileType;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.index.IndexedFileTypeProvider;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.psi.resolve.JSElementResolveScopeProvider;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaScriptResolveScopeProvider
extends JSElementResolveScopeProvider {
    private static final Set<FileType> myExpandedScopeFileTypes;

    public GlobalSearchScope getResolveScope(@NotNull VirtualFile file, Project project) {
        if (file == null) {
            JavaScriptResolveScopeProvider.$$$reportNull$$$0(0);
        }
        if (!this.isApplicable(file)) {
            return null;
        }
        return this.getProjectAndLibrariesScope(file, project);
    }

    public GlobalSearchScope getProjectAndLibrariesScope(@NotNull VirtualFile file, Project project) {
        Module module;
        if (file == null) {
            JavaScriptResolveScopeProvider.$$$reportNull$$$0(1);
        }
        if ((module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(file)) == null) {
            return this.getProjectScopeIncludingPredefines(project);
        }
        GlobalSearchScope scopeExcludingJsLibs = (GlobalSearchScope)((CachedValue)JSResolveUtil.ourScopeCache.get((UserDataHolder)module, null)).getValue();
        GlobalSearchScope libraryFilesScope = JSLibraryMappings.getInstance(project).getLibraryScopeForFile(file);
        return scopeExcludingJsLibs.uniteWith(libraryFilesScope);
    }

    @Override
    @NotNull
    public GlobalSearchScope getElementResolveScope(@NotNull PsiElement element) {
        VirtualFile virtualFile;
        if (element == null) {
            JavaScriptResolveScopeProvider.$$$reportNull$$$0(2);
        }
        Project project = element.getProject();
        PsiFile psiFile = element.getContainingFile();
        if (psiFile != null && (virtualFile = psiFile.getOriginalFile().getVirtualFile()) != null) {
            GlobalSearchScope defaultResolveScope = ResolveScopeManager.getInstance((Project)project).getDefaultResolveScope(virtualFile);
            GlobalSearchScope globalSearchScope = this.isApplicable(virtualFile) ? defaultResolveScope : defaultResolveScope.uniteWith(this.getProjectAndLibrariesScope(virtualFile, project));
            if (globalSearchScope == null) {
                JavaScriptResolveScopeProvider.$$$reportNull$$$0(3);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = this.getProjectScopeIncludingPredefines(project);
        if (globalSearchScope == null) {
            JavaScriptResolveScopeProvider.$$$reportNull$$$0(4);
        }
        return globalSearchScope;
    }

    @Override
    public boolean isApplicable(@NotNull VirtualFile file) {
        if (file == null) {
            JavaScriptResolveScopeProvider.$$$reportNull$$$0(5);
        }
        return myExpandedScopeFileTypes.contains(file.getFileType());
    }

    static {
        IndexedFileTypeProvider[] extensions;
        THashSet expandedScopeFileTypes = new THashSet(4);
        expandedScopeFileTypes.add(JavaScriptSupportLoader.JAVASCRIPT);
        expandedScopeFileTypes.add(ES6FileType.INSTANCE);
        expandedScopeFileTypes.add(FlowJSFileType.INSTANCE);
        expandedScopeFileTypes.add(HtmlFileType.INSTANCE);
        expandedScopeFileTypes.add(JSXHarmonyFileType.INSTANCE);
        for (IndexedFileTypeProvider iftp : extensions = (IndexedFileTypeProvider[])Extensions.getExtensions(IndexedFileTypeProvider.EP_NAME)) {
            Collections.addAll(expandedScopeFileTypes, iftp.getFileTypesToIndex());
        }
        myExpandedScopeFileTypes = expandedScopeFileTypes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JavaScriptResolveScopeProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JavaScriptResolveScopeProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementResolveScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResolveScope";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getProjectAndLibrariesScope";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElementResolveScope";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

