/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSymbolNamespace;
import com.intellij.lang.javascript.psi.JSSymbolNamespaceImpl;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSCompletionPlaceFilter;
import com.intellij.lang.javascript.psi.resolve.JSCompletionProcessor;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTaggedResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeInfo;
import com.intellij.lang.javascript.psi.resolve.JSVariantRecordTypeConverter;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSMixinTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.refactoring.BasicJavascriptNamesValidator;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariantsProcessor
extends BaseJSSymbolProcessor
implements JSCompletionProcessor {
    private static final Key<Boolean> ALL_ELEMENTS_ARE_FUNCTIONS = Key.create((String)"js.all.elements.are.functions");
    private static final Key<Boolean> ALL_FUNCTIONS_HAS_NO_PARAMETERS = Key.create((String)"js.all.functions.has.no.parameters");
    private static final Key<Boolean> HAS_BOLD_ELEMENT = Key.create((String)"js.has.bold.element");
    private static final Key<Boolean> CONTEXT_MATCHES = Key.create((String)"js.lookup.element.context.matches");
    private final MultiMap<String, LookupElement> myResults;
    private final Set<JSQualifiedName> myNeighbourReferences;
    private final Set<String> myPopulatedResultsNames;
    private final boolean hasSomeSmartnessAvailable;
    private final boolean myProcessOnlyProperties;
    private final boolean myProcessOnlyTypes;
    private final JSCompletionPlaceFilter myPlaceFilter;
    private final int myLimit;
    @Nullable
    private final String myReferencedParameterName;
    @Nullable
    private final PsiElement myOriginalElement;
    private final boolean myContextIsPropertyOfConstructorParameter;
    private final PrefixMatcher myPrefixMatcher;

    public VariantsProcessor(@NotNull PsiFile targetFile, @NotNull PsiElement context, @NotNull CompletionResultSet resultSet) {
        if (targetFile == null) {
            VariantsProcessor.$$$reportNull$$$0(0);
        }
        if (context == null) {
            VariantsProcessor.$$$reportNull$$$0(1);
        }
        if (resultSet == null) {
            VariantsProcessor.$$$reportNull$$$0(2);
        }
        this(targetFile, context, false, resultSet);
    }

    public VariantsProcessor(@NotNull PsiFile targetFile, @NotNull PsiElement context, boolean onlyTypeBased, @NotNull CompletionResultSet resultSet) {
        if (targetFile == null) {
            VariantsProcessor.$$$reportNull$$$0(3);
        }
        if (context == null) {
            VariantsProcessor.$$$reportNull$$$0(4);
        }
        if (resultSet == null) {
            VariantsProcessor.$$$reportNull$$$0(5);
        }
        super(targetFile.getOriginalFile(), context);
        this.myResults = MultiMap.create();
        this.myNeighbourReferences = new THashSet();
        this.myPopulatedResultsNames = new THashSet();
        this.myLimit = Registry.intValue((String)"ide.completion.variant.limit") / 2;
        this.myContextIsPropertyOfConstructorParameter = VariantsProcessor.initContextIsPropertyOfConstructorParameter(context);
        this.myPrefixMatcher = resultSet.getPrefixMatcher();
        boolean processOnlyTypes = false;
        this.myCurrentFile = targetFile.getOriginalFile() == targetFile ? null : targetFile.getOriginalFile().getVirtualFile();
        JSClass jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)context, JSClass.class);
        if (onlyTypeBased) {
            this.forceSetAddOnlyCompleteMatches();
        }
        String referencedParameterName = null;
        if (context instanceof JSReferenceExpression) {
            JSExpression qualifier;
            JSParameterItem parameter;
            JSReferenceExpression refExpr = (JSReferenceExpression)context;
            PsiElement parent = refExpr.getParent();
            if (parent instanceof JSArgumentList && (parameter = JSResolveUtil.findParameterForUsedArgument((JSExpression)refExpr, (JSArgumentList)parent)) != null) {
                referencedParameterName = parameter.getName();
            }
            if ((qualifier = refExpr.getQualifier()) != null) {
                JSNamespaceEvaluationResult namespace;
                if (qualifier instanceof JSThisExpression || qualifier instanceof JSSuperExpression) {
                    if (jsClass != null) {
                        this.forceSetAddOnlyCompleteMatches();
                        this.updateCanUseOnlyCompleteMatches(jsClass);
                    } else if (JSResolveUtil.getTypeFromTagNameInMxml(this.myTargetFile.getContext()) != null) {
                        this.forceSetAddOnlyCompleteMatches();
                    }
                }
                CompletionTypeProcessor processor = new CompletionTypeProcessor();
                JSTypeEvaluator.evaluateTypes(VariantsProcessor.getOriginalQualifier(qualifier), processor);
                if (processor.strictlyTyped) {
                    this.forceSetAddOnlyCompleteMatches();
                }
                if (!processor.getAllTypesResolved() && (namespace = JSSymbolUtil.evaluateNamespaceLocally(qualifier)) != null) {
                    this.myTypeInfo.addNamespace(namespace, false);
                }
            } else if (JSResolveUtil.isExprInTypeContext(refExpr) || this.ecmal4 && JSResolveUtil.isInPlaceWhereTypeCanBeDuringCompletion((PsiElement)refExpr)) {
                this.forceSetAddOnlyCompleteMatches();
                processOnlyTypes = true;
                this.addPackageScope(jsClass, (PsiElement)refExpr);
            }
        } else if (context instanceof JSProperty) {
            String qName;
            JSRecordType recordType;
            JSObjectLiteralExpression objLiteral = (JSObjectLiteralExpression)context.getParent();
            JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)objLiteral);
            if (expectedType instanceof JSTypeImpl) {
                expectedType = JSTypeUtils.getValuableType(expectedType);
            }
            if ((recordType = JSVariantRecordTypeConverter.getTypeAsRecord(expectedType, context)) != null) {
                this.myTypeInfo.addRecordType(recordType);
                this.forceSetAddOnlyCompleteMatches();
            } else if (expectedType instanceof JSNamedType && (qName = JSTypeUtils.getQualifiedNameMatchingType(expectedType, true)) != null) {
                JSNamespaceImpl namespace = VariantsProcessor.createNamespaceForNamedType((JSNamedType)expectedType, qName);
                this.myTypeInfo.addType(namespace, true);
            }
            JSSymbolNamespace guessedNs = VariantsProcessor.guessNamespaceFromProperty((JSProperty)context);
            if (guessedNs != null) {
                this.addTypeHierarchy((JSNamespace)guessedNs, null);
            }
        } else if (context instanceof JSDocTagValue) {
            processOnlyTypes = true;
        } else if (context instanceof JSDestructuringProperty) {
            PsiElement parent = context.getParent();
            JSTypeEvaluator.evaluateExpressionOrElementTypes(this.myTargetFile, new CompletionTypeProcessor(), parent, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
        }
        this.myProcessOnlyTypes = processOnlyTypes;
        this.myPlaceFilter = JSCompletionPlaceFilter.forPlace(context);
        boolean bl = this.myProcessOnlyProperties = context instanceof JSProperty && !this.myContextIsPropertyOfConstructorParameter;
        if (this.myTypeInfo.typeWasProcessed() && !this.myContextIsPropertyOfConstructorParameter && !this.myProcessOnlyProperties) {
            this.myTypeInfo.addBaseObjectType();
        }
        this.hasSomeSmartnessAvailable = this.myTypeInfo.hasExplicitNamespace();
        this.myOriginalElement = CompletionUtil.getOriginalElement((PsiElement)context);
        this.myReferencedParameterName = referencedParameterName;
        this.initCheckFileLevelAccess();
    }

    private static boolean initContextIsPropertyOfConstructorParameter(PsiElement context) {
        if (!(context instanceof JSProperty)) {
            return false;
        }
        PsiElement argList = context.getParent().getParent();
        if (!(argList instanceof JSArgumentList)) {
            return false;
        }
        PsiElement callExpr = argList.getParent();
        if (!(callExpr instanceof JSCallExpression)) {
            return false;
        }
        JSExpression methodExpression = ((JSCallExpression)callExpr).getMethodExpression();
        return methodExpression instanceof JSReferenceExpression;
    }

    @NotNull
    private static JSNamespaceImpl createNamespaceForNamedType(@NotNull JSNamedType expectedType, @NotNull String qName) {
        if (expectedType == null) {
            VariantsProcessor.$$$reportNull$$$0(6);
        }
        if (qName == null) {
            VariantsProcessor.$$$reportNull$$$0(7);
        }
        JSContext staticOrInstance = expectedType.isStaticOrInstance();
        boolean isExplicitlyDeclared = expectedType.getSource().isExplicitlyDeclared();
        JSNamespaceImpl jSNamespaceImpl = new JSNamespaceImpl(JSQualifiedNameImpl.fromQualifiedName(qName), staticOrInstance, isExplicitlyDeclared);
        if (jSNamespaceImpl == null) {
            VariantsProcessor.$$$reportNull$$$0(8);
        }
        return jSNamespaceImpl;
    }

    @Override
    @NotNull
    protected JSTypeInfo createTypeInfo() {
        JSTypeInfo jSTypeInfo = new JSTypeInfo(){

            @Override
            public void addNamespace(@NotNull JSNamespace namespace, boolean isTopClassInHierarchy, PsiFile jsModule) {
                if (namespace == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (VariantsProcessor.this.myContextIsPropertyOfConstructorParameter) {
                    JSParameterItem matchedParameter;
                    PsiElement grandParent;
                    JSQualifiedName qualifiedName = namespace.getQualifiedName();
                    qualifiedName = JSQualifiedNameImpl.create("options", qualifiedName);
                    namespace = new JSNamespaceImpl(qualifiedName, namespace.getJSContext(), namespace.isExplicitlyDeclared());
                    PsiElement parent = VariantsProcessor.this.myContext.getParent();
                    if (parent instanceof JSExpression && (grandParent = parent.getParent()) instanceof JSArgumentList && (matchedParameter = JSResolveUtil.findParameterForUsedArgument((JSExpression)parent, (JSArgumentList)grandParent)) != null && matchedParameter.getName() != null) {
                        qualifiedName = JSQualifiedNameImpl.create(matchedParameter.getName(), qualifiedName);
                        JSNamespaceImpl paramNs = new JSNamespaceImpl(qualifiedName, namespace.getJSContext(), namespace.isExplicitlyDeclared());
                        super.addNamespace(paramNs, isTopClassInHierarchy, jsModule);
                    }
                }
                super.addNamespace(namespace, isTopClassInHierarchy, jsModule);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor$1", "addNamespace"));
            }
        };
        if (jSTypeInfo == null) {
            VariantsProcessor.$$$reportNull$$$0(9);
        }
        return jSTypeInfo;
    }

    private void updateCanUseOnlyCompleteMatches(JSClass jsClass) {
        JSAttributeList attributeList;
        JSAttributeList jSAttributeList = attributeList = jsClass != null ? jsClass.getAttributeList() : null;
        if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.DYNAMIC)) {
            this.myAddOnlyCompleteMatches = false;
        }
    }

    public void populateCompletionList(Collection<? extends LookupElement> resultsAsObjects, boolean keepOverloads, @NotNull CompletionResultSet resultSet) {
        if (resultSet == null) {
            VariantsProcessor.$$$reportNull$$$0(10);
        }
        if (resultsAsObjects == null) {
            return;
        }
        for (LookupElement lookupElement : resultsAsObjects) {
            if (!this.myPopulatedResultsNames.add(lookupElement.getLookupString()) && !keepOverloads) continue;
            resultSet.addElement(lookupElement);
        }
    }

    public void collectReferencesUsedInCurrentScope(final PsiElement reference, final boolean qualified) {
        JSExecutionScope scope = (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)reference, JSExecutionScope.class);
        assert (scope != null) : reference.getContainingFile().getName();
        new JSRecursiveElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                JSQualifiedName name;
                if (node != reference && node.getQualifier() != null == qualified && (name = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)node)) != null) {
                    VariantsProcessor.this.myNeighbourReferences.add(name);
                }
                super.visitJSReferenceExpression(node);
            }

            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
            }

            public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                if (node == null) {
                    2.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/VariantsProcessor$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionDeclaration";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.visitElement((PsiElement)scope);
    }

    @Override
    protected boolean isStrictTypingPossible(PsiElement source, @NotNull JSType type) {
        if (type == null) {
            VariantsProcessor.$$$reportNull$$$0(11);
        }
        if (type.getSource().isExplicitlyDeclared()) {
            source = JSTypeEvaluator.EXPLICIT_TYPE_MARKER_ELEMENT;
        }
        return super.isStrictTypingPossible(source, type);
    }

    @Override
    protected void addGenericArguments(@NotNull JSNamespace namespace, @NotNull List<JSNamespace> parentClasses) {
        JSTypeSubstitutor genericArguments;
        if (namespace == null) {
            VariantsProcessor.$$$reportNull$$$0(12);
        }
        if (parentClasses == null) {
            VariantsProcessor.$$$reportNull$$$0(13);
        }
        if ((genericArguments = (JSTypeSubstitutor)namespace.getUserData(JSNamespace.GENERIC_ARGUMENTS_KEY)) != null && !genericArguments.isEmpty()) {
            for (JSNamespace parentClass : parentClasses) {
                JSQualifiedName parentClassQName = parentClass.getQualifiedName();
                assert (parentClassQName != null);
                JSQualifiedName namespaceQName = namespace.getQualifiedName();
                assert (namespaceQName != null);
                JSTypeSubstitutor parentClassTypeSubstitutor = JSGenericTypesEvaluator.applyTypeSubstitutorUpToParentClass(namespaceQName.getQualifiedName(), parentClassQName.getQualifiedName(), this.myContext, genericArguments);
                parentClass.putUserData(JSNamespace.GENERIC_ARGUMENTS_KEY, (Object)parentClassTypeSubstitutor);
            }
        }
    }

    public void addNeighbourReferences(boolean onlyApplyPriority) {
        for (JSQualifiedName neighbourReference : this.myNeighbourReferences) {
            if (!this.myTypeInfo.hasMatchedNamespace(neighbourReference.getParent(), JSContext.STATIC)) continue;
            String name = neighbourReference.getName();
            Collection elements = this.myResults.get((Object)name);
            if (!elements.isEmpty()) {
                for (LookupElement element : elements) {
                    if (!(element instanceof LookupItem)) continue;
                    int neighborPriority = JSLookupPriority.NEIGHBOUR_REFERENCES_PRIORITY.getPriorityValue();
                    double itemPriority = ((LookupItem)element).getPriority();
                    int neighborProximity = JSLookupPriority.NEIGHBOUR_REFERENCES_PRIORITY.getProximityValue();
                    Integer itemProximity = (Integer)element.getUserData(JSLookupPriority.EXPLICIT_PROXIMITY_KEY);
                    if (!((double)neighborPriority > itemPriority) && ((double)neighborPriority != itemPriority || itemProximity == null || neighborProximity <= itemProximity)) continue;
                    JSCompletionUtil.setJSLookupPriority((LookupItem)element, JSLookupPriority.NEIGHBOUR_REFERENCES_PRIORITY);
                }
                continue;
            }
            if (onlyApplyPriority) continue;
            LookupElementBuilder element = LookupElementBuilder.create((String)name);
            element = JSCompletionUtil.withJSLookupPriority((LookupElement)element, JSLookupPriority.NEIGHBOUR_REFERENCES_PRIORITY);
            this.myResults.putValue((Object)name, (Object)element);
        }
    }

    private void buildSeveralDefinitionsElements() {
        for (Map.Entry entry : this.myResults.entrySet()) {
            Boolean function;
            Collection value = (Collection)entry.getValue();
            LookupElement element = value.isEmpty() ? null : (LookupElement)value.iterator().next();
            if (!(element instanceof LookupElementBuilder)) continue;
            Integer priority = (Integer)element.getUserData(JSCompletionUtil.PRIORITY);
            Integer proximity = (Integer)element.getUserData(JSCompletionUtil.PROXIMITY);
            if (priority == null || proximity == null) continue;
            LookupElementBuilder lookupItem = (LookupElementBuilder)element;
            Boolean bold = (Boolean)element.getUserData(HAS_BOLD_ELEMENT);
            if (bold != null && bold.booleanValue()) {
                lookupItem = lookupItem.withBoldness(true);
            }
            if (Boolean.TRUE.equals(function = (Boolean)element.getUserData(ALL_ELEMENTS_ARE_FUNCTIONS))) {
                lookupItem = lookupItem.withInsertHandler(JSInsertHandler.DEFAULT).withTailText("()");
                JSInsertHandler.ForcedCompleteFunctionType completeFunctionType = Boolean.TRUE.equals(element.getUserData(ALL_FUNCTIONS_HAS_NO_PARAMETERS)) ? JSInsertHandler.ForcedCompleteFunctionType.EMPTY_PARAMETERS : JSInsertHandler.ForcedCompleteFunctionType.WITH_PARAMETERS;
                lookupItem.putUserData(JSInsertHandler.FORCED_COMPLETE_FUNCTION, (Object)completeFunctionType);
            }
            LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)lookupItem, (double)priority.intValue());
            lookupElement = PrioritizedLookupElement.withExplicitProximity((LookupElement)lookupElement, (int)proximity);
            entry.setValue(Collections.singleton(lookupElement));
        }
    }

    private boolean addResult(@NotNull String name, @NotNull LookupElement element) {
        boolean isLookupItem;
        Collection elements;
        if (name == null) {
            VariantsProcessor.$$$reportNull$$$0(14);
        }
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(15);
        }
        LookupElement firstStoredElement = (elements = this.myResults.get((Object)name)).isEmpty() ? null : (LookupElement)elements.iterator().next();
        boolean bl = isLookupItem = element instanceof LookupItem || element instanceof PrioritizedLookupElement;
        if (firstStoredElement == null || !isLookupItem) {
            this.myResults.putValue((Object)name, (Object)element);
            return this.checkLimit();
        }
        boolean keepCompleteMatchedOverloads = this.typescript;
        double itemPriority = JSCompletionUtil.getLookupElementPriority(element);
        int itemProximity = JSCompletionUtil.getLookupElementProximity(element);
        if (keepCompleteMatchedOverloads && VariantsProcessor.wasCompleteMatch(itemPriority)) {
            this.myResults.putValue((Object)name, (Object)element);
            return this.checkLimit();
        }
        PsiElement lookupItemElement = element.getPsiElement();
        PsiElement storedLookupItemElement = firstStoredElement.getPsiElement();
        double storedItemPriority = JSCompletionUtil.getLookupElementPriority(firstStoredElement);
        int storedItemProximity = JSCompletionUtil.getLookupElementProximity(firstStoredElement);
        if (itemPriority == storedItemPriority && itemProximity == storedItemProximity) {
            boolean currentIsProperty = VariantsProcessor.isPropertyWithFunctionInitializer(lookupItemElement);
            boolean storedIsProperty = VariantsProcessor.isPropertyWithFunctionInitializer(storedLookupItemElement);
            if (currentIsProperty && !storedIsProperty) {
                storedItemPriority -= 1.0;
            } else if (!currentIsProperty && storedIsProperty) {
                itemPriority -= 1.0;
            }
            boolean currentContextMatches = Boolean.TRUE.equals(element.getUserData(CONTEXT_MATCHES));
            boolean storedContextMatches = Boolean.TRUE.equals(firstStoredElement.getUserData(CONTEXT_MATCHES));
            if (currentContextMatches && !storedContextMatches) {
                storedItemPriority -= 1.0;
            } else if (!currentContextMatches && storedContextMatches) {
                itemPriority -= 1.0;
            }
        }
        if (itemPriority == storedItemPriority && itemProximity == storedItemProximity) {
            EnumSet<JSTaggedResolveResult.ResolveResultTag> itemTags = EnumSet.noneOf(JSTaggedResolveResult.ResolveResultTag.class);
            this.addResolveResultTags(itemTags, lookupItemElement);
            EnumSet<JSTaggedResolveResult.ResolveResultTag> storedItemTags = EnumSet.noneOf(JSTaggedResolveResult.ResolveResultTag.class);
            this.addResolveResultTags(storedItemTags, storedLookupItemElement);
            itemPriority -= (double)JSTaggedResolveResult.comparePriorities(itemTags, storedItemTags);
        }
        if (itemPriority == storedItemPriority && itemProximity == storedItemProximity) {
            boolean itemIsBold;
            if (element.equals(firstStoredElement)) {
                return true;
            }
            boolean bl2 = itemIsBold = element instanceof LookupItem && ((LookupItem)element).isBold();
            if (firstStoredElement instanceof LookupItem) {
                LookupElementBuilder mergedElement = LookupElementBuilder.create((String)name).withTypeText(JSBundle.message((String)"javascript.completion.several.definitions", (Object[])new Object[0]), true);
                mergedElement.putUserData(JSCompletionUtil.PRIORITY, (Object)((int)itemPriority));
                mergedElement.putUserData(JSCompletionUtil.PROXIMITY, (Object)itemProximity);
                mergedElement.putUserData(HAS_BOLD_ELEMENT, (Object)(itemIsBold || ((LookupItem)firstStoredElement).isBold() ? 1 : 0));
                JSFunction firstPossibleFunction = JSPsiImplUtils.getPossibleFunction(lookupItemElement);
                JSFunction secondPossibleFunction = JSPsiImplUtils.getPossibleFunction(storedLookupItemElement);
                boolean bothAreFunctions = firstPossibleFunction != null && secondPossibleFunction != null;
                mergedElement.putUserData(ALL_ELEMENTS_ARE_FUNCTIONS, (Object)bothAreFunctions);
                if (bothAreFunctions) {
                    mergedElement.putUserData(ALL_FUNCTIONS_HAS_NO_PARAMETERS, (Object)(firstPossibleFunction.getParameters().length == 0 && secondPossibleFunction.getParameters().length == 0 ? 1 : 0));
                }
                this.myResults.remove((Object)name);
                this.myResults.putValue((Object)name, (Object)mergedElement);
            } else if (storedLookupItemElement == null) {
                if (firstStoredElement.getUserData(ALL_ELEMENTS_ARE_FUNCTIONS) == Boolean.TRUE) {
                    JSFunction possibleFunction = JSPsiImplUtils.getPossibleFunction(lookupItemElement);
                    if (possibleFunction == null) {
                        firstStoredElement.putUserData(ALL_ELEMENTS_ARE_FUNCTIONS, (Object)Boolean.FALSE);
                    } else if (possibleFunction.getParameters().length > 0) {
                        firstStoredElement.putUserData(ALL_FUNCTIONS_HAS_NO_PARAMETERS, (Object)Boolean.FALSE);
                    }
                }
                if (firstStoredElement.getUserData(HAS_BOLD_ELEMENT) != Boolean.TRUE && itemIsBold) {
                    firstStoredElement.putUserData(HAS_BOLD_ELEMENT, (Object)Boolean.TRUE);
                }
            }
        } else if (itemPriority > storedItemPriority || itemPriority == storedItemPriority && itemProximity > storedItemProximity) {
            this.myResults.remove((Object)name);
            this.myResults.putValue((Object)name, (Object)element);
        }
        return this.checkLimit();
    }

    public List<LookupElement> getResults(String qualifiedNameToSkip) {
        this.addNeighbourReferences(false);
        this.buildSeveralDefinitionsElements();
        ArrayList<LookupElement> results = new ArrayList<LookupElement>(this.myResults.size());
        for (LookupElement element : this.myResults.values()) {
            VariantsProcessor.addVariant(qualifiedNameToSkip, results, element);
        }
        return results;
    }

    private static void addVariant(String qualifiedNameToSkip, List<LookupElement> results, LookupElement o) {
        if (qualifiedNameToSkip == null || !qualifiedNameToSkip.equals(o.getLookupString())) {
            results.add(o);
        }
    }

    @NotNull
    public Collection<? extends LookupElement> getCurrentResults() {
        this.addNeighbourReferences(true);
        this.buildSeveralDefinitionsElements();
        Collection collection = this.myResults.values();
        if (collection == null) {
            VariantsProcessor.$$$reportNull$$$0(16);
        }
        return collection;
    }

    public Collection<? extends LookupElement> getFinalResults() {
        List<LookupElement> recordTypesElements = this.createElementsFromRecordTypes();
        for (LookupElement recordTypesElement : recordTypesElements) {
            this.addResult(recordTypesElement.getLookupString(), recordTypesElement);
        }
        this.addNeighbourReferences(false);
        this.buildSeveralDefinitionsElements();
        return this.myResults.values();
    }

    @NotNull
    private List<LookupElement> createElementsFromRecordTypes() {
        if (this.myTypeInfo.myRecordTypes == null) {
            List<LookupElement> list = Collections.emptyList();
            if (list == null) {
                VariantsProcessor.$$$reportNull$$$0(17);
            }
            return list;
        }
        SmartList result = new SmartList();
        for (JSRecordType recordType : this.myTypeInfo.myRecordTypes) {
            Collection elements;
            JSElementIndexingData indexingData;
            PsiElement element = recordType.getSource().getSourceElement();
            THashMap implicitElements = new THashMap();
            if (element instanceof JSImplicitElementProvider && (indexingData = ((JSImplicitElementProvider)element).getIndexingData()) != null && (elements = indexingData.getImplicitElements()) != null) {
                for (JSImplicitElement implicitElement : elements) {
                    JSQualifiedName parentNamespace;
                    JSQualifiedName namespace = implicitElement.getNamespace();
                    if (namespace == null || (parentNamespace = namespace.getParent()) == null || !"options".equals(parentNamespace.getName())) continue;
                    implicitElements.put(implicitElement.getName(), implicitElement);
                }
            }
            for (JSRecordType.TypeMember member : recordType.getTypeMembers()) {
                if (!(member instanceof JSRecordType.PropertySignature)) continue;
                String name = JSSymbolUtil.handleSpecialPropertyNames(((JSRecordType.PropertySignature)member).getMemberName(), JSCodeStyleSettings.getQuoteChar((PsiElement)this.myTargetFile));
                JSType type = ((JSRecordType.PropertySignature)member).getType();
                String typeString = type != null ? type.getTypeText(JSType.TypeTextFormat.PRESENTABLE) : null;
                PsiElement sourceElement = (PsiElement)implicitElements.get(name);
                if (sourceElement == null) {
                    sourceElement = element;
                }
                LookupElementBuilder builder = LookupElementBuilder.create((Object)(sourceElement != null ? sourceElement : name), (String)name).withBoldness(true).withTypeText(typeString);
                result.add(JSCompletionUtil.withJSLookupPriority((LookupElement)builder, JSLookupPriority.MAX_PRIORITY));
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            VariantsProcessor.$$$reportNull$$$0(18);
        }
        return smartList;
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        JSNamedElement namedElement;
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(19);
        }
        if (state == null) {
            VariantsProcessor.$$$reportNull$$$0(20);
        }
        return !(element instanceof JSNamedElement) || this.addCompleteMatch((PsiElement)(namedElement = (JSNamedElement)element), namedElement.getName(), BaseJSSymbolProcessor.MatchType.COMPLETE);
    }

    @Override
    public String getRequiredName() {
        return null;
    }

    @Override
    public boolean doAdd(@NotNull JSPsiElementBase element) {
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(21);
        }
        return this.doAdd(element, null);
    }

    public boolean doAdd(@NotNull JSPsiElementBase element, @Nullable JSTypeSubstitutor typeSubstitutor) {
        JSDocComment comment;
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(22);
        }
        ProgressManager.checkCanceled();
        String name = element.getName();
        if (name == null || !BasicJavascriptNamesValidator.isUnqualifiedType(name) || !this.myPrefixMatcher.prefixMatches(name)) {
            return true;
        }
        JSQualifiedName namespace = element.getNamespace();
        JSAttributeList.AccessType accessType = element.getAccessType();
        if (element.isEquivalentTo(this.myOriginalElement)) {
            return true;
        }
        if (this.myPopulatedResultsNames.contains(name)) {
            return true;
        }
        if (this.isAcceptable(element) != null) {
            return true;
        }
        boolean seemsToBePrivateSymbol = JSVisibilityUtil.seemsToBePrivateSymbol(name);
        boolean isClassMember = element.getContext() instanceof JSClass;
        if (isClassMember && JSResolveUtil.isConstructorFunction((PsiElement)element)) {
            return true;
        }
        if (element instanceof JSProperty && (comment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)element)) != null && comment.hasConstructsTag()) {
            return true;
        }
        if (seemsToBePrivateSymbol && accessType == JSAttributeList.AccessType.PACKAGE_LOCAL) {
            accessType = JSAttributeList.AccessType.PRIVATE;
        }
        if (isClassMember && accessType == JSAttributeList.AccessType.PRIVATE) {
            return true;
        }
        boolean fromTheSameFile = this.myCurrentFile != null && this.myCurrentFile.equals(this.myTargetVirtualFile);
        boolean elementIsVisible = JSVisibilityUtil.isAccessible(namespace, (PsiElement)element, accessType, this.getContextScopeNames(), this.myContext, fromTheSameFile);
        if (element instanceof JSClass && !elementIsVisible) {
            return true;
        }
        if (this.myProcessOnlyProperties && (element instanceof JSImplicitElement ? ((JSImplicitElement)element).getType() != JSImplicitElement.Type.Property : !(element instanceof JSProperty) && !(element instanceof JSDefinitionExpression))) {
            return true;
        }
        Ref typeHierarchyLevel = new Ref((Object)-1);
        BaseJSSymbolProcessor.MatchType matchType = this.calcMatchType(element, accessType, elementIsVisible, (Ref<Integer>)typeHierarchyLevel);
        if (matchType == BaseJSSymbolProcessor.MatchType.PARTIAL || !elementIsVisible && VariantsProcessor.isCompleteOrWithContextMatchType(matchType)) {
            return this.addPartialMatch((PsiElement)element, name);
        }
        if (VariantsProcessor.isCompleteOrWithContextMatchType(matchType)) {
            return this.addCompleteMatch((PsiElement)element, name, matchType, (Integer)typeHierarchyLevel.get(), typeSubstitutor);
        }
        return true;
    }

    @NotNull
    private BaseJSSymbolProcessor.MatchType calcMatchType(@NotNull JSPsiElementBase element, @NotNull JSAttributeList.AccessType accessType, boolean elementIsVisible, @NotNull Ref<Integer> typeHierarchyLevel) {
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(23);
        }
        if (accessType == null) {
            VariantsProcessor.$$$reportNull$$$0(24);
        }
        if (typeHierarchyLevel == null) {
            VariantsProcessor.$$$reportNull$$$0(25);
        }
        BaseJSSymbolProcessor.MatchType matchType = this.isAcceptableQualifiedItem(element, typeHierarchyLevel);
        if (!this.myPlaceFilter.isAcceptable(element)) {
            BaseJSSymbolProcessor.MatchType matchType2 = BaseJSSymbolProcessor.MatchType.NOMATCH;
            if (matchType2 == null) {
                VariantsProcessor.$$$reportNull$$$0(26);
            }
            return matchType2;
        }
        if (accessType == JSAttributeList.AccessType.PRIVATE && this.myProcessOnlyTypes) {
            matchType = BaseJSSymbolProcessor.MatchType.PARTIAL;
        }
        if (VariantsProcessor.isCompleteOrWithContextMatchType(matchType) && this.myPlaceFilter.isPartialResult(element)) {
            matchType = BaseJSSymbolProcessor.MatchType.PARTIAL;
        }
        if (matchType == BaseJSSymbolProcessor.MatchType.COMPLETE && (Integer)typeHierarchyLevel.get() > 0 && !elementIsVisible) {
            matchType = BaseJSSymbolProcessor.MatchType.PARTIAL;
        }
        BaseJSSymbolProcessor.MatchType matchType3 = matchType;
        if (matchType3 == null) {
            VariantsProcessor.$$$reportNull$$$0(27);
        }
        return matchType3;
    }

    @Nullable
    private LookupElement createLookupElement(@Nullable PsiElement element, @NotNull String name, @NotNull JSLookupPriority priority, boolean isBold, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (name == null) {
            VariantsProcessor.$$$reportNull$$$0(28);
        }
        if (priority == null) {
            VariantsProcessor.$$$reportNull$$$0(29);
        }
        if (!JSLookupUtilImpl.willCreateLookupElement(priority)) {
            return null;
        }
        LookupItem<Object> lookupItem = JSLookupUtilImpl.createPrioritizedLookupItem(element, name, priority, isBold, this.ecmal4, typeSubstitutor);
        return lookupItem;
    }

    @Nullable
    private static JSSymbolNamespace guessNamespaceFromProperty(@NotNull JSProperty element) {
        JSExpression methodExpr;
        PsiElement grandGrandParent;
        PsiElement grandParent;
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(30);
        }
        if ((grandParent = element.getParent().getParent()) instanceof JSArgumentList && (grandGrandParent = grandParent.getParent()) instanceof JSCallExpression && (methodExpr = ((JSCallExpression)grandGrandParent).getMethodExpression()) instanceof JSReferenceExpression) {
            ArrayList<String> names = new ArrayList<String>(3);
            JSExpression qualifyingExpression = JSSymbolUtil.getFirstLiteralOrExprArg((JSArgumentList)grandParent);
            String method = qualifyingExpression != null ? StringUtil.unquoteString((String)qualifyingExpression.getText()) : methodExpr.getText();
            BaseJSSymbolProcessor.addIndexListFromQName(method, names);
            return new JSSymbolNamespaceImpl(JSQualifiedNameImpl.fromComponents(names), JSContext.UNKNOWN, true, true);
        }
        return null;
    }

    private boolean addCompleteMatch(@NotNull PsiElement _element, @Nullable String name, @NotNull BaseJSSymbolProcessor.MatchType matchType) {
        if (_element == null) {
            VariantsProcessor.$$$reportNull$$$0(31);
        }
        if (matchType == null) {
            VariantsProcessor.$$$reportNull$$$0(32);
        }
        return this.addCompleteMatch(_element, name, matchType, -1, null);
    }

    private boolean addCompleteMatch(@NotNull PsiElement element, @Nullable String name, @NotNull BaseJSSymbolProcessor.MatchType matchType, int nestingLevel, @Nullable JSTypeSubstitutor typeSubstitutor) {
        boolean isBold;
        JSLookupPriority priority;
        LookupElement lookupItem;
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(33);
        }
        if (matchType == null) {
            VariantsProcessor.$$$reportNull$$$0(34);
        }
        if (name == null) {
            return true;
        }
        if (element instanceof JSPsiElementBase && this.myPlaceFilter.isLoweredPriority((JSPsiElementBase)element)) {
            ++nestingLevel;
        }
        if ((lookupItem = this.createLookupElement(element, name, priority = this.getPriority(name, matchType, nestingLevel), isBold = VariantsProcessor.isCompleteOrWithContextMatchType(matchType) && nestingLevel == 0, typeSubstitutor)) != null && matchType == BaseJSSymbolProcessor.MatchType.COMPLETE_WITH_CONTEXT) {
            lookupItem.putUserData(CONTEXT_MATCHES, (Object)Boolean.TRUE);
        }
        if (lookupItem != null) {
            return this.addResult(name, lookupItem);
        }
        return true;
    }

    private JSLookupPriority getPriority(@NotNull String name, @NotNull BaseJSSymbolProcessor.MatchType matchType, int nestingLevel) {
        if (name == null) {
            VariantsProcessor.$$$reportNull$$$0(35);
        }
        if (matchType == null) {
            VariantsProcessor.$$$reportNull$$$0(36);
        }
        if (this.myTypeInfo.isGlobalStatusHint()) {
            nestingLevel += 5;
        }
        return this.myTypeInfo.isGlobalStatusHint() && !this.myProcessOnlyTypes ? JSLookupPriority.getLookupPriority(BaseJSSymbolProcessor.MatchType.PARTIAL, false, false) : JSLookupPriority.getSameTypeValue(name.equals(this.myReferencedParameterName), matchType, nestingLevel);
    }

    private boolean addPartialMatch(@NotNull PsiElement element, @Nullable String name) {
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(37);
        }
        if (name == null || this.myAddOnlyCompleteMatches) {
            return true;
        }
        boolean fromRelevantFileOrDirectory = this.isFromRelevantFileOrDirectory();
        JSLookupPriority priority = JSLookupPriority.getLookupPriority(null, fromRelevantFileOrDirectory, this.hasSomeSmartnessAvailable);
        LookupElement lookupElement = this.createLookupElement(element, name, priority, false, null);
        if (lookupElement != null) {
            return this.addResult(name, lookupElement);
        }
        return true;
    }

    private static boolean isPropertyWithFunctionInitializer(PsiElement lookupItemElement) {
        return lookupItemElement instanceof JSProperty && ((JSProperty)lookupItemElement).tryGetFunctionInitializer() != null;
    }

    static boolean wasCompleteMatch(double priority) {
        return priority > (double)JSLookupPriority.MAX_PRIORITY.getPriorityValue();
    }

    private boolean checkLimit() {
        return this.myResults.size() <= this.myLimit;
    }

    @Override
    @NotNull
    public PsiFile getTargetFile() {
        PsiFile psiFile = this.myTargetFile;
        if (psiFile == null) {
            VariantsProcessor.$$$reportNull$$$0(38);
        }
        return psiFile;
    }

    @Override
    @NotNull
    public PrefixMatcher getPrefixMatcher() {
        PrefixMatcher prefixMatcher = this.myPrefixMatcher;
        if (prefixMatcher == null) {
            VariantsProcessor.$$$reportNull$$$0(39);
        }
        return prefixMatcher;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 38: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 38: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/VariantsProcessor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClasses";
                break;
            }
            case 14: 
            case 28: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 30: 
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessType";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeHierarchyLevel";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_element";
                break;
            }
            case 32: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/VariantsProcessor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamespaceForNamedType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeInfo";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentResults";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createElementsFromRecordTypes";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "calcMatchType";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetFile";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefixMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNamespaceForNamedType";
                break;
            }
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 38: 
            case 39: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "populateCompletionList";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isStrictTypingPossible";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addGenericArguments";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addResult";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "doAdd";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "calcMatchType";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "guessNamespaceFromProperty";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addCompleteMatch";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getPriority";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "addPartialMatch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 38: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CompletionTypeProcessor
    extends BaseJSSymbolProcessor.JSTypeProcessorBase {
        private boolean hasUnknownElement;
        private boolean strictlyTyped;

        @Override
        public void processNamespace(@NotNull JSSymbolNamespace namespace, @NotNull JSEvaluateContext context, PsiElement source) {
            JSType type;
            if (namespace == null) {
                CompletionTypeProcessor.$$$reportNull$$$0(0);
            }
            if (context == null) {
                CompletionTypeProcessor.$$$reportNull$$$0(1);
            }
            if ((type = BaseJSSymbolProcessor.namespaceAsType((JSNamespace)namespace, source)) == null) {
                return;
            }
            if (context.ensureProcessed(type, context)) {
                return;
            }
            if (namespace.getQualifiedName() == null) {
                return;
            }
            if (namespace.isLocal() && context.getJSModule() == null) {
                return;
            }
            JSNamespaceImpl ns = new JSNamespaceImpl(namespace.getQualifiedName(), namespace.getJSContext(), true, namespace.isLocal());
            boolean isExportNamespace = CommonJSUtil.isExportNamespace(namespace.getQualifiedName());
            PsiFile jsModule = context.getJSModule();
            if (jsModule == null && isExportNamespace) {
                jsModule = VariantsProcessor.this.myTargetFile;
            }
            VariantsProcessor.this.addTypeHierarchy(ns, jsModule);
            if (namespace.isExplicitlyDeclared() || isExportNamespace) {
                this.strictlyTyped = true;
            }
        }

        @Override
        public void process(@NotNull JSType type, @NotNull JSEvaluateContext context, PsiElement source) {
            JSNamespace namespace;
            if (type == null) {
                CompletionTypeProcessor.$$$reportNull$$$0(2);
            }
            if (context == null) {
                CompletionTypeProcessor.$$$reportNull$$$0(3);
            }
            if (context.ensureProcessed(type, context)) {
                return;
            }
            if (!JSTypeUtils.processExpandedType(this, type, context, source)) {
                return;
            }
            JSTypeSource typeSource = type.getSource();
            if (type instanceof JSRecordType) {
                if (typeSource.isExplicitlyDeclared()) {
                    VariantsProcessor.this.setAddOnlyCompleteMatches(true);
                }
                VariantsProcessor.this.myTypeInfo.setTypeWasProcessed();
                return;
            }
            if (type instanceof JSMixinTypeImpl) {
                this.process(((JSMixinTypeImpl)type).getBaseType(), context, source);
                JSNamespace mixedType = JSTypeUtils.getNamespaceMatchingType(((JSMixinTypeImpl)type).getMixedType(), true, false);
                if (mixedType != null) {
                    VariantsProcessor.this.myTypeInfo.addNamespace(mixedType, false, null);
                    VariantsProcessor.this.addSupers(mixedType);
                }
                return;
            }
            if (type instanceof JSAnyType) {
                this.hasUnknownElement = true;
                VariantsProcessor.this.myTypeInfo.setForcedUnknownContext();
            }
            if ((namespace = JSTypeUtils.getNamespaceMatchingType(type, true, true)) == null || namespace.getQualifiedName() == null) {
                return;
            }
            VariantsProcessor.this.addTypeHierarchy(namespace, context.getJSModule());
            VariantsProcessor.this.tryAddFunctionType(type, source);
            if (VariantsProcessor.this.isStrictTypingPossible(source, type)) {
                this.strictlyTyped = true;
            }
            if (source instanceof JSReferenceExpression && source.getParent() instanceof JSNewExpression || source instanceof JSAssignmentExpression && this.isAssignmentChainOfNewExpression((JSAssignmentExpression)source)) {
                this.setUnknownElement(source.getParent());
            }
        }

        private boolean isAssignmentChainOfNewExpression(JSAssignmentExpression source) {
            JSExpression rOperand = source.getROperand();
            if (rOperand instanceof JSNewExpression) {
                return true;
            }
            if (rOperand instanceof JSAssignmentExpression) {
                return this.isAssignmentChainOfNewExpression((JSAssignmentExpression)rOperand);
            }
            return false;
        }

        @Override
        public PsiElement getTarget() {
            return null;
        }

        @Override
        public void setUnknownElement(@NotNull PsiElement element) {
            if (element == null) {
                CompletionTypeProcessor.$$$reportNull$$$0(4);
            }
            this.hasUnknownElement = true;
            VariantsProcessor.this.myTypeInfo.setForcedUnknownContext();
        }

        private boolean getAllTypesResolved() {
            return !this.hasUnknownElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/VariantsProcessor$CompletionTypeProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processNamespace";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setUnknownElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

