/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSHierarchyProcessor;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSImportedElementResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTaggedResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeInfo;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WalkUpResolveProcessor
extends BaseJSSymbolProcessor {
    private final JSResolveMatchData matchData;
    private boolean mySkipDefs;
    protected boolean myNewPropertiesDefinitionAllowed;
    protected final String myName;
    private boolean myTooManyCandidates;

    public WalkUpResolveProcessor(@NotNull String name, @NotNull PsiFile targetFile, @NotNull PsiElement context) {
        if (name == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(0);
        }
        if (targetFile == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(1);
        }
        if (context == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(2);
        }
        super(targetFile, context);
        this.matchData = new JSResolveMatchData();
        this.myName = name;
        if (context instanceof JSReferenceExpression) {
            JSNamespaceEvaluationResult ns;
            JSReferenceExpression refExpr = (JSReferenceExpression)context;
            JSExpression originalQualifier = refExpr.getQualifier();
            JSExpression qualifier = JSResolveUtil.getRealRefExprQualifier(refExpr);
            JSClass jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)context, JSClass.class);
            boolean haveNotEncounteredDynamics = true;
            if (qualifier == null || originalQualifier == null) {
                if (qualifier == null) {
                    JSImportedElementResolveResult expression = JSImportHandlingUtil.resolveTypeNameUsingImports(refExpr);
                    if (expression != null) {
                        JSQualifiedName qName = JSResolveUtil.buildNamespaceForQualifier(JSResolveUtil.getRealRefExprQualifierFromResult(refExpr, expression)).getQualifiedName();
                        this.myTypeInfo.buildIndexListFromQNameAndCorrectQName(qName != null ? qName.getQualifiedName() : "");
                    } else if (this.typescript) {
                        TypeScriptModule module = (TypeScriptModule)PsiTreeUtil.getParentOfType((PsiElement)refExpr, TypeScriptModule.class);
                        if (module != null) {
                            String qualifiedName = module.getQualifiedName();
                            assert (qualifiedName != null);
                            this.myTypeInfo.addAllParentScopes(qualifiedName);
                        }
                    } else if (this.ecmal4) {
                        this.addPackageScope(jsClass, (PsiElement)refExpr);
                    } else {
                        JSTypeEvaluateManager.iterateTypeHierarchy("Window", this.createHierarchyProcessor(), this.myContext);
                    }
                } else {
                    assert (originalQualifier == null);
                    if (refExpr.isAttributeReference()) {
                        haveNotEncounteredDynamics = false;
                    }
                }
            } else {
                if ((qualifier instanceof JSThisExpression || qualifier instanceof JSSuperExpression) && qualifier instanceof JSThisExpression) {
                    PsiElement clazz;
                    String contextQualifierText;
                    boolean explicitlyDeclared;
                    ns = JSContextResolver.resolveContext((PsiElement)qualifier);
                    boolean bl = explicitlyDeclared = ns != null && ns.isExplicitlyDeclared();
                    if (explicitlyDeclared) {
                        this.setAddOnlyCompleteMatches(true);
                    }
                    Object object = (contextQualifierText = JSNamespaceEvaluationResult.getQualifiedName(ns)) == null ? null : (clazz = this.ecmal4 ? JSClassResolver.findClassFromNamespace(contextQualifierText, context) : TypeScriptClassResolver.getInstance().findAnyClassByQName(contextQualifierText, JSResolveUtil.getResolveScope(context)));
                    if (clazz instanceof JSClass) {
                        boolean clazzIsDynamic;
                        JSAttributeList attrList = ((JSClass)clazz).getAttributeList();
                        if (attrList != null && (clazzIsDynamic = attrList.hasModifier(JSAttributeList.ModifierType.DYNAMIC))) {
                            haveNotEncounteredDynamics = false;
                        }
                        this.myTypeInfo.buildIndexListFromQNameAndCorrectQName(contextQualifierText);
                    } else if (contextQualifierText != null) {
                        this.myTypeInfo.buildIndexListFromQNameAndCorrectQName(contextQualifierText, true, ns.getJSContext());
                    }
                    if (!explicitlyDeclared) {
                        this.myTypeInfo.setForcedUnknownContext();
                    }
                }
                if (!(qualifier instanceof JSThisExpression) && !(qualifier instanceof JSSuperExpression) || !this.ecmal4) {
                    JSTypeEvaluator.evaluateTypes(qualifier, this.createTypeProcessor((PsiElement)qualifier));
                }
            }
            if (!this.myTypeInfo.isEmpty()) {
                if (!this.myAddOnlyCompleteMatchesSet) {
                    this.myAddOnlyCompleteMatches = haveNotEncounteredDynamics;
                }
            } else {
                if (qualifier instanceof JSReferenceExpression && (ns = JSSymbolUtil.createNamespaceFromReferenceExpression((JSReferenceExpression)qualifier, JSContext.STATIC, true)) != null) {
                    this.myTypeInfo.addNamespace(ns, false);
                }
                if (this.ecmal4 || this.typescript) {
                    this.myAddOnlyCompleteMatches = true;
                }
            }
        } else if (context instanceof JSDestructuringProperty) {
            PsiElement parent = context.getParent();
            JSTypeEvaluator.evaluateExpressionOrElementTypes(this.myTargetFile, this.createTypeProcessor(parent), parent, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
        }
        if (this.myTypeInfo.typeWasProcessed()) {
            this.myTypeInfo.addBaseObjectType();
        }
        this.initCheckFileLevelAccess();
    }

    @NotNull
    private JSHierarchyProcessor createHierarchyProcessor() {
        JSHierarchyProcessor jSHierarchyProcessor = new JSHierarchyProcessor(){

            @Override
            public boolean processNamespace(String qName, VirtualFile file) {
                return true;
            }

            @Override
            public boolean processClass(JSClass clazz) {
                return true;
            }

            @Override
            public boolean processObjectLiteral(JSObjectLiteralExpression objectLiteral) {
                return WalkUpResolveProcessor.this.processObjectLiteral(objectLiteral);
            }
        };
        if (jSHierarchyProcessor == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(3);
        }
        return jSHierarchyProcessor;
    }

    @Override
    protected boolean isStrictTypingPossible(PsiElement source, @NotNull JSType type) {
        if (type == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(4);
        }
        return (type.getSource().getLanguage() != JSTypeSource.SourceLanguage.JS || type.getSource().isExplicitlyDeclared()) && super.isStrictTypingPossible(source, type);
    }

    @NotNull
    private JSTypeProcessor createTypeProcessor(PsiElement qualifier) {
        BaseJSSymbolProcessor.JSTypeProcessorBase jSTypeProcessorBase = this.ecmal4 ? new ActionScriptResolveTypeProcessor() : new JSResolveTypeProcessor(qualifier);
        if (jSTypeProcessorBase == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(5);
        }
        return jSTypeProcessorBase;
    }

    @Override
    @NotNull
    protected JSTypeInfo.GlobalStatusHint initGlobalStatusHint(@Nullable PsiElement context, @Nullable PsiElement contextRefQualifier) {
        JSElement container;
        JSTypeInfo.GlobalStatusHint statusHint = super.initGlobalStatusHint(context, contextRefQualifier);
        if (context instanceof JSReferenceExpression && (container = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{JSEmbeddedContent.class, JSFile.class})) != null && (container.getContainingFile().getContext() != null || container.getContext() instanceof XmlAttributeValue) && statusHint == JSTypeInfo.GlobalStatusHint.GLOBAL) {
            statusHint = JSTypeInfo.GlobalStatusHint.UNKNOWN;
        }
        JSTypeInfo.GlobalStatusHint globalStatusHint = statusHint;
        if (globalStatusHint == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(6);
        }
        return globalStatusHint;
    }

    protected void doUnqualifiedCheck(@NotNull PsiElement element) {
        if (element == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(7);
        }
        this.addPartialResult(element, null);
    }

    protected void doQualifiedCheck(@NotNull JSPsiElementBase element) {
        String isAcceptable;
        if (element == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(8);
        }
        if ((isAcceptable = this.isAcceptable(element)) != null) {
            JSResolveResult o = new JSResolveResult((PsiElement)element, null, isAcceptable);
            EnumSet<JSTaggedResolveResult.ResolveResultTag> tags = isAcceptable == "javascript.element.need.to.be.imported" ? EnumSet.of(JSTaggedResolveResult.ResolveResultTag.NOT_IMPORTED) : (isAcceptable == "javascript.element.need.to.be.exported" ? EnumSet.of(JSTaggedResolveResult.ResolveResultTag.NOT_EXPORTED, JSTaggedResolveResult.ResolveResultTag.PARTIAL) : EnumSet.noneOf(JSTaggedResolveResult.ResolveResultTag.class));
            this.matchData.addResult(o, tags);
            return;
        }
        JSQualifiedName namespace = element.getNamespace();
        Ref matchLevel = Ref.create((Object)-1);
        BaseJSSymbolProcessor.MatchType matchType = this.isAcceptableQualifiedItem(element, (Ref<Integer>)matchLevel);
        if (WalkUpResolveProcessor.isCompleteOrWithContextMatchType(matchType)) {
            if (JSPsiImplUtils.isGetProperty((PsiElement)element) && this.myContext.getParent() instanceof JSDefinitionExpression) {
                matchType = BaseJSSymbolProcessor.MatchType.NOMATCH;
            }
            JSAttributeList.AccessType accessType = element.getAccessType();
            if (namespace != null && accessType != JSAttributeList.AccessType.PACKAGE_LOCAL && this.checkAndAddNotAccessibleJSElement(element, accessType)) {
                return;
            }
        }
        if (matchType == BaseJSSymbolProcessor.MatchType.PARTIAL) {
            this.addPartialResult((PsiElement)element, null);
        } else if (WalkUpResolveProcessor.isCompleteOrWithContextMatchType(matchType)) {
            EnumSet<JSTaggedResolveResult.ResolveResultTag> tags = matchType == BaseJSSymbolProcessor.MatchType.COMPLETE_WITH_CONTEXT ? EnumSet.of(JSTaggedResolveResult.ResolveResultTag.CONTEXT_MATCHES) : EnumSet.noneOf(JSTaggedResolveResult.ResolveResultTag.class);
            this.matchData.addResult(new JSResolveResult((PsiElement)element), tags, (Integer)matchLevel.get());
        }
    }

    private boolean checkAndAddNotAccessibleJSElement(@NotNull JSPsiElementBase element, @NotNull JSAttributeList.AccessType accessType) {
        if (element == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(9);
        }
        if (accessType == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(10);
        }
        if (this.ecmal4 || this.typescript || !(this.myContext instanceof JSReferenceExpression) || JSResolveUtil.isSameReference((JSReferenceExpression)this.myContext, (PsiElement)element)) {
            return false;
        }
        PsiFile file1 = element.getContainingFile();
        PsiFile file2 = this.myContext.getContainingFile();
        if (file1 == null || file2 == null || JSVisibilityUtil.isAccessible(element.getNamespace(), (PsiElement)element, accessType, this.getContextScopeNames(), this.myContext, file1.isEquivalentTo((PsiElement)file2))) {
            return false;
        }
        this.addCompleteResultWithProblem((PsiElement)element, accessType == JSAttributeList.AccessType.PRIVATE ? "javascript.jsdoc.private.member.is.not.accessible.message" : (accessType == JSAttributeList.AccessType.PROTECTED ? "javascript.jsdoc.protected.member.is.not.accessible.message" : null));
        return true;
    }

    private void addCompleteResult(PsiElement element) {
        JSResolveResult o = new JSResolveResult(element, null, null);
        this.addCompleteResult(o);
    }

    private void addCompleteResult(ResolveResult o) {
        this.matchData.addResult(o, EnumSet.noneOf(JSTaggedResolveResult.ResolveResultTag.class));
    }

    private void addCompleteResultWithProblem(PsiElement element, String problemKey) {
        JSResolveResult o = new JSResolveResult(element, null, problemKey);
        this.addCompleteResult(o);
    }

    private void addPartialResult(PsiElement element, @Nullable String resolveProblem) {
        JSResolveResult o = new JSResolveResult(element, null, resolveProblem);
        this.matchData.addResult(o, EnumSet.of(JSTaggedResolveResult.ResolveResultTag.PARTIAL));
    }

    public PsiFile getBaseFile() {
        return this.myTargetFile;
    }

    private static boolean handleDefinitionWithHigherPriority(JSDefinitionExpression expr) {
        return expr.tryGetFunctionExpressionInitializer() != null || CommonJSUtil.isExportNamespace(expr.getNamespace());
    }

    @Override
    public String getRequiredName() {
        return this.myName;
    }

    public void allowPartialResults() {
        this.myAddOnlyCompleteMatchesSet = true;
        this.myAddOnlyCompleteMatches = false;
    }

    public ResolveResult[] getResults() {
        if (this.myTooManyCandidates) {
            return JSResolveResult.TOO_MANY_CANDIDATES;
        }
        List<JSTaggedResolveResult> taggedResolveResults = this.getTaggedResolveResults();
        if (taggedResolveResults.isEmpty()) {
            return ResolveResult.EMPTY_ARRAY;
        }
        int resultCount = taggedResolveResults.size();
        ResolveResult[] result = new ResolveResult[resultCount];
        for (int i = 0; i < resultCount; ++i) {
            result[i] = taggedResolveResults.get((int)i).result;
        }
        return result;
    }

    @NotNull
    public List<JSTaggedResolveResult> getTaggedResolveResults() {
        List<JSTaggedResolveResult> list = this.matchData.getTaggedResolveResults();
        if (list == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(11);
        }
        return list;
    }

    public void addLocalResults(@NotNull SinkResolveProcessor<ResolveResultSink> processor) {
        if (processor == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(12);
        }
        ResolveResultSink sink = processor.getResultSink();
        List<Pair<ResolveResult, Boolean>> results = sink.getFilteredResults();
        for (Pair<ResolveResult, Boolean> pair : results) {
            ResolveResult e = (ResolveResult)pair.first;
            if (e.isValidResult() || !((Boolean)pair.second).booleanValue()) {
                EnumSet<JSTaggedResolveResult.ResolveResultTag> tags = EnumSet.noneOf(JSTaggedResolveResult.ResolveResultTag.class);
                PsiElement element = e.getElement();
                if (element != null && Boolean.TRUE.equals(element.getUserData(QualifiedItemProcessor.RECORD_TYPE_PROPERTY_KEY))) {
                    tags.add(JSTaggedResolveResult.ResolveResultTag.RECORD_TYPE_PROPERTY);
                }
                if (!((Boolean)pair.second).booleanValue()) {
                    tags.add(JSTaggedResolveResult.ResolveResultTag.MINOR_IMPORTANCE);
                }
                this.matchData.addResult(e, tags);
                continue;
            }
            if (!(e instanceof JSResolveResult)) continue;
            this.addPartialResult(e.getElement(), ((JSResolveResult)e).getResolveProblemKey());
        }
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(13);
        }
        if (state == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(14);
        }
        if (!(element instanceof JSNamedElement) || Comparing.equal((String)((JSNamedElement)element).getName(), (String)this.myName, (boolean)true)) {
            this.addCompleteResult(element);
        }
        return true;
    }

    public void setSkipDefinitions(boolean b) {
        this.mySkipDefs = b;
    }

    @Override
    protected boolean processObjectLiteral(@NotNull JSObjectLiteralExpression objectLiteral) {
        JSAttributeList.AccessType accessType;
        JSProperty property;
        if (objectLiteral == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(15);
        }
        if ((property = objectLiteral.findProperty(this.myName)) != null && !this.checkAndAddNotAccessibleJSElement((JSPsiElementBase)property, accessType = property.getAccessType())) {
            this.matchData.addResult(new JSResolveResult((PsiElement)property), EnumSet.of(JSTaggedResolveResult.ResolveResultTag.CONTEXT_MATCHES));
        }
        return true;
    }

    public void setTooManyCandidates() {
        this.myTooManyCandidates = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createHierarchyProcessor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "initGlobalStatusHint";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaggedResolveResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isStrictTypingPossible";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doUnqualifiedCheck";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doQualifiedCheck";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkAndAddNotAccessibleJSElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addLocalResults";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processObjectLiteral";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class JSResolveMatchData {
        @Nullable
        private List<JSTaggedResolveResult> matchData = null;
        private int myBestMatchedLevel = Integer.MAX_VALUE;

        private JSResolveMatchData() {
        }

        void addResult(ResolveResult o, @NotNull EnumSet<JSTaggedResolveResult.ResolveResultTag> tags) {
            if (tags == null) {
                JSResolveMatchData.$$$reportNull$$$0(0);
            }
            this.addResult(o, tags, 0);
        }

        void addResult(ResolveResult o, @NotNull EnumSet<JSTaggedResolveResult.ResolveResultTag> tags, int completeMatchLevel) {
            PsiElement element;
            boolean isDefinition;
            if (tags == null) {
                JSResolveMatchData.$$$reportNull$$$0(1);
            }
            if (this.myBestMatchedLevel < Integer.MAX_VALUE && tags.contains((Object)JSTaggedResolveResult.ResolveResultTag.PARTIAL)) {
                return;
            }
            if (!tags.contains((Object)JSTaggedResolveResult.ResolveResultTag.PARTIAL)) {
                if (completeMatchLevel < this.myBestMatchedLevel) {
                    this.matchData = null;
                    this.myBestMatchedLevel = completeMatchLevel;
                } else if (this.myBestMatchedLevel < completeMatchLevel) {
                    return;
                }
            }
            boolean bl = isDefinition = (element = o.getElement()) instanceof JSDefinitionExpression && !WalkUpResolveProcessor.handleDefinitionWithHigherPriority((JSDefinitionExpression)element);
            if (WalkUpResolveProcessor.this.mySkipDefs && isDefinition) {
                return;
            }
            if (this.matchData == null) {
                this.matchData = ContainerUtil.newSmartList();
            }
            if (WalkUpResolveProcessor.this.isFromRelevantFileOrDirectory()) {
                tags.add(JSTaggedResolveResult.ResolveResultTag.CURRENT_FILE);
            }
            WalkUpResolveProcessor.this.addResolveResultTags(tags, element);
            this.matchData.add(new JSTaggedResolveResult(o, tags));
        }

        List<JSTaggedResolveResult> getTaggedResolveResults() {
            if (this.matchData == null) {
                return Collections.emptyList();
            }
            Collections.sort(this.matchData);
            JSTaggedResolveResult topResult = this.matchData.get(0);
            boolean topResultIsPartial = topResult.tags.contains((Object)JSTaggedResolveResult.ResolveResultTag.PARTIAL);
            if (WalkUpResolveProcessor.this.addOnlyCompleteMatches() && topResultIsPartial) {
                this.matchData = null;
                return Collections.emptyList();
            }
            int resultCount = 0;
            for (JSTaggedResolveResult taggedResolveResult : this.matchData) {
                int compare;
                if (!topResultIsPartial && (compare = taggedResolveResult.comparePriorityTo(topResult)) != 0) {
                    assert (compare > 0);
                    break;
                }
                ++resultCount;
            }
            this.matchData = this.matchData.subList(0, resultCount);
            return this.matchData;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tags", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor$JSResolveMatchData", "addResult"));
        }
    }

    private class JSResolveTypeProcessor
    extends BaseJSSymbolProcessor.JSTypeProcessorBase {
        private final PsiElement myTarget;

        public JSResolveTypeProcessor(PsiElement target) {
            this.myTarget = target;
        }

        @Override
        public void process(@NotNull JSType type, @NotNull JSEvaluateContext context, PsiElement source) {
            JSNamespace namespace;
            if (type == null) {
                JSResolveTypeProcessor.$$$reportNull$$$0(0);
            }
            if (context == null) {
                JSResolveTypeProcessor.$$$reportNull$$$0(1);
            }
            if (context.ensureProcessed(type, context)) {
                return;
            }
            if (!JSTypeUtils.processExpandedType(this, type, context, source)) {
                return;
            }
            if (WalkUpResolveProcessor.this.isStrictTypingPossible(source, type)) {
                WalkUpResolveProcessor.this.setAddOnlyCompleteMatches(true);
            }
            JSTypeSource typeSource = type.getSource();
            if (type instanceof JSRecordType) {
                PsiElement sourceElement = typeSource.getSourceElement();
                if (sourceElement instanceof JSDocComment) {
                    sourceElement = JSStubBasedPsiTreeUtil.findAssociatedElement((JSDocComment)sourceElement);
                }
                if (sourceElement instanceof JSQualifiedNamedElement) {
                    JSQualifiedNameImpl qName = JSQualifiedNameImpl.fromQualifiedNamedElement((JSElementBase)((JSQualifiedNamedElement)sourceElement));
                    WalkUpResolveProcessor.this.myTypeInfo.addType(new JSNamespaceImpl(qName, JSContext.STATIC, false), true);
                }
                WalkUpResolveProcessor.this.myTypeInfo.addBaseObjectType();
            }
            if ((namespace = JSTypeUtils.getNamespaceMatchingType(type, true, false)) == null) {
                return;
            }
            WalkUpResolveProcessor.this.myNewPropertiesDefinitionAllowed |= JSTypeUtils.isNewPropertiesDefinitionAllowed(type);
            if (type instanceof JSAnyType || type instanceof JSGenericParameterImpl) {
                return;
            }
            if (typeSource.isTypeScript()) {
                if (typeSource.isExplicitlyDeclared()) {
                    WalkUpResolveProcessor.this.setAddOnlyCompleteMatches(true);
                } else {
                    WalkUpResolveProcessor.this.allowPartialResults();
                }
            }
            WalkUpResolveProcessor.this.addTypeHierarchy(namespace, context.getJSModule());
            WalkUpResolveProcessor.this.tryAddFunctionType(type, source);
        }

        @Override
        public PsiElement getTarget() {
            return this.myTarget;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor$JSResolveTypeProcessor";
            objectArray[2] = "process";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ActionScriptResolveTypeProcessor
    extends BaseJSSymbolProcessor.JSTypeProcessorBase {
        private ActionScriptResolveTypeProcessor() {
        }

        @Override
        public void process(@NotNull JSType type, @NotNull JSEvaluateContext context, PsiElement source) {
            if (type == null) {
                ActionScriptResolveTypeProcessor.$$$reportNull$$$0(0);
            }
            if (context == null) {
                ActionScriptResolveTypeProcessor.$$$reportNull$$$0(1);
            }
            if (context.ensureProcessed(type, context)) {
                return;
            }
            String typeString = type.getTypeText();
            if (type instanceof JSAnyType) {
                return;
            }
            final Ref proxyDescendant = new Ref();
            JSTypeEvaluateManager.iterateTypeHierarchy(typeString, new JSHierarchyProcessor(){

                @Override
                public boolean processNamespace(String qName, VirtualFile file) {
                    if ("Proxy".equals(qName)) {
                        proxyDescendant.set((Object)Boolean.TRUE);
                        return false;
                    }
                    return true;
                }

                @Override
                public boolean processClass(JSClass clazz) {
                    if ("flash.utils.Proxy".equals(clazz.getQualifiedName())) {
                        proxyDescendant.set((Object)Boolean.TRUE);
                        return false;
                    }
                    return true;
                }

                @Override
                public boolean processObjectLiteral(JSObjectLiteralExpression objectLiteral) {
                    return true;
                }
            }, WalkUpResolveProcessor.this.myContext);
            if (proxyDescendant.get() != null) {
                return;
            }
            WalkUpResolveProcessor.this.myTypeInfo.buildIndexListFromQNameAndCorrectQName(typeString);
        }

        @Override
        public PsiElement getTarget() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor$ActionScriptResolveTypeProcessor";
            objectArray[2] = "process";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

