/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve.context;

import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyCallElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyIndexedAccessElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyPropertyElement;
import com.intellij.lang.javascript.psi.types.JSApplyCallType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleTypeImpl;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSApplyContextUtil {
    @Nullable
    public static JSType getTypeWithAppliedContext(@NotNull JSType type, @NotNull JSEvaluateContext context) {
        if (type == null) {
            JSApplyContextUtil.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JSApplyContextUtil.$$$reportNull$$$0(1);
        }
        if (context.isJSElementsToApplyEmpty()) {
            return type;
        }
        JSApplyContextElement pop = context.popJSElementToApply();
        JSType result = null;
        if (pop instanceof JSApplyCallElement) {
            if (type instanceof JSFunctionTypeImpl) {
                JSType innerType;
                JSCallExpression callExpression = ((JSApplyCallElement)pop).getCallExpression();
                boolean isNew = callExpression instanceof JSNewExpression;
                JSType jSType = innerType = isNew ? ((JSFunctionTypeImpl)type).getNewType() : ((JSFunctionTypeImpl)type).getReturnType();
                if (innerType != null) {
                    result = JSApplyContextUtil.getTypeWithAppliedContext(innerType, context);
                }
            }
        } else if (pop instanceof JSApplyPropertyElement) {
            if (type instanceof JSRecordType) {
                JSType propertyType;
                JSRecordType.PropertySignature signature = ((JSRecordType)type).findPropertySignature(((JSApplyPropertyElement)pop).getName());
                JSType jSType = propertyType = signature != null ? signature.getType() : null;
                if (propertyType != null) {
                    result = JSApplyContextUtil.getTypeWithAppliedContext(propertyType, context);
                }
            }
        } else if (pop instanceof JSApplyIndexedAccessElement) {
            Ref componentType = Ref.create();
            JSApplyContextUtil.applyContextAndProcessDestructuringArray((JSApplyIndexedAccessElement)pop, type, arg_0 -> ((Ref)componentType).set(arg_0));
            if (!componentType.isNull()) {
                result = JSApplyContextUtil.getTypeWithAppliedContext((JSType)componentType.get(), context);
            }
        }
        context.pushJSElementToApply(pop);
        return result;
    }

    public static void applyContextAndProcessDestructuringArray(@NotNull JSApplyIndexedAccessElement pop, @NotNull JSType _type, @NotNull java.util.function.Consumer<JSType> callback) {
        if (pop == null) {
            JSApplyContextUtil.$$$reportNull$$$0(2);
        }
        if (_type == null) {
            JSApplyContextUtil.$$$reportNull$$$0(3);
        }
        if (callback == null) {
            JSApplyContextUtil.$$$reportNull$$$0(4);
        }
        JSDestructuringArray destructuringArray = pop.getDestructuringArray();
        PsiElement arrayElement = pop.getArrayElement();
        JSDestructuringArrayRestElement restElement = destructuringArray.getRestElement();
        if (_type instanceof JSTupleTypeImpl) {
            JSType newType;
            JSTupleTypeImpl tupleType = (JSTupleTypeImpl)_type;
            int indexMatched = ArrayUtil.indexOf((Object[])destructuringArray.getElements(), (Object)arrayElement);
            JSType toProcess = tupleType.getTypeByIndex(indexMatched);
            if (toProcess != null) {
                callback.accept(toProcess);
                return;
            }
            if (restElement != null && arrayElement == restElement && (newType = tupleType.excludePrefix(destructuringArray.getElements().length)) != null) {
                callback.accept(newType);
                return;
            }
        }
        if (restElement != null && arrayElement == restElement) {
            callback.accept(_type);
            return;
        }
        JSType componentType = JSTypeUtils.getIndexableComponentType(_type);
        if (componentType != null) {
            JSType optimizeTypeIfComposite = JSCompositeTypeImpl.optimizeTypeIfComposite(componentType);
            if (optimizeTypeIfComposite instanceof JSCompositeTypeImpl) {
                optimizeTypeIfComposite = JSTypeUtils.copyWithExplicitlyDeclared(optimizeTypeIfComposite, false);
            }
            callback.accept(optimizeTypeIfComposite);
        }
    }

    public static void applyTypeToContext(@NotNull JSType type, @Nullable JSEvaluationResultContext evaluateContext, @NotNull BiConsumer<JSType, JSEvaluationResultContext> consumer) {
        if (type == null) {
            JSApplyContextUtil.$$$reportNull$$$0(5);
        }
        if (consumer == null) {
            JSApplyContextUtil.$$$reportNull$$$0(6);
        }
        if (evaluateContext == null) {
            consumer.accept(type, null);
            return;
        }
        JSApplyCallElement newElement = null;
        JSType baseType = null;
        if (type instanceof JSApplyCallType) {
            baseType = ((JSApplyCallType)type).getBaseType();
            newElement = new JSApplyCallElement(null);
        }
        if (newElement == null) {
            consumer.accept(type, evaluateContext);
            return;
        }
        JSType _baseType = baseType;
        JSEvaluateContext.processWithJSElementToApply(newElement, evaluateContext, (Consumer<JSEvaluationResultContext>)((Consumer)newContext -> {
            if (consumer == null) {
                JSApplyContextUtil.$$$reportNull$$$0(7);
            }
            consumer.accept(_baseType, (JSEvaluationResultContext)newContext);
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pop";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/context/JSApplyContextUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTypeWithAppliedContext";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "applyContextAndProcessDestructuringArray";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "applyTypeToContext";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$applyTypeToContext$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

