/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSFileCachedDataEvaluator;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileStubImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.DefaultStubBuilder;
import com.intellij.psi.stubs.StubElement;
import org.jetbrains.annotations.NotNull;

public class JSFileStubBuilder
extends DefaultStubBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.psi.stubs.impl.JSFileStubBuilder");

    public StubElement buildStubTree(final @NotNull PsiFile file) {
        StubElement parentStub;
        if (file == null) {
            JSFileStubBuilder.$$$reportNull$$$0(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Building stub for " + file.getViewProvider().getVirtualFile().getCanonicalPath() + ", language: " + file.getLanguage());
        }
        if (!((parentStub = this.createStubForFile(file)) instanceof JSFileStubImpl) || !(file instanceof JSFile) || ((JSFileStubImpl)parentStub).getCachedData() != null) {
            return this.buildStubTreeFor((ASTNode)file.getNode(), parentStub);
        }
        final JSFileCachedData cachedData = new JSFileCachedData();
        for (FrameworkIndexingHandler handler : (FrameworkIndexingHandler[])FrameworkIndexingHandler.EP_NAME.getExtensions()) {
            handler.processFile((JSFile)file, cachedData);
        }
        new DefaultStubBuilder.StubBuildingWalkingVisitor((ASTNode)file.getNode(), parentStub){
            final JSFileCachedDataEvaluator evaluator;
            {
                super((DefaultStubBuilder)JSFileStubBuilder.this, x0, x1);
                this.evaluator = JSDialectSpecificHandlersFactory.forLanguage(DialectDetector.languageOfElement((PsiElement)file)).newFileCachedDataEvaluator(cachedData);
            }

            protected void visitNode(StubElement parentStub, ASTNode node, boolean immediateParentStubbed) {
                PsiElement element = node.getPsi();
                this.evaluator.startElement(element);
                super.visitNode(parentStub, node, immediateParentStubbed);
                if (node.getLastChildNode() == null) {
                    this.evaluator.finishElement(element);
                    ASTNode nextNode = this.peekNextElement();
                    if (nextNode != null) {
                        ASTNode nextNodeParent = nextNode.getTreeParent();
                        for (ASTNode currentParent = node.getTreeParent(); currentParent != null && currentParent != nextNodeParent; currentParent = currentParent.getTreeParent()) {
                            this.evaluator.finishElement(currentParent.getPsi());
                        }
                    }
                }
            }
        }.buildStubTree();
        ((JSFileStubImpl)parentStub).setCachedData(cachedData);
        return parentStub;
    }

    @NotNull
    protected StubElement createStubForFile(@NotNull PsiFile file) {
        if (file == null) {
            JSFileStubBuilder.$$$reportNull$$$0(1);
        }
        if (file instanceof JSFile) {
            JSFileStubImpl jSFileStubImpl = new JSFileStubImpl((JSFile)file);
            if (jSFileStubImpl == null) {
                JSFileStubBuilder.$$$reportNull$$$0(2);
            }
            return jSFileStubImpl;
        }
        StubElement stubElement = super.createStubForFile(file);
        if (stubElement == null) {
            JSFileStubBuilder.$$$reportNull$$$0(3);
        }
        return stubElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/JSFileStubBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/JSFileStubBuilder";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createStubForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildStubTree";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createStubForFile";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

