/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.util.ProcessingContext;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSBooleanLiteralTypeImpl
extends JSBooleanType
implements JSPrimitiveLiteralType<Boolean> {
    private final boolean myLiteral;
    private final boolean myStrict;

    public JSBooleanLiteralTypeImpl(boolean literal, boolean strict, JSTypeSource source) {
        super(true, source, JSTypeContext.INSTANCE);
        this.myLiteral = literal;
        this.myStrict = strict;
    }

    @Override
    @NotNull
    public Boolean getLiteral() {
        Boolean bl = this.myLiteral;
        if (bl == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(0);
        }
        return bl;
    }

    @Override
    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if (format == JSType.TypeTextFormat.RESOLVED) {
            if ("Boolean" == null) {
                JSBooleanLiteralTypeImpl.$$$reportNull$$$0(1);
            }
            return "Boolean";
        }
        String stringVal = Boolean.toString(this.myLiteral).toLowerCase(Locale.getDefault());
        if (format == JSType.TypeTextFormat.PRESENTABLE || format == JSType.TypeTextFormat.CODE) {
            String string = this.isTypeScript() && this.myStrict ? stringVal : "boolean";
            if (string == null) {
                JSBooleanLiteralTypeImpl.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (format == JSType.TypeTextFormat.SERIALIZED) {
            String string = stringVal + (this.myStrict ? "!" : "");
            if (string == null) {
                JSBooleanLiteralTypeImpl.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = "Boolean(" + stringVal + ")";
        if (string == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(5);
        }
        if (elementType instanceof JSBooleanLiteralTypeImpl && this.getSource().isExplicitlyDeclared() && this.myStrict) {
            return this.myLiteral == ((JSBooleanLiteralTypeImpl)elementType).myLiteral;
        }
        if (this.myStrict && elementType instanceof JSBooleanType) {
            return false;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(6);
        }
        return type instanceof JSBooleanLiteralTypeImpl && this.myLiteral == ((JSBooleanLiteralTypeImpl)type).myLiteral;
    }

    @Override
    @NotNull
    protected JSBooleanLiteralTypeImpl copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(7);
        }
        JSBooleanLiteralTypeImpl jSBooleanLiteralTypeImpl = new JSBooleanLiteralTypeImpl((boolean)this.getLiteral(), this.myStrict, source);
        if (jSBooleanLiteralTypeImpl == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(8);
        }
        return jSBooleanLiteralTypeImpl;
    }

    @Override
    public boolean isStrict() {
        return this.myStrict;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSBooleanLiteralTypeImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteral";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSBooleanLiteralTypeImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToImpl";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

