/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSSimpleTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.openapi.util.Segment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSEvaluableTypeBase
extends JSSimpleTypeBaseImpl
implements JSEvaluableType {
    protected JSEvaluableTypeBase(@NotNull JSTypeSource source) {
        if (source == null) {
            JSEvaluableTypeBase.$$$reportNull$$$0(0);
        }
        super(source);
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if (format == JSType.TypeTextFormat.SERIALIZED || format == JSType.TypeTextFormat.SIMPLE) {
            Segment range = this.getSegment();
            String string = range == null ? JSAnyType.get((PsiElement)this.getScope(), false).getTypeText(JSType.TypeTextFormat.SERIALIZED) : this.getPrefix() + "(" + range.getStartOffset() + "," + range.getEndOffset() + ")";
            if (string == null) {
                JSEvaluableTypeBase.$$$reportNull$$$0(1);
            }
            return string;
        }
        JSType evaluatedType = this.evaluateType();
        String string = evaluatedType.getTypeText(format);
        if (string == null) {
            JSEvaluableTypeBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSEvaluableTypeBase.$$$reportNull$$$0(3);
        }
        JSType type = this.evaluateType();
        return type.isDirectlyAssignableType(elementType, processingContext);
    }

    @Nullable
    protected PsiElement findElementToProcess(@Nullable Segment range) {
        PsiElement element;
        JSTypeSource source = this.getSource();
        PsiElement sourceElement = source.getSourceElement();
        if (sourceElement == null || !sourceElement.isValid()) {
            return null;
        }
        PsiFile scope = source.getScope();
        if (scope == null) {
            return null;
        }
        PsiElement psiElement = element = range != null ? scope.findElementAt(range.getStartOffset()) : null;
        while (element != null && !(element instanceof PsiFile) && element.getTextRange().getStartOffset() == range.getStartOffset() && element.getTextRange().getEndOffset() <= range.getEndOffset()) {
            if (element.getTextRange().getEndOffset() == range.getEndOffset() && this.isElementAcceptable(element)) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    protected abstract boolean isElementAcceptable(@NotNull PsiElement var1);

    @NotNull
    protected abstract JSType processElement(@NotNull PsiElement var1, @NotNull JSType var2, @Nullable Set<PsiElement> var3);

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSEvaluableTypeBase.$$$reportNull$$$0(4);
        }
        if (this.getClass() != type.getClass()) {
            return false;
        }
        if (!allowResolve) {
            JSEvaluableTypeBase otherType = (JSEvaluableTypeBase)type;
            Segment segment = this.getSegment();
            Segment otherTypeSegment = otherType.getSegment();
            if (segment != null && segment.equals(otherTypeSegment)) {
                return this.getSource().getSourceElement() == otherType.getSource().getSourceElement();
            }
            return false;
        }
        JSType thisType = this.evaluateType();
        type = ((JSEvaluableTypeBase)type).evaluateType();
        return thisType.isEquivalentTo(type, processingContext);
    }

    public abstract JSType evaluateType();

    protected abstract String getPrefix();

    @Nullable
    public abstract Segment getSegment();

    @Override
    @NotNull
    public JSType substitute() {
        JSType jSType = this.evaluateType();
        if (jSType == null) {
            JSEvaluableTypeBase.$$$reportNull$$$0(5);
        }
        return jSType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSEvaluableTypeBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSEvaluableTypeBase";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

