/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.LinkedMultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIntersectionTypeImpl
extends JSCompositeTypeBaseImpl
implements JSUnionOrIntersectionType {
    public static final String SEPARATOR = "&";

    public static JSType getIntersectionType(@NotNull Collection<JSType> types, JSTypeSource source) {
        if (types == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(0);
        }
        LinkedHashSet plainTypes = ContainerUtil.newLinkedHashSet();
        JSIntersectionTypeImpl.addTypesOverIntersection(types, plainTypes);
        if (plainTypes.size() == 0) {
            return JSAnyType.get(null, false);
        }
        if (plainTypes.size() == 1) {
            return (JSType)ContainerUtil.getFirstItem((Collection)plainTypes);
        }
        if (JSIntersectionTypeImpl.hasAnyType(plainTypes)) {
            JSType item = (JSType)ContainerUtil.getFirstItem((Collection)plainTypes);
            assert (item != null);
            return JSAnyType.get(null, true);
        }
        return new JSIntersectionTypeImpl(source, plainTypes);
    }

    public static boolean hasAnyType(@NotNull Collection<JSType> types) {
        if (types == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(1);
        }
        for (JSType type : types) {
            if (!(type instanceof JSAnyType)) continue;
            return true;
        }
        return false;
    }

    private static void addTypesOverIntersection(@Nullable Collection<JSType> typesToAdd, @NotNull Collection<JSType> types) {
        if (types == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(2);
        }
        if (typesToAdd == null) {
            return;
        }
        for (JSType type : typesToAdd) {
            if (type instanceof JSIntersectionTypeImpl) {
                JSIntersectionTypeImpl.addTypesOverIntersection(((JSIntersectionTypeImpl)type).getTypes(), types);
                continue;
            }
            types.add(type);
        }
    }

    public JSIntersectionTypeImpl(JSTypeSource source, Collection<JSType> _types) {
        super(source, _types);
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(3);
        }
        if (this.isEquivalentTo(elementType, processingContext)) {
            return true;
        }
        boolean allAssignable = true;
        for (JSType type : this.getTypes()) {
            if (type.isDirectlyAssignableType(elementType, processingContext)) continue;
            allAssignable = false;
            break;
        }
        if (allAssignable) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    @NotNull
    protected String getTypeSeparator() {
        if (SEPARATOR == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(4);
        }
        return SEPARATOR;
    }

    @Override
    @NotNull
    protected JSIntersectionTypeImpl createType(@NotNull List<JSType> transformedTypes, @NotNull JSTypeSource newSource) {
        if (transformedTypes == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(5);
        }
        if (newSource == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(6);
        }
        JSIntersectionTypeImpl jSIntersectionTypeImpl = new JSIntersectionTypeImpl(newSource, transformedTypes);
        if (jSIntersectionTypeImpl == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(7);
        }
        return jSIntersectionTypeImpl;
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType result = this.getSimpleCompositeTypeResult();
        if (result != null) {
            JSType jSType = result;
            if (jSType == null) {
                JSIntersectionTypeImpl.$$$reportNull$$$0(8);
            }
            return jSType;
        }
        Collection<JSRecordType> resolvedTypes = this.getNestedTypesAsRecordType();
        if (resolvedTypes.isEmpty()) {
            JSAnyType jSAnyType = JSAnyType.get(this.getSource().getSourceElement(), this.isExplicitlyDeclared());
            if (jSAnyType == null) {
                JSIntersectionTypeImpl.$$$reportNull$$$0(9);
            }
            return jSAnyType;
        }
        ArrayList resultMembers = ContainerUtil.newArrayList();
        LinkedMultiMap map = new LinkedMultiMap();
        for (JSRecordType resolvedType : resolvedTypes) {
            for (JSRecordType.TypeMember member : resolvedType.getTypeMembers()) {
                if (member instanceof JSRecordType.PropertySignature) {
                    JSRecordType.PropertySignature propertySignature = (JSRecordType.PropertySignature)member;
                    map.putValue((Object)propertySignature.getMemberName(), (Object)propertySignature);
                    continue;
                }
                resultMembers.add(member);
            }
        }
        if (map.size() > 0) {
            for (Map.Entry entry : map.entrySet()) {
                Collection value = (Collection)entry.getValue();
                if (value.size() == 1) {
                    resultMembers.add(ContainerUtil.getFirstItem((Collection)value));
                    continue;
                }
                boolean isOptional = true;
                ArrayList types = ContainerUtil.newArrayList();
                PsiElement propertySource = null;
                for (JSRecordType.PropertySignature signature : value) {
                    if (!signature.isOptional()) {
                        isOptional = false;
                    }
                    if (signature.getType() == null) continue;
                    types.add(signature.getType());
                    propertySource = signature.getSource();
                }
                JSType resultType = JSIntersectionTypeImpl.getIntersectionType(types, this.getSource());
                if (types.size() != 1) {
                    propertySource = null;
                }
                resultMembers.add(new JSRecordTypeImpl.PropertySignatureImpl((String)entry.getKey(), resultType, isOptional, propertySource));
            }
        }
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(this.getSource(), resultMembers);
        if (jSRecordTypeImpl == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(10);
        }
        return jSRecordTypeImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSIntersectionTypeImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformedTypes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSIntersectionTypeImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSeparator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIntersectionType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasAnyType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addTypesOverIntersection";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

