/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSNumberLiteralTypeImpl
extends JSNumberType
implements JSPrimitiveLiteralType<Double> {
    private final double myLiteral;
    private final boolean myStrict;
    @Nullable
    private final String myValueAsString;

    public JSNumberLiteralTypeImpl(double literal, boolean strict, JSTypeSource source, @Nullable String valueAsString) {
        super(true, source, JSTypeContext.INSTANCE);
        this.myLiteral = literal;
        this.myStrict = strict;
        this.myValueAsString = valueAsString;
    }

    @Nullable
    public String getValueAsString() {
        return this.myValueAsString;
    }

    @Override
    public Double getLiteral() {
        return this.myLiteral;
    }

    @Override
    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        String stringVal;
        if (format == JSType.TypeTextFormat.RESOLVED) {
            if ("Number" == null) {
                JSNumberLiteralTypeImpl.$$$reportNull$$$0(0);
            }
            return "Number";
        }
        String string = stringVal = this.myValueAsString != null ? this.myValueAsString : Double.toString(this.myLiteral);
        if (format == JSType.TypeTextFormat.PRESENTABLE || format == JSType.TypeTextFormat.CODE) {
            String string2 = this.isTypeScript() && this.myStrict ? stringVal : "number";
            if (string2 == null) {
                JSNumberLiteralTypeImpl.$$$reportNull$$$0(1);
            }
            return string2;
        }
        if (format == JSType.TypeTextFormat.SERIALIZED) {
            String string3 = stringVal + (this.myStrict ? "!" : "");
            if (string3 == null) {
                JSNumberLiteralTypeImpl.$$$reportNull$$$0(2);
            }
            return string3;
        }
        String string4 = "Number(" + stringVal + ")";
        if (string4 == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(3);
        }
        return string4;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(4);
        }
        if (elementType instanceof JSNumberLiteralTypeImpl && this.getSource().isExplicitlyDeclared() && this.myStrict) {
            return this.myLiteral == ((JSNumberLiteralTypeImpl)elementType).myLiteral;
        }
        if (this.myStrict && elementType instanceof JSNumberType) {
            return false;
        }
        if (this.myStrict && elementType instanceof JSTypeImpl) {
            JSTypeImpl elementImpl = (JSTypeImpl)elementType;
            if (elementImpl.isEnumLiteral()) {
                EnumConstantValue field = TypeScriptUtil.getEnumLiteralValue(elementImpl);
                Double value = field.getNumericValue();
                return value != null && value == this.myLiteral;
            }
            if (elementImpl.isEnum()) {
                return false;
            }
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(5);
        }
        return type instanceof JSNumberLiteralTypeImpl && this.myLiteral == ((JSNumberLiteralTypeImpl)type).myLiteral;
    }

    @Override
    @NotNull
    protected JSNumberLiteralTypeImpl copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(6);
        }
        JSNumberLiteralTypeImpl jSNumberLiteralTypeImpl = new JSNumberLiteralTypeImpl(this.getLiteral(), this.myStrict, source, this.myValueAsString);
        if (jSNumberLiteralTypeImpl == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(7);
        }
        return jSNumberLiteralTypeImpl;
    }

    @Override
    public boolean isStrict() {
        return this.myStrict;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSNumberLiteralTypeImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSNumberLiteralTypeImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToImpl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

