/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.TypeScriptIndexedAccessJSTypeImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptMappedJSTypeImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure {
    private final boolean myReadonly;
    private final boolean myOptional;
    @Nullable
    private final String myParameterName;
    @NotNull
    private final JSType myParameterType;
    @NotNull
    private final JSType myResultType;

    public TypeScriptMappedJSTypeImpl(@NotNull JSTypeSource source, boolean isReadonly, boolean isOptional, @Nullable String parameterName, @NotNull JSType parameterType, @NotNull JSType resultType) {
        if (source == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(0);
        }
        if (parameterType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(1);
        }
        if (resultType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(2);
        }
        super(source);
        this.myReadonly = isReadonly;
        this.myOptional = isOptional;
        this.myParameterName = parameterName;
        this.myParameterType = parameterType;
        this.myResultType = resultType;
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        boolean isSerialized = format == JSType.TypeTextFormat.SERIALIZED;
        StringBuilder builder = new StringBuilder();
        if (isSerialized) {
            builder.append("#mapped");
        }
        builder.append("{");
        if (this.isReadonly()) {
            builder.append(isSerialized ? "r" : "readonly ");
        }
        builder.append("[");
        String name = this.getParameterName();
        builder.append(name == null ? "MapParameter" : name);
        builder.append(isSerialized ? "+" : " in ");
        builder.append(this.getParameterType().getTypeText(format));
        builder.append("]");
        if (this.isOptional()) {
            builder.append("?");
        }
        builder.append(":");
        builder.append(this.getResultType().getTypeText(format));
        builder.append("}");
        String string = builder.toString();
        if (string == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    protected TypeScriptMappedJSTypeImpl copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(4);
        }
        TypeScriptMappedJSTypeImpl typeScriptMappedJSTypeImpl = new TypeScriptMappedJSTypeImpl(this.getSource(), this.isReadonly(), this.isOptional(), this.myParameterName, JSTypeUtils.transformTypeHierarchySafe(this.getParameterType(), childTransform), JSTypeUtils.transformTypeHierarchySafe(this.getResultType(), childTransform));
        if (typeScriptMappedJSTypeImpl == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(5);
        }
        return typeScriptMappedJSTypeImpl;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(6);
        }
        TypeScriptMappedJSTypeImpl typeScriptMappedJSTypeImpl = new TypeScriptMappedJSTypeImpl(source, this.myReadonly, this.myOptional, this.myParameterName, this.myParameterType, this.myResultType);
        if (typeScriptMappedJSTypeImpl == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(7);
        }
        return typeScriptMappedJSTypeImpl;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        JSType substitute;
        if (elementType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(8);
        }
        if ((substitute = this.substitute()) != this) {
            return substitute.isDirectlyAssignableType(elementType, processingContext);
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSTypeSource source = this.getSource();
        PsiElement element = source.getSourceElement();
        if (element != null && element.isValid()) {
            CachedValuesManager manager = CachedValuesManager.getManager((Project)element.getProject());
            JSType jSType = (JSType)manager.getCachedValue((UserDataHolder)this, () -> CachedValueProvider.Result.create((Object)this.substituteImpl(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
            if (jSType == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(9);
            }
            return jSType;
        }
        JSType jSType = this.substituteImpl();
        if (jSType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(10);
        }
        return jSType;
    }

    @NotNull
    private JSType substituteImpl() {
        JSType type = JSTypeUtils.getValuableType(this.getParameterType());
        Collection<JSStringLiteralTypeImpl> strings = TypeScriptIndexedAccessJSTypeImpl.getParameterStrings(type);
        String name = this.getParameterName();
        if (strings.isEmpty() || name == null) {
            JSAnyType jSAnyType = JSAnyType.getWithLanguage(this.getSource().getLanguage(), this.getSource().isExplicitlyDeclared());
            if (jSAnyType == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(11);
            }
            return jSAnyType;
        }
        JSType resultType = JSTypeUtils.getValuableType(this.getResultType());
        boolean optional = this.isOptional();
        List result = ContainerUtil.newSmartList();
        if (resultType instanceof TypeScriptIndexedAccessJSTypeImpl && TypeScriptMappedJSTypeImpl.isParameter(name, ((TypeScriptIndexedAccessJSTypeImpl)resultType).getParameterType())) {
            TypeScriptIndexedAccessJSTypeImpl accessJSType = (TypeScriptIndexedAccessJSTypeImpl)resultType;
            JSRecordType ownerRecordType = accessJSType.getOwner().asRecordType();
            Set propertyNames = strings.stream().map(el -> el.getLiteral()).collect(Collectors.toSet());
            for (JSRecordType.TypeMember member : ownerRecordType.getTypeMembers()) {
                JSRecordType.PropertySignature propertySignature;
                String memberName;
                if (!(member instanceof JSRecordType.PropertySignature) || !propertyNames.contains(memberName = (propertySignature = (JSRecordType.PropertySignature)member).getMemberName())) continue;
                boolean overrideOptional = optional == propertySignature.isOptional();
                result.add(overrideOptional ? new JSRecordTypeImpl.PropertySignatureImpl(memberName, propertySignature.getType(), optional, propertySignature.getSource()) : propertySignature);
            }
        } else {
            for (JSStringLiteralTypeImpl string : strings) {
                JSType propertyType = JSTypeUtils.transformTypeHierarchySafe(resultType, (Function<JSType, JSType>)((Function)el -> {
                    if (TypeScriptMappedJSTypeImpl.isParameter(name, el)) {
                        return string;
                    }
                    return el;
                }));
                if (propertyType instanceof TypeScriptIndexedAccessJSTypeImpl) {
                    propertyType = propertyType.substitute();
                }
                result.add(new JSRecordTypeImpl.PropertySignatureImpl(string.getLiteral(), propertyType, optional));
            }
        }
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(this.getSource(), result);
        if (jSRecordTypeImpl == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(12);
        }
        return jSRecordTypeImpl;
    }

    private static boolean isParameter(@NotNull String name, @NotNull JSType el) {
        if (name == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(13);
        }
        if (el == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(14);
        }
        return el instanceof JSTypeImpl && name.equals(el.getTypeText(JSType.TypeTextFormat.SIMPLE));
    }

    public boolean isReadonly() {
        return this.myReadonly;
    }

    @Override
    protected boolean isEquivalentToImpl(@NotNull JSType type, ProcessingContext context, boolean allowResolve) {
        if (type == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(15);
        }
        if (type instanceof TypeScriptMappedJSTypeImpl) {
            TypeScriptMappedJSTypeImpl mappedType = (TypeScriptMappedJSTypeImpl)type;
            return this.isReadonly() == mappedType.isReadonly() && this.isOptional() == mappedType.isOptional() && this.getParameterType().isEquivalentTo(mappedType.getParameterType(), context, allowResolve) && this.getResultType().isEquivalentTo(mappedType.getResultType(), context, allowResolve);
        }
        return false;
    }

    @NotNull
    public JSType getParameterType() {
        JSType jSType = this.myParameterType;
        if (jSType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(16);
        }
        return jSType;
    }

    @NotNull
    public JSType getResultType() {
        JSType jSType = this.myResultType;
        if (jSType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(17);
        }
        return jSType;
    }

    public boolean isOptional() {
        return this.myOptional;
    }

    @Nullable
    public String getParameterName() {
        return this.myParameterName;
    }

    @Override
    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
        this.myResultType.accept(visitor);
        this.myParameterType.accept(visitor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultType";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteImpl";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isParameter";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

