/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.flow.psi.impl.FlowJSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.flow.psi.impl.FlowJSMaybeTypeImpl;
import com.intellij.lang.javascript.flow.psi.impl.FlowJSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptArrayType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptBooleanLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexedAccessType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptMappedType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptNumberLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptStringLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptThisType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTupleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeOperator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypePredicate;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeofType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDecoratedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptIndexedAccessJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptMappedJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeMemberParser;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeOfJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeOperatorJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypePredicateTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeParser {
    private static final ParameterizedCachedValueProvider<JSRecordType, JSClass> BUILD_CLASS_PROVIDER = new ParameterizedCachedValueProvider<JSRecordType, JSClass>(){

        @NotNull
        public CachedValueProvider.Result<JSRecordType> compute(@NotNull JSClass currentClass) {
            JSRecordType result;
            if (currentClass == null) {
                1.$$$reportNull$$$0(0);
            }
            if ((result = (JSRecordType)RecursionManager.doPreventingRecursion((Object)currentClass, (boolean)false, () -> {
                if (currentClass == null) {
                    1.$$$reportNull$$$0(2);
                }
                return TypeScriptTypeParser.buildTypeFromClass(currentClass, false, true);
            })) == null) {
                result = new JSRecordTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)currentClass, false), ContainerUtil.emptyList());
            }
            CachedValueProvider.Result result2 = CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
            if (result2 == null) {
                1.$$$reportNull$$$0(1);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "compute";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$compute$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final Key<ParameterizedCachedValue<JSRecordType, JSClass>> BUILD_CLASS_CACHE_KEY = Key.create((String)"ts.create.record.cl");
    private static Function<JSType, Error> VALIDATE_TYPE_FUNCTION = null;
    public static final Function<JSTypeDeclaration, JSType> MAP_DECLARATION_TO_TYPE = TypeScriptTypeParser::buildTypeFromTypeScript;

    public static void setValidateTypeFunction(Function<JSType, Error> func) {
        VALIDATE_TYPE_FUNCTION = func;
    }

    @NotNull
    public static JSType buildTypeFromTypeScript(@NotNull JSTypeDeclaration type) {
        Error message;
        if (type == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(0);
        }
        JSType resultType = TypeScriptTypeParser.buildTypeFromTypeScriptImpl(type);
        if (VALIDATE_TYPE_FUNCTION != null && (message = (Error)VALIDATE_TYPE_FUNCTION.fun((Object)resultType)) != null) {
            throw message;
        }
        JSType jSType = resultType;
        if (jSType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(1);
        }
        return jSType;
    }

    @NotNull
    private static JSType buildTypeFromTypeScriptImpl(@NotNull JSTypeDeclaration type) {
        if (type == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(2);
        }
        JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)type, true);
        if (type instanceof TypeScriptObjectType) {
            ArrayList<JSRecordType.TypeMember> typeMembers = new ArrayList<JSRecordType.TypeMember>();
            TypeScriptTypeParser.addObjectTypeProperties(typeMembers, (TypeScriptObjectType)type, JSTypeSubstitutor.EMPTY);
            JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(source, typeMembers);
            if (jSRecordTypeImpl == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(3);
            }
            return jSRecordTypeImpl;
        }
        if (type instanceof TypeScriptFunctionType) {
            JSType jsType = TypeScriptTypeParser.buildFunctionType((JSFunction)((TypeScriptFunctionType)type));
            if (((TypeScriptFunctionType)type).isConstructor() && jsType instanceof JSFunctionTypeImpl) {
                SmartList typeMembers = new SmartList((Object)new JSRecordTypeImpl.CallSignatureImpl(true, (JSFunctionTypeImpl)jsType));
                JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(source, (List<JSRecordType.TypeMember>)typeMembers);
                if (jSRecordTypeImpl == null) {
                    TypeScriptTypeParser.$$$reportNull$$$0(4);
                }
                return jSRecordTypeImpl;
            }
            JSType jSType = jsType;
            if (jSType == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(5);
            }
            return jSType;
        }
        if (type instanceof TypeScriptArrayType) {
            TypeScriptType arrayBaseType = ((TypeScriptArrayType)type).getType();
            JSType baseType = arrayBaseType != null ? TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)arrayBaseType) : JSAnyType.get((PsiElement)type, false);
            JSArrayTypeImpl jSArrayTypeImpl = new JSArrayTypeImpl(baseType, source);
            if (jSArrayTypeImpl == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(6);
            }
            return jSArrayTypeImpl;
        }
        if (type instanceof TypeScriptSingleType) {
            String typeName = ((TypeScriptSingleType)type).getQualifiedTypeName();
            if (typeName != null) {
                TypeScriptTypeArgumentList typeArguments;
                TypeScriptTypeParameterListOwner parameterListOwner = (TypeScriptTypeParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)type, TypeScriptTypeParameterListOwner.class);
                TypeScriptTypeParameterList partOfList = (TypeScriptTypeParameterList)PsiTreeUtil.getParentOfType((PsiElement)type, TypeScriptTypeParameterList.class);
                JSType baseType = null;
                while (parameterListOwner != null) {
                    TypeScriptTypeParameterList typeParameterList = parameterListOwner.getTypeParameterList();
                    if (typeParameterList != null) {
                        TypeScriptTypeParameter[] parameters;
                        for (TypeScriptTypeParameter parameter : parameters = typeParameterList.getTypeParameters()) {
                            if (!StringUtil.equals((CharSequence)typeName, (CharSequence)parameter.getName())) continue;
                            TypeScriptType constraint = parameter.getTypeConstraint();
                            JSType constraintType = null;
                            if (constraint != null && partOfList == null) {
                                constraintType = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)constraint);
                            }
                            baseType = new JSGenericParameterImpl(typeName, source, constraintType);
                        }
                    }
                    parameterListOwner = (TypeScriptTypeParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)parameterListOwner, TypeScriptTypeParameterListOwner.class);
                }
                if (baseType == null) {
                    baseType = JSNamedType.createType(typeName, source, JSContext.INSTANCE);
                }
                if ((typeArguments = ((TypeScriptSingleType)type).getTypeArguments()) != null) {
                    JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(source, baseType, ContainerUtil.map((Object[])typeArguments.getTypeArguments(), MAP_DECLARATION_TO_TYPE));
                    if (jSGenericTypeImpl == null) {
                        TypeScriptTypeParser.$$$reportNull$$$0(7);
                    }
                    return jSGenericTypeImpl;
                }
                JSType jSType = baseType;
                if (jSType == null) {
                    TypeScriptTypeParser.$$$reportNull$$$0(8);
                }
                return jSType;
            }
        } else if (type instanceof TypeScriptStringLiteralType) {
            String literal = ((TypeScriptStringLiteralType)type).getInnerText();
            if (literal != null) {
                JSStringLiteralTypeImpl jSStringLiteralTypeImpl = new JSStringLiteralTypeImpl(literal, true, source);
                if (jSStringLiteralTypeImpl == null) {
                    TypeScriptTypeParser.$$$reportNull$$$0(9);
                }
                return jSStringLiteralTypeImpl;
            }
        } else if (type instanceof TypeScriptNumberLiteralType) {
            Double parsedLiteral;
            String literal = ((TypeScriptNumberLiteralType)type).getInnerText();
            if (literal != null && (parsedLiteral = JSNumberParser.tryParseNumericValue(literal)) != null) {
                JSNumberLiteralTypeImpl jSNumberLiteralTypeImpl = new JSNumberLiteralTypeImpl(parsedLiteral, true, source, literal);
                if (jSNumberLiteralTypeImpl == null) {
                    TypeScriptTypeParser.$$$reportNull$$$0(10);
                }
                return jSNumberLiteralTypeImpl;
            }
        } else {
            if (type instanceof TypeScriptBooleanLiteralType) {
                JSBooleanLiteralTypeImpl jSBooleanLiteralTypeImpl = new JSBooleanLiteralTypeImpl(((TypeScriptBooleanLiteralType)type).getValue(), true, source);
                if (jSBooleanLiteralTypeImpl == null) {
                    TypeScriptTypeParser.$$$reportNull$$$0(11);
                }
                return jSBooleanLiteralTypeImpl;
            }
            if (type instanceof TypeScriptTypeofType) {
                PsiElement owner;
                TypeScriptTypeofType typeofType = (TypeScriptTypeofType)type;
                String text = typeofType.getReferenceText();
                if (text != null && TypeScriptTypeParser.canUseTypeOf(owner = typeofType.getOwner())) {
                    TypeScriptTypeOfJSTypeImpl typeScriptTypeOfJSTypeImpl = new TypeScriptTypeOfJSTypeImpl(text, source);
                    if (typeScriptTypeOfJSTypeImpl == null) {
                        TypeScriptTypeParser.$$$reportNull$$$0(12);
                    }
                    return typeScriptTypeOfJSTypeImpl;
                }
                JSExpression expression = typeofType.getExpression();
                if (expression != null) {
                    JSTypeofTypeImpl jSTypeofTypeImpl = new JSTypeofTypeImpl(expression, source);
                    if (jSTypeofTypeImpl == null) {
                        TypeScriptTypeParser.$$$reportNull$$$0(13);
                    }
                    return jSTypeofTypeImpl;
                }
            } else if (type instanceof TypeScriptUnionOrIntersectionType) {
                ArrayList types = ContainerUtil.newArrayList();
                TypeScriptUnionOrIntersectionType unionOrIntersectionType = (TypeScriptUnionOrIntersectionType)type;
                for (TypeScriptType scriptType : unionOrIntersectionType.getTypes()) {
                    types.add(TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)scriptType));
                }
                if (unionOrIntersectionType.isUnionType()) {
                    ContainerUtil.sort((List)types, JSCompositeTypeImpl.GENERIC_PARAMETER_LAST);
                    JSCompositeTypeImpl jSCompositeTypeImpl = new JSCompositeTypeImpl(source, types);
                    if (jSCompositeTypeImpl == null) {
                        TypeScriptTypeParser.$$$reportNull$$$0(14);
                    }
                    return jSCompositeTypeImpl;
                }
                if (unionOrIntersectionType.isIntersectionType()) {
                    JSType jSType = JSIntersectionTypeImpl.getIntersectionType(types, source);
                    if (jSType == null) {
                        TypeScriptTypeParser.$$$reportNull$$$0(15);
                    }
                    return jSType;
                }
            } else if (type instanceof TypeScriptTypeOperator) {
                JSType nestedType;
                TypeScriptType operatorType = ((TypeScriptTypeOperator)type).getOperatorType();
                JSType jSType = nestedType = operatorType == null ? null : TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)operatorType);
                if (nestedType != null) {
                    TypeScriptTypeOperatorJSTypeImpl typeScriptTypeOperatorJSTypeImpl = new TypeScriptTypeOperatorJSTypeImpl(nestedType, source);
                    if (typeScriptTypeOperatorJSTypeImpl == null) {
                        TypeScriptTypeParser.$$$reportNull$$$0(16);
                    }
                    return typeScriptTypeOperatorJSTypeImpl;
                }
            } else if (type instanceof TypeScriptIndexedAccessType) {
                JSType parameterType;
                TypeScriptIndexedAccessType indexedAccessType = (TypeScriptIndexedAccessType)type;
                TypeScriptType ownerTypeElement = indexedAccessType.getOwnerTypeElement();
                JSType ownerType = ownerTypeElement == null ? null : TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)ownerTypeElement);
                TypeScriptType parameterTypeElement = indexedAccessType.getParameterTypeElement();
                JSType jSType = parameterType = parameterTypeElement == null ? null : TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)parameterTypeElement);
                if (ownerType != null && parameterType != null) {
                    TypeScriptIndexedAccessJSTypeImpl typeScriptIndexedAccessJSTypeImpl = new TypeScriptIndexedAccessJSTypeImpl(ownerType, parameterType, source);
                    if (typeScriptIndexedAccessJSTypeImpl == null) {
                        TypeScriptTypeParser.$$$reportNull$$$0(17);
                    }
                    return typeScriptIndexedAccessJSTypeImpl;
                }
            } else if (type instanceof TypeScriptMappedType) {
                TypeScriptMappedType mappedType = (TypeScriptMappedType)type;
                TypeScriptType resultTypeElement = mappedType.getResultTypeElement();
                TypeScriptMappedTypeParameter parameter = mappedType.getTypeParameter();
                if (resultTypeElement != null && parameter != null) {
                    TypeScriptType parameterTypeElement = parameter.getTypeElement();
                    String name = parameter.getName();
                    if (name != null && parameterTypeElement != null) {
                        boolean optional = mappedType.isOptional();
                        boolean readonly = mappedType.isReadonly();
                        TypeScriptMappedJSTypeImpl typeScriptMappedJSTypeImpl = new TypeScriptMappedJSTypeImpl(source, readonly, optional, name, TypeScriptTypeParser.buildTypeFromTypeScriptImpl((JSTypeDeclaration)parameterTypeElement), TypeScriptTypeParser.buildTypeFromTypeScriptImpl((JSTypeDeclaration)resultTypeElement));
                        if (typeScriptMappedJSTypeImpl == null) {
                            TypeScriptTypeParser.$$$reportNull$$$0(18);
                        }
                        return typeScriptMappedJSTypeImpl;
                    }
                }
            } else {
                if (type instanceof TypeScriptTypePredicate) {
                    TypeScriptTypePredicate typePredicate = (TypeScriptTypePredicate)type;
                    JSType guardType = typePredicate.getGuardType();
                    TypeScriptTypePredicateTypeImpl typeScriptTypePredicateTypeImpl = new TypeScriptTypePredicateTypeImpl(guardType, source, typePredicate.getParameterName(), typePredicate.getParameterIndex());
                    if (typeScriptTypePredicateTypeImpl == null) {
                        TypeScriptTypeParser.$$$reportNull$$$0(19);
                    }
                    return typeScriptTypePredicateTypeImpl;
                }
                if (type instanceof TypeScriptThisType) {
                    JSClass parentClass = (JSClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)type, JSClass.class);
                    if (parentClass != null) {
                        String name = parentClass.getQualifiedName();
                        JSType parentType = name == null ? null : JSNamedType.createType(name, source, JSContext.INSTANCE);
                        TypeScriptGenericThisTypeImpl typeScriptGenericThisTypeImpl = new TypeScriptGenericThisTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)parentClass, true), parentType);
                        if (typeScriptGenericThisTypeImpl == null) {
                            TypeScriptTypeParser.$$$reportNull$$$0(20);
                        }
                        return typeScriptGenericThisTypeImpl;
                    }
                } else {
                    if (type instanceof TypeScriptTupleType) {
                        ArrayList types = ContainerUtil.newArrayList();
                        for (TypeScriptType scriptType : ((TypeScriptTupleType)type).getElements()) {
                            types.add(TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)scriptType));
                        }
                        JSTupleTypeImpl jSTupleTypeImpl = new JSTupleTypeImpl(source, types, true);
                        if (jSTupleTypeImpl == null) {
                            TypeScriptTypeParser.$$$reportNull$$$0(21);
                        }
                        return jSTupleTypeImpl;
                    }
                    if (type instanceof FlowJSMaybeTypeImpl) {
                        JSTypeDeclaration innerType = ((FlowJSMaybeTypeImpl)type).getType();
                        if (innerType != null) {
                            JSType innerJSType = TypeScriptTypeParser.buildTypeFromTypeScriptImpl(innerType);
                            JSDecoratedTypeImpl jSDecoratedTypeImpl = new JSDecoratedTypeImpl(source, innerJSType, Collections.singleton(JSDecoratedTypeImpl.TypeDecoration.NULLABLE));
                            if (jSDecoratedTypeImpl == null) {
                                TypeScriptTypeParser.$$$reportNull$$$0(22);
                            }
                            return jSDecoratedTypeImpl;
                        }
                    } else {
                        if (type instanceof FlowJSBooleanLiteralTypeImpl) {
                            JSBooleanType jSBooleanType = new JSBooleanType(true, source, JSTypeContext.INSTANCE);
                            if (jSBooleanType == null) {
                                TypeScriptTypeParser.$$$reportNull$$$0(23);
                            }
                            return jSBooleanType;
                        }
                        if (type instanceof FlowJSNumberLiteralTypeImpl) {
                            JSNumberType jSNumberType = new JSNumberType(true, source, JSTypeContext.INSTANCE);
                            if (jSNumberType == null) {
                                TypeScriptTypeParser.$$$reportNull$$$0(24);
                            }
                            return jSNumberType;
                        }
                    }
                }
            }
        }
        JSAnyType jSAnyType = JSAnyType.get((PsiElement)type, false);
        if (jSAnyType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(25);
        }
        return jSAnyType;
    }

    private static boolean canUseTypeOf(@Nullable PsiElement owner) {
        if (owner instanceof JSParameter) {
            return TypeScriptTypeParser.canUseTypeOf((PsiElement)((JSParameter)owner).getDeclaringFunction());
        }
        return PsiTreeUtil.getParentOfType((PsiElement)owner, (Class[])new Class[]{JSFunction.class, JSBlockStatement.class}) == null;
    }

    @NotNull
    public static JSType buildFunctionType(@NotNull JSFunction function) {
        if (function == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(26);
        }
        TypeScriptJSFunctionTypeImpl jsType = TypeScriptTypeParser.buildFunctionTypeWithoutTypeArguments(function);
        if (!(function instanceof TypeScriptFunction)) {
            TypeScriptJSFunctionTypeImpl typeScriptJSFunctionTypeImpl = jsType;
            if (typeScriptJSFunctionTypeImpl == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(27);
            }
            return typeScriptJSFunctionTypeImpl;
        }
        TypeScriptTypeParameter[] parameters = TypeScriptPsiUtil.getTypeParametersForOwner((PsiElement)function);
        if (parameters.length == 0) {
            TypeScriptJSFunctionTypeImpl typeScriptJSFunctionTypeImpl = jsType;
            if (typeScriptJSFunctionTypeImpl == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(28);
            }
            return typeScriptJSFunctionTypeImpl;
        }
        List<JSType> generics = TypeScriptGenericTypesEvaluator.buildGenericParameters(parameters);
        JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(jsType.getSource(), (JSType)jsType, generics);
        if (jSGenericTypeImpl == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(29);
        }
        return jSGenericTypeImpl;
    }

    @NotNull
    public static TypeScriptJSFunctionTypeImpl buildFunctionTypeWithoutTypeArguments(@NotNull JSFunction type) {
        if (type == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(30);
        }
        TypeScriptJSFunctionTypeImpl typeScriptJSFunctionTypeImpl = TypeScriptTypeParser.buildFunctionTypeWithoutTypeArguments(type, type.getReturnType());
        if (typeScriptJSFunctionTypeImpl == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(31);
        }
        return typeScriptJSFunctionTypeImpl;
    }

    static TypeScriptJSFunctionTypeImpl buildFunctionTypeWithoutTypeArguments(@NotNull JSFunction type, @Nullable JSType returnType) {
        if (type == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(32);
        }
        SmartList decorators = new SmartList();
        JSParameterListElement[] parameters = type.getParameters();
        String[] parameterNames = ArrayUtil.EMPTY_STRING_ARRAY;
        if (parameters.length > 0) {
            parameterNames = new String[parameters.length];
        }
        int index = 0;
        for (JSParameterListElement p : parameters) {
            decorators.add(p.getTypeDecorator());
            parameterNames[index++] = p.getName();
        }
        return new TypeScriptJSFunctionTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)type, true), (List<JSParameterTypeDecorator>)decorators, parameterNames, returnType);
    }

    private static void addObjectTypeProperties(@NotNull List<JSRecordType.TypeMember> typeMembers, @Nullable TypeScriptObjectType type, @Nullable JSTypeSubstitutor typeSubstitutor) {
        TypeScriptTypeMember[] members;
        if (typeMembers == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(33);
        }
        if (type == null) {
            return;
        }
        for (TypeScriptTypeMember member : members = type.getTypeMembers()) {
            JSRecordType.TypeMember typeMember = TypeScriptTypeMemberParser.buildTypeMember(member, typeSubstitutor);
            if (typeMember == null) continue;
            typeMembers.add(typeMember);
        }
    }

    @NotNull
    public static JSRecordType buildTypeFromClass(@NotNull JSClass clazz, boolean isStatic) {
        if (clazz == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(34);
        }
        if (!isStatic) {
            JSRecordType jSRecordType = (JSRecordType)CachedValuesManager.getManager((Project)clazz.getProject()).getParameterizedCachedValue((UserDataHolder)clazz, BUILD_CLASS_CACHE_KEY, BUILD_CLASS_PROVIDER, false, (Object)clazz);
            if (jSRecordType == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(35);
            }
            return jSRecordType;
        }
        JSRecordType jSRecordType = TypeScriptTypeParser.buildTypeFromClass(clazz, true, true);
        if (jSRecordType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(36);
        }
        return jSRecordType;
    }

    public static JSRecordType buildTypeFromClass(@NotNull JSClass clazz, boolean isStatic, boolean includeSupers) {
        if (clazz == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(37);
        }
        return TypeScriptTypeParser.buildTypeFromClass(clazz, isStatic, includeSupers, true);
    }

    @NotNull
    public static JSRecordType buildTypeFromClass(final @NotNull JSClass clazz, final boolean isStatic, boolean includeSupers, final boolean includeAbstractMembers) {
        JSType declaration;
        if (clazz == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(38);
        }
        if (clazz instanceof TypeScriptTypeAlias && (declaration = ((TypeScriptTypeAlias)clazz).getParsedTypeDeclaration()) != null) {
            JSRecordType jSRecordType = declaration.asRecordType();
            if (jSRecordType == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(39);
            }
            return jSRecordType;
        }
        final JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)clazz, true);
        final ArrayList<JSRecordType.TypeMember> typeMembers = new ArrayList<JSRecordType.TypeMember>();
        TypeScriptUtil.JSClassHierarchyProcessor processor = new TypeScriptUtil.JSClassHierarchyProcessor(){
            private boolean isFunctionProcessed = false;

            @Override
            public boolean process(@NotNull JSClass<?> currentClass, @NotNull JSTypeSubstitutor typeSubstitutor, boolean fromImplements) {
                if (currentClass == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (typeSubstitutor == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (currentClass != clazz && TypeScriptTypeParser.isFunctionClass(currentClass)) {
                    if (this.isFunctionProcessed) {
                        return true;
                    }
                    JSRecordType recordFunction = TypeScriptUtil.getFunctionTypeMembers((PsiElement)clazz);
                    if (recordFunction != null) {
                        typeMembers.addAll(recordFunction.getTypeMembers());
                    }
                    this.isFunctionProcessed = true;
                    return true;
                }
                if (currentClass instanceof TypeScriptInterface) {
                    TypeScriptObjectType body = ((TypeScriptInterface)currentClass).getBody();
                    TypeScriptTypeParser.addObjectTypeProperties(typeMembers, body, typeSubstitutor);
                } else {
                    for (JSElement element : currentClass.getMembers()) {
                        JSRecordType.TypeMember typeMember;
                        JSAttributeListOwner function;
                        JSAttributeList list;
                        if (element instanceof JSAttributeListOwner && !includeAbstractMembers && (list = (function = (JSAttributeListOwner)element).getAttributeList()) != null && list.hasModifier(JSAttributeList.ModifierType.ABSTRACT) || (typeMember = TypeScriptTypeMemberParser.buildTypeMemberFromClassMember(clazz, element, isStatic, source, typeSubstitutor)) == null) continue;
                        typeMembers.add(typeMember);
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "currentClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "typeSubstitutor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser$2";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (includeSupers) {
            JSClassUtils.processClassesInHierarchy(clazz, includeAbstractMembers, processor);
        } else {
            processor.process(clazz, JSTypeSubstitutor.EMPTY, false);
        }
        if (clazz instanceof TypeScriptClass && isStatic) {
            ArrayList constructorTypes = ContainerUtil.newArrayList();
            for (JSRecordType.TypeMember member : typeMembers) {
                if (!(member instanceof JSRecordType.CallSignature) || !((JSRecordType.CallSignature)member).hasNew()) continue;
                constructorTypes.add(member);
                break;
            }
            if (constructorTypes.isEmpty()) {
                JSType returnType = TypeScriptTypeParser.createConstructorReturnType(clazz, source);
                JSFunctionTypeImpl functionType = new JSFunctionTypeImpl(source, ContainerUtil.emptyList(), returnType);
                typeMembers.add((JSRecordType.TypeMember)new JSRecordTypeImpl.CallSignatureImpl(true, functionType));
            }
        }
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(source, typeMembers);
        if (jSRecordTypeImpl == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(40);
        }
        return jSRecordTypeImpl;
    }

    static JSType createConstructorReturnType(@NotNull JSClass clazz, @NotNull JSTypeSource source) {
        String name;
        if (clazz == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(41);
        }
        if (source == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(42);
        }
        if (StringUtil.isEmpty((String)(name = clazz.getQualifiedName()))) {
            if (clazz instanceof JSExpression) {
                return TypeScriptTypeParser.buildTypeFromClass(clazz, false);
            }
            return JSAnyType.get(source.getSourceElement(), false);
        }
        return JSNamedType.createType(name, source, JSContext.INSTANCE);
    }

    private static boolean isFunctionClass(JSClass<?> currentClass) {
        String fileName = currentClass.getContainingFile().getName();
        return "Function".equals(currentClass.getName()) && (TypeScriptLibraryProvider.LIBS_D_TS.contains(fileName) || TypeScriptLibraryProvider.FILES_FROM_TYPESCRIPT.contains(fileName));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static JSType buildTypeFromClassMember(PsiElement element) {
        if (element instanceof JSFunction) {
            if (((JSFunction)element).isGetProperty()) {
                return ((JSFunction)element).getReturnType();
            }
            if (!((JSFunction)element).isSetProperty()) return TypeScriptTypeParser.buildFunctionTypeWithoutTypeArguments((JSFunction)element);
            JSParameterListElement[] parameters = ((JSFunction)element).getParameters();
            if (parameters.length != 1) return null;
            return parameters[0].getType();
        }
        if (!(element instanceof JSTypeDeclarationOwner)) return null;
        return ((JSTypeDeclarationOwner)element).getType();
    }

    private static JSRecordType buildResolvedType(@NotNull Collection<? extends PsiElement> elements, @NotNull JSType type, @Nullable JSRecursionGuard recursionGuard) {
        if (elements == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(43);
        }
        if (type == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(44);
        }
        boolean isStatic = type instanceof JSNamedType && ((JSNamedType)type).isStaticOrInstance() == JSContext.STATIC;
        ArrayList<JSRecordType.TypeMember> members = new ArrayList<JSRecordType.TypeMember>();
        for (PsiElement psiElement : elements) {
            TypeScriptTypeParser.addTypeMembersFromClass(type, isStatic, members, psiElement, recursionGuard);
        }
        JSRecordTypeImpl resultType = new JSRecordTypeImpl(type.getSource(), members);
        return TypeScriptTypeParser.overrideSourceForLibrarySymbols(elements, resultType);
    }

    @NotNull
    private static JSRecordType overrideSourceForLibrarySymbols(@NotNull Collection<? extends PsiElement> elements, @NotNull JSRecordTypeImpl resultType) {
        if (elements == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(45);
        }
        if (resultType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(46);
        }
        if (elements.isEmpty()) {
            JSRecordTypeImpl jSRecordTypeImpl = resultType;
            if (jSRecordTypeImpl == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(47);
            }
            return jSRecordTypeImpl;
        }
        PsiElement context = elements.iterator().next();
        Set<VirtualFile> libraries = TypeScriptLibraryProvider.getAllPredefinedLibraries(context.getProject());
        boolean hasSourceFromLibrary = false;
        for (PsiElement psiElement : elements) {
            PsiFile file = psiElement.getContainingFile();
            if (file == null || !libraries.contains(file.getVirtualFile())) continue;
            hasSourceFromLibrary = true;
        }
        if (!hasSourceFromLibrary) {
            JSRecordTypeImpl jSRecordTypeImpl = resultType;
            if (jSRecordTypeImpl == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(48);
            }
            return jSRecordTypeImpl;
        }
        JSType candidate = resultType.transformTypeHierarchy((Function<JSType, JSType>)((Function)el -> {
            PsiFile file;
            if (resultType == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(58);
            }
            if (!(el instanceof JSNamedType)) {
                return el;
            }
            PsiElement element = el.getSource().getSourceElement();
            PsiFile psiFile = file = element == null ? null : element.getContainingFile();
            if (file != null && libraries.contains(file.getVirtualFile())) {
                return ((JSNamedType)((Object)((Object)el))).copyWithNewSource(resultType.getSource());
            }
            return el;
        }));
        JSRecordTypeImpl jSRecordTypeImpl = candidate instanceof JSRecordType ? (JSRecordType)candidate : resultType;
        if (jSRecordTypeImpl == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(49);
        }
        return jSRecordTypeImpl;
    }

    public static JSRecordType buildResolvedType(Collection<? extends PsiElement> elements, JSType type) {
        return TypeScriptTypeParser.buildResolvedType(elements, type, null);
    }

    @NotNull
    public static JSRecordType buildResolvedType(@Nullable JSType type) {
        Collection<? extends PsiElement> elements = TypeScriptTypeParser.resolveElementsByType(type);
        JSRecordType jSRecordType = TypeScriptTypeParser.buildResolvedType(elements, type);
        if (jSRecordType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(50);
        }
        return jSRecordType;
    }

    @NotNull
    public static Collection<? extends PsiElement> resolveElementsByType(@Nullable JSType type) {
        if (type == null) {
            List list = Collections.emptyList();
            if (list == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(51);
            }
            return list;
        }
        PsiElement sourceElement = type.getSource().getSourceElement();
        if (sourceElement == null || !DialectDetector.isTypeScript(sourceElement)) {
            List list = Collections.emptyList();
            if (list == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(52);
            }
            return list;
        }
        Collection<? extends PsiElement> collection = JSImportHandlingUtil.resolveElementsByType(type, sourceElement);
        if (collection == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(53);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static void addTypeMembersFromClass(@NotNull JSType type, boolean isStatic, @NotNull List<JSRecordType.TypeMember> members, @NotNull PsiElement resolvedElement, @Nullable JSRecursionGuard recursionGuard) {
        if (type == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(54);
        }
        if (members == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(55);
        }
        if (resolvedElement == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(56);
        }
        if (resolvedElement instanceof JSClass) {
            if (type instanceof JSArrayTypeImpl) {
                type = ((JSArrayTypeImpl)type).asGenericType();
            }
            classType = null;
            if (type instanceof JSGenericTypeImpl) {
                classType = JSTypeCastUtil.buildWithAppliedGenericArguments((JSClass)resolvedElement, (JSGenericTypeImpl)type);
            } else if (resolvedElement instanceof TypeScriptTypeAlias) {
                if (recursionGuard == null) {
                    recursionGuard = new JSRecursionGuard();
                }
                if (recursionGuard.isAlreadyProcessingItem(resolvedElement)) {
                    return;
                }
                recursionGuard.addProcessingItem(resolvedElement);
                try {
                    declaration = ((TypeScriptTypeAlias)resolvedElement).getParsedTypeDeclaration();
                    if (declaration instanceof JSRecordType) {
                        classType = (JSRecordType)declaration;
                    }
                    if (declaration instanceof JSFunctionTypeImpl) {
                        classType = declaration.asRecordType();
                    }
                    if (declaration == null) ** GOTO lbl35
                    classType = TypeScriptTypeParser.buildResolvedType(TypeScriptTypeParser.resolveElementsByType(declaration), declaration, recursionGuard);
                }
                finally {
                    recursionGuard.removeProcessingItem(resolvedElement);
                }
            } else {
                classType = TypeScriptTypeParser.buildTypeFromClass((JSClass)resolvedElement, isStatic);
            }
lbl35:
            // 6 sources

            if (classType != null) {
                members.addAll(classType.getTypeMembers());
            }
        } else if (resolvedElement instanceof TypeScriptModule && isStatic && (moduleType = TypeScriptTypeParser.buildTypeForModule((TypeScriptModule)resolvedElement)) != null) {
            members.addAll(moduleType.getTypeMembers());
        }
    }

    @Nullable
    public static JSRecordType buildTypeForModule(@NotNull TypeScriptModule element) {
        if (element == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(57);
        }
        if (!element.isInstantiated()) {
            return null;
        }
        JSSourceElement[] elements = JSResolveUtil.getSourceElements((PsiElement)element);
        ArrayList<JSRecordType.TypeMember> typeMembers = new ArrayList<JSRecordType.TypeMember>();
        for (JSSourceElement sourceElement : elements) {
            if (!(sourceElement instanceof JSVarStatement) && (!(sourceElement instanceof JSElementBase) || ((JSElementBase)sourceElement).getAccessType() != JSAttributeList.AccessType.PUBLIC)) continue;
            if (sourceElement instanceof JSVarStatement) {
                for (JSVariable variable : ((JSVarStatement)sourceElement).getStubSafeVariables()) {
                    String name;
                    if (variable.getAccessType() != JSAttributeList.AccessType.PUBLIC || (name = variable.getName()) == null) continue;
                    typeMembers.add((JSRecordType.TypeMember)new JSRecordTypeImpl.PropertySignatureImpl(name, variable.getType(), false, (PsiElement)variable));
                }
                continue;
            }
            if (sourceElement instanceof JSFunction) {
                JSFunction function = (JSFunction)sourceElement;
                String name = function.getName();
                if (name == null) continue;
                typeMembers.add((JSRecordType.TypeMember)new JSRecordTypeImpl.PropertySignatureImpl(name, TypeScriptTypeParser.buildFunctionType(function), false, (PsiElement)function));
                continue;
            }
            if (!(sourceElement instanceof JSClass)) continue;
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)sourceElement, true);
            String name = sourceElement.getName();
            if (name == null) continue;
            JSType type = JSNamedType.createType(name, source, JSContext.STATIC);
            typeMembers.add((JSRecordType.TypeMember)new JSRecordTypeImpl.PropertySignatureImpl(name, type, false, (PsiElement)sourceElement));
        }
        JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)element, true);
        return new JSRecordTypeImpl(source, typeMembers);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMembers";
                break;
            }
            case 34: 
            case 37: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 46: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultType";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedElement";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTypeFromTypeScript";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTypeFromTypeScriptImpl";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFunctionType";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFunctionTypeWithoutTypeArguments";
                break;
            }
            case 35: 
            case 36: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTypeFromClass";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "overrideSourceForLibrarySymbols";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "buildResolvedType";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveElementsByType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeFromTypeScript";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeFromTypeScriptImpl";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "buildFunctionType";
                break;
            }
            case 30: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "buildFunctionTypeWithoutTypeArguments";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addObjectTypeProperties";
                break;
            }
            case 34: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeFromClass";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createConstructorReturnType";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "buildResolvedType";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "overrideSourceForLibrarySymbols";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "addTypeMembersFromClass";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeForModule";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "lambda$overrideSourceForLibrarySymbols$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

