/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSSymbolType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeFacts {
    public static final JSTypeFacts TYPE_FACTS = new JSTypeFacts();
    public static final Map<String, SimpleFact> typeofEQFacts = ContainerUtil.immutableMapBuilder().put((Object)"string", (Object)SimpleFact.TypeofEQString).put((Object)"number", (Object)SimpleFact.TypeofEQNumber).put((Object)"boolean", (Object)SimpleFact.TypeofEQBoolean).put((Object)"symbol", (Object)SimpleFact.TypeofEQSymbol).put((Object)"undefined", (Object)SimpleFact.EQUndefined).put((Object)"object", (Object)SimpleFact.TypeofEQObject).put((Object)"function", (Object)SimpleFact.TypeofEQFunction).build();
    public static final Map<String, SimpleFact> typeofNEFacts = ContainerUtil.immutableMapBuilder().put((Object)"string", (Object)SimpleFact.TypeofNEString).put((Object)"number", (Object)SimpleFact.TypeofNENumber).put((Object)"boolean", (Object)SimpleFact.TypeofNEBoolean).put((Object)"symbol", (Object)SimpleFact.TypeofNESymbol).put((Object)"undefined", (Object)SimpleFact.NEUndefined).put((Object)"object", (Object)SimpleFact.TypeofNEObject).put((Object)"function", (Object)SimpleFact.TypeofNEFunction).build();

    @NotNull
    private static EnumSet<SimpleFact> unionEnumSets(@NotNull EnumSet<SimpleFact> start, @NotNull EnumSet<SimpleFact> end) {
        if (start == null) {
            JSTypeFacts.$$$reportNull$$$0(0);
        }
        if (end == null) {
            JSTypeFacts.$$$reportNull$$$0(1);
        }
        EnumSet<SimpleFact> result = EnumSet.copyOf(start);
        result.addAll(end);
        EnumSet<SimpleFact> enumSet = result;
        if (enumSet == null) {
            JSTypeFacts.$$$reportNull$$$0(2);
        }
        return enumSet;
    }

    @NotNull
    private static EnumSet<SimpleFact> addValues(@NotNull EnumSet<SimpleFact> start, SimpleFact ... facts) {
        if (start == null) {
            JSTypeFacts.$$$reportNull$$$0(3);
        }
        if (facts == null) {
            JSTypeFacts.$$$reportNull$$$0(4);
        }
        EnumSet<SimpleFact> result = EnumSet.copyOf(start);
        ContainerUtil.addAll(result, (Object[])facts);
        EnumSet<SimpleFact> enumSet = result;
        if (enumSet == null) {
            JSTypeFacts.$$$reportNull$$$0(5);
        }
        return enumSet;
    }

    @NotNull
    public Set<SimpleFact> getFacts(@Nullable JSType type, @NotNull PsiElement context) {
        boolean isEnum;
        if (context == null) {
            JSTypeFacts.$$$reportNull$$$0(6);
        }
        if (type == null) {
            Set<SimpleFact> set = Collections.emptySet();
            if (set == null) {
                JSTypeFacts.$$$reportNull$$$0(7);
            }
            return set;
        }
        boolean strictNullChecks = JSTypeFacts.isStrictNulls(context);
        if ((type = JSTypeFacts.expandType(type)) instanceof JSStringLiteralTypeImpl) {
            JSStringLiteralTypeImpl literal = (JSStringLiteralTypeImpl)type;
            boolean isEmpty = StringUtil.isEmpty((String)literal.getLiteral());
            EnumSet<SimpleFact> enumSet = strictNullChecks ? (isEmpty ? SimpleFact.EmptyStringStrictFacts : SimpleFact.NonEmptyStringStrictFacts) : (isEmpty ? SimpleFact.EmptyStringFacts : SimpleFact.NonEmptyStringFacts);
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(8);
            }
            return enumSet;
        }
        if (type instanceof JSStringType) {
            EnumSet<SimpleFact> enumSet = strictNullChecks ? SimpleFact.StringStrictFacts : SimpleFact.StringFacts;
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(9);
            }
            return enumSet;
        }
        if (type instanceof JSNumberLiteralTypeImpl) {
            boolean isZero;
            boolean bl = isZero = ((JSNumberLiteralTypeImpl)type).getLiteral() == 0.0;
            EnumSet<SimpleFact> enumSet = strictNullChecks ? (isZero ? SimpleFact.ZeroStrictFacts : SimpleFact.NonZeroStrictFacts) : (isZero ? SimpleFact.ZeroFacts : SimpleFact.NonZeroFacts);
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(10);
            }
            return enumSet;
        }
        if (type instanceof JSNumberType) {
            EnumSet<SimpleFact> enumSet = strictNullChecks ? SimpleFact.NumberStrictFacts : SimpleFact.NumberFacts;
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(11);
            }
            return enumSet;
        }
        if (type instanceof JSTypeImpl && (isEnum = ((JSTypeImpl)type).isEnum())) {
            EnumSet<SimpleFact> enumSet = strictNullChecks ? SimpleFact.NumberStrictFacts : SimpleFact.NumberFacts;
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(12);
            }
            return enumSet;
        }
        if (type instanceof JSBooleanType) {
            if (type instanceof JSBooleanLiteralTypeImpl && ((JSBooleanLiteralTypeImpl)type).isStrict()) {
                JSBooleanLiteralTypeImpl literalType = (JSBooleanLiteralTypeImpl)type;
                boolean value = literalType.getLiteral();
                EnumSet<SimpleFact> enumSet = strictNullChecks ? (!value ? SimpleFact.FalseStrictFacts : SimpleFact.TrueStrictFacts) : (!value ? SimpleFact.FalseFacts : SimpleFact.TrueFacts);
                if (enumSet == null) {
                    JSTypeFacts.$$$reportNull$$$0(13);
                }
                return enumSet;
            }
            EnumSet<SimpleFact> enumSet = strictNullChecks ? SimpleFact.BooleanStrictFacts : SimpleFact.BooleanFacts;
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(14);
            }
            return enumSet;
        }
        if (type instanceof JSVoidType || type instanceof JSUndefinedType) {
            EnumSet<SimpleFact> enumSet = SimpleFact.UndefinedFacts;
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(15);
            }
            return enumSet;
        }
        if (type instanceof JSNullType) {
            EnumSet<SimpleFact> enumSet = SimpleFact.NullFacts;
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(16);
            }
            return enumSet;
        }
        if (type instanceof JSSymbolType) {
            EnumSet<SimpleFact> enumSet = strictNullChecks ? SimpleFact.SymbolStrictFacts : SimpleFact.SymbolFacts;
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(17);
            }
            return enumSet;
        }
        if (type instanceof JSUnionOrIntersectionType) {
            Set<SimpleFact> set = this.getTypeFactsOfTypes(((JSUnionOrIntersectionType)type).getTypes(), context);
            if (set == null) {
                JSTypeFacts.$$$reportNull$$$0(18);
            }
            return set;
        }
        EnumSet<SimpleFact> enumSet = EnumSet.of(SimpleFact.All);
        if (enumSet == null) {
            JSTypeFacts.$$$reportNull$$$0(19);
        }
        return enumSet;
    }

    @NotNull
    private Set<SimpleFact> getTypeFactsOfTypes(@NotNull Collection<JSType> types, @NotNull PsiElement context) {
        if (types == null) {
            JSTypeFacts.$$$reportNull$$$0(20);
        }
        if (context == null) {
            JSTypeFacts.$$$reportNull$$$0(21);
        }
        HashSet result = ContainerUtil.newHashSet();
        for (JSType type : types) {
            Set<SimpleFact> facts = this.getFacts(type, context);
            if (facts.contains((Object)SimpleFact.All)) {
                Set<SimpleFact> set = facts;
                if (set == null) {
                    JSTypeFacts.$$$reportNull$$$0(22);
                }
                return set;
            }
            result.addAll(facts);
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            JSTypeFacts.$$$reportNull$$$0(23);
        }
        return hashSet;
    }

    private static JSType expandType(@Nullable JSType type) {
        return JSTypeUtils.getValuableType(type);
    }

    @Nullable
    public JSType getTypeWithFact(@Nullable JSType type, @NotNull SimpleFact fact, @NotNull PsiElement context) {
        if (fact == null) {
            JSTypeFacts.$$$reportNull$$$0(24);
        }
        if (context == null) {
            JSTypeFacts.$$$reportNull$$$0(25);
        }
        return JSTypeFacts.filterType(type, (Predicate<JSType>)((Predicate)el -> {
            if (fact == null) {
                JSTypeFacts.$$$reportNull$$$0(38);
            }
            if (context == null) {
                JSTypeFacts.$$$reportNull$$$0(39);
            }
            return this.hasFact((JSType)el, fact, context);
        }), context);
    }

    @NotNull
    public static JSType filterType(@Nullable JSType type, @NotNull Predicate<JSType> filter, @NotNull PsiElement context) {
        if (filter == null) {
            JSTypeFacts.$$$reportNull$$$0(26);
        }
        if (context == null) {
            JSTypeFacts.$$$reportNull$$$0(27);
        }
        if (type == null) {
            TypeScriptNeverType typeScriptNeverType = new TypeScriptNeverType(JSTypeSourceFactory.createTypeSource(context, true));
            if (typeScriptNeverType == null) {
                JSTypeFacts.$$$reportNull$$$0(28);
            }
            return typeScriptNeverType;
        }
        if ((type = JSTypeFacts.expandType(type)) instanceof JSCompositeTypeImpl) {
            List<JSType> types = ((JSCompositeTypeImpl)type).getTypes();
            List<JSType> resultTypes = types.stream().filter(el -> {
                if (filter == null) {
                    JSTypeFacts.$$$reportNull$$$0(37);
                }
                return filter.apply(el);
            }).collect(Collectors.toList());
            if (types.size() == resultTypes.size()) {
                JSType jSType = type;
                if (jSType == null) {
                    JSTypeFacts.$$$reportNull$$$0(29);
                }
                return jSType;
            }
            if (resultTypes.size() == 1) {
                JSType jSType = (JSType)resultTypes.get(0);
                if (jSType == null) {
                    JSTypeFacts.$$$reportNull$$$0(30);
                }
                return jSType;
            }
            if (resultTypes.size() == 0) {
                TypeScriptNeverType typeScriptNeverType = new TypeScriptNeverType(type.getSource());
                if (typeScriptNeverType == null) {
                    JSTypeFacts.$$$reportNull$$$0(31);
                }
                return typeScriptNeverType;
            }
            JSCompositeTypeImpl jSCompositeTypeImpl = new JSCompositeTypeImpl(type.getSource(), resultTypes);
            if (jSCompositeTypeImpl == null) {
                JSTypeFacts.$$$reportNull$$$0(32);
            }
            return jSCompositeTypeImpl;
        }
        Object object = filter.apply((Object)type) ? type : new TypeScriptNeverType(type.getSource());
        if (object == null) {
            JSTypeFacts.$$$reportNull$$$0(33);
        }
        return object;
    }

    private boolean hasFact(@Nullable JSType type, @NotNull SimpleFact fact, @NotNull PsiElement context) {
        Set<SimpleFact> facts;
        if (fact == null) {
            JSTypeFacts.$$$reportNull$$$0(34);
        }
        if (context == null) {
            JSTypeFacts.$$$reportNull$$$0(35);
        }
        return (facts = this.getFacts(type, context)).contains((Object)SimpleFact.All) || facts.contains((Object)fact);
    }

    private static boolean isStrictNulls(@NotNull PsiElement context) {
        if (context == null) {
            JSTypeFacts.$$$reportNull$$$0(36);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/JSTypeFacts";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facts";
                break;
            }
            case 6: 
            case 21: 
            case 25: 
            case 27: 
            case 35: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 24: 
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fact";
                break;
            }
            case 26: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/JSTypeFacts";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "unionEnumSets";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "addValues";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacts";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFactsOfTypes";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "filterType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "unionEnumSets";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addValues";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFacts";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFactsOfTypes";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTypeWithFact";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "filterType";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "hasFact";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isStrictNulls";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$filterType$1";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getTypeWithFact$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum SimpleFact {
        TypeofEQString,
        TypeofEQNumber,
        TypeofEQBoolean,
        TypeofEQSymbol,
        TypeofEQObject,
        TypeofEQFunction,
        TypeofEQHostObject,
        TypeofNEString,
        TypeofNENumber,
        TypeofNEBoolean,
        TypeofNESymbol,
        TypeofNEObject,
        TypeofNEFunction,
        TypeofNEHostObject,
        EQUndefined,
        EQNull,
        EQUndefinedOrNull,
        NEUndefined,
        NENull,
        NEUndefinedOrNull,
        Truthy,
        Falsy,
        Discriminatable,
        All;

        public static final EnumSet<SimpleFact> BaseStringStrictFacts;
        public static final EnumSet<SimpleFact> BaseStringFacts;
        public static final EnumSet<SimpleFact> StringStrictFacts;
        public static final EnumSet<SimpleFact> StringFacts;
        public static final EnumSet<SimpleFact> EmptyStringStrictFacts;
        public static final EnumSet<SimpleFact> EmptyStringFacts;
        public static final EnumSet<SimpleFact> NonEmptyStringStrictFacts;
        public static final EnumSet<SimpleFact> NonEmptyStringFacts;
        public static final EnumSet<SimpleFact> BaseNumberStrictFacts;
        public static final EnumSet<SimpleFact> BaseNumberFacts;
        public static final EnumSet<SimpleFact> NumberStrictFacts;
        public static final EnumSet<SimpleFact> NumberFacts;
        public static final EnumSet<SimpleFact> ZeroStrictFacts;
        public static final EnumSet<SimpleFact> ZeroFacts;
        public static final EnumSet<SimpleFact> NonZeroStrictFacts;
        public static final EnumSet<SimpleFact> NonZeroFacts;
        public static final EnumSet<SimpleFact> BaseBooleanStrictFacts;
        public static final EnumSet<SimpleFact> BaseBooleanFacts;
        public static final EnumSet<SimpleFact> BooleanStrictFacts;
        public static final EnumSet<SimpleFact> BooleanFacts;
        public static final EnumSet<SimpleFact> FalseStrictFacts;
        public static final EnumSet<SimpleFact> FalseFacts;
        public static final EnumSet<SimpleFact> TrueStrictFacts;
        public static final EnumSet<SimpleFact> TrueFacts;
        public static final EnumSet<SimpleFact> SymbolStrictFacts;
        public static final EnumSet<SimpleFact> SymbolFacts;
        public static final EnumSet<SimpleFact> ObjectStrictFacts;
        public static final EnumSet<SimpleFact> ObjectFacts;
        public static final EnumSet<SimpleFact> FunctionStrictFacts;
        public static final EnumSet<SimpleFact> FunctionFacts;
        public static final EnumSet<SimpleFact> UndefinedFacts;
        public static final EnumSet<SimpleFact> NullFacts;

        static {
            BaseStringStrictFacts = EnumSet.of(TypeofEQString, new SimpleFact[]{TypeofNENumber, TypeofNEBoolean, TypeofNESymbol, TypeofNEObject, TypeofNEFunction, TypeofNEHostObject, NEUndefined, NENull, NEUndefinedOrNull});
            BaseStringFacts = JSTypeFacts.unionEnumSets(SimpleFact.BaseStringStrictFacts, EnumSet.of(SimpleFact.EQUndefined, SimpleFact.EQNull, SimpleFact.EQUndefinedOrNull, SimpleFact.Falsy));
            StringStrictFacts = JSTypeFacts.unionEnumSets(SimpleFact.BaseStringStrictFacts, EnumSet.of(SimpleFact.Truthy, SimpleFact.Falsy));
            StringFacts = JSTypeFacts.addValues(SimpleFact.BaseStringFacts, new SimpleFact[]{SimpleFact.Truthy});
            EmptyStringStrictFacts = JSTypeFacts.addValues(SimpleFact.BaseStringStrictFacts, new SimpleFact[]{SimpleFact.Falsy});
            EmptyStringFacts = BaseStringFacts;
            NonEmptyStringStrictFacts = JSTypeFacts.addValues(SimpleFact.BaseStringStrictFacts, new SimpleFact[]{SimpleFact.Truthy});
            NonEmptyStringFacts = JSTypeFacts.addValues(SimpleFact.BaseStringFacts, new SimpleFact[]{SimpleFact.Truthy});
            BaseNumberStrictFacts = EnumSet.of(TypeofEQNumber, new SimpleFact[]{TypeofNEString, TypeofNEBoolean, TypeofNESymbol, TypeofNEObject, TypeofNEFunction, TypeofNEHostObject, NEUndefined, NENull, NEUndefinedOrNull});
            BaseNumberFacts = JSTypeFacts.addValues(SimpleFact.BaseNumberStrictFacts, new SimpleFact[]{SimpleFact.EQUndefined, SimpleFact.EQNull, SimpleFact.EQUndefinedOrNull, SimpleFact.Falsy});
            NumberStrictFacts = JSTypeFacts.addValues(SimpleFact.BaseNumberStrictFacts, new SimpleFact[]{SimpleFact.Truthy, SimpleFact.Falsy});
            NumberFacts = JSTypeFacts.addValues(SimpleFact.BaseNumberFacts, new SimpleFact[]{SimpleFact.Truthy});
            ZeroStrictFacts = JSTypeFacts.addValues(SimpleFact.BaseNumberStrictFacts, new SimpleFact[]{SimpleFact.Falsy});
            ZeroFacts = BaseNumberFacts;
            NonZeroStrictFacts = JSTypeFacts.addValues(SimpleFact.BaseNumberStrictFacts, new SimpleFact[]{SimpleFact.Truthy});
            NonZeroFacts = JSTypeFacts.addValues(SimpleFact.BaseNumberFacts, new SimpleFact[]{SimpleFact.Truthy});
            BaseBooleanStrictFacts = EnumSet.of(TypeofEQBoolean, new SimpleFact[]{TypeofNEString, TypeofNENumber, TypeofNESymbol, TypeofNEObject, TypeofNEFunction, TypeofNEHostObject, NEUndefined, NENull, NEUndefinedOrNull});
            BaseBooleanFacts = JSTypeFacts.addValues(SimpleFact.BaseBooleanStrictFacts, new SimpleFact[]{SimpleFact.EQUndefined, SimpleFact.EQNull, SimpleFact.EQUndefinedOrNull, SimpleFact.Falsy});
            BooleanStrictFacts = JSTypeFacts.addValues(SimpleFact.BaseBooleanStrictFacts, new SimpleFact[]{SimpleFact.Truthy, SimpleFact.Falsy});
            BooleanFacts = JSTypeFacts.addValues(SimpleFact.BaseBooleanFacts, new SimpleFact[]{SimpleFact.Truthy});
            FalseStrictFacts = JSTypeFacts.addValues(SimpleFact.BaseBooleanStrictFacts, new SimpleFact[]{SimpleFact.Falsy});
            FalseFacts = BaseBooleanFacts;
            TrueStrictFacts = JSTypeFacts.addValues(SimpleFact.BaseBooleanStrictFacts, new SimpleFact[]{SimpleFact.Truthy});
            TrueFacts = JSTypeFacts.addValues(SimpleFact.BaseBooleanFacts, new SimpleFact[]{SimpleFact.Truthy});
            SymbolStrictFacts = EnumSet.of(TypeofEQSymbol, new SimpleFact[]{TypeofNEString, TypeofNENumber, TypeofNEBoolean, TypeofNEObject, TypeofNEFunction, TypeofNEHostObject, NEUndefined, NENull, NEUndefinedOrNull, Truthy});
            SymbolFacts = JSTypeFacts.addValues(SimpleFact.SymbolStrictFacts, new SimpleFact[]{SimpleFact.EQUndefined, SimpleFact.EQNull, SimpleFact.EQUndefinedOrNull, SimpleFact.Falsy});
            ObjectStrictFacts = EnumSet.of(TypeofEQObject, new SimpleFact[]{TypeofEQHostObject, TypeofNEString, TypeofNENumber, TypeofNEBoolean, TypeofNESymbol, TypeofNEFunction, NEUndefined, NENull, NEUndefinedOrNull, Truthy, Discriminatable});
            ObjectFacts = JSTypeFacts.addValues(SimpleFact.ObjectStrictFacts, new SimpleFact[]{SimpleFact.EQUndefined, SimpleFact.EQNull, SimpleFact.EQUndefinedOrNull, SimpleFact.Falsy});
            FunctionStrictFacts = EnumSet.of(TypeofEQFunction, new SimpleFact[]{TypeofEQHostObject, TypeofNEString, TypeofNENumber, TypeofNEBoolean, TypeofNESymbol, TypeofNEObject, NEUndefined, NENull, NEUndefinedOrNull, Truthy, Discriminatable});
            FunctionFacts = JSTypeFacts.addValues(SimpleFact.FunctionStrictFacts, new SimpleFact[]{SimpleFact.EQUndefined, SimpleFact.EQNull, SimpleFact.EQUndefinedOrNull, SimpleFact.Falsy});
            UndefinedFacts = EnumSet.of(TypeofNEString, new SimpleFact[]{TypeofNENumber, TypeofNEBoolean, TypeofNESymbol, TypeofNEObject, TypeofNEFunction, TypeofNEHostObject, EQUndefined, EQUndefinedOrNull, NENull, Falsy});
            NullFacts = EnumSet.of(TypeofEQObject, new SimpleFact[]{TypeofNEString, TypeofNENumber, TypeofNEBoolean, TypeofNESymbol, TypeofNEFunction, TypeofNEHostObject, EQNull, EQUndefinedOrNull, NEUndefined, Falsy});
        }
    }
}

