/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.typescript.resolve.TypeScriptTypeHelper;
import com.intellij.util.ProcessingContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeRelations {
    public static boolean isTypeIdenticalTo(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        return false;
    }

    public static boolean isTypeSubtypeOf(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        if (source instanceof JSTypeImpl && target instanceof JSTypeImpl) {
            return source.isEquivalentTo(target, null) || TypeScriptTypeHelper.areNamedTypesClassAssignable((JSTypeImpl)target, (JSTypeImpl)source).isAssignable();
        }
        if (target == null) {
            return false;
        }
        return target.isDirectlyAssignableType(source, context);
    }

    public static boolean isTypeInstanceOf(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        return TypeScriptTypeRelations.isTypeSubtypeOf(source, target, context);
    }

    public static boolean areTypesComparable(@Nullable JSType type1, @Nullable JSType type2, @Nullable ProcessingContext context) {
        return TypeScriptTypeRelations.isTypeComparableTo(type1, type2, context) || TypeScriptTypeRelations.isTypeComparableTo(type2, type1, context);
    }

    public static boolean isTypeComparableTo(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        return target != null && target.isDirectlyAssignableType(source, context);
    }

    public static boolean compareTypesAssignable(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        return source != null && source.isDirectlyAssignableType(target, context);
    }

    public static boolean isTypeAssignableTo(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        return target != null && target.isDirectlyAssignableType(source, context);
    }

    public static boolean isTypeSubsetOf(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        if (source == null || target == null) {
            return source == target;
        }
        if (source.isEquivalentTo(target, context)) {
            return true;
        }
        return target instanceof JSCompositeTypeImpl && TypeScriptTypeRelations.isTypeSubsetOfUnionType(source, (JSCompositeTypeImpl)target, context);
    }

    public static boolean isTypeSubsetOfUnionType(@NotNull JSType source, @NotNull JSCompositeTypeImpl target, @Nullable ProcessingContext context) {
        if (source == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(0);
        }
        if (target == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(1);
        }
        List<JSType> types = target.getTypes();
        if (source instanceof JSCompositeTypeImpl) {
            List<JSType> subTypes = ((JSCompositeTypeImpl)source).getTypes();
            for (JSType type : subTypes) {
                if (TypeScriptTypeRelations.containsType(types, type, context)) continue;
                return false;
            }
            return true;
        }
        return TypeScriptTypeRelations.containsType(types, source, context);
    }

    public static boolean containsType(@NotNull List<JSType> types, @NotNull JSType sourceType, @Nullable ProcessingContext context) {
        if (types == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(2);
        }
        if (sourceType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(3);
        }
        return types.stream().anyMatch(el -> {
            if (sourceType == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(4);
            }
            return el.isEquivalentTo(sourceType, context);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/TypeScriptTypeRelations";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isTypeSubsetOfUnionType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "containsType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$containsType$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

