/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.impl.ES6SpreadPropertyImpl;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyIndexedAccessElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyPropertyElement;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDestructuringUtil {
    @Nullable
    public static PsiElement getParentSkippingDestructuring(@NotNull JSVariable var) {
        if (var == null) {
            JSDestructuringUtil.$$$reportNull$$$0(0);
        }
        PsiElement parent = var.getParent();
        while (JSDestructuringUtil.isDestructuring(parent)) {
            parent = parent.getParent();
        }
        return parent;
    }

    public static boolean isDestructuring(@Nullable PsiElement parent) {
        return parent instanceof JSDestructuringContainer || parent instanceof JSDestructuringProperty || parent instanceof JSDestructuringElement || parent instanceof JSDestructuringArrayRestElement;
    }

    @Nullable
    public static ASTNode getParentSkippingDestructuring(@NotNull ASTNode varNode) {
        if (varNode == null) {
            JSDestructuringUtil.$$$reportNull$$$0(1);
        }
        ASTNode parent = varNode.getTreeParent();
        while (JSElementTypes.DESTRUCTURING_CONTAINERS.contains(parent.getElementType()) || JSExtendedLanguagesTokenSetProvider.DESTRUCTURING_ELEMENTS.contains(parent.getElementType()) || JSStubElementTypes.DESTRUCTURING_PROPERTIES.contains(parent.getElementType()) || JSStubElementTypes.DESTRUCTURING_ARRAY_REST == parent.getElementType()) {
            if ((parent = parent.getTreeParent()) != null) continue;
            return null;
        }
        return parent;
    }

    @Nullable
    public static JSExpression getNearestDestructuringInitializer(@NotNull JSVariable var) {
        if (var == null) {
            JSDestructuringUtil.$$$reportNull$$$0(2);
        }
        PsiElement parent = var.getParent();
        while (JSDestructuringUtil.isDestructuring(parent)) {
            JSExpression initializer;
            if (parent instanceof JSInitializerOwner && (initializer = ((JSInitializerOwner)parent).getInitializer()) != null) {
                return initializer;
            }
            parent = parent.getParent();
        }
        return null;
    }

    @Nullable
    public static JSExpression getNearestDestructuringInitializer(@NotNull JSReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            JSDestructuringUtil.$$$reportNull$$$0(3);
        }
        PsiElement parent = referenceExpression.getParent();
        while (parent instanceof JSProperty || parent instanceof JSObjectLiteralExpression || parent instanceof JSArrayLiteralExpression || parent instanceof JSSpreadExpression || parent instanceof ES6SpreadPropertyImpl) {
            parent = parent.getParent();
        }
        return parent instanceof JSDefinitionExpression ? ((JSDefinitionExpression)parent).getInitializer() : null;
    }

    @Nullable
    public static JSInitializerOwner findDestructuringParent(@NotNull JSElement destructuringElement, @NotNull JSEvaluateContext context, @NotNull Condition<JSInitializerOwner> parentCondition) {
        if (destructuringElement == null) {
            JSDestructuringUtil.$$$reportNull$$$0(4);
        }
        if (context == null) {
            JSDestructuringUtil.$$$reportNull$$$0(5);
        }
        if (parentCondition == null) {
            JSDestructuringUtil.$$$reportNull$$$0(6);
        }
        JSElement element = destructuringElement;
        JSElement prevElement = destructuringElement;
        while (element instanceof JSDestructuringContainer || element instanceof JSDestructuringElement || element instanceof JSDestructuringProperty || element instanceof JSDestructuringArrayRestElement || element instanceof JSInitializerOwner) {
            if (element instanceof JSInitializerOwner && parentCondition.value((Object)((JSInitializerOwner)element))) {
                return (JSInitializerOwner)element;
            }
            if (element instanceof JSDestructuringArray) {
                context.pushJSElementToApply(new JSApplyIndexedAccessElement((JSDestructuringArray)element, (PsiElement)prevElement));
            } else if (element instanceof JSDestructuringProperty) {
                context.pushJSElementToApply(new JSApplyPropertyElement((JSDestructuringProperty)element));
            }
            prevElement = element;
            element = element.getParent();
        }
        return null;
    }

    @NotNull
    public static List<JSReferenceExpression> collectAssignmentTargets(@NotNull JSExpression pattern) {
        if (pattern == null) {
            JSDestructuringUtil.$$$reportNull$$$0(7);
        }
        assert (pattern instanceof JSObjectLiteralExpression || pattern instanceof JSArrayLiteralExpression);
        final ArrayList result = ContainerUtil.newArrayList();
        pattern.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

            public void visitJSAssignmentExpression(JSAssignmentExpression node) {
                JSDefinitionExpression definition = node.getDefinitionExpression();
                if (definition != null) {
                    definition.accept((PsiElementVisitor)this);
                }
            }

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                super.visitJSReferenceExpression(node);
                result.add(node);
            }
        });
        ArrayList arrayList = result;
        if (arrayList == null) {
            JSDestructuringUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentCondition";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/util/JSDestructuringUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/util/JSDestructuringUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAssignmentTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getParentSkippingDestructuring";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNearestDestructuringInitializer";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findDestructuringParent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectAssignmentTargets";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

