/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractMethod;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.JSDeclarationsAtScopeStartInspection;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.extractMethod.DefaultJSExtractFunctionSettings;
import com.intellij.lang.javascript.refactoring.extractMethod.ExtractedFunctionSignatureGenerator;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionDialog;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionSettings;
import com.intellij.lang.javascript.refactoring.extractMethod.JSScopeSelectionUI;
import com.intellij.lang.javascript.refactoring.extractMethod.JSSignatureContext;
import com.intellij.lang.javascript.refactoring.introduce.JSIntroducedExpressionReplacer;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSExtractFunctionHandler
implements RefactoringActionHandler {
    private static final Class[] classTypes = new Class[]{JSObjectLiteralExpression.class, JSClass.class, JSFile.class, JSBlockStatement.class, JSEmbeddedContent.class, TypeScriptModule.class};
    public static final String RET_PREFIX = "__ret";
    private JSLanguageDialect dialect;
    private static final String VOID_TYPE_NAME = "void";
    protected static boolean GLOBAL_SCOPE_WAS_SELECTED = false;

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(0);
        }
        if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)file, editor, JSBundle.message((String)"javascript.refactoring.extract.function.title", (Object[])new Object[0]))) {
            return;
        }
        this.dialect = DialectDetector.languageDialectOfElement((PsiElement)file);
        if (!editor.getSelectionModel().hasSelection()) {
            editor.getSelectionModel().selectLineAtCaret();
        }
        this.doRefactoringWithDialog(file, editor, project);
    }

    protected void doRefactoringInWriteAction(Project project, Editor editor, @NotNull JSExtractFunctionSettings settings) {
        if (settings == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(1);
        }
        WriteCommandAction.runWriteCommandAction((Project)project, (String)JSBundle.message((String)"javascript.extract.method.title", (Object[])new Object[0]), null, () -> {
            if (settings == null) {
                JSExtractFunctionHandler.$$$reportNull$$$0(44);
            }
            this.doRefactoring(project, editor, settings);
        }, (PsiFile[])new PsiFile[0]);
    }

    protected void doRefactoringWithDialog(final PsiFile file, final Editor editor, final @Nullable Project project) {
        final ContextInfo ci = new ContextInfo(editor);
        if (!this.possibleToExtract(editor, ci)) {
            return;
        }
        final ExtractedFunctionSignatureGenerator signatureGenerator = this.getSignatureGenerator();
        Pass<IntroductionScope> callback = new Pass<IntroductionScope>(){

            public void pass(IntroductionScope scope) {
                GLOBAL_SCOPE_WAS_SELECTED = scope.isGlobal();
                JSExtractFunctionSettings settings = JSExtractFunctionHandler.this.showDialog(file, ci, signatureGenerator, scope);
                if (settings != null) {
                    JSExtractFunctionHandler.this.doRefactoringInWriteAction(project, editor, settings);
                }
            }
        };
        this.chooseIntroductionScope((JSSignatureContext)ci, callback, editor, "extracted");
    }

    protected JSExtractFunctionSettings showDialog(PsiFile file, ContextInfo ci, ExtractedFunctionSignatureGenerator signatureGenerator, @NotNull IntroductionScope scope) {
        if (scope == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(2);
        }
        JSExtractFunctionDialog dialog = new JSExtractFunctionDialog((PsiElement)file, signatureGenerator, ci, scope);
        dialog.show();
        if (dialog.getExitCode() != 0) {
            return null;
        }
        return dialog;
    }

    public JSScopeSelectionUI getScopeSelectionUI(Editor editor) {
        return new ScopeSelectionPopup(editor);
    }

    public final void chooseIntroductionScope(JSSignatureContext ci, Pass<IntroductionScope> callback, Editor editor, String name) {
        this.chooseIntroductionScope(ci, callback, this.getScopeSelectionUI(editor), name);
    }

    public final void chooseIntroductionScope(@NotNull JSSignatureContext signatureContext, @NotNull Pass<IntroductionScope> callback, @NotNull JSScopeSelectionUI scopeSelectionUi, @NotNull String functionName) {
        if (signatureContext == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(3);
        }
        if (callback == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(4);
        }
        if (scopeSelectionUi == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(5);
        }
        if (functionName == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(6);
        }
        List<IntroductionScope> introductionScopes = signatureContext.getIntroductionScopes();
        PsiElement anchorElement = signatureContext.getAnchor();
        if (signatureContext.isActionScript()) {
            callback.pass((Object)JSExtractFunctionHandler.getDefaultSuggestedScope(introductionScopes, false));
            return;
        }
        if (introductionScopes.size() == 1) {
            callback.pass((Object)introductionScopes.get(0));
            return;
        }
        if (introductionScopes.size() > 1) {
            ArrayList<IntroductionScope> scopesInList = new ArrayList<IntroductionScope>(introductionScopes);
            Collections.reverse(scopesInList);
            IntroductionScope defaultSuggestedScope = JSExtractFunctionHandler.getDefaultSuggestedScope(introductionScopes, true);
            List presentations = ContainerUtil.map(scopesInList, scope -> {
                if (functionName == null) {
                    JSExtractFunctionHandler.$$$reportNull$$$0(42);
                }
                if (signatureContext == null) {
                    JSExtractFunctionHandler.$$$reportNull$$$0(43);
                }
                DefaultJSExtractFunctionSettings defaultSettings = new DefaultJSExtractFunctionSettings(functionName, (IntroductionScope)scope);
                PsiElement anchor = this.findFunctionAnchor(scope.parent, anchorElement);
                assert (anchor != null) : "ci.anchor was null; parent: " + scope.parent;
                int hintPosition = anchor.getTextRange().getStartOffset();
                return new JSScopeSelectionUI.ScopePresentation((IntroductionScope)scope, this.getSignatureGenerator().fun(defaultSettings, signatureContext), hintPosition);
            });
            scopeSelectionUi.show(defaultSuggestedScope, presentations, callback);
        }
    }

    private static IntroductionScope getDefaultSuggestedScope(List<IntroductionScope> introductionScopes, boolean checkLastSelectedScope) {
        IntroductionScope nearestScope = introductionScopes.get(0);
        boolean insidePackageStatement = PsiTreeUtil.getParentOfType((PsiElement)nearestScope.getParent(), (Class[])new Class[]{JSPackageStatement.class, JSClass.class}) instanceof JSPackageStatement;
        for (IntroductionScope scope : introductionScopes) {
            if (scope.isClassContext()) {
                return scope;
            }
            if (!scope.isGlobal() || insidePackageStatement || checkLastSelectedScope && !GLOBAL_SCOPE_WAS_SELECTED) continue;
            return scope;
        }
        return nearestScope;
    }

    protected boolean possibleToExtract(Editor editor, ContextInfo ci) {
        if (ci.getProblem() != null) {
            CommonRefactoringUtil.showErrorHint((Project)editor.getProject(), (Editor)editor, (String)ci.getProblem(), (String)JSBundle.message((String)"javascript.refactoring.extract.function.title", (Object[])new Object[0]), (String)"refactoring.extractFunction");
            return false;
        }
        return true;
    }

    private boolean notAllowedStatement(PsiElement n) {
        return n instanceof JSPackageStatement || n instanceof JSImportStatement || n instanceof JSBlockStatement && n.getParent() instanceof JSFunction || n instanceof JSFunction;
    }

    protected PsiElement findStatement(PsiElement elementAt, int start, int end) {
        if ((elementAt instanceof PsiComment || elementAt instanceof PsiWhiteSpace) && (elementAt.getParent() instanceof JSBlockStatement || elementAt.getParent() instanceof JSFile)) {
            return elementAt;
        }
        JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)elementAt, JSStatement.class);
        if (this.notAllowedStatement((PsiElement)statement)) {
            return null;
        }
        return statement;
    }

    static JSExtractFunctionSettings.ParametersInfo createDefaultParametersInfo(IntroductionScope scope) {
        JSExtractFunctionSettings.ParametersInfo parametersInfo = new JSExtractFunctionSettings.ParametersInfo();
        parametersInfo.variables.addAll(scope.usedVars);
        return parametersInfo;
    }

    protected int getExtractFragmentStartOffset(Editor editor) {
        SelectionModel selectionModel = editor.getSelectionModel();
        return selectionModel.getSelectionStart();
    }

    protected int getExtractFragmentEndOffset(Editor editor) {
        SelectionModel selectionModel = editor.getSelectionModel();
        return selectionModel.getSelectionEnd();
    }

    public static boolean isPropertyContext(PsiElement parent) {
        return parent instanceof JSObjectLiteralExpression;
    }

    private void doRefactoring(Project project, Editor editor, @NotNull JSExtractFunctionSettings settings) {
        boolean needReformat;
        ContextInfo contextInfo;
        if (settings == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(7);
        }
        IntroductionScope introductionScope = settings.getIntroductionScope();
        if (settings instanceof JSExtractFunctionDialog) {
            contextInfo = ((JSExtractFunctionDialog)settings).getContextInfo();
        } else {
            contextInfo = new ContextInfo(editor);
            int scopeNumber = introductionScope.presentation == null ? 0 : Integer.parseInt(introductionScope.presentation);
            IntroductionScope actualScope = contextInfo.introductionScopes.get(scopeNumber);
            if (introductionScope.parent != null) {
                for (IntroductionScope contextScope : contextInfo.introductionScopes) {
                    if (contextScope.parent != introductionScope.parent) continue;
                    actualScope = contextScope;
                    break;
                }
            }
            introductionScope.outputVars = actualScope.outputVars;
            introductionScope.usedVars = actualScope.usedVars;
            introductionScope.returnType = actualScope.returnType;
            introductionScope.forceMakeFunExpr = actualScope.forceMakeFunExpr;
            introductionScope.presentation = actualScope.presentation;
            introductionScope.parent = actualScope.parent;
            if (!this.possibleToExtract(editor, contextInfo)) {
                return;
            }
        }
        ExtractedFunctionSignatureGenerator signatureGenerator = this.getSignatureGenerator();
        editor.getSelectionModel().removeSelection();
        boolean doReformat = !(introductionScope.parent instanceof XmlBackedJSClass);
        int startOffset = contextInfo.possibleRange.getStartOffset();
        String origText = editor.getDocument().getCharsSequence().subSequence(startOffset, contextInfo.possibleRange.getEndOffset()).toString();
        String text = origText.trim();
        int leftTrim = origText.indexOf(text);
        startOffset += leftTrim;
        StringBuilder b = new StringBuilder(text);
        JSExtractFunctionSettings.ParametersInfo parametersInfo = JSExtractFunctionHandler.getNotNullParametersInfo(settings);
        String semicolon = this.getStatementTerminator(contextInfo);
        for (Map.Entry e : contextInfo.parameterReferences.entrySet()) {
            JSExtractFunctionSettings.ParameterInfo parameterInfo = parametersInfo.variableOptions.get(e.getValue());
            if (parameterInfo == null) continue;
            RangeMarker range = (RangeMarker)e.getKey();
            b.replace(range.getStartOffset() - startOffset, range.getEndOffset() - startOffset, parameterInfo.name);
            startOffset += ((JSVariable)e.getValue()).getName().length() - parameterInfo.name.length();
        }
        for (RangeMarker range : contextInfo.continueStatementsToReplaceWithReturn) {
            int rangeStart = range.getStartOffset();
            int rangeEnd = range.getEndOffset();
            String toInsert = "return" + semicolon;
            b.replace(rangeStart - startOffset, rangeEnd - startOffset, toInsert);
            startOffset += rangeEnd - rangeStart - toInsert.length();
        }
        text = b.toString();
        String callArgs = "";
        String callPrefix = "";
        String callSuffix = "";
        if (contextInfo.isExpression) {
            boolean exprIsVoid = VOID_TYPE_NAME.equals(introductionScope.returnType);
            text = (exprIsVoid ? "" : this.getReturnStatementPrefix()) + text;
            if (!text.endsWith(semicolon)) {
                text = text + semicolon;
            }
        } else {
            ArrayList<JSVariable> outputVars = new ArrayList<JSVariable>(introductionScope.outputVars);
            Iterator i = outputVars.iterator();
            while (i.hasNext()) {
                JSVariable var = (JSVariable)i.next();
                JSExtractFunctionSettings.ParameterInfo parameterInfo = parametersInfo.variableOptions.get(var);
                if (parameterInfo == null || parameterInfo.used) continue;
                i.remove();
            }
            if (outputVars.size() == 1) {
                JSVariable var = (JSVariable)outputVars.get(0);
                JSType type = var.getType();
                text = text + JSExtractFunctionHandler.getReturnText(semicolon, var);
                boolean createVar = this.hasVariableDeclarationInExtractedText(contextInfo, var);
                callPrefix = (createVar ? this.getVariableDeclarationPrefix(var) : "") + var.getName();
                if (contextInfo.isActionScript() && createVar && type != null) {
                    callPrefix = callPrefix + ":" + type.getTypeText();
                }
                callPrefix = callPrefix + " = ";
            } else if (outputVars.size() > 1) {
                text = text + JSExtractFunctionHandler.getReturnLiteralObjectText(contextInfo, outputVars, semicolon);
                if (this.canUseDestructuring(contextInfo, outputVars)) {
                    callPrefix = this.getOutputDestructuringDeclarationPrefix(contextInfo, outputVars);
                } else {
                    callPrefix = this.getVariableDeclarationPrefix(null) + RET_PREFIX + (contextInfo.isActionScript() ? ":Object" : "") + " = ";
                    callSuffix = this.getOutputVariablesInitialization(contextInfo, outputVars, semicolon);
                }
            }
        }
        String signature = signatureGenerator.fun(settings, contextInfo);
        boolean makeProperty = JSExtractFunctionHandler.isPropertyContext(introductionScope.parent) && settings.makeFunctionExpression();
        String introducedFunctionText = signature;
        boolean referencesArguments = false;
        for (JSVariable var : JSExtractFunctionHandler.getOrderedParameters(parametersInfo)) {
            if (JSExtractFunctionHandler.isArgumentsReference(var)) {
                referencesArguments = true;
                continue;
            }
            JSExtractFunctionSettings.ParameterInfo parameterInfo = parametersInfo.variableOptions.get(var);
            if (parameterInfo != null && !parameterInfo.used) continue;
            if (callArgs.length() > 0) {
                callArgs = callArgs + ",";
            }
            callArgs = callArgs + var.getName();
        }
        if (referencesArguments) {
            if (callArgs.length() > 0) {
                callArgs = callArgs + ",";
            }
            callArgs = callArgs + "arguments";
        }
        if (contextInfo.hasReturnInside) {
            callPrefix = callPrefix + this.getReturnStatementPrefix();
        }
        if (makeProperty) {
            introducedFunctionText = "x = {\n" + introducedFunctionText;
        }
        if (contextInfo.isAsync()) {
            callPrefix = callPrefix + "await ";
        }
        if (settings.makeFunctionExpression() && (makeProperty || ExtractedFunctionSignatureGenerator.findClassRefForScope(contextInfo.anchor, introductionScope.parent) != null)) {
            callPrefix = callPrefix + "this.";
        }
        introducedFunctionText = this.addBodyToSignature(introducedFunctionText, text);
        if (settings.makeFunctionExpression() && !JSExtractFunctionHandler.isPropertyContext(introductionScope.parent) && !introductionScope.isClassContext()) {
            introducedFunctionText = introducedFunctionText + semicolon;
        }
        JSIntroducedExpressionReplacer replacer = contextInfo.isExpression ? JSExtractFunctionHandler.buildExpressionReplacer(contextInfo.extractedElements, contextInfo.possibleRange) : null;
        ASTNode fromText = this.createAstNodeForIntroducedFunctionText(project, introductionScope, introducedFunctionText);
        if (fromText != null) {
            PsiElement parent = introductionScope.parent;
            if (makeProperty) {
                JSExpression expression = ((JSAssignmentExpression)((JSExpressionStatement)fromText.getPsi()).getExpression()).getROperand();
                fromText = ((JSObjectLiteralExpression)expression).getFirstProperty().getNode();
            } else if (JSExtractFunctionHandler.isPropertyContext(introductionScope.parent)) {
                parent = PsiTreeUtil.getParentOfType((PsiElement)contextInfo.anchor, JSBlockStatement.class);
            }
            assert (parent != null);
            PsiElement functionAnchor = this.findFunctionAnchor(parent, contextInfo.anchor);
            PsiElement element = parent.addBefore(fromText.getPsi(), functionAnchor);
            if (contextInfo.ecmaL4 && element instanceof JSFunction) {
                PsiElement typeElement = ((JSFunction)element).getReturnTypeElement();
                String typeName = JSResolveUtil.getShortTypeName(introductionScope.returnType, true);
                if (typeElement != null && introductionScope.returnType.indexOf(46) != -1 && !introductionScope.returnType.equals(typeName)) {
                    ImportUtils.doImport(typeElement, introductionScope.returnType, false);
                }
            }
            if (doReformat) {
                CodeStyleManager.getInstance((Project)project).reformatNewlyAddedElement(parent.getNode(), element.getNode());
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            }
        } else assert (false) : introducedFunctionText;
        String callString = this.createMethodCallStringAfterExtractMethod(contextInfo, settings, callArgs, callPrefix);
        if (contextInfo.isExpression) {
            PsiElement extractedExpression = contextInfo.extractedElements.get(0);
            JSExpressionStatement callStatement = JSChangeUtil.createStatementPsiFromTextWithContext(callString, extractedExpression, JSExpressionStatement.class);
            replacer.replaceExpression(callStatement.getExpression());
        } else {
            JSStatement callStatement = JSChangeUtil.createStatementPsiFromTextWithContext(callString + semicolon, contextInfo.getAnchor(), JSStatement.class);
            contextInfo.anchor = JSExtractFunctionHandler.replaceStatements(callStatement, contextInfo.extractedElements, contextInfo.anchor);
        }
        if (callSuffix.length() > 0) {
            PsiElement callEpilogue = JSChangeUtil.createJSTreeFromText(project, callSuffix, this.dialect).getPsi();
            PsiElement last = callEpilogue.getNextSibling();
            while (last.getNextSibling() != null) {
                last = last.getNextSibling();
            }
            contextInfo.anchor.getParent().addRangeAfter(callEpilogue, last, contextInfo.anchor);
        }
        boolean bl = needReformat = !contextInfo.isExpression && contextInfo.extractedElements.size() > 1 || callSuffix.length() > 0;
        if (needReformat) {
            CodeStyleManager.getInstance((Project)project).reformatNewlyAddedElement(contextInfo.anchor.getParent().getNode(), contextInfo.anchor.getNode());
        }
    }

    @NotNull
    private static JSIntroducedExpressionReplacer buildExpressionReplacer(@NotNull List<PsiElement> expressions, @NotNull TextRange possibleRange) {
        PsiElement expressionParent;
        TextRange expressionRange;
        if (expressions == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(8);
        }
        if (possibleRange == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(9);
        }
        TextRange range = !possibleRange.equals((Object)(expressionRange = (expressionParent = (PsiElement)ObjectUtils.assertNotNull((Object)PsiTreeUtil.findCommonParent((PsiElement)expressions.get(0), (PsiElement)expressions.get(expressions.size() - 1)))).getTextRange())) ? expressionRange.intersection(possibleRange) : null;
        Pair expressionDescriptor = Pair.create((Object)((JSExpression)expressionParent), (Object)range);
        JSIntroducedExpressionReplacer jSIntroducedExpressionReplacer = new JSIntroducedExpressionReplacer((Pair<JSExpression, TextRange>)expressionDescriptor);
        if (jSIntroducedExpressionReplacer == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(10);
        }
        return jSIntroducedExpressionReplacer;
    }

    private static PsiElement replaceStatements(@NotNull JSStatement callStatement, @NotNull List<PsiElement> extractedElements, PsiElement anchor) {
        if (callStatement == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(11);
        }
        if (extractedElements == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(12);
        }
        if (extractedElements.size() == 1) {
            extractedElements.iterator().next().replace((PsiElement)callStatement);
        } else {
            anchor = anchor.getParent().addBefore((PsiElement)callStatement, anchor);
            for (PsiElement s : extractedElements) {
                if (!s.isValid()) continue;
                PsiElement prev = s.getPrevSibling();
                if (prev instanceof PsiWhiteSpace) {
                    prev.delete();
                }
                s.delete();
            }
        }
        return anchor;
    }

    private boolean canUseDestructuring(ContextInfo contextInfo, List<JSVariable> outputVars) {
        DialectOptionHolder holder = contextInfo.holder;
        if (holder == null || !holder.hasFeature(JSLanguageFeature.DESTRUCTURING_ASSIGNMENT)) {
            return false;
        }
        String prefix = this.getVariableDeclarationPrefix(outputVars.get(0));
        for (JSVariable var : outputVars) {
            String currentPrefix = this.getVariableDeclarationPrefix(var);
            if (this.hasVariableDeclarationInExtractedText(contextInfo, var) && StringUtil.equals((CharSequence)prefix, (CharSequence)currentPrefix)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private JSVarStatement.VarKeyword getKeywordForVariable(@Nullable JSVariable variable) {
        if (variable == null) {
            JSVarStatement.VarKeyword varKeyword = this.dialect != null && this.dialect.getOptionHolder().hasFeature(JSLanguageFeature.LET_DEFINITIONS) ? JSVarStatement.VarKeyword.CONST : JSVarStatement.VarKeyword.VAR;
            if (varKeyword == null) {
                JSExtractFunctionHandler.$$$reportNull$$$0(13);
            }
            return varKeyword;
        }
        JSVarStatement currentStatementParent = (JSVarStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, JSVarStatement.class);
        JSVarStatement.VarKeyword varKeyword = currentStatementParent == null ? JSVarStatement.VarKeyword.VAR : currentStatementParent.getVarKeyword();
        if (varKeyword == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(14);
        }
        return varKeyword;
    }

    private boolean hasVariableDeclarationInExtractedText(@NotNull ContextInfo contextInfo, @NotNull JSVariable var) {
        if (contextInfo == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(15);
        }
        if (var == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(16);
        }
        return contextInfo.possibleRange.contains(var.getTextRange());
    }

    private static String getReturnText(String semicolon, JSVariable var) {
        return "\nreturn " + var.getName() + semicolon;
    }

    private String getOutputDestructuringDeclarationPrefix(@NotNull ContextInfo contextInfo, @NotNull List<JSVariable> outputVars) {
        if (contextInfo == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(17);
        }
        if (outputVars == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(18);
        }
        String variables = StringUtil.join(outputVars, el -> el.getName(), (String)", ");
        return this.getVariableDeclarationPrefix(outputVars.get(0)) + "{ " + variables + " } = ";
    }

    @NotNull
    private String getOutputVariablesInitialization(@NotNull ContextInfo contextInfo, @NotNull List<JSVariable> outputVars, @NotNull String semicolon) {
        if (contextInfo == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(19);
        }
        if (outputVars == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(20);
        }
        if (semicolon == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(21);
        }
        String join = StringUtil.join(outputVars, el -> {
            if (contextInfo == null) {
                JSExtractFunctionHandler.$$$reportNull$$$0(40);
            }
            if (semicolon == null) {
                JSExtractFunctionHandler.$$$reportNull$$$0(41);
            }
            String varName = el.getName();
            boolean hasVariableDeclarationInExtractedText = this.hasVariableDeclarationInExtractedText(contextInfo, (JSVariable)el);
            String varPrefix = hasVariableDeclarationInExtractedText ? this.getVariableDeclarationPrefix((JSVariable)el) : "";
            return varPrefix + varName + " = " + RET_PREFIX + "." + varName + semicolon;
        }, (String)"\n");
        String string = "\n" + join;
        if (string == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    private static String getReturnLiteralObjectText(@NotNull ContextInfo contextInfo, @NotNull List<JSVariable> outputVars, @NotNull String semicolon) {
        DialectOptionHolder holder;
        if (contextInfo == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(23);
        }
        if (outputVars == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(24);
        }
        if (semicolon == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(25);
        }
        boolean isShorthandPropertyAllow = (holder = contextInfo.holder) != null && holder.hasFeature(JSLanguageFeature.SHORTHAND_PROPERTY_NAMES);
        String string = "\nreturn {" + StringUtil.join(outputVars, el -> {
            String varName = el.getName();
            return isShorthandPropertyAllow ? varName : varName + ":" + varName;
        }, (String)", ") + "}" + semicolon;
        if (string == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(26);
        }
        return string;
    }

    protected String createMethodCallStringAfterExtractMethod(ContextInfo contextInfo, JSExtractFunctionSettings settings, String callArgs, String callPrefix) {
        boolean shouldProvideDirectThis;
        IntroductionScope scope = settings.getIntroductionScope();
        String methodName = settings.getMethodName();
        if (scope.isClassContext() && !contextInfo.ecmaL4) {
            String scopePrefix = settings.makeStatic() ? ((JSClass)scope.getParent()).getName() : "this";
            return callPrefix + scopePrefix + "." + methodName + "(" + callArgs + ")";
        }
        PsiElement parent = settings.getIntroductionScope().parent;
        boolean bl = shouldProvideDirectThis = !settings.makeFunctionExpression() || settings.makeFunctionExpression() && ExtractedFunctionSignatureGenerator.findClassRefForScope(contextInfo.anchor, parent) == null && !JSExtractFunctionHandler.isPropertyContext(parent);
        if (shouldProvideDirectThis && !contextInfo.isActionScript() && contextInfo.hasThisUsage) {
            return callPrefix + methodName + ".call(this" + (callArgs.isEmpty() ? "" : ", ") + callArgs + ")";
        }
        return callPrefix + methodName + "(" + callArgs + ")";
    }

    protected ASTNode createAstNodeForIntroducedFunctionText(Project project, IntroductionScope introductionScope, String introducedFunctionText) {
        PsiElement parent;
        if (introductionScope.isClassContext() && !DialectDetector.isActionScript(parent = introductionScope.getParent())) {
            return JSChangeUtil.createClassMemberFromText(project, introducedFunctionText, JSUtils.getDialect(parent.getContainingFile()));
        }
        return JSChangeUtil.createJSTreeFromText(project, introducedFunctionText, this.dialect);
    }

    protected String getStatementTerminator(ContextInfo contextInfo) {
        return JSCodeStyleSettings.getSemicolon(contextInfo.file);
    }

    protected String getReturnStatementPrefix() {
        return "return ";
    }

    protected ExtractedFunctionSignatureGenerator getSignatureGenerator() {
        return new ExtractedFunctionSignatureGenerator();
    }

    protected String getVariableDeclarationPrefix(@Nullable JSVariable variable) {
        JSVarStatement.VarKeyword keyword = this.getKeywordForVariable(variable);
        return keyword.getText() + " ";
    }

    protected String addBodyToSignature(String signature, String body) {
        return signature + "{\n" + body + "\n}";
    }

    @Nullable
    private PsiElement findFunctionAnchor(PsiElement scope, PsiElement startElement) {
        boolean placeAtScopeStart = JSDeclarationsAtScopeStartInspection.isEnabledForElement(startElement);
        PsiElement anchor = JSUtils.findFunctionAnchor(scope, startElement, placeAtScopeStart);
        return this.needInsertAfter(scope, anchor) ? JSPsiImplUtils.getNextSiblingIgnoreWhitespace(anchor) : JSPsiImplUtils.findLeadingCommentOrSelf(anchor);
    }

    protected boolean needInsertAfter(@NotNull PsiElement parent, @Nullable PsiElement functionAnchor) {
        if (parent == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(27);
        }
        return parent instanceof JSClass || functionAnchor instanceof JSPackageStatement;
    }

    static boolean isArgumentsReference(JSVariable var) {
        return "arguments".equals(var.getName()) && !(var instanceof JSParameter);
    }

    private static String getExpressionElementPresentation(PsiElement element) {
        if (element instanceof JSFunctionExpression) {
            element = ((JSFunctionExpression)element).getBody()[0];
        }
        String compactedText = element.getText().replaceAll("[\\n|\\r| ]+", " ");
        return "starting with " + compactedText.substring(0, Math.min(compactedText.length(), 30));
    }

    @Nullable
    protected IntroductionScope createPairWithPresentation(PsiElement parent) {
        if (parent == null) {
            return null;
        }
        String presentation = null;
        boolean forceMakeFunExpr = false;
        PsiElement element = parent;
        Class[] classes = (Class[])ArrayUtil.append((Object[])this.getScopeTypes(), JSFunction.class);
        while (element instanceof JSBlockStatement) {
            element = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])classes);
        }
        if (element instanceof JSObjectLiteralExpression) {
            PsiElement objectParent = element.getParent();
            JSExpression assignedTo = null;
            if (objectParent instanceof JSAssignmentExpression) {
                assignedTo = ((JSAssignmentExpression)objectParent).getLOperand();
            } else if (objectParent instanceof JSVariable) {
                assignedTo = ((JSVariable)objectParent).getNameIdentifier();
            }
            presentation = "object " + (assignedTo == null ? JSExtractFunctionHandler.getExpressionElementPresentation(element) : "assigned to " + assignedTo.getText());
            forceMakeFunExpr = true;
        } else if (element instanceof JSClass) {
            presentation = "class " + ((JSClass)element).getName();
        } else if (element instanceof JSFile) {
            presentation = "global";
        } else if (element instanceof XmlTagChild) {
            String string = presentation = element instanceof JSEmbeddedContent ? "global" : "xml tag";
            if (element instanceof XmlTag) {
                presentation = presentation + " " + ((XmlTag)element).getName();
            }
        } else if (element instanceof JSFunction) {
            String functionName = ((JSFunction)element).getQualifiedName();
            presentation = "function " + (functionName == null ? JSExtractFunctionHandler.getExpressionElementPresentation(element) : functionName);
        } else if (element instanceof TypeScriptModule) {
            presentation = "module " + ((TypeScriptModule)element).getName();
        }
        IntroductionScope scope = new IntroductionScope();
        scope.parent = parent;
        scope.presentation = presentation;
        scope.forceMakeFunExpr = forceMakeFunExpr;
        return scope;
    }

    protected Class[] getScopeTypes() {
        return classTypes;
    }

    protected boolean acceptBlockStatementAsScope(JSBlockStatement blockStatement) {
        return false;
    }

    @Nullable
    public IntroductionScope findBase(PsiElement at, boolean findAll) {
        PsiElement classFromContext;
        JSEmbeddedContent scriptTagAnchor;
        PsiElement decorator = PsiTreeUtil.getParentOfType((PsiElement)at, ES6Decorator.class);
        if (decorator != null) {
            IntroductionScope base = this.findBase(decorator, findAll);
            while (base != null && base.getParent() instanceof JSClass) {
                base = this.findBase(base.getParent(), findAll);
            }
            return base;
        }
        if (at.getContainingFile() instanceof XmlFile && PsiTreeUtil.getParentOfType((PsiElement)at, XmlAttributeValue.class) != null && (scriptTagAnchor = JSUtils.findScriptTagContent((XmlFile)at.getContainingFile())) != null) {
            return this.createPairWithPresentation((PsiElement)scriptTagAnchor);
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)at, (Class[])this.getScopeTypes());
        if (parent instanceof JSEmbeddedContent && parent.getNode().getElementType() == JSElementTypes.EMBEDDED_EXPRESSION) {
            return this.findBase(parent.getParent(), findAll);
        }
        boolean stopOnNextParent = false;
        while (parent instanceof JSBlockStatement) {
            if (this.acceptBlockStatementAsScope((JSBlockStatement)parent) || stopOnNextParent) {
                return this.createPairWithPresentation(parent);
            }
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof JSFunction) {
                if (findAll) {
                    return this.createPairWithPresentation(parent);
                }
                PsiElement ref = ExtractedFunctionSignatureGenerator.findClassRef(parent);
                if (ref != null) {
                    stopOnNextParent = true;
                    parent = grandParent;
                } else if (grandParent instanceof JSFunctionExpression && !ActionScriptResolveUtil.isAnonymousEventHandler((JSFunctionExpression)grandParent)) {
                    PsiElement grandParent2 = grandParent.getParent();
                    if (grandParent2 instanceof JSParenthesizedExpression) {
                        grandParent2 = grandParent2.getParent();
                    }
                    if (grandParent2 instanceof JSCallExpression) {
                        return this.createPairWithPresentation(parent);
                    }
                }
            }
            parent = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])this.getScopeTypes());
        }
        if (parent instanceof JSFile && parent.getContext() != null && (classFromContext = JSResolveUtil.getClassReferenceForXmlFromContext(parent)) != null) {
            parent = classFromContext;
        }
        if (at instanceof XmlBackedJSClass) {
            return null;
        }
        return this.createPairWithPresentation(parent);
    }

    public List<IntroductionScope> findBases(PsiElement at) {
        ArrayList<IntroductionScope> scopes = new ArrayList<IntroductionScope>();
        IntroductionScope currentScope = this.findBase(at, true);
        while (currentScope != null && !(currentScope.parent instanceof JSFile) && !(currentScope.parent instanceof XmlTagChild)) {
            scopes.add(currentScope);
            currentScope = this.findBase(currentScope.parent, true);
        }
        if (currentScope != null) {
            scopes.add(currentScope);
        }
        return scopes;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(28);
        }
        if (elements == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(29);
        }
        throw new UnsupportedOperationException();
    }

    public static JSExtractFunctionSettings.ParametersInfo getNotNullParametersInfo(JSExtractFunctionSettings settings) {
        JSExtractFunctionSettings.ParametersInfo parametersInfo = settings.getParametersInfo();
        if (parametersInfo != null) {
            return parametersInfo;
        }
        return JSExtractFunctionHandler.createDefaultParametersInfo(settings.getIntroductionScope());
    }

    public static List<JSVariable> getOrderedParameters(JSExtractFunctionSettings.ParametersInfo parametersInfo) {
        ArrayList<JSVariable> parameters = new ArrayList<JSVariable>(parametersInfo.variables);
        if (parametersInfo.variables.size() != parametersInfo.variableOptions.size()) {
            return parameters;
        }
        Collections.sort(parameters, Comparator.comparingInt(o -> parametersInfo.variableOptions.get((Object)o).index));
        return parameters;
    }

    @NotNull
    private static List<JSExpression> getExtractedExpressions(@Nullable PsiElement nonEmptyAt, @NotNull TextRange extractionRange) {
        if (extractionRange == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(30);
        }
        JSExpression parent = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)nonEmptyAt, JSExpression.class, (boolean)false);
        JSExpression expression = null;
        while (parent != null && extractionRange.contains(parent.getTextRange())) {
            expression = parent;
            parent = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)parent, JSExpression.class);
        }
        if (expression == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSExtractFunctionHandler.$$$reportNull$$$0(31);
            }
            return list;
        }
        ArrayList extractedElements = ContainerUtil.newArrayList();
        extractedElements.add(expression);
        if (parent instanceof JSBinaryExpression) {
            PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)expression, (boolean)true);
            while (nextLeaf != null && extractionRange.contains(nextLeaf.getTextRange())) {
                JSExpression parentExpr = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)nextLeaf, JSExpression.class);
                PsiElement nextExpr = null;
                while (parentExpr != null && extractionRange.contains(parentExpr.getTextRange())) {
                    nextExpr = parentExpr;
                    parentExpr = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)parentExpr, JSExpression.class);
                }
                if (nextExpr != null) {
                    extractedElements.add(nextExpr);
                }
                nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)(nextExpr != null ? nextExpr : nextLeaf), (boolean)true);
            }
        }
        ArrayList arrayList = extractedElements;
        if (arrayList == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    @NotNull
    private static TextRange getExpressionRange(@NotNull List<? extends PsiElement> expressions) {
        if (expressions == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(33);
        }
        TextRange textRange = JSExtractFunctionHandler.expandRangeByNonMeaningfulElements((JSExpression)expressions.get(0), (JSExpression)expressions.get(expressions.size() - 1));
        if (textRange == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(34);
        }
        return textRange;
    }

    @NotNull
    private static TextRange expandRangeByNonMeaningfulElements(@NotNull JSExpression left, @NotNull JSExpression right) {
        if (left == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(35);
        }
        if (right == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(36);
        }
        PsiElement newLeft = JSExtractFunctionHandler.takeLeavesOrSelf((PsiElement)left, (Condition<PsiElement>)((Condition)psiElement -> psiElement instanceof PsiWhiteSpace || psiElement instanceof PsiComment), false);
        PsiElement newRight = JSExtractFunctionHandler.takeLeavesOrSelf((PsiElement)right, (Condition<PsiElement>)((Condition)psiElement -> psiElement instanceof PsiWhiteSpace || psiElement instanceof PsiComment || psiElement.getNode() != null && psiElement.getNode().getElementType() == JSTokenTypes.SEMICOLON), true);
        TextRange textRange = new TextRange(newLeft.getTextRange().getStartOffset(), newRight.getTextRange().getEndOffset());
        if (textRange == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(37);
        }
        return textRange;
    }

    @NotNull
    private static PsiElement takeLeavesOrSelf(@NotNull PsiElement element, Condition<PsiElement> condition, boolean forward) {
        PsiElement result;
        if (element == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(38);
        }
        PsiElement previous = element;
        PsiElement psiElement = result = forward ? PsiTreeUtil.nextLeaf((PsiElement)element) : PsiTreeUtil.prevLeaf((PsiElement)element);
        while (result != null && condition.value((Object)result)) {
            previous = result;
            result = forward ? PsiTreeUtil.nextLeaf((PsiElement)result) : PsiTreeUtil.prevLeaf((PsiElement)result);
        }
        PsiElement psiElement2 = previous;
        if (psiElement2 == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(39);
        }
        return psiElement2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 22: 
            case 26: 
            case 31: 
            case 32: 
            case 34: 
            case 37: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 22: 
            case 26: 
            case 31: 
            case 32: 
            case 34: 
            case 37: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatureContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeSelectionUi";
                break;
            }
            case 6: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 8: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleRange";
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 22: 
            case 26: 
            case 31: 
            case 32: 
            case 34: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callStatement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractedElements";
                break;
            }
            case 15: 
            case 17: 
            case 19: 
            case 23: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextInfo";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 18: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputVars";
                break;
            }
            case 21: 
            case 25: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semicolon";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractionRange";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "buildExpressionReplacer";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywordForVariable";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputVariablesInitialization";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnLiteralObjectText";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtractedExpressions";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionRange";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "expandRangeByNonMeaningfulElements";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "takeLeavesOrSelf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doRefactoringInWriteAction";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "chooseIntroductionScope";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doRefactoring";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildExpressionReplacer";
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 22: 
            case 26: 
            case 31: 
            case 32: 
            case 34: 
            case 37: 
            case 39: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "replaceStatements";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasVariableDeclarationInExtractedText";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getOutputDestructuringDeclarationPrefix";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getOutputVariablesInitialization";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getReturnLiteralObjectText";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "needInsertAfter";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getExtractedExpressions";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionRange";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "expandRangeByNonMeaningfulElements";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "takeLeavesOrSelf";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getOutputVariablesInitialization$3";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lambda$chooseIntroductionScope$1";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doRefactoringInWriteAction$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 22: 
            case 26: 
            case 31: 
            case 32: 
            case 34: 
            case 37: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class IntroductionScope {
        PsiElement parent;
        String presentation;
        boolean forceMakeFunExpr;
        Set<JSVariable> usedVars = new LinkedHashSet<JSVariable>();
        Set<JSVariable> outputVars = new LinkedHashSet<JSVariable>();
        String returnType;

        public IntroductionScope() {
        }

        public IntroductionScope(PsiElement parent, String presentation) {
            this.parent = parent;
            this.presentation = presentation;
        }

        public String toString() {
            return this.presentation;
        }

        public boolean isClassContext() {
            return this.parent instanceof JSClass;
        }

        public boolean isGlobal() {
            return this.parent instanceof JSFile || this.parent instanceof JSEmbeddedContent;
        }

        public PsiElement getParent() {
            return this.parent;
        }
    }

    public class ContextInfo
    implements JSSignatureContext {
        final List<PsiElement> extractedElements = new ArrayList<PsiElement>();
        private final TextRange possibleRange;
        private final List<RangeMarker> continueStatementsToReplaceWithReturn = new ArrayList<RangeMarker>();
        private final Map<RangeMarker, JSVariable> parameterReferences = new LinkedHashMap<RangeMarker, JSVariable>();
        public final List<IntroductionScope> introductionScopes;
        final PsiFile file;
        public final boolean ecmaL4;
        boolean isExpression;
        public PsiElement anchor;
        boolean hasReturnInside;
        boolean hasThisUsage;
        public boolean hasAwaitExpressions;
        private String myProblem;
        public DialectOptionHolder holder;

        public ContextInfo(Editor editor) {
            TextRange expandedRange;
            List expressions;
            PsiElement statement;
            PsiElement nonEmptyAt;
            final Document document = editor.getDocument();
            int start = JSExtractFunctionHandler.this.getExtractFragmentStartOffset(editor);
            int end = JSExtractFunctionHandler.this.getExtractFragmentEndOffset(editor);
            this.possibleRange = new TextRange(start, end);
            this.file = PsiDocumentManager.getInstance((Project)editor.getProject()).getPsiFile(document);
            this.holder = DialectDetector.dialectOfElement((PsiElement)this.file);
            this.ecmaL4 = this.holder != null && this.holder.isECMA4;
            PsiElement at = this.file.findElementAt(start);
            PsiElement elementToSearchScope = nonEmptyAt = at instanceof PsiWhiteSpace || at instanceof PsiComment ? JSPsiImplUtils.findNextCodeLeaf(at) : at;
            this.anchor = statement = JSExtractFunctionHandler.this.findStatement(at, start, end);
            if (statement instanceof PsiWhiteSpace) {
                this.anchor = statement.getNextSibling();
            }
            PsiElement statement2 = JSExtractFunctionHandler.this.findStatement(this.file.findElementAt(end - 1), start, end);
            this.isExpression = false;
            if (statement == statement2 && statement != null && !this.possibleRange.contains(statement.getTextRange()) && !(expressions = JSExtractFunctionHandler.getExtractedExpressions(nonEmptyAt, this.possibleRange)).isEmpty() && (expandedRange = JSExtractFunctionHandler.getExpressionRange(expressions)).contains(this.possibleRange)) {
                this.isExpression = true;
                this.extractedElements.addAll(expressions);
                elementToSearchScope = (PsiElement)expressions.get(0);
            }
            this.introductionScopes = JSExtractFunctionHandler.this.findBases(elementToSearchScope);
            final Ref returnType = new Ref();
            JSRecursiveElementVisitor elementVisitor = new JSRecursiveElementVisitor(){
                final Set<JSVariable> processed = new THashSet();
                JSFunction currentFunction;

                public void visitJSReferenceExpression(JSReferenceExpression node) {
                    PsiElement element;
                    if (node.getQualifier() == null && !JSResolveUtil.isSelfReference((PsiElement)node) && (element = node.resolve()) instanceof JSVariable && element.getContainingFile().getOriginalFile().equals(node.getContainingFile().getOriginalFile())) {
                        JSVariable var = (JSVariable)element;
                        this.handleVariable(var, true);
                        ContextInfo.this.parameterReferences.put(document.createRangeMarker(node.getTextRange()), var);
                    }
                    super.visitJSReferenceExpression(node);
                }

                public void visitJSBreakStatement(JSBreakStatement node) {
                    JSStatement statementToBreak = node.getStatementToBreak();
                    if (statementToBreak == null || !ContextInfo.this.possibleRange.contains(statementToBreak.getTextRange())) {
                        ContextInfo.this.myProblem = JSBundle.message((String)"javascript.refactoring.extract.function.code.contain.break.statement", (Object[])new Object[0]);
                    }
                    super.visitJSBreakStatement(node);
                }

                public void visitJSContinueStatement(JSContinueStatement node) {
                    JSStatement statementToContinue = node.getStatementToContinue();
                    boolean continueFromCompletelyExtractedLoopBody = false;
                    if (statementToContinue instanceof JSLoopStatement && !ContextInfo.this.possibleRange.contains(statementToContinue.getTextRange())) {
                        JSStatement body;
                        JSStatement firstChild = body = ((JSLoopStatement)statementToContinue).getBody();
                        JSStatement lastChild = body;
                        if (body instanceof JSBlockStatement) {
                            firstChild = body.getFirstChild();
                            lastChild = body.getLastChild();
                            if (firstChild.getNode().getElementType() == JSTokenTypes.LBRACE && (firstChild = firstChild.getNextSibling()) instanceof PsiWhiteSpace) {
                                firstChild = firstChild.getNextSibling();
                            }
                            if (lastChild.getNode().getElementType() == JSTokenTypes.RBRACE && (lastChild = lastChild.getPrevSibling()) instanceof PsiWhiteSpace) {
                                lastChild = lastChild.getPrevSibling();
                            }
                        }
                        if (firstChild != null && lastChild != null && ContextInfo.this.possibleRange.contains(new TextRange(firstChild.getTextOffset(), lastChild.getTextRange().getEndOffset()))) {
                            continueFromCompletelyExtractedLoopBody = true;
                            ContextInfo.this.continueStatementsToReplaceWithReturn.add(document.createRangeMarker(node.getTextRange()));
                        }
                    }
                    if (statementToContinue == null || !continueFromCompletelyExtractedLoopBody && !ContextInfo.this.possibleRange.contains(statementToContinue.getTextRange())) {
                        ContextInfo.this.myProblem = JSBundle.message((String)"javascript.refactoring.extract.function.code.contain.continue.statement", (Object[])new Object[0]);
                    }
                    super.visitJSContinueStatement(node);
                }

                public void visitJSVariable(JSVariable node) {
                    super.visitJSVariable(node);
                    this.handleVariable(node, false);
                }

                public void visitJSReturnStatement(@NotNull JSReturnStatement node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitJSReturnStatement(node);
                    if (this.currentFunction == null) {
                        if (!ContextInfo.this.isExpression && ContextInfo.this.extractedElements.get(ContextInfo.this.extractedElements.size() - 1) != node) {
                            ContextInfo.this.myProblem = JSBundle.message((String)"javascript.refactoring.extract.function.code.contain.conditional.return", (Object[])new Object[0]);
                        }
                        returnType.set((Object)JSResolveUtil.getExpressionType(node.getExpression(), ContextInfo.this.file));
                        ContextInfo.this.hasReturnInside = true;
                    }
                }

                public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    JSFunction prevCurrentFunction = this.currentFunction;
                    this.currentFunction = node;
                    super.visitJSFunctionExpression(node);
                    this.currentFunction = prevCurrentFunction;
                }

                public void visitJSPrefixExpression(JSPrefixExpression node) {
                    if (node.getOperationSign() == JSTokenTypes.AWAIT_KEYWORD) {
                        ContextInfo.this.hasAwaitExpressions = true;
                    }
                    super.visitJSPrefixExpression(node);
                }

                public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    JSFunction prevCurrentFunction = this.currentFunction;
                    this.currentFunction = node;
                    super.visitJSFunctionDeclaration(node);
                    this.currentFunction = prevCurrentFunction;
                }

                public void visitJSThrowStatement(JSThrowStatement node) {
                    super.visitJSThrowStatement(node);
                }

                public void visitJSThisExpression(JSThisExpression node) {
                    if (this.currentFunction == null) {
                        ContextInfo.this.hasThisUsage = true;
                    }
                    super.visitJSThisExpression(node);
                }

                private void handleVariable(JSVariable var, boolean referencedInFragment) {
                    if (!this.processed.contains(var)) {
                        if (JSResolveUtil.findParent((PsiElement)var) instanceof JSClass) {
                            this.processed.add(var);
                            return;
                        }
                        boolean hasReadsOutOfBlock = false;
                        THashSet hasWritesInBlock = new THashSet();
                        if (!referencedInFragment && var.getInitializer() != null) {
                            hasWritesInBlock.addAll(ContextInfo.this.introductionScopes);
                        }
                        PsiElement varBase = var.getDeclarationScope();
                        THashSet varIsReachableFrom = new THashSet();
                        for (IntroductionScope scope : ContextInfo.this.introductionScopes) {
                            if (!ContextInfo.this.reachableFromExtractScope(varBase, scope)) continue;
                            varIsReachableFrom.add(scope);
                        }
                        for (PsiReference ref : ReferencesSearch.search((PsiElement)var, (SearchScope)JSRefactoringUtil.getElementSearchScope((PsiElement)var))) {
                            TextRange textRange = ref.getElement().getTextRange();
                            ReadWriteAccessDetector.Access access = JSReadWriteAccessDetector.ourInstance.getExpressionAccess(ref.getElement());
                            if (!(access == ReadWriteAccessDetector.Access.Write && !JSResolveUtil.isSelfReference(ref.getElement()) || ContextInfo.this.possibleRange.contains(textRange) && !this.isInsideLoop(ref.getElement(), varBase))) {
                                hasReadsOutOfBlock = true;
                            }
                            if (access == ReadWriteAccessDetector.Access.Read || !ContextInfo.this.possibleRange.contains(textRange)) continue;
                            for (IntroductionScope scope : ContextInfo.this.introductionScopes) {
                                if (varIsReachableFrom.contains(scope)) continue;
                                hasWritesInBlock.add(scope);
                            }
                        }
                        if (hasReadsOutOfBlock) {
                            for (IntroductionScope scope : hasWritesInBlock) {
                                scope.outputVars.add(var);
                            }
                        }
                        if (referencedInFragment) {
                            for (IntroductionScope scope : ContextInfo.this.introductionScopes) {
                                if (varIsReachableFrom.contains(scope)) continue;
                                scope.usedVars.add(var);
                            }
                        }
                        this.processed.add(var);
                    }
                }

                private boolean isInsideLoop(PsiElement element, PsiElement varBase) {
                    PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSLoopStatement.class, varBase.getClass()});
                    while (parent instanceof JSLoopStatement) {
                        if (!ContextInfo.this.possibleRange.contains(parent.getTextRange())) {
                            return true;
                        }
                        parent = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{JSLoopStatement.class, varBase.getClass()});
                    }
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "node";
                    objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler$ContextInfo$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJSReturnStatement";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJSFunctionExpression";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJSFunctionDeclaration";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            if (this.isExpression) {
                for (PsiElement element2 : this.extractedElements) {
                    element2.accept((PsiElementVisitor)elementVisitor);
                }
            }
            while (statement != null) {
                TextRange textRange = statement.getTextRange();
                if (!this.possibleRange.contains(textRange)) {
                    boolean nonws;
                    boolean intersects = textRange.intersectsStrict(this.possibleRange);
                    boolean bl = nonws = !(statement instanceof PsiWhiteSpace);
                    if (nonws || !intersects) {
                        if (!nonws || !intersects || textRange.contains(this.possibleRange)) break;
                        this.extractedElements.clear();
                        break;
                    }
                }
                this.extractedElements.add(statement);
                statement.accept((PsiElementVisitor)elementVisitor);
                if (statement == statement2) break;
                PsiElement n = statement.getNextSibling();
                statement = null;
                while (n != null) {
                    if (!(n instanceof PsiWhiteSpace)) {
                        statement = n;
                        break;
                    }
                    if (n == statement2) break;
                    n = n.getNextSibling();
                }
                if (n == null) break;
                if (!JSExtractFunctionHandler.this.notAllowedStatement(n)) continue;
                this.extractedElements.clear();
                break;
            }
            if (this.isExpression) {
                JSExpression expression = (JSExpression)this.extractedElements.get(0);
                returnType.set((Object)(expression.getParent() instanceof JSExpressionStatement ? JSExtractFunctionHandler.VOID_TYPE_NAME : JSResolveUtil.getExpressionType(expression, this.file)));
            } else {
                for (IntroductionScope scope : this.introductionScopes) {
                    int outputVarsSize = scope.outputVars.size();
                    String scopeReturnType = (String)returnType.get();
                    if (outputVarsSize == 1) {
                        JSVariable next = scope.outputVars.iterator().next();
                        JSType type = next.getType();
                        String string = scopeReturnType = type == null ? null : type.getTypeText(JSType.TypeTextFormat.CODE);
                        if (scopeReturnType == null) {
                            scopeReturnType = "*";
                        }
                    } else if (outputVarsSize > 1) {
                        scopeReturnType = "Object";
                    }
                    scope.returnType = scopeReturnType;
                }
            }
            for (IntroductionScope scope : this.introductionScopes) {
                if (scope.returnType != null) continue;
                scope.returnType = returnType.get() == null ? JSExtractFunctionHandler.VOID_TYPE_NAME : (String)returnType.get();
            }
            if (this.extractedElements.size() == 0 || this.anchor == null || ContainerUtil.and(this.extractedElements, element -> element instanceof PsiWhiteSpace)) {
                this.myProblem = JSBundle.message((String)"javascript.refactoring.extract.function.bad.selection", (Object[])new Object[0]);
            }
            if (this.continueStatementsToReplaceWithReturn.size() != 0) {
                boolean allScopesReturnVoid = true;
                for (IntroductionScope scope : this.introductionScopes) {
                    if (JSExtractFunctionHandler.VOID_TYPE_NAME.equals(scope.returnType)) continue;
                    allScopesReturnVoid = false;
                }
                if (!allScopesReturnVoid) {
                    this.myProblem = JSBundle.message((String)"javascript.refactoring.extract.function.code.contain.continue.statement", (Object[])new Object[0]);
                }
            }
        }

        private boolean reachableFromExtractScope(PsiElement varScope, IntroductionScope scope) {
            PsiElement parent = scope.getParent();
            if (parent == varScope || parent.getParent() == varScope) {
                return true;
            }
            return PsiTreeUtil.findCommonParent((PsiElement)parent, (PsiElement)varScope) == varScope;
        }

        public String getProblem() {
            return this.myProblem;
        }

        @Override
        public boolean isActionScript() {
            return this.ecmaL4;
        }

        @Override
        public boolean isAsync() {
            return this.hasAwaitExpressions;
        }

        @Override
        public PsiElement getAnchor() {
            return this.anchor;
        }

        @Override
        @NotNull
        public List<IntroductionScope> getIntroductionScopes() {
            List<IntroductionScope> list = this.introductionScopes;
            if (list == null) {
                ContextInfo.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler$ContextInfo", "getIntroductionScopes"));
        }
    }

    public static class ScopeSelectionPopup
    implements JSScopeSelectionUI {
        private final Editor editor;
        private LightweightHint myLastHint;

        public ScopeSelectionPopup(Editor editor) {
            this.editor = editor;
        }

        @Override
        public void show(@NotNull IntroductionScope defaultSuggestedScope, final @NotNull List<JSScopeSelectionUI.ScopePresentation> scopeList, @NotNull Pass<IntroductionScope> callback) {
            if (defaultSuggestedScope == null) {
                ScopeSelectionPopup.$$$reportNull$$$0(0);
            }
            if (scopeList == null) {
                ScopeSelectionPopup.$$$reportNull$$$0(1);
            }
            if (callback == null) {
                ScopeSelectionPopup.$$$reportNull$$$0(2);
            }
            final LogicalPosition initialPos = this.editor.offsetToLogicalPosition(this.editor.getCaretModel().getOffset());
            final JBList list = new JBList((Collection)ContainerUtil.map(scopeList, presentation -> presentation.getScope()));
            list.setSelectedValue((Object)defaultSuggestedScope, true);
            list.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int index = list.getSelectedIndex();
                    if (index < 0) {
                        return;
                    }
                    JSScopeSelectionUI.ScopePresentation presentation = (JSScopeSelectionUI.ScopePresentation)scopeList.get(index);
                    int hintPosition = presentation.getHintPosition();
                    LogicalPosition position = editor.offsetToLogicalPosition(hintPosition);
                    editor.getScrollingModel().scrollTo(position, ScrollType.MAKE_VISIBLE);
                    editor.getScrollingModel().runActionOnScrollingFinished(() -> {
                        JComponent label = HintUtil.createInformationLabel((String)presentation.getSignature());
                        LightweightHint hint = new LightweightHint(label);
                        myLastHint = hint;
                        HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
                        Point p = HintManagerImpl.getHintPosition((LightweightHint)hint, (Editor)editor, (LogicalPosition)position, (short)3);
                        hintManager.showEditorHint(hint, editor, p, 48, 0, false, HintManagerImpl.createHintHint((Editor)editor, (Point)p, (LightweightHint)hint, (short)3).setContentActive(false).setAwtTooltip(true).setShowImmediately(true));
                    });
                }
            });
            list.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component rendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    IntroductionScope scope = (IntroductionScope)value;
                    PsiElement expr = scope.parent;
                    if (expr.isValid()) {
                        this.setText(scope.presentation);
                    }
                    return rendererComponent;
                }
            });
            JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Choose Destination Scope").setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(() -> {
                if (callback == null) {
                    ScopeSelectionPopup.$$$reportNull$$$0(3);
                }
                callback.pass(list.getSelectedValue());
            }).addListener((JBPopupListener)new JBPopupAdapter(){

                public void onClosed(LightweightWindowEvent event) {
                    editor.getScrollingModel().scrollTo(initialPos, ScrollType.CENTER);
                    if (myLastHint != null) {
                        myLastHint.hide();
                    }
                }
            }).createPopup().showInBestPositionFor(this.editor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultSuggestedScope";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scopeList";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler$ScopeSelectionPopup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "show";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$show$1";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

