/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceParameter;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.refactoring.JSIntroduceTargetChooser;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.introduceParameter.JSIntroduceParameterDialog;
import com.intellij.lang.javascript.refactoring.introduceParameter.JSIntroduceParameterSettings;
import com.intellij.lang.javascript.refactoring.introduceParameter.JSParameterInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduceVariable.InplaceSettings;
import com.intellij.lang.javascript.validation.fixes.JSParameterInserter;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIntroduceParameterHandler
extends JSBaseIntroduceHandler<JSElement, JSIntroduceParameterSettings, JSIntroduceParameterDialog> {
    protected JSParameterInserter parameterInserter;
    private JSIntroduceParameterSettings mySettings;
    private List<UsageInfo> myFunctionCallUsages;
    private static final String ADD_JSDOC_KEY = "js.introduce.parameter.add.jsdoc";
    private static final String GENERATE_OPTIONAL_KEY = "js.introduce.parameter.generate.optional";
    private SmartPsiElementPointer<PsiElement> myInitializerPointer;
    public static final JSIntroduceTargetChooser<JSFunction> DEFAULT_SCOPE_CHOOSER = (editor, elements, callback, presenter) -> callback.pass(ContainerUtil.getLastItem((List)elements));
    private final JSIntroduceTargetChooser<JSFunction> myScopeChooser;

    public JSIntroduceParameterHandler() {
        this.myScopeChooser = ApplicationManager.getApplication().isUnitTestMode() ? DEFAULT_SCOPE_CHOOSER : JSIntroduceParameterHandler::showScopeChooser;
    }

    public JSIntroduceParameterHandler(@NotNull JSIntroduceTargetChooser<JSExpression> expressionChooser, @NotNull JSIntroduceTargetChooser<JSFunction> scopeChooser) {
        if (expressionChooser == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(0);
        }
        if (scopeChooser == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(1);
        }
        super(expressionChooser);
        this.myScopeChooser = scopeChooser;
    }

    @Override
    protected String getRefactoringName() {
        return JSBundle.message((String)"javascript.introduce.parameter.title", (Object[])new Object[0]);
    }

    @Override
    protected String getCannotIntroduceMessagePropertyKey() {
        return "javascript.introduce.parameter.error.no.expression.selected";
    }

    @Override
    protected String getCannotIntroduceVoidExpressionTypeMessagePropertyKey() {
        return "javascript.introduce.parameter.error.expression.has.void.type";
    }

    @Override
    protected void findIntroducedScope(@NotNull Editor editor, @NotNull Pair<JSExpression, TextRange> expressionDescriptor, @NotNull NullableConsumer<JSElement> callback) {
        if (editor == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(2);
        }
        if (expressionDescriptor == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(3);
        }
        if (callback == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(4);
        }
        List<JSFunction> candidates = JSIntroduceParameterHandler.getPossibleScopes(expressionDescriptor);
        JSIntroduceParameterHandler.chooseElement(this.myScopeChooser, editor, candidates, arg_0 -> callback.consume(arg_0), JSIntroduceParameterHandler::getScopePresentation);
    }

    @NotNull
    private static List<JSFunction> getPossibleScopes(@NotNull Pair<JSExpression, TextRange> expression) {
        if (expression == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(5);
        }
        SmartList functions = new SmartList();
        JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)expression.first), JSFunction.class);
        while (fun != null) {
            functions.add(fun);
            fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)fun, JSFunction.class);
        }
        SmartList smartList = functions;
        if (smartList == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(6);
        }
        return smartList;
    }

    @Override
    protected JSBaseInplaceIntroducer<JSIntroduceParameterSettings> createInplaceIntroducer(JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceParameterSettings> context, JSElement scope, Editor editor, Project project, JSExpression[] occurences) {
        return new JSParameterInplaceIntroducer(editor, project, occurences, this, context);
    }

    @Override
    protected InplaceSettings<JSIntroduceParameterSettings> getInplaceSettings(final Pair<JSExpression, TextRange> exprDescriptor, JSExpression[] occurrences, final PsiElement scope, final OccurrencesChooser.ReplaceChoice choice) {
        BasicIntroducedEntityInfoProvider entityInfoProvider = new BasicIntroducedEntityInfoProvider((JSExpression)exprDescriptor.first, occurrences, scope);
        final String[] candidateNames = entityInfoProvider.suggestCandidateNames();
        final String myIntroducedName = candidateNames.length > 0 ? candidateNames[0].trim() : "newParam";
        return new InplaceSettings<JSIntroduceParameterSettings>(){

            @Override
            public String[] getSuggestedNames() {
                return candidateNames;
            }

            @Override
            public JSIntroduceParameterSettings getSettings() {
                return new JSIntroduceParameterSettings.Base(exprDescriptor){

                    @Override
                    public boolean addOptionalParameter() {
                        return JSIntroduceParameterHandler.isGenerateOptional(((JSExpression)exprDescriptor.first).getProject());
                    }

                    @Override
                    public boolean addJsDoc() {
                        return JSIntroduceParameterHandler.isAddJSDoc(((JSExpression)exprDescriptor.first).getProject());
                    }

                    @Override
                    public String getInitialValue() {
                        return JSIntroduceParameterHandler.access$001(JSIntroduceParameterHandler.this, exprDescriptor).getText();
                    }

                    @Override
                    public boolean isReplaceAllOccurrences() {
                        return choice == OccurrencesChooser.ReplaceChoice.ALL;
                    }

                    @Override
                    public String getVariableName() {
                        return myIntroducedName;
                    }

                    @Override
                    public String getVariableType() {
                        return null;
                    }

                    @Override
                    public JSFunction functionForIntroduceParameter() {
                        if (scope instanceof JSFunction) {
                            return (JSFunction)scope;
                        }
                        return super.functionForIntroduceParameter();
                    }
                };
            }
        };
    }

    @Override
    protected boolean doPreprocess(Project project, Editor editor, @NotNull Pair<JSExpression, TextRange> expressionDescriptor, @NotNull JSElement scope) {
        if (expressionDescriptor == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(8);
        }
        JSFunction fun = (JSFunction)scope;
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReferencesSearch.search((PsiElement)fun).forEach(psiReference -> {
            result.add(new UsageInfo(psiReference));
            return true;
        }), JSBundle.message((String)"javascript.refactoring.searching.usages", (Object[])new Object[0]), false, project);
        this.myFunctionCallUsages = result;
        if (JSIntroduceParameterHandler.containsAwaitExpressions((JSExpression)expressionDescriptor.first) && ContainerUtil.or(this.myFunctionCallUsages, u -> !JSIntroduceParameterHandler.isInAsyncContext(u.getElement()))) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JSBundle.message((String)"javascript.introduce.parameter.error.not.async.context", (Object[])new Object[0]), (String)this.getRefactoringName(), null);
            return false;
        }
        return true;
    }

    private static boolean isInAsyncContext(PsiElement element) {
        return ES6PsiUtil.isAsyncContext((JSFunction)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class));
    }

    @Override
    protected boolean visitInnerFunctions() {
        return true;
    }

    @Override
    protected JSIntroduceParameterDialog createDialog(Project project, JSExpression expression, JSExpression[] occurrences, PsiElement scope) {
        return new JSIntroduceParameterDialog(project, occurrences, expression, expression.getText(), scope instanceof JSFunction ? (JSFunction)scope : (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)expression, JSFunction.class));
    }

    @Override
    protected JSExpression getReplacementExpression(Pair<JSExpression, TextRange> expressionDescriptor) {
        String initialValue;
        String string = initialValue = this.mySettings == null ? super.getReplacementExpression(expressionDescriptor).getText() : this.mySettings.getInitialValue();
        if (initialValue.length() == 0) {
            initialValue = "null";
        }
        boolean doUnwrapParenthesized = false;
        if (expressionDescriptor.first instanceof JSFunctionExpression || expressionDescriptor.first instanceof JSObjectLiteralExpression || expressionDescriptor.first instanceof JSArrayLiteralExpression) {
            initialValue = "(" + initialValue + ")";
            doUnwrapParenthesized = true;
        }
        JSExpression psi = JSChangeUtil.createExpressionPsiWithContext(initialValue, (PsiElement)expressionDescriptor.first, JSExpression.class);
        if (doUnwrapParenthesized) {
            psi = ((JSParenthesizedExpression)psi).getInnerExpression();
        }
        return psi;
    }

    @Override
    protected JSElement findAnchor(JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceParameterSettings> settingsBaseIntroduceContext, boolean replaceAllOccurences) {
        this.mySettings = (JSIntroduceParameterSettings)settingsBaseIntroduceContext.settings;
        this.parameterInserter = JSParameterInserter.build(((JSIntroduceParameterSettings)settingsBaseIntroduceContext.settings).functionForIntroduceParameter());
        return super.findAnchor(settingsBaseIntroduceContext, replaceAllOccurences);
    }

    protected JSParameter addStatementBefore(JSElement anchor, JSVarStatement declaration) throws IncorrectOperationException {
        JSVariable var = declaration.getVariables()[0];
        JSType type = var.getType();
        String paramText = var.getName() + (type != null ? ":" + type.getTypeText(JSType.TypeTextFormat.CODE) : "");
        JSExpression initializer = var.getInitializer();
        if (this.mySettings.addOptionalParameter() && JSIntroduceParameterHandler.shouldGenerateParameterInitializer(initializer)) {
            paramText = var.getText();
        }
        return this.parameterInserter.doInsert(paramText, this.mySettings.addOptionalParameter(), initializer != null ? initializer.getText() : null);
    }

    @Override
    protected void doPostprocess(JSVarStatement declaration, JSIntroduceParameterSettings settings, Editor editor) {
        JSFunction fun = settings.functionForIntroduceParameter();
        assert (fun != null);
        JSVariable variable = declaration.getVariables()[0];
        Document document = fun.getContainingFile().getViewProvider().getDocument();
        PsiDocumentManager instance = PsiDocumentManager.getInstance((Project)fun.getProject());
        assert (document != null);
        boolean documentChanged = false;
        JSExpression initializer = variable.getInitializer();
        if (settings.addOptionalParameter() && !JSIntroduceParameterHandler.shouldGenerateParameterInitializer(initializer)) {
            String initializerText = initializer != null ? initializer.getText() : null;
            this.myInitializerPointer = JSIntroduceParameterHandler.addOptionalParameterInitializer(fun, variable.getName(), initializerText, editor);
            documentChanged = true;
        }
        if (settings.addJsDoc()) {
            ArrayList<String> create = new ArrayList<String>();
            StringBuilder paramTag = new StringBuilder("param ");
            JSType type = JSResolveUtil.getExpressionJSType(initializer);
            if (type != null && (!(type instanceof JSAnyType) || type.getSource().isExplicitlyDeclared())) {
                paramTag.append("{").append(type.getTypeText(JSType.TypeTextFormat.CODE)).append("} ");
            }
            paramTag.append(variable.getName());
            create.add(paramTag.toString());
            instance.doPostponedOperationsAndUnblockDocument(document);
            JSDocumentationUtils.createOrUpdateTagsInDocComment((PsiElement)fun, create, null, null);
            documentChanged = true;
        }
        if (documentChanged) {
            instance.commitDocument(document);
        }
    }

    @Override
    public void performIntroduce(@NotNull JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceParameterSettings> introduceContext) {
        PsiElement grandParent;
        if (introduceContext == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(9);
        }
        JSFunction fun = ((JSIntroduceParameterSettings)introduceContext.settings).functionForIntroduceParameter();
        assert (fun != null);
        for (UsageInfo u : this.myFunctionCallUsages) {
            PsiElement parent;
            PsiElement element = u.getElement();
            if (element == null || !((parent = element.getParent()) instanceof JSCallExpression)) continue;
            this.parameterInserter.fixCall((JSCallExpression)parent);
        }
        if (fun instanceof JSFunctionExpression && fun.getParent() instanceof JSParenthesizedExpression && (grandParent = fun.getParent().getParent()) instanceof JSCallExpression) {
            this.parameterInserter.fixCall((JSCallExpression)grandParent);
        }
    }

    public static SmartPsiElementPointer<PsiElement> addOptionalParameterInitializer(@NotNull JSFunction function, String variableName, String defaultValue, @Nullable Editor editor) {
        if (function == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(10);
        }
        return JSIntroduceParameterHandler.addOptionalParameterInitializer(function, variableName, defaultValue, false, true, editor);
    }

    public static SmartPsiElementPointer<PsiElement> addOptionalParameterInitializer(@NotNull JSFunction function, @NotNull String variableName, @NotNull String defaultValue, boolean addBeforeFirstElement, boolean addSemicolon, @Nullable Editor editor) {
        JSSourceElement[] functionBody;
        if (function == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(11);
        }
        if (variableName == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(12);
        }
        if (defaultValue == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(13);
        }
        if ((functionBody = function.getBody()).length == 0) {
            return null;
        }
        JSSourceElement body = functionBody[0];
        Project project = function.getProject();
        String text = variableName + "=" + variableName + "||" + defaultValue;
        if (addSemicolon) {
            text = text + JSCodeStyleSettings.getSemicolon(function.getContainingFile());
        }
        JSStatement initializeStatement = (JSStatement)ObjectUtils.assertNotNull((Object)JSChangeUtil.createStatementPsiFromTextWithContext(text, (PsiElement)function, JSStatement.class));
        PsiElement element = addBeforeFirstElement ? body.addBefore((PsiElement)initializeStatement, body.getFirstChild()) : body.addAfter((PsiElement)initializeStatement, body.getFirstChild());
        SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(element);
        if (editor != null) {
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        }
        JSIntroduceParameterHandler.fixFormat(project, pointer.getElement());
        return pointer;
    }

    public void removeOptionalParameterInitializer() {
        PsiElement element;
        PsiElement psiElement = element = this.myInitializerPointer != null ? this.myInitializerPointer.getElement() : null;
        if (element != null) {
            element.getParent().deleteChildRange(element, element.getNextSibling());
        }
    }

    public List<JSReferenceExpression> getParameterReferencesFromOptionalInitializer() {
        PsiElement element = this.myInitializerPointer != null ? this.myInitializerPointer.getElement() : null;
        ArrayList referenceExpressions = ContainerUtil.newArrayList();
        PsiTreeUtil.processElements((PsiElement)element, child -> {
            if (child instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)child, this.mySettings.getVariableName())) {
                referenceExpressions.add((JSReferenceExpression)child);
            }
            return true;
        });
        return referenceExpressions;
    }

    private static void showScopeChooser(@NotNull Editor editor, @NotNull List<JSFunction> functions, @NotNull Pass<JSFunction> callback, @NotNull Function<JSFunction, String> presenter) {
        if (editor == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(14);
        }
        if (functions == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(15);
        }
        if (callback == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(16);
        }
        if (presenter == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(17);
        }
        IntroduceTargetChooser.showChooser((Editor)editor, functions, callback, presenter, (String)"Target Function");
    }

    @NotNull
    private static String getScopePresentation(JSFunction function) {
        ItemPresentation presentation = function.getPresentation();
        if (presentation == null) {
            if ("" == null) {
                JSIntroduceParameterHandler.$$$reportNull$$$0(18);
            }
            return "";
        }
        String locationString = presentation.getLocationString();
        String string = presentation.getPresentableText() + (locationString != null ? " " + locationString : "");
        if (string == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(19);
        }
        return string;
    }

    public static boolean isAddJSDoc(@NotNull Project project) {
        if (project == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(20);
        }
        return PropertiesComponent.getInstance((Project)project).getBoolean(ADD_JSDOC_KEY, false);
    }

    public static boolean isGenerateOptional(@NotNull Project project) {
        if (project == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(21);
        }
        return PropertiesComponent.getInstance((Project)project).getBoolean(GENERATE_OPTIONAL_KEY, true);
    }

    public static void setAddJSDoc(@NotNull Project project, boolean value) {
        if (project == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(22);
        }
        PropertiesComponent.getInstance((Project)project).setValue(ADD_JSDOC_KEY, value, false);
    }

    public static void setGenerateOptional(@NotNull Project project, boolean value) {
        if (project == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(23);
        }
        PropertiesComponent.getInstance((Project)project).setValue(GENERATE_OPTIONAL_KEY, value, true);
    }

    private static boolean shouldGenerateParameterInitializer(@Nullable JSExpression initializerExpression) {
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)initializerExpression);
        return JSIntroduceParameterHandler.dialectSupportsParameterInitializers(dialect) && (!dialect.hasFeature(JSLanguageFeature.ASYNC_AWAIT) || !JSIntroduceParameterHandler.containsAwaitExpressions(initializerExpression));
    }

    private static boolean dialectSupportsParameterInitializers(@Nullable DialectOptionHolder holder) {
        return holder != null && (holder.isECMA4 || holder.isECMA6 || holder.isTypeScript);
    }

    static /* synthetic */ JSExpression access$001(JSIntroduceParameterHandler x0, Pair x1) {
        return super.getReplacementExpression((Pair<JSExpression, TextRange>)x1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionChooser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeChooser";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionDescriptor";
                break;
            }
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/introduceParameter/JSIntroduceParameterHandler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introduceContext";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functions";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presenter";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/introduceParameter/JSIntroduceParameterHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleScopes";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopePresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findIntroducedScope";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleScopes";
                break;
            }
            case 6: 
            case 18: 
            case 19: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doPreprocess";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "performIntroduce";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addOptionalParameterInitializer";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showScopeChooser";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isAddJSDoc";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isGenerateOptional";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setAddJSDoc";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setGenerateOptional";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

