/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.memberPullUp;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.refactoring.BaseJSRefactoringHandler;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.memberPullUp.JSPullUpConflictsUtil;
import com.intellij.lang.javascript.refactoring.memberPullUp.JSPullUpDialog;
import com.intellij.lang.javascript.refactoring.memberPullUp.JSPullUpHelper;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfoStorage;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class JSPullUpHandler
extends BaseJSRefactoringHandler
implements JSPullUpDialog.Callback {
    private static final Logger LOG = Logger.getInstance((String)JSPullUpHandler.class.getName());
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"pull.members.up.title");
    private static final String CANNOT_REFACTOR_REASON = RefactoringBundle.message((String)"the.caret.should.be.positioned.inside.a.class.to.pull.members.from");
    private JSClass mySubclass;
    private Project myProject;

    public JSPullUpHandler() {
        super(REFACTORING_NAME, CANNOT_REFACTOR_REASON);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        JSPullUpDialog dialog;
        if (project == null) {
            JSPullUpHandler.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            JSPullUpHandler.$$$reportNull$$$0(1);
        }
        if (elements.length != 1) {
            return;
        }
        this.myProject = project;
        PsiElement element = elements[0];
        if (!this.checkEcma(element, (Editor)CommonDataKeys.EDITOR.getData(dataContext))) {
            return;
        }
        JSClass aClass = JSPullUpHandler.getClass(element);
        if (aClass == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)CANNOT_REFACTOR_REASON);
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)((Editor)CommonDataKeys.EDITOR.getData(dataContext)), (String)message, (String)REFACTORING_NAME, null);
            return;
        }
        ArrayList<JSClass> bases = new ArrayList<JSClass>(JSInheritanceUtil.findAllParentsForClass(aClass, false));
        if (bases.isEmpty()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"class.does.not.have.base.classes.interfaces.in.current.project", (Object[])new Object[]{JSFormatUtil.formatClass(aClass, 2048)}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)((Editor)CommonDataKeys.EDITOR.getData(dataContext)), (String)message, (String)REFACTORING_NAME, null);
            return;
        }
        Collections.sort(bases, (o1, o2) -> o1.getQualifiedName().compareTo(o2.getQualifiedName()));
        this.mySubclass = aClass;
        JSMemberInfoStorage memberInfoStorage = new JSMemberInfoStorage(this.mySubclass, (MemberInfoBase.Filter<JSAttributeListOwner>)new MemberInfoBase.EmptyFilter());
        if (element instanceof JSElement) {
            for (JSMemberInfo memberInfo : memberInfoStorage.getClassMemberInfos((PsiElement)this.mySubclass)) {
                memberInfo.setChecked(Collections.singletonList((JSElement)element));
            }
        }
        if (!(dialog = new JSPullUpDialog(project, aClass, bases, memberInfoStorage, this)).showAndGet()) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)REFACTORING_NAME, null, () -> this.doRefactoring(dialog), (PsiFile[])new PsiFile[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefactoring(JSPullUpDialog dialog) {
        LocalHistoryAction a = LocalHistory.getInstance().startAction(this.getCommandName());
        try {
            try {
                JSPullUpHelper helper = new JSPullUpHelper(this.mySubclass, dialog.getSuperClass(), dialog.getSelectedMemberInfos(), dialog.getJavaDocPolicy());
                helper.moveMembersToBase();
            }
            finally {
                a.finish();
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private String getCommandName() {
        return RefactoringBundle.message((String)"pullUp.command", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)this.mySubclass)});
    }

    @Override
    public boolean checkConflicts(JSPullUpDialog dialog) {
        JSMemberInfo[] infos = dialog.getSelectedMemberInfos();
        JSClass superClass = dialog.getSuperClass();
        if (!JSPullUpHandler.checkWritable(superClass, infos)) {
            return false;
        }
        MultiMap<PsiElement, String> conflicts = JSPullUpConflictsUtil.checkConflicts(infos, this.mySubclass, superClass, dialog.getContainmentVerifier(), JSVisibilityUtil.DEFAULT_OPTIONS);
        if (!conflicts.isEmpty()) {
            ConflictsDialog conflictsDialog = new ConflictsDialog(this.myProject, conflicts);
            conflictsDialog.show();
            boolean ok = conflictsDialog.isOK();
            if (!ok && conflictsDialog.isShowConflicts()) {
                dialog.close(1);
            }
            return ok;
        }
        return true;
    }

    private static boolean checkWritable(JSClass superClass, JSMemberInfo[] infos) {
        if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)superClass, null, REFACTORING_NAME)) {
            return false;
        }
        for (JSMemberInfo info : infos) {
            if (info.getMember() instanceof JSClass && info.getOverrides() != null || JSRefactoringUtil.checkReadOnlyStatus(info.getMember(), null, REFACTORING_NAME)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/refactoring/memberPullUp/JSPullUpHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

