/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCacheService;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.validation.JSEmptyTypeChecker;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSFunctionSignatureChecker
extends JSElementVisitor {
    public static final JSFunctionSignatureChecker NO_OP_CHECKER = new JSFunctionSignatureChecker((JSTypeChecker)JSEmptyTypeChecker.getInstance()){

        @Override
        protected void checkFunctionInternal(@NotNull JSCallExpression node, @NotNull PsiElement element, LocalQuickFix[] quickFixes) {
            if (node == null) {
                1.$$$reportNull$$$0(0);
            }
            if (element == null) {
                1.$$$reportNull$$$0(1);
            }
        }

        @Override
        protected void registerProblem(JSCallExpression callExpression, String message, LocalQuickFix ... fixes) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/validation/JSFunctionSignatureChecker$1";
            objectArray[2] = "checkFunctionInternal";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    protected final JSTypeChecker<?> myTypeChecker;

    public JSFunctionSignatureChecker(@NotNull JSTypeChecker<?> typeChecker) {
        if (typeChecker == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(0);
        }
        this.myTypeChecker = typeChecker;
    }

    protected abstract void registerProblem(JSCallExpression var1, String var2, LocalQuickFix ... var3);

    public final void checkFunction(@NotNull JSCallExpression node, @NotNull PsiElement element) {
        PsiElement targetElement;
        if (node == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(1);
        }
        if (element == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(2);
        }
        if (JSClassUtils.canHaveClasses(element) && (targetElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(element)) instanceof JSClass) {
            this.checkConstructorCall(node, (JSClass)targetElement);
            return;
        }
        this.checkFunctionInternal(node, element, LocalQuickFix.EMPTY_ARRAY);
    }

    protected void checkFunctionInternal(@NotNull JSCallExpression node, @NotNull PsiElement element, LocalQuickFix[] quickFixes) {
        JSFunctionItem functionItem;
        if (node == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(3);
        }
        if (element == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(4);
        }
        if ((functionItem = JSPsiImplUtils.calculatePossibleFunction(element, (PsiElement)node)) != null) {
            JSType returnType;
            if (!functionItem.isGetProperty() || (returnType = functionItem.getReturnType()) == null || !this.isCallableType(node instanceof JSNewExpression, returnType)) {
                this.checkCallParameters(node, (PsiElement)functionItem, quickFixes);
            }
        } else {
            JSType jsType = JSTypeUtils.getTypeOfElement(element);
            this.canBeCalledWithArguments(jsType, node, quickFixes);
        }
    }

    protected void checkConstructorCall(@NotNull JSCallExpression node, @NotNull JSClass target) {
        if (node == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(5);
        }
        if (target == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(6);
        }
        if (!(node instanceof JSNewExpression) && !(node.getMethodExpression() instanceof JSSuperExpression)) {
            return;
        }
        ResolveResult[] results = JSClassUtils.resolveES6Constructor(target, node.getMethodExpression());
        PsiElement resolveResultElement = JSResolveResult.resolveAny(results);
        LocalQuickFix createConstructorFix = JSFixFactory.getInstance().createConstructorFix(node, target);
        if (resolveResultElement instanceof JSFunction) {
            LocalQuickFix[] localQuickFixArray;
            if (JSResolveUtil.getClassOfContext(resolveResultElement) != target) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = createConstructorFix;
            } else {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            }
            LocalQuickFix[] quickFixes = localQuickFixArray;
            this.checkFunctionInternal(node, resolveResultElement, quickFixes);
            return;
        }
        if (node.getArguments().length > 0) {
            this.registerProblem(node, JSBundle.message((String)"javascript.invalid.number.of.parameters", (Object[])new Object[]{0}), createConstructorFix);
        }
    }

    public void reportProblemIfNotExpectedCountOfParameters(JSCallExpression node, int count, String n) {
        if (node.getArguments().length != count) {
            this.registerProblem(node, JSBundle.message((String)"javascript.invalid.number.of.parameters", (Object[])new Object[]{n}), new LocalQuickFix[0]);
        }
    }

    protected boolean isCallableType(boolean inNewExpression, @NotNull JSType type) {
        if (type == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(7);
        }
        return inNewExpression ? JSTypeUtils.hasConstructorType(type) : JSTypeUtils.hasFunctionType(type);
    }

    protected void canBeCalledWithArguments(@Nullable JSType type, @NotNull JSCallExpression node, @NotNull LocalQuickFix[] quickFixes) {
        if (node == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(8);
        }
        if (quickFixes == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(9);
        }
        if ((type = JSTypeUtils.getValuableType(type)) instanceof JSFunctionTypeImpl) {
            JSParameterTypeDecorator nextDecorator;
            JSExpression[] arguments = node.getArguments();
            List<JSParameterTypeDecorator> parameters = ((JSFunctionTypeImpl)type).getParameters();
            Iterator<JSParameterTypeDecorator> myIterator = parameters.iterator();
            JSType restType = null;
            ProcessingContext context = JSTypeComparingCacheService.getProcessingContextWithCache((PsiElement)node);
            context.put(JSGenericParameterImpl.CALL_ENV_KEY, (Object)true);
            for (JSExpression argument : arguments) {
                JSType next;
                JSParameterTypeDecorator nextDecorator2 = null;
                if (restType != null) {
                    next = restType;
                } else if (myIterator.hasNext()) {
                    nextDecorator2 = myIterator.next();
                    next = nextDecorator2.getType();
                } else {
                    this.registerProblem(node, JSBundle.message((String)"javascript.invalid.number.of.parameters", (Object[])new Object[]{parameters.size()}), quickFixes);
                    break;
                }
                if (nextDecorator2 != null && nextDecorator2.isRest()) {
                    restType = nextDecorator2.getType();
                }
                this.myTypeChecker.checkExpressionIsAssignableToType(argument, next, "javascript.argument.type.mismatch", null, context);
            }
            if (myIterator.hasNext() && !(nextDecorator = myIterator.next()).isOptional() && !nextDecorator.isRest()) {
                this.registerProblem(node, JSBundle.message((String)"javascript.invalid.number.of.parameters", (Object[])new Object[]{parameters.size()}), quickFixes);
            }
        }
    }

    protected void checkCallParameters(@NotNull JSCallExpression node, @Nullable PsiElement element, LocalQuickFix[] quickFixes) {
        boolean matchFound;
        int[] initialMatchedParams;
        JSExpression[] expressions;
        JSFunctionItem function;
        if (node == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(10);
        }
        JSFunctionItem jSFunctionItem = function = element != null ? JSPsiImplUtils.calculatePossibleFunction(element, (PsiElement)node.getMethodExpression()) : null;
        if (function == null) {
            return;
        }
        JSParameterItem[] parameters = function.getParameters();
        JSArgumentList argumentList = node.getArgumentList();
        if (PsiTreeUtil.getChildrenOfType((PsiElement)argumentList, OuterLanguageElement.class) != null) {
            return;
        }
        JSExpression[] jSExpressionArray = expressions = argumentList != null ? argumentList.getArguments() : JSExpression.EMPTY_ARRAY;
        if (!(function.isReferencesArguments() || function instanceof JSImplicitElement && parameters.length == 0 && function.getReturnType() == null)) {
            Trinity<Integer, Integer, Boolean> minMaxParameters = ValidateTypesUtil.getMinMaxParameters(parameters);
            if (expressions.length < (Integer)minMaxParameters.first || expressions.length > (Integer)minMaxParameters.second) {
                String s;
                String string = (Boolean)minMaxParameters.third != false ? minMaxParameters.first + " or more" : (s = String.valueOf(minMaxParameters.first) + (!((Integer)minMaxParameters.first).equals(minMaxParameters.second) ? ".." + minMaxParameters.second : ""));
                if (function instanceof JSFunction) {
                    JSFunction topMethod = JSInheritanceUtil.findTopMethods((JSFunction)function).iterator().next();
                    JSFunction psiElement = topMethod != function ? topMethod : (JSFunction)function;
                    LocalQuickFix changeSignatureFix = JSFixFactory.getInstance().changeSignatureFix(psiElement, argumentList);
                    quickFixes = (LocalQuickFix[])ArrayUtil.append((Object[])quickFixes, (Object)changeSignatureFix);
                }
                if (expressions.length == 1 && "window".equalsIgnoreCase(expressions[0].getText()) && parameters.length == 2) {
                    return;
                }
                if (argumentList != null && argumentList.hasSpreadElement() && expressions.length < (Integer)minMaxParameters.first) {
                    return;
                }
                this.registerProblem(node, JSBundle.message((String)"javascript.invalid.number.of.parameters", (Object[])new Object[]{s}), quickFixes);
                return;
            }
        }
        if (!JSFunctionSignatureChecker.tryMakeInitialMatch(initialMatchedParams = new int[expressions.length], 0, 0, parameters)) {
            int paramWithMissedArgument;
            int arg = 0;
            for (paramWithMissedArgument = 0; paramWithMissedArgument < parameters.length; ++paramWithMissedArgument) {
                if (parameters[paramWithMissedArgument].isOptional() || parameters[paramWithMissedArgument].getType() == null) continue;
                if (arg >= expressions.length) break;
                ++arg;
            }
            if (paramWithMissedArgument < parameters.length) {
                this.registerProblem(node, JSBundle.message((String)"javascript.missed.argument.for.parameter", (Object[])new Object[]{parameters[paramWithMissedArgument].getName()}), quickFixes);
            }
            return;
        }
        int[] matchedParams = new int[initialMatchedParams.length];
        System.arraycopy(initialMatchedParams, 0, matchedParams, 0, matchedParams.length);
        boolean first = true;
        ProcessingContext context = JSTypeComparingCacheService.getProcessingContextWithCache((PsiElement)node);
        block1: do {
            if (first) {
                int[] _matchedParams = new int[matchedParams.length];
                System.arraycopy(matchedParams, 0, _matchedParams, 0, matchedParams.length);
                if (!this.obtainNextMatchedParams(_matchedParams, parameters) || JSFunctionSignatureChecker.useOnlyFirstMatch(function)) {
                    matchFound = false;
                    break;
                }
                first = false;
            }
            matchFound = true;
            for (int argIndex = 0; argIndex < expressions.length; ++argIndex) {
                JSParameterItem p = parameters[matchedParams[argIndex]];
                if (JSResolveUtil.isAssignableJSType(this.addGenericTypesFromCall(p.getTypeIncludingOverridden(), node, element), JSResolveUtil.getExpressionJSType(expressions[argIndex]), context)) continue;
                matchFound = false;
                continue block1;
            }
        } while (!matchFound && this.obtainNextMatchedParams(matchedParams, parameters));
        if (!matchFound) {
            DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)node);
            for (int argIndex = 0; argIndex < expressions.length; ++argIndex) {
                JSParameterItem p = parameters[initialMatchedParams[argIndex]];
                if (p.getTypeDecorator().isRest()) {
                    if (dialect == DialectOptionHolder.ECMA_4) break;
                    JSType type = p.getTypeIncludingOverridden();
                    this.myTypeChecker.checkExpressionIsAssignableToType(expressions[argIndex], this.addGenericTypesFromCall(type, node, element), "javascript.argument.type.mismatch", null, context);
                    continue;
                }
                this.checkCallArgumentType(p, expressions[argIndex], node, element);
            }
        }
    }

    private static boolean useOnlyFirstMatch(@NotNull JSFunctionItem function) {
        PsiFile file;
        if (function == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(11);
        }
        VirtualFile virtualFile = (file = function.getContainingFile()) != null ? file.getViewProvider().getVirtualFile() : null;
        return virtualFile != null && JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles().contains(virtualFile);
    }

    protected boolean obtainNextMatchedParams(int[] matchedParams, JSParameterItem[] parameters) {
        for (int argIndexToShift = matchedParams.length - 1; argIndexToShift >= 0; --argIndexToShift) {
            int paramOffset;
            int oldParamIndex;
            if (matchedParams[argIndexToShift] >= parameters.length - 1 || !parameters[oldParamIndex = matchedParams[argIndexToShift]].isOptional() && !parameters[oldParamIndex].getTypeDecorator().isRest()) continue;
            int newParamIndex = oldParamIndex + 1;
            int n = paramOffset = newParamIndex < parameters.length && parameters[newParamIndex].getTypeDecorator().isRest() ? newParamIndex : newParamIndex + 1;
            if (!JSFunctionSignatureChecker.tryMakeInitialMatch(matchedParams, argIndexToShift + 1, paramOffset, parameters)) continue;
            int n2 = argIndexToShift;
            matchedParams[n2] = matchedParams[n2] + 1;
            return true;
        }
        return false;
    }

    private static boolean tryMakeInitialMatch(int[] matchedParams, int matchedParamsOffset, int paramsOffset, JSParameterItem[] parameters) {
        boolean fits;
        if (matchedParamsOffset > matchedParams.length) {
            return false;
        }
        if (paramsOffset > parameters.length) {
            return false;
        }
        int argumentsToMatch = matchedParams.length - matchedParamsOffset;
        int required = 0;
        boolean hasRest = false;
        for (int i = paramsOffset; i < parameters.length; ++i) {
            if (parameters[i].getTypeDecorator().isRest()) {
                hasRest = true;
                continue;
            }
            if (parameters[i].isOptional()) continue;
            ++required;
        }
        boolean bl = fits = required <= argumentsToMatch && (hasRest || argumentsToMatch <= parameters.length - paramsOffset);
        if (!fits) {
            return false;
        }
        for (int i = matchedParamsOffset; i < matchedParams.length; ++i) {
            if (required == matchedParams.length - i) {
                while (parameters[paramsOffset].getTypeDecorator().isRest() || parameters[paramsOffset].isOptional()) {
                    ++paramsOffset;
                }
            }
            matchedParams[i] = paramsOffset;
            if (parameters[paramsOffset].getTypeDecorator().isRest()) continue;
            if (!parameters[paramsOffset].isOptional()) {
                --required;
            }
            ++paramsOffset;
        }
        return true;
    }

    @Nullable
    @Contract(value="!null, _, _ -> !null")
    protected final JSType addGenericTypesFromCall(@Nullable JSType type, JSCallExpression callExpression, PsiElement resolveResult) {
        return this.addGenericTypesFromCall(type, callExpression, resolveResult, null);
    }

    @Nullable
    @Contract(value="!null, _, _,_ -> !null")
    protected JSType addGenericTypesFromCall(@Nullable JSType type, JSCallExpression callExpression, PsiElement resolveResult, @Nullable JSGenericTypesEvaluator.GenericErrorReporter reporter) {
        return type;
    }

    protected void checkCallArgumentType(JSParameterItem p, JSExpression expression, JSCallExpression node, PsiElement resolveResult) {
        this.myTypeChecker.checkExpressionIsAssignableToType(expression, p.getType(), "javascript.argument.type.mismatch", (PsiElement)(p instanceof JSParameter ? (JSParameter)p : null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeChecker";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/validation/JSFunctionSignatureChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFunction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFunctionInternal";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkConstructorCall";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isCallableType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeCalledWithArguments";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCallParameters";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "useOnlyFirstMatch";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

