/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.watcher;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.watcher.TypeScriptTaskConsumer;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.ui.TypeScriptCompilerEditorNotificationProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.watcher.config.FileWatchersState;
import com.intellij.plugins.watcher.model.ProjectTasksOptions;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompilerFwEditorNotificationProvider
extends TypeScriptCompilerEditorNotificationProvider
implements TypeScriptCompilerEditorNotificationProvider.NotificationOverride {
    public TypeScriptCompilerFwEditorNotificationProvider(Project project, EditorNotifications notifications) {
        super(project, notifications);
    }

    @Nullable
    protected TaskOptions getEnabledFwForTypeScript() {
        FileWatchersState state = ProjectTasksOptions.getInstance((Project)this.myProject).getWatchersState();
        for (Pair pair : state.getTasks()) {
            String program;
            if (!((Boolean)pair.getSecond()).booleanValue() || !(program = FileUtil.toSystemIndependentName((String)StringUtil.notNullize((String)((TaskOptions)pair.getFirst()).getProgram()).trim())).equals(TypeScriptTaskConsumer.TSC_NAME) && !program.endsWith("/" + TypeScriptTaskConsumer.TSC_NAME)) continue;
            return (TaskOptions)pair.getFirst();
        }
        return null;
    }

    @Override
    @Nullable
    public JComponent createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (file == null) {
            TypeScriptCompilerFwEditorNotificationProvider.$$$reportNull$$$0(0);
        }
        if (fileEditor == null) {
            TypeScriptCompilerFwEditorNotificationProvider.$$$reportNull$$$0(1);
        }
        if (this.showCompilerNotification(file)) {
            if (this.getEnabledFwForTypeScript() != null) {
                return new FwReConfigEditorNotificationPanel();
            }
            return new TypeScriptCompilerEditorNotificationProvider.CompilerEditorNotificationPanel(this, file);
        }
        return null;
    }

    @Override
    protected boolean hasOverride() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "fileEditor";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/watcher/TypeScriptCompilerFwEditorNotificationProvider";
        objectArray[2] = "createNotificationPanel";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected class FwReConfigEditorNotificationPanel
    extends EditorNotificationPanel {
        public FwReConfigEditorNotificationPanel() {
            super(EditorColors.GUTTER_BACKGROUND);
            this.setText(JSBundle.message((String)"typescript.compiler.notification.editor.fw.message", (Object[])new Object[0]));
            this.createActionLabel(JSBundle.message((String)"typescript.compiler.notification.editor.fw.replace", (Object[])new Object[0]), () -> {
                AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
                try {
                    TaskOptions script = TypeScriptCompilerFwEditorNotificationProvider.this.getEnabledFwForTypeScript();
                    if (script == null) {
                        return;
                    }
                    TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(TypeScriptCompilerFwEditorNotificationProvider.this.myProject);
                    settings.setGenerateSourceMap(false);
                    settings.setScopeName(script.getScopeName());
                    ArrayList params = ContainerUtil.newArrayList();
                    DataContext context = SimpleDataContext.getProjectContext((Project)TypeScriptCompilerFwEditorNotificationProvider.this.myProject);
                    String arguments = script.getArguments();
                    String[] stringArray = ParametersList.parse((String)arguments);
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String param;
                        String newParam = param = stringArray[i];
                        if (param.contains(TypeScriptTaskConsumer.FILE_PATH_MACRO)) continue;
                        if (param.toLowerCase(Locale.ENGLISH).equals("--sourceMap".toLowerCase(Locale.ENGLISH))) {
                            settings.setGenerateSourceMap(true);
                            continue;
                        }
                        try {
                            newParam = MacroManager.getInstance().expandMacrosInString(param, false, context);
                            if (newParam == null) continue;
                            if ((newParam = FileUtil.toSystemIndependentName((String)newParam)).startsWith("/") && !param.startsWith("/")) {
                                newParam = StringUtil.trimStart((String)newParam, (String)"/");
                            }
                        }
                        catch (Macro.ExecutionCancelledException executionCancelledException) {
                            // empty catch block
                        }
                        params.add(newParam);
                    }
                    settings.setTypeScriptCompilerParams(ParametersList.join((List)params));
                    settings.setImmediateCompileEnabled(true);
                    ProjectTasksOptions.getInstance((Project)TypeScriptCompilerFwEditorNotificationProvider.this.myProject).setEnabledForTask(script.getName(), false);
                }
                finally {
                    token.finish();
                }
                ApplicationManager.getApplication().saveSettings();
                TypeScriptCompilerService.restartServices(TypeScriptCompilerFwEditorNotificationProvider.this.myProject);
                TypeScriptCompilerFwEditorNotificationProvider.this.myNotifications.updateAllNotifications();
            });
            this.createActionLabel(JSBundle.message((String)"typescript.compiler.notification.editor.configure.compiler", (Object[])new Object[0]), TypeScriptCompilerFwEditorNotificationProvider.this.getConfigureAction());
            this.createActionLabel(JSBundle.message((String)"typescript.compiler.notification.editor.dismiss", (Object[])new Object[0]), TypeScriptCompilerFwEditorNotificationProvider.this.getDismissAction());
        }
    }
}

