/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.util.scopeChooser.ScopeChooserUtils;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSFileHighlightingInfo;
import com.intellij.lang.javascript.service.JSHighlightingInfoBuilder;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommand;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceQueueImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceResultContainer;
import com.intellij.lang.javascript.service.JSLanguageServiceToolWindowInfoReporter;
import com.intellij.lang.javascript.service.JSLanguageServiceUpdateContext;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptLanguageServiceAnnotatorCheckerProvider;
import com.intellij.lang.typescript.compiler.TypeScriptToolWindowProvider;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceAnnotationResult;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.codeFixes.TypeScriptLanguageServiceFix;
import com.intellij.lang.typescript.compiler.languageService.codeFixes.TypeScriptLanguageServiceFixSet;
import com.intellij.lang.typescript.compiler.languageService.protocol.TypeScriptLanguageServiceCacheImpl;
import com.intellij.lang.typescript.compiler.languageService.protocol.TypeScriptServiceStandardOutputProtocol;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.CompletionDetailsRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.SemanticDiagnosticsSyncRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.SyntacticDiagnosticsSyncRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCloseEditorCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCommandSetRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompileCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompileFileArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompletionsCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompletionsRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileLocationRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileObject;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileWithConfigArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetProjectErrCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptLanguageServiceUpdateCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptOpenEditorCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptReloadProjectsCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptServiceCommandClean;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptCompletionResponse;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptDiagnosticsResponse;
import com.intellij.lang.typescript.compiler.ui.TypeScriptServerServiceSettings;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsImpl;
import com.intellij.lang.typescript.tsconfig.graph.TypeScriptImportGraph;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptServerServiceImpl
extends TypeScriptCompilerService {
    private static final int TIME_TO_MERGE_COMPILE_EVENTS_MILLS = 2500;
    private static final int TIME_TO_MERGE_PROJECT_EVENTS_MILLS = 2500;
    public static final String BODY_FIELD = "body";
    public static final String GENERATED_FILES_FIELD = "generatedFiles";
    public static final String PROCESSED_FILES_FIELD = "processedFiles";
    public static final int NO_FIX_CODE = -1;
    public static final String DIAGNOSTICS_FIELD = "diagnostics";
    @NotNull
    private final MergingUpdateQueue myCompileQueue;
    @NotNull
    private final MergingUpdateQueue myProjectErrorsQueue;
    @NotNull
    private final ConcurrentMap<String, Consumer<JSLanguageServiceAnswer>> myEventCollector;
    protected volatile int[] myErrorCodeFixes;
    @NotNull
    protected final TypeScriptCompilerSettings mySettings;
    @NotNull
    private final Condition<VirtualFile> myFileFilter;
    private final ConcurrentMap<String, JSLanguageServiceAnswer> myConfigDiagnostics;
    @NotNull
    private final JSLanguageServiceCommandProcessor<List<TypeScriptCompletionResponse.CompletionEntryDetail>> myCompletionDefaultProcessor;

    public TypeScriptServerServiceImpl(@NotNull Project project, @NotNull TypeScriptCompilerSettings settings) {
        if (project == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(1);
        }
        this(project, settings, "Console");
    }

    protected TypeScriptServerServiceImpl(@NotNull Project project, @NotNull TypeScriptCompilerSettings settings, @NotNull String consoleId) {
        if (project == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(3);
        }
        if (consoleId == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(4);
        }
        super(project, consoleId);
        this.myErrorCodeFixes = new int[0];
        this.myConfigDiagnostics = ContainerUtil.newConcurrentMap();
        this.myCompletionDefaultProcessor = (serviceObject, answer) -> {
            JsonObject element = answer.getElement();
            try {
                TypeScriptCompletionResponse response = (TypeScriptCompletionResponse)JSLanguageServiceQueueImpl.GSON.fromJson((JsonElement)element, TypeScriptCompletionResponse.class);
                if (response == null || response.body == null) {
                    return ContainerUtil.emptyList();
                }
                return ContainerUtil.newArrayList((Object[])response.body);
            }
            catch (Exception e) {
                JSLanguageServiceQueue.LOGGER.error(e.getMessage(), (Throwable)e);
                return ContainerUtil.emptyList();
            }
        };
        this.mySettings = settings;
        this.myEventCollector = ContainerUtil.newConcurrentMap();
        this.myCompileQueue = new MergingUpdateQueue("TypeScript Compile queue", 2500, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        this.myProjectErrorsQueue = new MergingUpdateQueue("TypeScript Project Errors queue", 2500, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        TypeScriptConfigService service = TypeScriptConfigService.Provider.get(project);
        this.myFileFilter = service == null ? TypeScriptLanguageServiceUtil.ACCEPTABLE_TS_FILE : virtualFile -> {
            if (project == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(106);
            }
            if (!TypeScriptLanguageServiceUtil.IS_VALID_FILE_FOR_SERVICE.value(virtualFile)) {
                return false;
            }
            if (TypeScriptLanguageServiceUtil.ACCEPTABLE_TS_FILE.value(virtualFile)) {
                return true;
            }
            FileType type = virtualFile.getFileType();
            if (!DialectDetector.JAVASCRIPT_FILE_TYPES.contains(type)) {
                return false;
            }
            return (Boolean)ReadAction.compute(() -> {
                if (project == null) {
                    TypeScriptServerServiceImpl.$$$reportNull$$$0(107);
                }
                if (DumbService.isDumb((Project)project)) {
                    return false;
                }
                Collection<TypeScriptConfig> configFiles = service.getConfigFiles();
                if (configFiles.isEmpty() || configFiles.stream().noneMatch(el -> el.allowJs())) {
                    return false;
                }
                TypeScriptConfig config2 = TypeScriptConfigUtil.getNearestParentConfig(virtualFile, configFiles);
                return config2 != null && config2.allowJs();
            });
        };
        this.registerEventTracker("configFileDiag", (Consumer<JSLanguageServiceAnswer>)((Consumer)el -> {
            JsonObject element = el.getElement();
            JsonObject body = element.getAsJsonObject(BODY_FIELD);
            JsonElement file = body.get("configFile");
            if (file != null && file.isJsonPrimitive()) {
                String string = file.getAsString();
                this.myConfigDiagnostics.put(string, (JSLanguageServiceAnswer)el);
                JSLanguageServiceQueue.LOGGER.debug("Updated config diagnostics: " + el.getElement());
            }
        }));
    }

    @Override
    public void sendCleanCommandToCompiler(@NotNull TypeScriptServiceCommandClean command) {
        if (command == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(5);
        }
        if (!this.isServiceCreated()) {
            return;
        }
        JSLanguageServiceQueue process = this.getProcess();
        if (process != null) {
            String path = command.getCompilerId();
            if (StringUtil.isEmpty((String)path)) {
                this.sendCommand(new TypeScriptReloadProjectsCommand());
            } else {
                TypeScriptFileWithConfigArgs args = new TypeScriptFileWithConfigArgs();
                args.projectFileName = path;
                this.sendCommand(new TypeScriptReloadProjectsCommand(args));
            }
            process.resetCaches();
        }
    }

    @Override
    protected void addFileToCompileQueue(@NotNull List<VirtualFile> files) {
        List<String> fileNames;
        if (files == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(6);
        }
        if ((fileNames = this.getAcceptableCompileFileNames(files)).isEmpty()) {
            return;
        }
        if (!files.isEmpty()) {
            this.myCompileQueue.queue(new Update(new TypeScriptCompileUpdater(), 10){

                public void run() {
                    if (TypeScriptServerServiceImpl.this.isServiceCreated()) {
                        JSLanguageServiceUpdateContext context = (JSLanguageServiceUpdateContext)ReadAction.compute(() -> JSHighlightingInfoBuilder.createUpdateContext(TypeScriptServerServiceImpl.this.myProject, TypeScriptServerServiceImpl.this.getAcceptableFilesFilter()));
                        TypeScriptServerServiceImpl.this.update(context);
                    }
                }
            });
        }
        this.addFileToCompileQueue((Collection<String>)fileNames);
    }

    @NotNull
    private List<String> getAcceptableCompileFileNames(@NotNull List<VirtualFile> files) {
        if (files == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(7);
        }
        if (!this.isCompileEnabled()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(8);
            }
            return list;
        }
        GlobalSearchScope scope = this.getScope();
        List list = ContainerUtil.mapNotNull(files, el -> {
            if (el.isInLocalFileSystem() && el.isValid() && scope.accept(el) && null == el.getUserData(JSLanguageServiceQueue.GENERATED_FILE_MARKER)) {
                return TypeScriptCompilerConfigUtil.normalizeNameAndPath(el);
            }
            return null;
        });
        if (list == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    public Future<List<TypeScriptCompletionResponse.CompletionEntryDetail>> updateAndGetCompletionItems(@NotNull VirtualFile virtualFile, @NotNull PsiFile file, @NotNull Document document, int positionInFileOffset) {
        if (virtualFile == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(10);
        }
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(11);
        }
        if (document == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        JSLanguageServiceQueue process = this.getProcess();
        if (process == null) {
            return null;
        }
        JSLanguageServiceUpdateContext context = JSHighlightingInfoBuilder.createUpdateContext(file.getProject(), this.getAcceptableFilesFilter());
        TypeScriptCompletionsRequestArgs args = new TypeScriptCompletionsRequestArgs();
        TypeScriptLanguageServiceUtil.fillFilePosition(args, virtualFile, document, positionInFileOffset);
        JSLanguageServiceSimpleCommand completionCommand = this.createCompletionCommand(args, virtualFile, file);
        this.update(context);
        JSLanguageServiceCommandProcessor<List<TypeScriptCompletionResponse.CompletionEntryDetail>> completionProcessor = this.createCompletionProcessor();
        return process.execute(completionCommand, completionProcessor);
    }

    @Override
    @Nullable
    public Future<List<TypeScriptCompletionResponse.CompletionEntryDetail>> getDetailedCompletionItems(@NotNull VirtualFile virtualFile, @NotNull List<TypeScriptCompletionResponse.CompletionEntryDetail> items, @NotNull Document document, int positionInFileOffset) {
        if (virtualFile == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(13);
        }
        if (items == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(14);
        }
        if (document == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        JSLanguageServiceQueue process = this.getProcess();
        if (process == null) {
            return null;
        }
        List<String> names = items.stream().map(el -> el.name).collect(Collectors.toList());
        CompletionDetailsRequest request = new CompletionDetailsRequest(names);
        TypeScriptLanguageServiceUtil.fillFilePosition((TypeScriptFileLocationRequestArgs)request.arguments, virtualFile, document, positionInFileOffset);
        JSLanguageServiceCommandProcessor<List<TypeScriptCompletionResponse.CompletionEntryDetail>> completionProcessor = this.createCompletionProcessor();
        return process.execute(request, completionProcessor);
    }

    @Override
    @Nullable
    public TypeScriptServerServiceSettings getServiceSettings() {
        return null;
    }

    @NotNull
    protected JSLanguageServiceCommandProcessor<List<TypeScriptCompletionResponse.CompletionEntryDetail>> createCompletionProcessor() {
        JSLanguageServiceCommandProcessor<List<TypeScriptCompletionResponse.CompletionEntryDetail>> jSLanguageServiceCommandProcessor = this.myCompletionDefaultProcessor;
        if (jSLanguageServiceCommandProcessor == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(16);
        }
        return jSLanguageServiceCommandProcessor;
    }

    @NotNull
    protected JSLanguageServiceSimpleCommand createCompletionCommand(@NotNull TypeScriptCompletionsRequestArgs args, @NotNull VirtualFile virtualFile, @NotNull PsiFile file) {
        if (args == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(17);
        }
        if (virtualFile == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(18);
        }
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(19);
        }
        TypeScriptCompletionsCommand typeScriptCompletionsCommand = new TypeScriptCompletionsCommand(args);
        if (typeScriptCompletionsCommand == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(20);
        }
        return typeScriptCompletionsCommand;
    }

    @Override
    @Nullable
    public Future<Boolean> update(@NotNull JSLanguageServiceUpdateContext context) {
        if (context == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(21);
        }
        return this.updateImpl(context);
    }

    @Override
    @Nullable
    public Future<JSLanguageServiceResultContainer> compileFileAndGetErrors(@NotNull VirtualFile file) {
        JSLanguageServiceQueue process;
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(22);
        }
        if ((process = this.getProcess()) == null) {
            return null;
        }
        String path = file.getCanonicalPath();
        if (path == null || TypeScriptUtil.isDefinitionFile(path) || !TypeScriptLanguageServiceUtil.ACCEPTABLE_TS_FILE.value((Object)file)) {
            return null;
        }
        TypeScriptCompileFileArgs args = new TypeScriptCompileFileArgs();
        args.includeErrors = true;
        args.force = true;
        args.file = TypeScriptCompilerConfigUtil.normalizeNameAndPath(file);
        this.setMacroParamsIfNeed(args, file);
        TypeScriptCompileCommand command = new TypeScriptCompileCommand(args);
        return process.execute(command, this.createCompileResultProcessor());
    }

    @Override
    @Nullable
    public Future<JSLanguageServiceResultContainer> compileConfigProjectAndGetErrors(@NotNull TypeScriptConfig config2) {
        JSLanguageServiceQueue process;
        if (config2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(23);
        }
        if ((process = this.getProcess()) == null) {
            return null;
        }
        TypeScriptCompileFileArgs args = new TypeScriptCompileFileArgs();
        args.includeErrors = true;
        args.force = true;
        args.projectFileName = TypeScriptCompilerConfigUtil.normalizeNameAndPath(config2.getConfigFile());
        return process.execute(new TypeScriptCompileCommand(args), this.createCompileResultProcessor());
    }

    @Override
    public void closeLastEditor(@NotNull VirtualFile file) {
        VirtualFile mainFile;
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(24);
        }
        if (!TypeScriptLanguageServiceUtil.checkProject(this.myProject)) {
            return;
        }
        if (!TypeScriptLanguageServiceUtil.isServiceEnabled(this.myProject) || !this.isServiceCreated()) {
            return;
        }
        if (this.mySettings.isUseMainFile() && file.equals(mainFile = this.getMainFile())) {
            return;
        }
        String normalizeNameAndPath = TypeScriptCompilerConfigUtil.normalizeNameAndPath(file);
        TypeScriptFileObject arguments = new TypeScriptFileObject();
        TypeScriptCloseEditorCommand command = new TypeScriptCloseEditorCommand(arguments, file);
        arguments.file = normalizeNameAndPath;
        this.sendCommand(command);
    }

    @Override
    @NotNull
    public Collection<? extends IntentionAction> getFixes(@NotNull PsiFile file, @NotNull JSAnnotationError result) {
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(25);
        }
        if (result == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(26);
        }
        if (!(result instanceof TypeScriptLanguageServiceAnnotationResult)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(27);
            }
            return list;
        }
        int code = ((TypeScriptLanguageServiceAnnotationResult)result).getErrorCode();
        if (code == -1) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(28);
            }
            return list;
        }
        int[] codes = this.myErrorCodeFixes;
        if (codes.length > 0 && Arrays.stream(codes).anyMatch(el -> el == code)) {
            TypeScriptLanguageServiceFixSet set = new TypeScriptLanguageServiceFixSet(this, file.getVirtualFile(), (TypeScriptLanguageServiceAnnotationResult)result);
            List<TypeScriptLanguageServiceFix> list = set.getFixes();
            if (list == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(29);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(30);
        }
        return list;
    }

    @Override
    public void openEditor(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(31);
        }
        if (!TypeScriptLanguageServiceUtil.checkProject(this.myProject)) {
            return;
        }
        if (!TypeScriptLanguageServiceUtil.isServiceEnabled(this.myProject) || !this.isServiceCreated()) {
            return;
        }
        TypeScriptOpenEditorCommand command = TypeScriptServerServiceImpl.createOpenEditorCommand(file);
        JSLanguageServiceQueue process = this.getProcess();
        if (process == null) {
            return;
        }
        process.executeNoBlocking(command, null, (Consumer<JSLanguageServiceObject>)((Consumer)el -> {
            if (file == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(105);
            }
            this.addFileToCompileQueue(Collections.singletonList(file));
        }));
    }

    @Override
    public boolean checkCanUseService() {
        return this.getCanStartProcessState() != ThreeState.NO && (this.mySettings.isCompilerEnabled() || this.myFailCount.get() < (long)this.getAliveCheckCount());
    }

    @Override
    public JSLanguageServiceQueue getLSProcess() {
        return super.getLSProcess();
    }

    @Override
    @Nullable
    public Future<List<JSAnnotationError>> highlight(@NotNull PsiFile file, @NotNull JSFileHighlightingInfo info) {
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(32);
        }
        if (info == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(33);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection<VirtualFile> configs = TypeScriptServerServiceImpl.getChangedConfigs();
        if (configs != null && !configs.isEmpty()) {
            this.saveChangedConfigsAndRestartHighlighting(file, configs);
            return null;
        }
        return this.updateFilesAndGetErrors(info);
    }

    @Override
    public boolean canHighlight(@NotNull PsiFile file) {
        DialectOptionHolder holder;
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(34);
        }
        if ((holder = DialectDetector.dialectOfElement((PsiElement)file)) == null || !holder.isTypeScript && !holder.isJavaScript()) {
            return false;
        }
        TypeScriptAnnotatorCheckerProvider provider = TypeScriptAnnotatorCheckerProvider.getCheckerProvider((PsiElement)file);
        if (!(provider instanceof TypeScriptLanguageServiceAnnotatorCheckerProvider)) {
            return false;
        }
        if (holder.isTypeScript) {
            return true;
        }
        TypeScriptConfig configForPsiFile = TypeScriptConfigUtil.getConfigForPsiFile(file);
        return configForPsiFile != null && configForPsiFile.checkJs();
    }

    @Override
    @NotNull
    public Condition<VirtualFile> getAcceptableFilesFilter() {
        Condition<VirtualFile> condition = this.myFileFilter;
        if (condition == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(35);
        }
        return condition;
    }

    @Override
    @Nullable
    protected JSLanguageServiceQueue createLanguageServiceQueue() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        String interpreter = TypeScriptLanguageServiceUtil.getNodeInterpreterPath(this.myProject);
        boolean hasInterpreter = !StringUtil.isEmptyOrSpaces((String)interpreter);
        ThreeState prevValue = this.getCanStartProcessState();
        this.setCanStartProcessState(ThreeState.fromBoolean((boolean)hasInterpreter));
        if (!hasInterpreter) {
            this.showInterpreterError(prevValue);
            return null;
        }
        Ref serviceRef = Ref.create();
        Condition expiredConditionForReadyConsumer = el -> {
            JSLanguageServiceQueue service = (JSLanguageServiceQueue)serviceRef.get();
            if (service == null) {
                return false;
            }
            return !service.isValid();
        };
        Consumer<JsonObject> readyConsumer = this.createReadyConsumer((Condition<Object>)expiredConditionForReadyConsumer);
        JSLanguageServiceProtocol protocol = this.createProtocol(readyConsumer);
        if (protocol == null) {
            return null;
        }
        boolean setActive = this.myFailCount.get() == 0L;
        JSLanguageServiceQueue.ServiceInfoReporter errorReporter = this.myToolWindowManager != null ? new JSLanguageServiceToolWindowInfoReporter(this.myProject, this.getProcessName(), this.myToolWindowManager, setActive) : this.myDefaultReporter;
        JSLanguageServiceQueueImpl service = new JSLanguageServiceQueueImpl(this.myProject, protocol, this.myProcessConnector, errorReporter, new TypeScriptLanguageServiceCacheImpl());
        serviceRef.set((Object)service);
        Consumer<JSLanguageServiceQueue> initializer = this.getInitializedCallback();
        initializer.consume((Object)service);
        return service;
    }

    @NotNull
    private Consumer<JsonObject> createReadyConsumer(Condition<Object> expiredCondition) {
        Consumer consumer = el -> {
            try {
                JsonElement codes;
                JsonObject message = el.getAsJsonObject("message");
                if (message == null) {
                    JSLanguageServiceQueue.LOGGER.error("No ready message");
                    return;
                }
                JsonPrimitive version = message.getAsJsonPrimitive("version");
                String versionAsString = TypeScriptLanguageServiceUtil.getNormalizedVersionString(version.getAsString());
                if (this.myToolWindowManager != null) {
                    ApplicationManager.getApplication().invokeLater(() -> this.myToolWindowManager.setName(versionAsString), expiredCondition);
                }
                if ((codes = message.get("supportedErrorCodes")) != null && codes.isJsonArray()) {
                    JsonArray array = codes.getAsJsonArray();
                    int[] result = new int[array.size()];
                    int i = 0;
                    for (JsonElement element : array) {
                        if (element.isJsonPrimitive()) {
                            JsonPrimitive primitive = element.getAsJsonPrimitive();
                            try {
                                if (primitive.isNumber()) {
                                    result[i++] = primitive.getAsInt();
                                    continue;
                                }
                                if (!primitive.isString()) continue;
                                result[i++] = Integer.valueOf(primitive.getAsString());
                            }
                            catch (Exception e) {
                                result[i++] = -1;
                            }
                            continue;
                        }
                        result[i++] = -1;
                    }
                    this.myErrorCodeFixes = result;
                }
            }
            catch (Exception e) {
                JSLanguageServiceQueue.LOGGER.error(e.getMessage(), (Throwable)e);
            }
        };
        if (consumer == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(36);
        }
        return consumer;
    }

    @Nullable
    protected JSLanguageServiceProtocol createProtocol(Consumer<?> readyConsumer) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return new TypeScriptServiceStandardOutputProtocol(this.myProject, this.mySettings, readyConsumer, this.createEventConsumer());
    }

    @NotNull
    protected Consumer<JSLanguageServiceAnswer> createEventConsumer() {
        Consumer consumer = el -> {
            String type = el.getProperty("event");
            if (type == null) {
                return;
            }
            Consumer consumer = (Consumer)this.myEventCollector.get(type);
            if (consumer != null) {
                consumer.consume(el);
            } else {
                JSLanguageServiceQueue.LOGGER.debug("Unprocessed event: " + el.getElement());
            }
        };
        if (consumer == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(37);
        }
        return consumer;
    }

    @Override
    @Nullable
    protected JSLanguageServiceToolWindowManager createToolWindow(Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        return TypeScriptToolWindowProvider.getToolWindow(project);
    }

    @Override
    protected boolean needInitToolWindow() {
        return this.isEnabled();
    }

    @NotNull
    protected Consumer<JSLanguageServiceQueue> getInitializedCallback() {
        Consumer consumer = service -> ReadAction.run(() -> this.sendInitialState((JSLanguageServiceQueue)service));
        if (consumer == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(38);
        }
        return consumer;
    }

    protected void sendInitialState(@NotNull JSLanguageServiceQueue service) {
        VirtualFile mainFile;
        if (service == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(39);
        }
        ArrayList toProcess = ContainerUtil.newArrayList();
        VirtualFile virtualFile = mainFile = this.isMainFileContext() ? this.getMainFile() : null;
        if (mainFile != null) {
            toProcess.add(mainFile);
        }
        toProcess.addAll(JSHighlightingInfoBuilder.getFilteredOpenedFiles(this.myProject, this.getAcceptableFilesFilter()).keySet());
        if (toProcess.isEmpty()) {
            return;
        }
        for (VirtualFile vFile : toProcess) {
            TypeScriptOpenEditorCommand command = TypeScriptServerServiceImpl.createOpenEditorCommand(vFile);
            service.executeNoBlocking(command, null, (Consumer<JSLanguageServiceObject>)((Consumer)serviceObject -> {
                if (service == null) {
                    TypeScriptServerServiceImpl.$$$reportNull$$$0(103);
                }
                ReadAction.run(() -> {
                    PsiFile file;
                    if (service == null) {
                        TypeScriptServerServiceImpl.$$$reportNull$$$0(104);
                    }
                    if (!service.isValid()) {
                        return;
                    }
                    if (vFile.isValid() && !this.myProject.isDisposed() && (file = PsiManager.getInstance((Project)this.myProject).findFile(vFile)) != null) {
                        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(file);
                    }
                });
            }));
        }
    }

    @Nullable
    private static Collection<VirtualFile> getChangedConfigs() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        FileDocumentManager manager = FileDocumentManager.getInstance();
        List changedConfigs = null;
        for (Document document : manager.getUnsavedDocuments()) {
            VirtualFile docFile = manager.getFile(document);
            if (docFile == null || !TypeScriptCompilerConfigUtil.isConfig(docFile, docFile.getFileType())) continue;
            if (changedConfigs == null) {
                changedConfigs = ContainerUtil.newSmartList();
            }
            changedConfigs.add(docFile);
        }
        return changedConfigs;
    }

    private void saveChangedConfigsAndRestartHighlighting(@NotNull PsiFile file, @NotNull Collection<VirtualFile> configs) {
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(40);
        }
        if (configs == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(41);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (configs == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(101);
            }
            if (file == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(102);
            }
            for (VirtualFile config2 : configs) {
                Document document = FileDocumentManager.getInstance().getDocument(config2);
                if (document == null) continue;
                FileDocumentManager.getInstance().saveDocument(document);
            }
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(file);
        }, this.myProject.getDisposed());
    }

    private boolean isEnabled() {
        return !this.myProject.isDefault() && !this.myProject.isDisposed() && (this.mySettings.isCompilerEnabled() || this.mySettings.isUseService());
    }

    @Override
    public void flushCompileQueue() {
        this.myCompileQueue.flush();
    }

    public void flushQueues() {
        this.flushCompileQueue();
        this.myProjectErrorsQueue.flush();
    }

    @NotNull
    private static TypeScriptOpenEditorCommand createOpenEditorCommand(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(42);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        FileDocumentManager instance = FileDocumentManager.getInstance();
        Document document = instance.getDocument(file);
        if (document == null) {
            TypeScriptOpenEditorCommand typeScriptOpenEditorCommand;
            block5: {
                try {
                    String content = StringUtil.convertLineSeparators((String)VfsUtilCore.loadText((VirtualFile)file));
                    int lineCount = StringUtil.countNewLines((CharSequence)content) + 1;
                    long contentLength = content.length();
                    int index = content.lastIndexOf(10);
                    typeScriptOpenEditorCommand = new TypeScriptOpenEditorCommand(file, -1L, contentLength, lineCount, index == -1 ? 0 : index, null);
                    if (typeScriptOpenEditorCommand != null) break block5;
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                TypeScriptServerServiceImpl.$$$reportNull$$$0(43);
            }
            return typeScriptOpenEditorCommand;
        }
        int lineCount = document.getLineCount();
        long contentLength = document.getTextLength();
        String content = instance.isDocumentUnsaved(document) ? document.getText() : null;
        int lastLineStartOffset = lineCount == 0 ? 0 : document.getLineStartOffset(lineCount - 1);
        TypeScriptOpenEditorCommand typeScriptOpenEditorCommand = new TypeScriptOpenEditorCommand(file, -1L, contentLength, lineCount, lastLineStartOffset, content);
        if (typeScriptOpenEditorCommand == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(44);
        }
        return typeScriptOpenEditorCommand;
    }

    @NotNull
    private JSLanguageServiceCommandProcessor<JSLanguageServiceResultContainer> createCompileResultProcessor() {
        JSLanguageServiceCommandProcessor<JSLanguageServiceResultContainer> jSLanguageServiceCommandProcessor = (serviceObject, answer) -> {
            List<String> emittedFiles;
            JsonObject element = answer.getElement();
            JsonElement body = element.get(BODY_FIELD);
            if (body == null || !body.isJsonObject()) {
                return null;
            }
            JsonObject bodyObject = body.getAsJsonObject();
            List<String> list = emittedFiles = bodyObject.has(GENERATED_FILES_FIELD) ? TypeScriptCompilerConfigUtil.jsonArrayToStringArray((JsonElement)bodyObject.getAsJsonArray(GENERATED_FILES_FIELD)) : ContainerUtil.emptyList();
            if (!emittedFiles.isEmpty()) {
                TypeScriptCompilerConfigUtil.refreshFiles(this.myProject, emittedFiles);
            }
            List<String> processedFiles = bodyObject.has(PROCESSED_FILES_FIELD) ? TypeScriptCompilerConfigUtil.jsonArrayToStringArray((JsonElement)bodyObject.getAsJsonArray(PROCESSED_FILES_FIELD)) : ContainerUtil.emptyList();
            List<JSAnnotationError> results = TypeScriptServerServiceImpl.parseAnnotationResult((JsonElement)bodyObject);
            return new JSLanguageServiceResultContainer(results, processedFiles, emittedFiles);
        };
        if (jSLanguageServiceCommandProcessor == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(45);
        }
        return jSLanguageServiceCommandProcessor;
    }

    @Nullable
    private Future<List<JSAnnotationError>> updateFilesAndGetErrors(@NotNull JSFileHighlightingInfo info) {
        JSLanguageServiceQueue process;
        if (info == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(46);
        }
        if ((process = this.getProcess()) == null) {
            return null;
        }
        this.updateImpl(info.updateContext);
        VirtualFile file = info.file;
        final String path = TypeScriptCompilerConfigUtil.normalizeNameAndPath(file);
        if (path == null) {
            return null;
        }
        Collection<JSLanguageServiceCacheableCommand> commands = this.createGetErrCommand(file, path);
        if (commands.isEmpty()) {
            return null;
        }
        ArrayList futures = ContainerUtil.newArrayList();
        for (JSLanguageServiceCacheableCommand command : commands) {
            CompletableFuture<List<JSAnnotationError>> result = process.executeWithCache(command, new JSLanguageServiceCacheableCommandProcessor<List<JSAnnotationError>>(){

                @Override
                public List<JSAnnotationError> process(@NotNull JSLanguageServiceCacheableCommand command, @NotNull JSLanguageServiceObject object, @NotNull JSLanguageServiceAnswer answer) {
                    if (command == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (object == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (answer == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return TypeScriptServerServiceImpl.this.parseGetErrorResult(answer, path);
                }

                @Override
                @NotNull
                public List<JSAnnotationError> processFromCache(@NotNull JSLanguageServiceCacheableCommand command, @NotNull List<JSAnnotationError> result) {
                    if (command == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    if (result == null) {
                        2.$$$reportNull$$$0(4);
                    }
                    List<JSAnnotationError> list = result;
                    if (list == null) {
                        2.$$$reportNull$$$0(5);
                    }
                    return list;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 5: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 5: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "command";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "object";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "answer";
                            break;
                        }
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "result";
                            break;
                        }
                        case 5: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$2";
                            break;
                        }
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[1] = "processFromCache";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "process";
                            break;
                        }
                        case 3: 
                        case 4: {
                            objectArray = objectArray;
                            objectArray[2] = "processFromCache";
                            break;
                        }
                        case 5: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 5: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
            if (result == null) continue;
            futures.add(result);
        }
        String config2 = this.getConfigForFile(file);
        CompletionStage result = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(el -> {
            LinkedHashSet annotations = ContainerUtil.newLinkedHashSet((Iterable)futures.stream().flatMap(future -> future.getNow(ContainerUtil.emptyList()).stream()).collect(Collectors.toList()));
            this.appendGlobalErrors(config2, annotations, file);
            ArrayList list = ContainerUtil.newArrayList((Iterable)annotations);
            if (!this.mySettings.isShowAllProjectErrors() && TypeScriptServerServiceImpl.checkState(process)) {
                this.updateErrorsForCurrentSelectedEditor(file, list);
            }
            return list;
        });
        if (this.mySettings.isShowAllProjectErrors()) {
            this.queueProjectErrorsTask(this.createProjectCommand(file, path), file);
        }
        return result;
    }

    @NotNull
    protected List<JSAnnotationError> parseGetErrorResult(@NotNull JSLanguageServiceAnswer answer, String path) {
        JsonObject element;
        JsonElement bodyProperty;
        if (answer == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(47);
        }
        if ((bodyProperty = (element = answer.getElement()).get(BODY_FIELD)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(48);
            }
            return list;
        }
        if (bodyProperty.isJsonArray()) {
            List<JSAnnotationError> list = TypeScriptServerServiceImpl.parseDiagnosticsForFile(path, (TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics[])JSLanguageServiceQueueImpl.GSON.fromJson(bodyProperty, TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics[].class));
            if (list == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(49);
            }
            return list;
        }
        List<JSAnnotationError> list = TypeScriptServerServiceImpl.parseAnnotationResult(bodyProperty);
        if (list == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(50);
        }
        return list;
    }

    @NotNull
    protected JSLanguageServiceCommand createProjectCommand(@NotNull VirtualFile file, @NotNull String path) {
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(51);
        }
        if (path == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(52);
        }
        TypeScriptGetProjectErrCommand typeScriptGetProjectErrCommand = new TypeScriptGetProjectErrCommand(path);
        if (typeScriptGetProjectErrCommand == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(53);
        }
        return typeScriptGetProjectErrCommand;
    }

    @Nullable
    private Future<Boolean> updateImpl(@NotNull JSLanguageServiceUpdateContext context) {
        if (context == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(54);
        }
        TypeScriptLanguageServiceUpdateCommand command = this.getUpdateFilesCommand(context);
        JSLanguageServiceQueue process = this.getProcess();
        if (process == null) {
            return null;
        }
        process.executeNoBlocking(command, null, (Consumer<JSLanguageServiceObject>)((Consumer)serviceObject -> {
            if (!this.isCompileEnabled() || !this.isEnabled()) {
                return;
            }
            List<VirtualFile> files = TypeScriptServerServiceImpl.getFilesToCompileFromServiceObject(serviceObject);
            this.addFileToCompileQueue(files);
        }));
        return null;
    }

    @NotNull
    private static List<VirtualFile> getFilesToCompileFromServiceObject(@NotNull JSLanguageServiceObject object) {
        if (object == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(55);
        }
        if (object instanceof TypeScriptFileObject) {
            String file = ((TypeScriptFileObject)object).file;
            List list = ContainerUtil.createMaybeSingletonList((Object)LocalFileSystem.getInstance().findFileByPath(file));
            if (list == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(56);
            }
            return list;
        }
        if (object instanceof TypeScriptCommandSetRequest) {
            ArrayList result = ContainerUtil.newArrayList();
            ((TypeScriptCommandSetRequest)object).nestedRequests.forEach((obj, command) -> result.addAll(TypeScriptServerServiceImpl.getFilesToCompileFromServiceObject(obj)));
            ArrayList arrayList = result;
            if (arrayList == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(57);
            }
            return arrayList;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(58);
        }
        return list;
    }

    @NotNull
    protected TypeScriptLanguageServiceUpdateCommand getUpdateFilesCommand(@NotNull JSLanguageServiceUpdateContext context) {
        if (context == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(59);
        }
        HashMap timestamps = ContainerUtil.newHashMap();
        context.getTimestamps().forEach((el, value) -> timestamps.put(el, value));
        HashMap contents = ContainerUtil.newHashMap();
        context.getOpenContents().forEach((el, value) -> contents.put(el, value));
        context.getUnsavedContents().forEach((el, value) -> contents.put(el, value));
        TypeScriptLanguageServiceUpdateCommand typeScriptLanguageServiceUpdateCommand = new TypeScriptLanguageServiceUpdateCommand(timestamps, contents);
        if (typeScriptLanguageServiceUpdateCommand == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(60);
        }
        return typeScriptLanguageServiceUpdateCommand;
    }

    @NotNull
    private GlobalSearchScope getScope() {
        GlobalSearchScope globalSearchScope = ScopeChooserUtils.findScopeByName((Project)this.myProject, (String)this.mySettings.getScopeName());
        if (globalSearchScope == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(61);
        }
        return globalSearchScope;
    }

    @NotNull
    protected Collection<JSLanguageServiceCacheableCommand> createGetErrCommand(@NotNull VirtualFile file, @NotNull String path) {
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(62);
        }
        if (path == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(63);
        }
        SyntacticDiagnosticsSyncRequest syntactic = new SyntacticDiagnosticsSyncRequest(path);
        SemanticDiagnosticsSyncRequest semantic = new SemanticDiagnosticsSyncRequest(path);
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new JSLanguageServiceCacheableCommand[]{semantic, syntactic});
        if (arrayList == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(64);
        }
        return arrayList;
    }

    protected boolean isMainFileContext() {
        return TypeScriptLanguageServiceUtil.shouldUseMainFile(this.mySettings) && !StringUtil.isEmpty((String)this.mySettings.getMainFilePath());
    }

    @NotNull
    private static List<JSAnnotationError> parseAnnotationResult(@NotNull JsonElement bodyProperty) {
        if (bodyProperty == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(65);
        }
        TypeScriptDiagnosticsResponse result = (TypeScriptDiagnosticsResponse)JSLanguageServiceQueueImpl.GSON.fromJson(bodyProperty, TypeScriptDiagnosticsResponse.class);
        LinkedHashSet results = ContainerUtil.newLinkedHashSet();
        if (result == null || result.infos == null || result.infos.length == 0) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(66);
            }
            return list;
        }
        for (TypeScriptDiagnosticsResponse.DiagnosticsResponseInfo body : result.infos) {
            results.addAll(TypeScriptServerServiceImpl.parseDiagnosticsForFile(body.file, body.diagnostics));
        }
        ImmutableList immutableList = ContainerUtil.immutableList((List)ContainerUtil.newArrayList((Iterable)results));
        if (immutableList == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(67);
        }
        return immutableList;
    }

    @NotNull
    private static List<JSAnnotationError> parseDiagnosticsForFile(@Nullable String fileName, @Nullable TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics[] diags) {
        if (diags == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(68);
            }
            return list;
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics diagnostic : diags) {
            String category = diagnostic.category;
            if (StringUtil.isEmpty((String)category)) {
                category = "error";
            }
            TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnosticsLineInfo start = diagnostic.start;
            TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnosticsLineInfo end = diagnostic.end;
            result.add(new TypeScriptLanguageServiceAnnotationResult(StringUtil.notNullize((String)diagnostic.text, (String)"error"), fileName, category, diagnostic.source, diagnostic.code, start == null ? 0 : start.line, start == null ? 0 : start.offset, end == null ? 0 : end.line, end == null ? 0 : end.offset));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(69);
        }
        return arrayList;
    }

    private void addFileToCompileQueue(@NotNull Collection<String> fileNames) {
        if (fileNames == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(70);
        }
        this.getCompileArguments(fileNames).forEach(this::queueCompileTask);
    }

    @NotNull
    private Collection<TypeScriptCompileFileArgs> getCompileArguments(@NotNull Collection<String> fileNames) {
        if (fileNames == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(71);
        }
        if (!fileNames.isEmpty()) {
            if (!TypeScriptLanguageServiceUtil.shouldUseMainFile(this.mySettings)) {
                Collection collection = fileNames.stream().filter(el -> !TypeScriptUtil.isDefinitionFile(el)).map(el -> {
                    VirtualFile configFile = (VirtualFile)ReadAction.compute(() -> {
                        TypeScriptConfig config2;
                        VirtualFile path = LocalFileSystem.getInstance().findFileByPath(el);
                        if (path != null && (config2 = TypeScriptConfigUtil.getConfigForFile(this.myProject, path)) != null) {
                            return config2.getConfigFile();
                        }
                        return null;
                    });
                    TypeScriptCompileFileArgs args = new TypeScriptCompileFileArgs();
                    args.file = el;
                    if (configFile != null) {
                        args.projectFileName = TypeScriptCompilerConfigUtil.normalizeNameAndPath(configFile);
                    }
                    return args;
                }).collect(Collectors.toList());
                if (collection == null) {
                    TypeScriptServerServiceImpl.$$$reportNull$$$0(72);
                }
                return collection;
            }
            String path = this.mySettings.getMainFilePath();
            if (!StringUtil.isEmpty((String)path)) {
                TypeScriptCompileFileArgs args = new TypeScriptCompileFileArgs();
                args.file = FileUtil.toSystemDependentName((String)path);
                args.force = true;
                List<TypeScriptCompileFileArgs> list = Collections.singletonList(args);
                if (list == null) {
                    TypeScriptServerServiceImpl.$$$reportNull$$$0(73);
                }
                return list;
            }
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(74);
        }
        return list;
    }

    private boolean isCompileEnabled() {
        return this.mySettings.isCompilerEnabledAndNeedTrackChanges();
    }

    private void queueProjectErrorsTask(final @NotNull JSLanguageServiceCommand args, final @NotNull VirtualFile file) {
        if (args == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(75);
        }
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(76);
        }
        this.myProjectErrorsQueue.queue(new Update(args){

            public void run() {
                TypeScriptServerServiceImpl.this.updateProjectErrors(args, file);
            }
        });
    }

    private void queueCompileTask(final @NotNull TypeScriptCompileFileArgs args) {
        VirtualFile path;
        if (args == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(77);
        }
        if (!((path = LocalFileSystem.getInstance().findFileByPath(args.file)) != null && this.getScope().contains(path) && TypeScriptLanguageServiceUtil.ACCEPTABLE_TS_FILE.value((Object)path) && path.isValid())) {
            return;
        }
        this.setMacroParamsIfNeed(args, path);
        this.myCompileQueue.queue(new Update(args){

            public void run() {
                if (!path.isValid()) {
                    return;
                }
                TypeScriptServerServiceImpl.this.sendCompileCommand(args);
            }
        });
    }

    private void setMacroParamsIfNeed(@NotNull TypeScriptCompileFileArgs args, @NotNull VirtualFile path) {
        String outDir;
        if (args == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(78);
        }
        if (path == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(79);
        }
        if (!this.mySettings.isUseConfigForCompiler() && this.mySettings.isHasOutDirectory() && !StringUtil.isEmpty((String)(outDir = this.mySettings.getOutDirectory())) && outDir.contains("$")) {
            Pair<String, String> info = JSHighlightingInfoBuilder.getModuleInfo(this.myProject, path);
            args.contentRootForMacro = (String)info.first;
            args.sourceRootForMacro = (String)info.second;
        }
    }

    private void updateProjectErrors(@NotNull JSLanguageServiceCommand command, @NotNull VirtualFile file) {
        JSLanguageServiceQueue process;
        if (command == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(80);
        }
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(81);
        }
        if (!TypeScriptServerServiceImpl.checkState(process = this.getProcess())) {
            return;
        }
        ConcurrentList answers = ContainerUtil.createConcurrentList();
        Consumer tracker = el -> answers.add(el);
        this.registerEventTracker("syntaxDiag", (Consumer<JSLanguageServiceAnswer>)tracker);
        this.registerEventTracker("semanticDiag", (Consumer<JSLanguageServiceAnswer>)tracker);
        LinkedHashSet results = ContainerUtil.newLinkedHashSet();
        String config2 = this.getConfigForFile(file);
        Consumer processor = answer -> {
            boolean isRemoved;
            if (file == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(100);
            }
            if (!(isRemoved = this.removeEventTracker("syntaxDiag", (Consumer<JSLanguageServiceAnswer>)tracker) & this.removeEventTracker("semanticDiag", (Consumer<JSLanguageServiceAnswer>)tracker))) {
                return;
            }
            this.appendGlobalErrors(config2, results, file);
            results.addAll(TypeScriptServerServiceImpl.convertEventsToAnnotations((List<JSLanguageServiceAnswer>)answers));
            if (TypeScriptServerServiceImpl.checkState(process)) {
                this.updateErrorsForCurrentSelectedEditor(file, ContainerUtil.newArrayList((Iterable)results));
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            process.execute(command, (obj, answer) -> {
                processor.consume((Object)answer);
                return null;
            });
        } else {
            process.executeNoBlocking(command, (Consumer<JSLanguageServiceAnswer>)processor);
        }
    }

    @Nullable
    protected String getConfigForFile(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(82);
        }
        return (String)ReadAction.compute(() -> {
            if (file == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(99);
            }
            return TypeScriptCompilerConfigUtil.getConfigIdForFile(this.myProject, file);
        });
    }

    private void appendGlobalErrors(@Nullable String config2, @NotNull Collection<JSAnnotationError> results, @NotNull VirtualFile file) {
        if (results == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(83);
        }
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(84);
        }
        if (this.isMainFileContext()) {
            VirtualFile mainFile = this.getMainFile();
            if (mainFile != null) {
                ReadAction.run(() -> {
                    if (file == null) {
                        TypeScriptServerServiceImpl.$$$reportNull$$$0(97);
                    }
                    if (results == null) {
                        TypeScriptServerServiceImpl.$$$reportNull$$$0(98);
                    }
                    if (DumbService.isDumb((Project)this.myProject)) {
                        return;
                    }
                    TypeScriptImportGraph graph = new TypeScriptImportGraph(new TypeScriptFileImportsImpl(this.myProject, mainFile));
                    if (!graph.containsFile(file)) {
                        results.add(new TypeScriptLanguageServiceAnnotationResult("File was not processed because there is no a reference from main file", TypeScriptCompilerConfigUtil.normalizeNameAndPath(file)));
                    }
                });
            }
            return;
        }
        if (config2 == null && !this.skipConfigNotFoundError(file)) {
            results.add(new TypeScriptLanguageServiceAnnotationResult("Cannot find parent 'tsconfig.json'", TypeScriptCompilerConfigUtil.normalizeNameAndPath(file)));
        }
        if (config2 == null) {
            return;
        }
        JSLanguageServiceAnswer configErrors = (JSLanguageServiceAnswer)this.myConfigDiagnostics.get(config2);
        if (configErrors == null) {
            return;
        }
        JsonObject body = configErrors.getElement().get(BODY_FIELD).getAsJsonObject();
        JsonElement diags = body.get(DIAGNOSTICS_FIELD);
        if (diags == null) {
            return;
        }
        TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics[] diagnostics = (TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics[])JSLanguageServiceQueueImpl.GSON.fromJson(diags, TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics[].class);
        results.addAll(TypeScriptServerServiceImpl.parseDiagnosticsForFile(config2, diagnostics));
    }

    @Nullable
    private VirtualFile getMainFile() {
        String mainPath = this.mySettings.getMainFilePath();
        return LocalFileSystem.getInstance().findFileByPath(mainPath);
    }

    protected boolean skipConfigNotFoundError(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(85);
        }
        return !StringUtil.isEmpty((String)this.mySettings.getTypeScriptCompilerParams()) || this.mySettings.isUseMainFile() || !TypeScriptLanguageServiceUtil.ACCEPTABLE_TS_FILE.value((Object)file);
    }

    private void registerEventTracker(@NotNull String eventName, @NotNull Consumer<JSLanguageServiceAnswer> tracker) {
        if (eventName == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(86);
        }
        if (tracker == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(87);
        }
        this.myEventCollector.put(eventName, tracker);
    }

    private boolean removeEventTracker(@NotNull String eventName, @NotNull Consumer<JSLanguageServiceAnswer> tracker) {
        if (eventName == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(88);
        }
        if (tracker == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(89);
        }
        return this.myEventCollector.remove(eventName, tracker);
    }

    private static List<JSAnnotationError> convertEventsToAnnotations(List<JSLanguageServiceAnswer> answers) {
        ArrayList result = ContainerUtil.newArrayList();
        for (JSLanguageServiceAnswer answer : answers) {
            JsonObject element = answer.getElement();
            JsonElement body = element.get(BODY_FIELD);
            if (body == null) continue;
            TypeScriptDiagnosticsResponse.DiagnosticsResponseInfo responseInfo = (TypeScriptDiagnosticsResponse.DiagnosticsResponseInfo)JSLanguageServiceQueueImpl.GSON.fromJson(body, TypeScriptDiagnosticsResponse.DiagnosticsResponseInfo.class);
            result.addAll(TypeScriptServerServiceImpl.parseDiagnosticsForFile(responseInfo.file, responseInfo.diagnostics));
        }
        return ContainerUtil.immutableList((List)ContainerUtil.sorted((Collection)result, Comparator.comparing(el -> el.getAbsoluteFilePath())));
    }

    private void updateErrorsForCurrentSelectedEditor(@NotNull VirtualFile file, @Nullable List<JSAnnotationError> results) {
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(90);
        }
        Runnable runnable = () -> {
            VirtualFile editorFile;
            if (file == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(96);
            }
            if (!this.myProject.isOpen() || this.myProject.isDisposed() || !this.isServiceCreated()) {
                return;
            }
            Editor editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor();
            if (editor instanceof EditorEx && file.equals(editorFile = ((EditorEx)editor).getVirtualFile())) {
                this.getDefaultReporter().logCurrentErrors(results == null ? ContainerUtil.emptyList() : results);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ReadAction.run(() -> runnable.run());
        } else {
            ApplicationManager.getApplication().invokeLater(runnable, this.myProject.getDisposed());
        }
    }

    protected static boolean checkState(@Nullable JSLanguageServiceQueue process) {
        if (process == null) {
            return false;
        }
        return process.isValid();
    }

    private void showInterpreterError(@NotNull ThreeState prevValue) {
        if (prevValue == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(91);
        }
        if (prevValue != this.getCanStartProcessState()) {
            Runnable runnable = () -> ApplicationManager.getApplication().invokeLater(() -> {
                if (this.myToolWindowManager != null) {
                    this.myToolWindowManager.logCurrentErrors((List<JSAnnotationError>)JSLanguageServiceAnnotationResult.buildError(JSBundle.message((String)"javascript.service.node.error", (Object[])new Object[0])), this.mySettings.isCompilerEnabled());
                }
                DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
            }, this.myProject.getDisposed());
            if (this.myProject.isOpen()) {
                StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(runnable);
            }
        }
    }

    @Override
    @NotNull
    protected String getProcessName() {
        if ("TypeScript" == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(92);
        }
        return "TypeScript";
    }

    @Override
    protected void resetState() {
        this.myProjectErrorsQueue.cancelAllUpdates();
        this.myCompileQueue.cancelAllUpdates();
        this.myConfigDiagnostics.clear();
        super.resetState();
    }

    private void sendCompileCommand(@NotNull TypeScriptCompileFileArgs args) {
        JSLanguageServiceQueue process;
        if (args == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(93);
        }
        if (!TypeScriptServerServiceImpl.checkState(process = this.getProcess())) {
            return;
        }
        this.sendCompile(args, process);
    }

    private void sendCompile(@NotNull TypeScriptCompileFileArgs args, @NotNull JSLanguageServiceQueue process) {
        if (args == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(94);
        }
        if (process == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(95);
        }
        TypeScriptCompileCommand command = new TypeScriptCompileCommand(args);
        Consumer consumer = answer -> {
            JsonObject element = answer.getElement();
            JsonElement jsonElement = element.get(BODY_FIELD);
            if (jsonElement == null || !jsonElement.isJsonObject()) {
                return;
            }
            TypeScriptCompilerConfigUtil.processEmitFilesAfterCompiling(this.myProject, jsonElement.getAsJsonObject(), GENERATED_FILES_FIELD);
        };
        process.executeNoBlocking(command, (Consumer<JSLanguageServiceAnswer>)consumer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 16: 
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 72: 
            case 73: 
            case 74: 
            case 92: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 16: 
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 72: 
            case 73: 
            case 74: 
            case 92: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleId";
                break;
            }
            case 5: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 8: 
            case 9: 
            case 16: 
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 72: 
            case 73: 
            case 74: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl";
                break;
            }
            case 10: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 11: 
            case 19: 
            case 22: 
            case 24: 
            case 25: 
            case 31: 
            case 32: 
            case 34: 
            case 40: 
            case 42: 
            case 51: 
            case 62: 
            case 76: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 90: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 102: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 17: 
            case 75: 
            case 77: 
            case 78: 
            case 93: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 21: 
            case 54: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 33: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 39: 
            case 103: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 41: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configs";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answer";
                break;
            }
            case 52: 
            case 63: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bodyProperty";
                break;
            }
            case 70: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNames";
                break;
            }
            case 83: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 86: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventName";
                break;
            }
            case 87: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevValue";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptableCompileFileNames";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompletionProcessor";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompletionCommand";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptableFilesFilter";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createReadyConsumer";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createEventConsumer";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializedCallback";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createOpenEditorCommand";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompileResultProcessor";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "parseGetErrorResult";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectCommand";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToCompileFromServiceObject";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdateFilesCommand";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "createGetErrCommand";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAnnotationResult";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDiagnosticsForFile";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompileArguments";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sendCleanCommandToCompiler";
                break;
            }
            case 6: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "addFileToCompileQueue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAcceptableCompileFileNames";
                break;
            }
            case 8: 
            case 9: 
            case 16: 
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 72: 
            case 73: 
            case 74: 
            case 92: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateAndGetCompletionItems";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDetailedCompletionItems";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createCompletionCommand";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "compileFileAndGetErrors";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "compileConfigProjectAndGetErrors";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "closeLastEditor";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getFixes";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "openEditor";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "highlight";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "canHighlight";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "sendInitialState";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "saveChangedConfigsAndRestartHighlighting";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createOpenEditorCommand";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "updateFilesAndGetErrors";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "parseGetErrorResult";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createProjectCommand";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "updateImpl";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getFilesToCompileFromServiceObject";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getUpdateFilesCommand";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createGetErrCommand";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "parseAnnotationResult";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getCompileArguments";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "queueProjectErrorsTask";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "queueCompileTask";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "setMacroParamsIfNeed";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "updateProjectErrors";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getConfigForFile";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "appendGlobalErrors";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "skipConfigNotFoundError";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "registerEventTracker";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "removeEventTracker";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "updateErrorsForCurrentSelectedEditor";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "showInterpreterError";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "sendCompileCommand";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "sendCompile";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateErrorsForCurrentSelectedEditor$35";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "lambda$appendGlobalErrors$33";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getConfigForFile$32";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateProjectErrors$30";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "lambda$saveChangedConfigsAndRestartHighlighting$17";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "lambda$sendInitialState$16";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$15";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "lambda$openEditor$8";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$3";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 16: 
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 72: 
            case 73: 
            case 74: 
            case 92: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TypeScriptCompileUpdater {
        private TypeScriptCompileUpdater() {
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass().equals(obj.getClass());
        }
    }
}

