/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.codeFixes;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptCodeActionInfo;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptResponseCommon;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageServiceFix
implements IntentionAction,
Comparable<IntentionAction>,
Iconable {
    @NotNull
    private final Runnable myRefreshCallback;
    private final int myIndex;
    @Nullable
    private volatile State myState;

    public TypeScriptLanguageServiceFix(@NotNull Runnable refresh, int index) {
        if (refresh == null) {
            TypeScriptLanguageServiceFix.$$$reportNull$$$0(0);
        }
        this.myRefreshCallback = refresh;
        this.myIndex = index;
    }

    @Nls
    @NotNull
    public String getText() {
        this.myRefreshCallback.run();
        State state = this.myState;
        String string = state == null ? "" : StringUtil.notNullize((String)state.getName());
        if (string == null) {
            TypeScriptLanguageServiceFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            TypeScriptLanguageServiceFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public Icon getIcon(@Iconable.IconFlags int flags) {
        return JavaScriptLanguageIcons.Typescript.TypeScript_Compiler;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            TypeScriptLanguageServiceFix.$$$reportNull$$$0(3);
        }
        this.myRefreshCallback.run();
        State state = this.myState;
        return state != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        State state;
        if (project == null) {
            TypeScriptLanguageServiceFix.$$$reportNull$$$0(4);
        }
        if ((state = this.myState) == null) {
            return;
        }
        TypeScriptCodeActionInfo fix = state.fix;
        if (fix == null) {
            return;
        }
        for (TypeScriptCodeActionInfo.FileCodeEdits change : fix.changes) {
            TypeScriptCodeActionInfo.CodeEdit[] changes;
            String name = change.fileName;
            if (StringUtil.isEmpty((String)name) || (changes = change.textChanges) == null || changes.length == 0) continue;
            String filePath = FileUtil.toSystemIndependentName((String)name);
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(filePath);
            if (virtualFile == null) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)("Cannot find the file " + filePath), (String)CommonBundle.getErrorTitle(), null);
                break;
            }
            boolean okToWrite = FileModificationService.getInstance().prepareVirtualFilesForWrite(project, (Collection)ContainerUtil.createMaybeSingletonList((Object)virtualFile));
            if (!okToWrite) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)("Cannot write to the file " + filePath), (String)CommonBundle.getErrorTitle(), null);
                break;
            }
            Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
            if (document == null) continue;
            WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getText(), null, () -> {
                if (project == null) {
                    TypeScriptLanguageServiceFix.$$$reportNull$$$0(5);
                }
                int startRange = -1;
                int endRange = -1;
                PsiManager manager = file.getManager();
                PsiFile currentPsiFile = manager.findFile(virtualFile);
                for (TypeScriptCodeActionInfo.CodeEdit edit : changes) {
                    String text = StringUtil.convertLineSeparators((String)StringUtil.notNullize((String)edit.newText));
                    TextRange range = TypeScriptLanguageServiceFix.replaceText(text, document, edit);
                    if (range == null) continue;
                    TextRange newRange = new TextRange(range.getStartOffset(), range.getStartOffset() + text.length());
                    PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                    if (startRange == -1 || startRange > newRange.getStartOffset()) {
                        startRange = newRange.getStartOffset();
                    }
                    if (endRange != -1 && endRange >= newRange.getEndOffset()) continue;
                    endRange = newRange.getEndOffset();
                }
                if (startRange == -1 || startRange >= document.getTextLength()) {
                    return;
                }
                if (endRange == -1 || endRange >= document.getTextLength() || endRange < startRange) {
                    return;
                }
                if (currentPsiFile != null) {
                    CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)currentPsiFile, startRange, endRange);
                }
            }, (PsiFile[])new PsiFile[0]);
        }
    }

    private static TextRange replaceText(String text, Document document, TypeScriptCodeActionInfo.CodeEdit edit) {
        TypeScriptResponseCommon.Location start = edit.start;
        TypeScriptResponseCommon.Location end = edit.end;
        JSLanguageServiceUtil.PsiElementInfo info = TypeScriptLanguageServiceUtil.getPsiElementInfo(null, document, start, end);
        if (info == null) {
            return null;
        }
        TextRange range = info.getRange();
        if (range == null) {
            return null;
        }
        document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)text);
        return range;
    }

    public void update(State state) {
        this.myState = state;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public int compareTo(IntentionAction o) {
        if (o instanceof TypeScriptLanguageServiceFix) {
            return this.myIndex - ((TypeScriptLanguageServiceFix)o).myIndex;
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresh";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFix";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class State {
        @Nullable
        private final TypeScriptCodeActionInfo fix;

        public State(@Nullable TypeScriptCodeActionInfo fix) {
            this.fix = fix;
        }

        @Nullable
        private String getName() {
            return this.fix == null ? null : this.fix.description;
        }
    }
}

