/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.completion;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.ES6CompletionKeywordsContributor;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.KeywordCompletionConsumer;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class TypeScriptCompletionKeywordsContributor
extends ES6CompletionKeywordsContributor {
    public static final String[] PRIMITIVE_TYPES = new String[]{"string", "boolean", "number", "void", "never", "symbol", "object", "any"};
    public static final String[] TYPE_PREFIXES = new String[]{"typeof", "keyof"};
    private static final String[] PRIMITIVE_TYPES_FOR_INDEXER = new String[]{"string", "number"};
    private static final String[] TYPE_PREFIXES_FOR_INDEXER = new String[0];

    @Override
    public boolean process(KeywordCompletionConsumer consumer, PsiElement context) {
        ASTNode currentNode;
        ASTNode prev;
        JSFunction function;
        PsiElement parent;
        if (!super.process(consumer, context)) {
            return false;
        }
        boolean isTsIndexer = TypeScriptPsiUtil.isTsIndexerType(parent = context.getParent());
        if (TypeScriptCompletionKeywordsContributor.addPredefinedTypesInTypeContext(parent, consumer, isTsIndexer ? PRIMITIVE_TYPES_FOR_INDEXER : PRIMITIVE_TYPES, isTsIndexer ? TYPE_PREFIXES_FOR_INDEXER : TYPE_PREFIXES) || parent instanceof TypeScriptImportStatement) {
            return false;
        }
        if (parent instanceof JSParameter && (function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)parent, JSFunction.class)) != null && function.isConstructor() && (prev = TreeUtil.prevLeaf((ASTNode)(currentNode = context.getNode()))) != null) {
            IElementType type;
            ASTNode newPrev;
            if (JSTokenTypes.COMMENTS_AND_WHITESPACES.contains(prev.getElementType()) && (newPrev = TreeUtil.skipElementsBack((ASTNode)prev, (TokenSet)JSTokenTypes.COMMENTS_AND_WHITESPACES)) != null) {
                prev = newPrev;
            }
            if ((type = prev.getElementType()) == JSTokenTypes.COMMA || type == JSTokenTypes.LPAR) {
                consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "private", "public", "protected", "readonly");
                return false;
            }
        }
        PsiElement grandParent = parent.getParent();
        boolean grandParentParentIsModule = false;
        if (grandParent instanceof JSExpressionStatement || grandParent instanceof JSAttributeList) {
            if (grandParent instanceof JSExpressionStatement) {
                PsiElement prev2;
                PsiElement grandParentParent = grandParent.getParent();
                if (grandParentParent instanceof PsiFile || grandParentParent instanceof TypeScriptModule) {
                    grandParentParentIsModule = true;
                    consumer.consume(JSLookupPriority.KEYWORDS_PRIORITY, true, "class", "enum", "interface", "declare", "abstract", "async", "export", "type", "module", "namespace", "import");
                }
                if ((prev2 = JSPsiImplUtils.findPrevCodeElement(grandParent)) instanceof TypeScriptClass && prev2.getNode().findChildByType(JSTokenTypes.LBRACE) == null || prev2 instanceof TypeScriptInterface && ((TypeScriptInterface)prev2).getBody() == null) {
                    consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "extends");
                    if (prev2 instanceof TypeScriptClass) {
                        consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "implements");
                    }
                    return false;
                }
            }
            if (grandParentParentIsModule) {
                consumer.consume(JSLookupPriority.KEYWORDS_PRIORITY, true, "function", "let", "const", "var");
            } else {
                consumer.consume(JSLookupPriority.KEYWORDS_PRIORITY, true, "public", "private", "protected", "function", "let", "const", "var");
            }
            return !TypeScriptPsiUtil.isAmbientDeclaration(grandParent.getParent());
        }
        if (grandParent instanceof TypeScriptImportStatement && parent instanceof JSReferenceExpression && ((JSReferenceExpression)parent).getQualifier() == null) {
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, false, "require");
            return false;
        }
        if (grandParent instanceof JSVarStatement && grandParent.getParent() instanceof TypeScriptClass) {
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, false, "constructor");
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "public", "private", "protected", "static", "abstract", "readonly", "async", "get", "set");
            return false;
        }
        if (parent instanceof JSReferenceExpression && grandParent instanceof ES6Property) {
            return false;
        }
        if (grandParent instanceof JSBinaryExpression || grandParent instanceof TypeScriptTypeParameterList) {
            consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, false, "extends");
        }
        return true;
    }

    public static boolean addPredefinedTypesInTypeContext(PsiElement parent, KeywordCompletionConsumer consumer, @NotNull String[] types, @NotNull String[] typesWithSpaces) {
        if (types == null) {
            TypeScriptCompletionKeywordsContributor.$$$reportNull$$$0(0);
        }
        if (typesWithSpaces == null) {
            TypeScriptCompletionKeywordsContributor.$$$reportNull$$$0(1);
        }
        if (parent instanceof JSReferenceExpression && JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)parent)) {
            if (PsiTreeUtil.getParentOfType((PsiElement)parent, JSReferenceList.class) == null && ((JSReferenceExpression)parent).getQualifier() == null) {
                consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, false, types);
                consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, typesWithSpaces);
            }
            return true;
        }
        return false;
    }

    public static boolean addPredefinedTypesInTypeContext(PsiElement parent, KeywordCompletionConsumer consumer, String ... types) {
        return TypeScriptCompletionKeywordsContributor.addPredefinedTypesInTypeContext(parent, consumer, types, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    @Override
    public void appendSpecificKeywords(@NotNull KeywordCompletionConsumer consumer) {
        if (consumer == null) {
            TypeScriptCompletionKeywordsContributor.$$$reportNull$$$0(2);
        }
    }

    @Override
    protected void appendKeywordsAfterExport(KeywordCompletionConsumer consumer) {
        super.appendKeywordsAfterExport(consumer);
        consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "namespace", "module", "enum", "type", "interface");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typesWithSpaces";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/completion/TypeScriptCompletionKeywordsContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addPredefinedTypesInTypeContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "appendSpecificKeywords";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

